/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.structure;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import superlord.prehistoricfauna.init.PFLootTables;
import superlord.prehistoricfauna.init.PFStructures;

public class DjadochtaHutStructure
extends Structure<NoFeatureConfig> {
    public DjadochtaHutStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
        this.setRegistryName("prehistoricfauna:djadochta_hut");
    }

    public String func_143025_a() {
        return "prehistoricfauna:djadochta_hut";
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation resourceLocation;
        private Rotation rotation;

        public Piece(TemplateManager templateManager, ResourceLocation resourceLocation, BlockPos pos, Rotation rotation) {
            super(PFStructures.DJADOCHTA_HUT_PIECE_TYPE, 0);
            this.resourceLocation = resourceLocation;
            this.field_186178_c = pos;
            this.rotation = rotation;
            this.setupPiece(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT compound) {
            super(PFStructures.DJADOCHTA_HUT_PIECE_TYPE, compound);
            this.resourceLocation = new ResourceLocation(compound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)compound.func_74779_i("Rot"));
            this.setupPiece(templateManager);
        }

        public static void start(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, Random random) {
            int x = pos.func_177958_n();
            int z = pos.func_177952_p();
            BlockPos rotationOffset = new BlockPos(0, 0, 0).func_190942_a(rotation);
            BlockPos blockPos = rotationOffset.func_177982_a(x, pos.func_177956_o(), z);
            pieceList.add((StructurePiece)new Piece(templateManager, new ResourceLocation("prehistoricfauna", "djadochta_hut"), blockPos, rotation));
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementSettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementSettings);
        }

        protected void func_143011_b(CompoundNBT compound) {
            super.func_143011_b(compound);
            compound.func_74778_a("Template", this.resourceLocation.toString());
            compound.func_74778_a("Rot", this.rotation.name());
        }

        public boolean func_230383_a_(ISeedReader seedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox structureBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
            BlockPos pos = BlockPos.field_177992_a;
            this.field_186178_c.func_177971_a((Vector3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(-pos.func_177958_n(), 0, -pos.func_177952_p())));
            return super.func_230383_a_(seedReader, structureManager, chunkGenerator, random, structureBoundingBox, chunkPos, blockPos);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox sbb) {
            BlockPos blockpos;
            if (function.startsWith("Chest")) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                blockpos = pos.func_177977_b();
                if (sbb.func_175898_b((Vector3i)blockpos)) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)blockpos, (ResourceLocation)PFLootTables.HELL_CREEK_LOOT_TABLE);
                }
            }
            if (function.startsWith("Sand")) {
                world.func_180501_a(pos, Blocks.field_150354_m.func_176223_P(), 2);
                blockpos = pos.func_177977_b();
                if (sbb.func_175898_b((Vector3i)blockpos)) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)blockpos, (ResourceLocation)PFLootTables.HELL_CREEK_LOOT_TABLE);
                }
            }
        }
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int reference, long seed) {
            super(structure, chunkX, chunkZ, mutableBoundingBox, reference, seed);
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistryManager, ChunkGenerator generator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            int surfaceY = Math.max(generator.func_222532_b(x + 12, z + 12, Heightmap.Type.WORLD_SURFACE_WG) - 1, generator.func_205470_d() - 1);
            BlockPos blockpos = new BlockPos(x, surfaceY, z);
            Piece.start(templateManager, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }
    }
}

