/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.feature.trees.zamites;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.IPlantable;
import superlord.prehistoricfauna.common.blocks.ZamitesFrondsBlock;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.world.feature.config.JohnstoniaConfig;

public class ZamiteBushFeature
extends Feature<JohnstoniaConfig> {
    public ZamiteBushFeature(Codec<JohnstoniaConfig> codec) {
        super(codec);
    }

    protected static boolean isSoil(ISeedReader reader, BlockPos pos, IPlantable sapling) {
        if (!(reader instanceof IBlockReader) || sapling == null) {
            return ZamiteBushFeature.isDirtOrGrassBlock(reader, pos);
        }
        return reader.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)reader, pos, Direction.UP, sapling));
    }

    @Deprecated
    public static boolean isDirtOrGrassBlock(ISeedReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_227221_0_ -> ZamiteBushFeature.func_227250_b_((Block)p_227221_0_.func_177230_c()));
    }

    public static boolean isAir(ISeedReader worldIn, BlockPos pos) {
        if (worldIn instanceof IBlockReader) {
            return worldIn.func_217375_a(pos, state -> state.isAir((IBlockReader)worldIn, pos));
        }
        return worldIn.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f);
    }

    public static boolean isAirOrLeaves(ISeedReader worldIn, BlockPos pos) {
        if (worldIn instanceof IWorldReader) {
            return worldIn.func_217375_a(pos, state -> state.canBeReplacedByLeaves((IWorldReader)worldIn, pos));
        }
        return worldIn.func_217375_a(pos, p_227223_0_ -> p_227223_0_.func_196958_f() || p_227223_0_.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos startPosition, JohnstoniaConfig config) {
        BlockPos pos = startPosition;
        while (pos.func_177956_o() > 1 && ZamiteBushFeature.isAirOrLeaves(worldIn, pos)) {
            pos = pos.func_177977_b();
        }
        if (!ZamiteBushFeature.isSoil(worldIn, pos, null)) {
            return false;
        }
        pos = pos.func_177984_a();
        int height = rand.nextInt(3) + 2;
        int frondsChance = rand.nextInt(2);
        int secondFrondsChance = rand.nextInt(2);
        int secondFrondsHeight = rand.nextInt(3) + 1;
        int secondFrondsDirection = rand.nextInt(4);
        int frondsHeight = rand.nextInt(3) + 1;
        int frondsDirection = rand.nextInt(4);
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 2 <= 256) {
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + height; ++j) {
                if (ZamiteBushFeature.isAir(worldIn, new BlockPos(x, j, z))) {
                    this.func_230367_a_((IWorldWriter)worldIn, new BlockPos(x, j, z), PFBlocks.ZAMITES_LOG.func_176223_P());
                }
                if (frondsChance == 0) {
                    if (frondsDirection == 0 && ZamiteBushFeature.isAir(worldIn, new BlockPos(x + 1, pos.func_177956_o() + frondsHeight, z))) {
                        this.func_230367_a_((IWorldWriter)worldIn, new BlockPos(x + 1, pos.func_177956_o() + frondsHeight, z), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.WEST));
                    }
                    if (frondsDirection == 1 && ZamiteBushFeature.isAir(worldIn, new BlockPos(x + 0, pos.func_177956_o() + frondsHeight, z + 1))) {
                        this.func_230367_a_((IWorldWriter)worldIn, new BlockPos(x + 0, pos.func_177956_o() + frondsHeight, z + 1), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.NORTH));
                    }
                    if (frondsDirection == 2 && ZamiteBushFeature.isAir(worldIn, new BlockPos(x + 0, pos.func_177956_o() + frondsHeight, z - 1))) {
                        this.func_230367_a_((IWorldWriter)worldIn, new BlockPos(x + 0, pos.func_177956_o() + frondsHeight, z - 1), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.SOUTH));
                    }
                    if (frondsDirection == 3 && ZamiteBushFeature.isAir(worldIn, new BlockPos(x - 1, pos.func_177956_o() + frondsHeight, z - 0))) {
                        this.func_230367_a_((IWorldWriter)worldIn, new BlockPos(x - 1, pos.func_177956_o() + frondsHeight, z - 0), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.EAST));
                    }
                }
                if (secondFrondsChance != 2) continue;
                if (secondFrondsDirection == 0 && ZamiteBushFeature.isAir(worldIn, new BlockPos(x + 1, pos.func_177956_o() + secondFrondsHeight, z))) {
                    this.func_230367_a_((IWorldWriter)worldIn, new BlockPos(x + 1, pos.func_177956_o() + secondFrondsHeight, z), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.WEST));
                }
                if (secondFrondsDirection == 1 && ZamiteBushFeature.isAir(worldIn, new BlockPos(x + 0, pos.func_177956_o() + secondFrondsHeight, z + 1))) {
                    this.func_230367_a_((IWorldWriter)worldIn, new BlockPos(x + 0, pos.func_177956_o() + secondFrondsHeight, z + 1), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.NORTH));
                }
                if (secondFrondsDirection == 2 && ZamiteBushFeature.isAir(worldIn, new BlockPos(x + 0, pos.func_177956_o() + secondFrondsHeight, z - 1))) {
                    this.func_230367_a_((IWorldWriter)worldIn, new BlockPos(x + 0, pos.func_177956_o() + secondFrondsHeight, z - 1), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.SOUTH));
                }
                if (secondFrondsDirection != 3 || !ZamiteBushFeature.isAir(worldIn, new BlockPos(x - 1, pos.func_177956_o() + secondFrondsHeight, z - 0))) continue;
                this.func_230367_a_((IWorldWriter)worldIn, new BlockPos(x - 1, pos.func_177956_o() + secondFrondsHeight, z - 0), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.EAST));
            }
            if (ZamiteBushFeature.isAir(worldIn, new BlockPos(x, pos.func_177956_o() + height + 1, z))) {
                this.func_230367_a_((IWorldWriter)worldIn, new BlockPos(x, pos.func_177956_o() + height + 1, z), PFBlocks.ZAMITES_LEAVES.func_176223_P());
            }
            return true;
        }
        return false;
    }
}

