/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.feature.trees.util;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import superlord.prehistoricfauna.world.feature.config.PFTreeConfig;
import superlord.prehistoricfauna.world.feature.trees.util.TreeSpawner;

public abstract class HugeTreeSpawner
extends TreeSpawner {
    public static boolean canBigTreeSpawnAt(BlockState blockUnder, IBlockReader world, BlockPos pos, int xOffset, int zOffset) {
        Block block = blockUnder.func_177230_c();
        return block == world.func_180495_p(pos.func_177982_a(xOffset, 0, zOffset)).func_177230_c() && block == world.func_180495_p(pos.func_177982_a(xOffset + 1, 0, zOffset)).func_177230_c() && block == world.func_180495_p(pos.func_177982_a(xOffset, 0, zOffset + 1)).func_177230_c() && block == world.func_180495_p(pos.func_177982_a(xOffset + 1, 0, zOffset + 1)).func_177230_c();
    }

    @Override
    public boolean spawn(ISeedReader world, ChunkGenerator chunkGenerator, BlockPos pos, BlockState blockUnder, Random random) {
        for (int i = 0; i >= -1; --i) {
            for (int j = 0; j >= -1; --j) {
                if (!HugeTreeSpawner.canBigTreeSpawnAt(blockUnder, (IBlockReader)world, pos, i, j)) continue;
                return this.bigTree(world, chunkGenerator, pos, blockUnder, random, i, j);
            }
        }
        return super.spawn(world, chunkGenerator, pos, blockUnder, random);
    }

    @Nullable
    protected abstract ConfiguredFeature<PFTreeConfig, ?> getBigTreeFeature(Random var1);

    public boolean bigTree(ISeedReader world, ChunkGenerator chunkGenerator, BlockPos pos, BlockState blockUnder, Random random, int xOffset, int zOffset) {
        ConfiguredFeature<PFTreeConfig, ?> configuredTreeFeature = this.getBigTreeFeature(random);
        if (configuredTreeFeature == null) {
            return false;
        }
        BlockState blockstate = Blocks.field_150350_a.func_176223_P();
        world.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset), blockstate, 4);
        world.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset), blockstate, 4);
        world.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset + 1), blockstate, 4);
        world.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset + 1), blockstate, 4);
        ((PFTreeConfig)configuredTreeFeature.field_222738_b).forcePlacement();
        if (configuredTreeFeature.func_242765_a(world, chunkGenerator, random, pos.func_177982_a(xOffset, 0, zOffset))) {
            return true;
        }
        world.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset), blockUnder, 4);
        world.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset), blockUnder, 4);
        world.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset + 1), blockUnder, 4);
        world.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset + 1), blockUnder, 4);
        return false;
    }
}

