/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.feature.config;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class PFTreeConfig
implements IFeatureConfig {
    public static final Codec<PFTreeConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.field_236796_a_.fieldOf("trunk_provider").orElse((Object)new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P())).forGetter(config -> config.trunkProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("leaves_provider").orElse((Object)new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P())).forGetter(config -> config.leavesProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("ground_replacement_provider").orElse((Object)new SimpleBlockStateProvider(Blocks.field_150346_d.func_176223_P())).forGetter(config -> config.groundReplacementProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("disk_provider").orElse((Object)new SimpleBlockStateProvider(Blocks.field_196661_l.func_176223_P())).forGetter(config -> config.diskProvider), (App)Codec.INT.fieldOf("min_height").orElse((Object)15).forGetter(config -> config.minHeight), (App)Codec.INT.fieldOf("max_height").orElse((Object)15).forGetter(config -> config.maxHeight), (App)Codec.INT.fieldOf("disk_radius").orElse((Object)0).forGetter(config -> config.diskRadius), (App)BlockState.field_235877_b_.listOf().fieldOf("whitelist").forGetter(config -> config.whitelist.stream().map(Block::func_176223_P).collect(Collectors.toList()))).apply((Applicative)codecRecorder, PFTreeConfig::new));
    private final BlockStateProvider trunkProvider;
    private final BlockStateProvider leavesProvider;
    @Deprecated
    private final BlockStateProvider groundReplacementProvider;
    private final BlockStateProvider diskProvider;
    private final int minHeight;
    private final int maxHeight;
    private final int diskRadius;
    private final Set<Block> whitelist;
    private boolean forcedPlacement = false;
    private Rotation rotation = Rotation.NONE;
    private Mirror mirror = Mirror.NONE;

    PFTreeConfig(BlockStateProvider trunkProvider, BlockStateProvider leavesProvider, BlockStateProvider groundReplacementProvider, BlockStateProvider diskProvider, int minHeight, int maxHeight, int diskRadius, List<BlockState> whitelist) {
        this.trunkProvider = trunkProvider;
        this.leavesProvider = leavesProvider;
        this.groundReplacementProvider = groundReplacementProvider;
        this.diskProvider = diskProvider;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.diskRadius = diskRadius;
        this.whitelist = whitelist.stream().map(AbstractBlock.AbstractBlockState::func_177230_c).collect(Collectors.toSet());
    }

    public void forcePlacement() {
        this.forcedPlacement = true;
    }

    public BlockStateProvider getTrunkProvider() {
        return this.trunkProvider;
    }

    public BlockStateProvider getLeavesProvider() {
        return this.leavesProvider;
    }

    @Deprecated
    public BlockStateProvider getGroundReplacementProvider() {
        return this.groundReplacementProvider;
    }

    public BlockStateProvider getDiskProvider() {
        return this.diskProvider;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getDiskRadius() {
        return this.diskRadius;
    }

    public Set<Block> getWhitelist() {
        return this.whitelist;
    }

    public int getMaxPossibleHeight() {
        int returnValue = this.maxHeight - this.minHeight;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public boolean isPlacementForced() {
        return this.forcedPlacement;
    }

    public void setRoationAndMirror(Rotation rotation, Mirror mirror) {
        this.rotation = rotation;
        this.mirror = mirror;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public static class Builder {
        private BlockStateProvider trunkProvider = new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P());
        private BlockStateProvider leavesProvider = new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());
        @Deprecated
        private BlockStateProvider groundReplacementProvider = new SimpleBlockStateProvider(Blocks.field_150346_d.func_176223_P());
        private BlockStateProvider diskProvider = new SimpleBlockStateProvider(Blocks.field_196661_l.func_176223_P());
        private List<Block> whitelist = ImmutableList.of((Object)Blocks.field_196658_i);
        private int minHeight = 15;
        private int maxPossibleHieght = 1;
        private int diskRadius = 0;

        public Builder setTrunkBlock(Block block) {
            this.trunkProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P());
            return this;
        }

        public Builder setTrunkBlock(BlockState state) {
            this.trunkProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P());
            return this;
        }

        public Builder setTrunkBlock(BlockStateProvider stateProvider) {
            this.trunkProvider = stateProvider != null ? stateProvider : new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P());
            return this;
        }

        public Builder setLeavesBlock(Block block) {
            this.leavesProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());
            return this;
        }

        public Builder setLeavesBlock(BlockState state) {
            this.leavesProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());
            return this;
        }

        public Builder setLeavesBlock(BlockStateProvider stateProvider) {
            this.leavesProvider = stateProvider != null ? stateProvider : new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());
            return this;
        }

        @Deprecated
        public Builder setGroundReplacementBlock(Block block) {
            this.groundReplacementProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_150346_d.func_176223_P());
            return this;
        }

        @Deprecated
        public Builder setGroundReplacementBlock(BlockState state) {
            this.groundReplacementProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_150350_a.func_176223_P());
            return this;
        }

        @Deprecated
        public Builder setGroundReplacementBlock(BlockStateProvider stateProvider) {
            this.groundReplacementProvider = stateProvider != null ? stateProvider : new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());
            return this;
        }

        public Builder setDiskBlock(Block block) {
            this.diskProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_150350_a.func_176223_P());
            return this;
        }

        public Builder setDiskBlock(BlockState state) {
            this.diskProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_150350_a.func_176223_P());
            return this;
        }

        public Builder setDiskBlock(BlockStateProvider stateProvider) {
            this.diskProvider = stateProvider != null ? stateProvider : new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());
            return this;
        }

        public Builder setMinHeight(int minHeight) {
            this.minHeight = minHeight;
            return this;
        }

        public Builder setMaxHeight(int maxPossibleHeight) {
            this.maxPossibleHieght = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder setDiskRadius(int diskRadius) {
            this.diskRadius = Math.abs(diskRadius);
            return this;
        }

        public Builder setWhitelist(ImmutableList<Block> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public Builder copy(PFTreeConfig config) {
            this.trunkProvider = config.trunkProvider;
            this.leavesProvider = config.leavesProvider;
            this.groundReplacementProvider = config.groundReplacementProvider;
            this.diskProvider = config.diskProvider;
            this.maxPossibleHieght = config.maxHeight;
            this.minHeight = config.minHeight;
            this.diskRadius = config.diskRadius;
            this.whitelist = ImmutableList.copyOf((Collection)config.whitelist);
            return this;
        }

        public PFTreeConfig build() {
            return new PFTreeConfig(this.trunkProvider, this.leavesProvider, this.groundReplacementProvider, this.diskProvider, this.minHeight, this.maxPossibleHieght, this.diskRadius, this.whitelist.stream().map(Block::func_176223_P).collect(Collectors.toList()));
        }
    }
}

