/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.dimension.triassic;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.traits.ICastleTransformer;
import superlord.prehistoricfauna.init.PFBiomes;
import superlord.prehistoricfauna.world.dimension.triassic.TriassicLayerUtil;

public enum TriassicRiverLayer implements ICastleTransformer
{
    INSTANCE;

    private boolean ischigualasto = false;
    private boolean chinle = false;
    private List<Integer> ischigualastoBiomes = ImmutableList.of((Object)TriassicLayerUtil.getBiomeId(PFBiomes.ISCHIGUALASTO_CLEARING_BIOME.getKey()), (Object)TriassicLayerUtil.getBiomeId(PFBiomes.ISCHIGUALASTO_FOREST_BIOME.getKey()), (Object)TriassicLayerUtil.getBiomeId(PFBiomes.ISCHIGUALASTO_HILLS_BIOME.getKey()));
    private List<Integer> chinleBiomes = ImmutableList.of((Object)TriassicLayerUtil.getBiomeId(PFBiomes.CHINLE_FLATS_BIOME.getKey()), (Object)TriassicLayerUtil.getBiomeId(PFBiomes.CHINLE_SWAMP_BIOME.getKey()), (Object)TriassicLayerUtil.getBiomeId(PFBiomes.CHINLE_WOODED_MOUNTAINS_BIOME.getKey()));

    public int func_202748_a(INoiseRandom random, int north, int west, int south, int east, int center) {
        if (this.shouldRiver(center, west, south, east, north)) {
            if (this.ischigualasto) {
                return TriassicLayerUtil.getBiomeId(PFBiomes.ISCHIGUALASTO_RIVER_BIOME.getKey());
            }
            if (this.chinle) {
                return TriassicLayerUtil.getBiomeId(PFBiomes.CHINLE_RIVER_BIOME.getKey());
            }
            return -1;
        }
        return -1;
    }

    boolean shouldRiver(int mid, int left, int down, int right, int up) {
        return this.shouldRiver(mid, left) || this.shouldRiver(mid, right) || this.shouldRiver(mid, down) || this.shouldRiver(mid, up);
    }

    boolean shouldRiver(int id1, int id2) {
        if (id1 == id2) {
            return false;
        }
        if (id1 == id2) {
            return false;
        }
        this.ischigualasto = this.ischigualastoBiomes.contains(id1) || this.ischigualastoBiomes.contains(id2);
        this.chinle = this.chinleBiomes.contains(id1) || this.chinleBiomes.contains(id2);
        return true;
    }
}

