/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.dimension.triassic;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.layer.Layer;
import superlord.prehistoricfauna.PrehistoricFauna;
import superlord.prehistoricfauna.init.PFBiomes;
import superlord.prehistoricfauna.world.dimension.WorldSeedHolder;
import superlord.prehistoricfauna.world.dimension.triassic.TriassicLayerUtil;

public class TriassicBiomeProvider
extends BiomeProvider {
    public static final Codec<TriassicBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").orElseGet(WorldSeedHolder::getSeed).forGetter(chunkGenerator -> chunkGenerator.seed), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(obj -> obj.registry)).apply((Applicative)instance, instance.stable(TriassicBiomeProvider::new)));
    private final long seed;
    private final Registry<Biome> registry;
    private final Layer genBiomes;
    private static final List<RegistryKey<Biome>> biomes = ImmutableList.of(PFBiomes.ISCHIGUALASTO_FOREST_BIOME.getKey(), PFBiomes.ISCHIGUALASTO_CLEARING_BIOME.getKey(), PFBiomes.ISCHIGUALASTO_HILLS_BIOME.getKey(), PFBiomes.ISCHIGUALASTO_RIVER_BIOME.getKey(), PFBiomes.CHINLE_SWAMP_BIOME.getKey(), PFBiomes.CHINLE_FLATS_BIOME.getKey(), PFBiomes.CHINLE_WOODED_MOUNTAINS_BIOME.getKey());

    public TriassicBiomeProvider(long seed, Registry<Biome> registry) {
        super(biomes.stream().map(define -> () -> (Biome)registry.func_243576_d(define)));
        this.seed = seed;
        this.registry = registry;
        this.genBiomes = TriassicLayerUtil.makeLayers(seed, registry);
    }

    public BiomeProvider func_230320_a_(long seed) {
        return new TriassicBiomeProvider(seed, this.registry);
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.getBiomeFromPos(this.registry, x, z);
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    public Biome getBiomeFromPos(Registry<Biome> registry, int x, int z) {
        int i = this.genBiomes.field_215742_b.func_202678_a(x, z);
        Biome biome = (Biome)registry.func_148745_a(i);
        if (biome == null) {
            if (SharedConstants.field_206244_b) {
                throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Unkown biome id: " + i));
            }
            PrehistoricFauna.LOGGER.warn("Unknown biome id: ", (Object)i);
            return (Biome)registry.func_230516_a_(BiomeRegistry.func_244203_a((int)0));
        }
        return biome;
    }
}

