/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.biome.triassic;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import superlord.prehistoricfauna.common.world.PFConfiguredFeatures;
import superlord.prehistoricfauna.common.world.PFSurfaceBuilders;
import superlord.prehistoricfauna.common.world.WorldGenRegistrationHelper;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.world.biome.PFBiome;
import superlord.prehistoricfauna.world.biome.triassic.ChinleFlatsBiome;
import superlord.prehistoricfauna.world.biome.triassic.ChinleWoodedMountainsBiome;

public class ChinleSwampBiome
extends PFBiome {
    static final ConfiguredSurfaceBuilder<?> SURFACE_BUILDER = WorldGenRegistrationHelper.createConfiguredSurfaceBuilder("chinle_swamp_sb", new ConfiguredSurfaceBuilder(PFSurfaceBuilders.CHINLE_SWAMP, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(PFBlocks.MOSSY_DIRT.func_176223_P(), Blocks.field_196660_k.func_176223_P(), Blocks.field_196660_k.func_176223_P())));
    static final Biome.RainType PRECIPITATION = Biome.RainType.RAIN;
    static final Biome.Category CATEGORY = Biome.Category.NONE;
    static final float TEMPERATURE = 0.9f;
    static final float DOWNFALL = 0.9f;
    static final int WATER_COLOR = 7372597;
    static final int WATER_FOG_COLOR = 5267523;
    static final int SKY_COLOR = 15922646;
    static final int FOLIAGE_COLOR = 7372597;
    static final int FOG_COLOR = 13622197;
    static final float DEPTH = -0.2f;
    static final float SCALE = 0.0f;
    static final Biome.Climate WEATHER = new Biome.Climate(PRECIPITATION, 0.9f, Biome.TemperatureModifier.NONE, 0.9f);
    static final MobSpawnInfo.Builder SPAWN_SETTINGS = new MobSpawnInfo.Builder().func_242571_a();
    static final BiomeGenerationSettings.Builder GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().func_242517_a(SURFACE_BUILDER);

    public ChinleSwampBiome() {
        super(WEATHER, CATEGORY, -0.2f, 0.0f, new BiomeAmbience.Builder().func_235246_b_(7372597).func_235248_c_(5267523).func_242539_d(15922646).func_235239_a_(13622197).func_242540_e(7372597).func_242541_f(7372597).func_235238_a_(), GENERATION_SETTINGS.func_242508_a(), SPAWN_SETTINGS.func_242577_b());
    }

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeDictionary() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.HOT};
    }

    @Override
    public Biome getClearing() {
        return new ChinleFlatsBiome().getBiome();
    }

    @Override
    public Biome getHills() {
        return new ChinleWoodedMountainsBiome().getBiome();
    }

    @Override
    public BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.WARM;
    }

    static {
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        PFConfiguredFeatures.withChinlePlants(GENERATION_SETTINGS);
        if (PrehistoricFaunaConfig.caveSentinelChinleSwampSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.TRILOBITE_SENTINEL_ENTITY, PrehistoricFaunaConfig.caveSentinelChinleSwampSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.landSentinelChinleSwampSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.LAND_SENTINEL_ENTITY, PrehistoricFaunaConfig.landSentinelChinleSwampSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.desmatosuchusChinleSwampSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.DESMATOSUCHUS_ENTITY, PrehistoricFaunaConfig.desmatosuchusChinleSwampSpawnWeight, 2, 4));
        }
        if (PrehistoricFaunaConfig.trilophosaurusChinleSwampSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.TRILOPHOSAURUS_ENTITY, PrehistoricFaunaConfig.trilophosaurusChinleSwampSpawnWeight, 1, 3));
        }
        if (PrehistoricFaunaConfig.chinleaChinleSwampSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(PFEntities.CHINLEA_ENTITY, PrehistoricFaunaConfig.chinleaChinleSwampSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.arganodusChinleSwampSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(PFEntities.ARGANODUS_ENTITY, PrehistoricFaunaConfig.saurichthysChinleSwampSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.mooreodontusChinleSwampSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(PFEntities.MOOREODONTUS_ENTITY, PrehistoricFaunaConfig.saurichthysChinleSwampSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.saurichthysChinleSwampSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(PFEntities.SAURICHTHYS_ENTITY, PrehistoricFaunaConfig.saurichthysChinleSwampSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.postosuchusChinleSwampSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.POSTOSUCHUS_ENTITY, PrehistoricFaunaConfig.postosuchusChinleSwampSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.placeriasChinleSwampSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.PLACERIAS_ENTITY, PrehistoricFaunaConfig.placeriasChinleSwampSpawnWeight, 1, 4));
        }
        if (PrehistoricFaunaConfig.coelophysisChinleSwampSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.COELOPHYSIS_ENTITY, PrehistoricFaunaConfig.coelophysisChinleSwampSpawnWeight, 1, 3));
        }
        if (PrehistoricFaunaConfig.poposaurusChinleSwampSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.POPOSAURUS_ENTITY, PrehistoricFaunaConfig.poposaurusChinleSwampSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.typothoraxChinleSwampSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.TYPOTHORAX_ENTITY, PrehistoricFaunaConfig.typothoraxChinleSwampSpawnWeight, 1, 4));
        }
    }
}

