/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.biome.triassic;

import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import superlord.prehistoricfauna.common.world.PFConfiguredFeatures;
import superlord.prehistoricfauna.common.world.PFSurfaceBuilders;
import superlord.prehistoricfauna.common.world.WorldGenRegistrationHelper;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.world.biome.PFBiome;

public class ChinleRiverBiome
extends PFBiome {
    static final ConfiguredSurfaceBuilder<?> SURFACE_BUILDER = WorldGenRegistrationHelper.createConfiguredSurfaceBuilder("chinle_river_sb", new ConfiguredSurfaceBuilder(PFSurfaceBuilders.CHINLE_FLATS, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(PFBlocks.SILT.func_176223_P(), PFBlocks.HARDENED_SILT.func_176223_P(), PFBlocks.SILT.func_176223_P())));
    static final Biome.RainType PRECIPITATION = Biome.RainType.RAIN;
    static final Biome.Category CATEGORY = Biome.Category.NONE;
    static final float TEMPERATURE = 0.9f;
    static final float DOWNFALL = 0.9f;
    static final int WATER_COLOR = 7372597;
    static final int WATER_FOG_COLOR = 5267523;
    static final int SKY_COLOR = 15922646;
    static final int FOLIAGE_COLOR = 7372597;
    static final int FOG_COLOR = 13622197;
    static final float SCALE = 0.05f;
    static final float DEPTH = -0.6f;
    static final Biome.Climate WEATHER = new Biome.Climate(PRECIPITATION, 0.9f, Biome.TemperatureModifier.NONE, 0.9f);
    static final MobSpawnInfo.Builder SPAWN_SETTINGS = new MobSpawnInfo.Builder().func_242571_a();
    static final BiomeGenerationSettings.Builder GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().func_242517_a(SURFACE_BUILDER);

    public ChinleRiverBiome() {
        super(WEATHER, CATEGORY, -0.6f, 0.05f, new BiomeAmbience.Builder().func_235246_b_(7372597).func_235248_c_(5267523).func_242539_d(ChinleRiverBiome.getSkyColorWithTemperatureModifier(0.9f)).func_235239_a_(13622197).func_242540_e(7372597).func_235238_a_(), GENERATION_SETTINGS.func_242508_a(), SPAWN_SETTINGS.func_242577_b());
    }

    @Override
    public Biome getRiver() {
        return this.getBiome();
    }

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeDictionary() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.HOT};
    }

    @Override
    public BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.WARM;
    }

    static {
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        PFConfiguredFeatures.withClayDisks(GENERATION_SETTINGS);
        PFConfiguredFeatures.withChinleRiverPlants(GENERATION_SETTINGS);
        PFConfiguredFeatures.withDeadPlants(GENERATION_SETTINGS);
        if (PrehistoricFaunaConfig.caveSentinelChinleRiverSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.TRILOBITE_SENTINEL_ENTITY, PrehistoricFaunaConfig.caveSentinelChinleRiverSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.landSentinelChinleRiverSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.LAND_SENTINEL_ENTITY, PrehistoricFaunaConfig.landSentinelChinleRiverSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.chinleaChinleRiverSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.CHINLEA_ENTITY, PrehistoricFaunaConfig.chinleaChinleRiverSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.arganodusChinleRiverSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.ARGANODUS_ENTITY, PrehistoricFaunaConfig.arganodusChinleRiverSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.saurichthysChinleRiverSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.SAURICHTHYS_ENTITY, PrehistoricFaunaConfig.saurichthysChinleRiverSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.mooreodontusChinleRiverSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.MOOREODONTUS_ENTITY, PrehistoricFaunaConfig.mooreodontusChinleRiverSpawnWeight, 1, 2));
        }
    }
}

