/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.biome.jurassic;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import superlord.prehistoricfauna.common.world.PFConfiguredFeatures;
import superlord.prehistoricfauna.common.world.PFSurfaceBuilders;
import superlord.prehistoricfauna.common.world.WorldGenRegistrationHelper;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.world.biome.PFBiome;

public class MorrisonSavannahHillsBiome
extends PFBiome {
    static final ConfiguredSurfaceBuilder<?> SURFACE_BUILDER = WorldGenRegistrationHelper.createConfiguredSurfaceBuilder("morrison_savannah_hills_sb", new ConfiguredSurfaceBuilder(PFSurfaceBuilders.MORRISON_SAVANNA, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(PFBlocks.HARDENED_SILT.func_176223_P(), PFBlocks.HARDENED_SILT.func_176223_P(), Blocks.field_150435_aG.func_176223_P())));
    static final Biome.RainType PRECIPATATION = Biome.RainType.NONE;
    static final Biome.Category CATEGORY = Biome.Category.NONE;
    static final float TEMPERATURE = 1.0f;
    static final float DOWNFALL = 0.2f;
    static final int WATER_COLOR = 11245677;
    static final int WATER_FOG_COLOR = 10259559;
    static final int FOG_COLOR = 12638463;
    static final float SCALE = 0.1f;
    static final float DEPTH = 0.2f;
    static final Biome.Climate WEATHER = new Biome.Climate(PRECIPATATION, 1.0f, Biome.TemperatureModifier.NONE, 0.2f);
    static final MobSpawnInfo.Builder SPAWN_SETTINGS = new MobSpawnInfo.Builder().func_242571_a();
    static final BiomeGenerationSettings.Builder GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().func_242517_a(SURFACE_BUILDER);

    public MorrisonSavannahHillsBiome() {
        super(WEATHER, CATEGORY, 0.2f, 0.1f, new BiomeAmbience.Builder().func_235246_b_(11245677).func_235248_c_(10259559).func_242539_d(MorrisonSavannahHillsBiome.getSkyColorWithTemperatureModifier(1.0f)).func_235239_a_(12638463).func_235238_a_(), GENERATION_SETTINGS.func_242508_a(), SPAWN_SETTINGS.func_242577_b());
    }

    @Override
    public Biome getHills() {
        return this.getBiome();
    }

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeDictionary() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HOT};
    }

    @Override
    public BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.WARM;
    }

    static {
        PFConfiguredFeatures.addMorrisonSavannaVegetation(GENERATION_SETTINGS);
        if (PrehistoricFaunaConfig.stegosaurusMorrisonSavannahSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.STEGOSAURUS_ENTITY, PrehistoricFaunaConfig.stegosaurusMorrisonSavannahSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.dryosaurusMorrisonSavannahSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.DRYOSAURUS_ENTITY, PrehistoricFaunaConfig.dryosaurusMorrisonSavannahSpawnWeight, 2, 4));
        }
        if (PrehistoricFaunaConfig.ceratosaurusMorrisonSavannahSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.CERATOSAURUS_ENTITY, PrehistoricFaunaConfig.ceratosaurusMorrisonSavannahSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.allosaurusMorrisonSavannahSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.ALLOSAURUS_ENTITY, PrehistoricFaunaConfig.allosaurusMorrisonSavannahSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.hesperornithoidesMorrisonSavannahSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.HESPERORNITHOIDES_ENTITY, PrehistoricFaunaConfig.hesperornithoidesMorrisonSavannahSpawnWeight, 2, 3));
        }
        if (PrehistoricFaunaConfig.eilenodonMorrisonSavannahSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.EILENODON_ENTITY, PrehistoricFaunaConfig.eilenodonMorrisonSavannahSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.camarasaurusMorrisonSavannahSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.CAMARASAURUS_ENTITY, PrehistoricFaunaConfig.camarasaurusMorrisonSavannahSpawnWeight, 2, 4));
        }
        if (PrehistoricFaunaConfig.ceratodusMorrisonSavannahSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(PFEntities.CERATODUS, PrehistoricFaunaConfig.ceratodusMorrisonSavannahSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.potamoceratodusMorrisonSavannahSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(PFEntities.POTAMOCERATODUS, PrehistoricFaunaConfig.potamoceratodusMorrisonSavannahSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.caveSentinelMorrisonSavannahSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.TRILOBITE_SENTINEL_ENTITY, PrehistoricFaunaConfig.caveSentinelMorrisonSavannahSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.landSentinelMorrisonSavannahSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.LAND_SENTINEL_ENTITY, PrehistoricFaunaConfig.landSentinelMorrisonSavannahSpawnWeight, 1, 1));
        }
        GENERATION_SETTINGS.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, PFConfiguredFeatures.JURASSIC_FOSSILIZED_SANDSTONE);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        PFConfiguredFeatures.addExtraIronOre(GENERATION_SETTINGS);
        PFConfiguredFeatures.addMorrisonHillsVegetation(GENERATION_SETTINGS);
    }
}

