/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.biome.jurassic;

import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import superlord.prehistoricfauna.common.world.PFConfiguredFeatures;
import superlord.prehistoricfauna.common.world.PFSurfaceBuilders;
import superlord.prehistoricfauna.common.world.WorldGenRegistrationHelper;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.world.biome.PFBiome;

public class KayentaDesertBiome
extends PFBiome {
    static final ConfiguredSurfaceBuilder<?> SURFACE_BUILDER = WorldGenRegistrationHelper.createConfiguredSurfaceBuilder("kayenta_desert_sb", new ConfiguredSurfaceBuilder(PFSurfaceBuilders.KAYENTA_DESERT, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(PFBlocks.SILT.func_176223_P(), PFBlocks.SILT.func_176223_P(), PFBlocks.HARDENED_SILT.func_176223_P())));
    static final Biome.RainType PRECIPATATION = Biome.RainType.NONE;
    static final Biome.Category CATEGORY = Biome.Category.NONE;
    static final float TEMPERATURE = 1.2f;
    static final float DOWNFALL = 0.0f;
    static final int WATER_COLOR = 2187172;
    static final int WATER_FOG_COLOR = 3630722;
    static final int SKY_COLOR = 9743839;
    static final int FOLIAGE_COLOR = 5468447;
    static final int GRASS_COLOR = 5468447;
    static final int FOG_COLOR = 14587735;
    static final float DEPTH = 0.0f;
    static final float SCALE = 0.0f;
    static final Biome.Climate WEATHER = new Biome.Climate(PRECIPATATION, 1.2f, Biome.TemperatureModifier.NONE, 0.0f);
    static final MobSpawnInfo.Builder SPAWN_SETTINGS = new MobSpawnInfo.Builder().func_242571_a();
    static final BiomeGenerationSettings.Builder GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().func_242517_a(SURFACE_BUILDER);

    public KayentaDesertBiome() {
        super(WEATHER, CATEGORY, 0.0f, 0.0f, new BiomeAmbience.Builder().func_235246_b_(2187172).func_235248_c_(3630722).func_242539_d(9743839).func_235239_a_(14587735).func_242540_e(5468447).func_242541_f(5468447).func_235238_a_(), GENERATION_SETTINGS.func_242508_a(), SPAWN_SETTINGS.func_242577_b());
    }

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeDictionary() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DRY};
    }

    @Override
    public BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.WARM;
    }

    static {
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        GENERATION_SETTINGS.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, PFConfiguredFeatures.JURASSIC_FOSSILIZED_SANDSTONE);
        PFConfiguredFeatures.withDeadPlants(GENERATION_SETTINGS);
        PFConfiguredFeatures.addKayentaDesertRocks(GENERATION_SETTINGS);
        GENERATION_SETTINGS.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PFConfiguredFeatures.ZAMITES_BUSH);
        if (PrehistoricFaunaConfig.calsoyasuchusKayentaDesertSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.CALSOYASUCHUS_ENTITY, PrehistoricFaunaConfig.calsoyasuchusKayentaDesertSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.dilophosaurusKayentaDesertSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.DILOPHOSAURUS_ENTITY, PrehistoricFaunaConfig.dilophosaurusKayentaDesertSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.sarahsaurusKayentaDesertSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.SARAHSAURUS_ENTITY, PrehistoricFaunaConfig.sarahsaurusKayentaDesertSpawnWeight, 1, 3));
        }
        if (PrehistoricFaunaConfig.scelidosaurusKayentaDesertSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.SCELIDOSAURUS_ENTITY, PrehistoricFaunaConfig.scelidosaurusKayentaDesertSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.ceratodusKayentaDesertSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(PFEntities.CERATODUS, PrehistoricFaunaConfig.ceratodusKayentaDesertSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.potamoceratodusKayentaDesertSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(PFEntities.POTAMOCERATODUS, PrehistoricFaunaConfig.potamoceratodusKayentaDesertSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.caveSentinelKayentaDesertSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.TRILOBITE_SENTINEL_ENTITY, PrehistoricFaunaConfig.caveSentinelKayentaDesertSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.landSentinelKayentaDesertSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.LAND_SENTINEL_ENTITY, PrehistoricFaunaConfig.landSentinelKayentaDesertSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.scutellosaurusKayentaDesertSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.SCUTELLOSAURUS_ENTITY, PrehistoricFaunaConfig.scutellosaurusKayentaDesertSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.megapnosaurusKayentaDesertSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.MEGAPNOSAURUS_ENTITY, PrehistoricFaunaConfig.megapnosaurusKayentaDesertSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.kayentatheriumKayentaDesertSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.KAYENTATHERIUM_ENTITY, PrehistoricFaunaConfig.kayentatheriumKayentaDesertSpawnWeight, 1, 2));
        }
    }
}

