/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.biome.jurassic;

import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import superlord.prehistoricfauna.common.world.PFConfiguredFeatures;
import superlord.prehistoricfauna.common.world.PFSurfaceBuilders;
import superlord.prehistoricfauna.common.world.WorldGenRegistrationHelper;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.world.biome.PFBiome;

public class KayentaButtesBiome
extends PFBiome {
    static final ConfiguredSurfaceBuilder<?> SURFACE_BUILDER = WorldGenRegistrationHelper.createConfiguredSurfaceBuilder("kayenta_buttes_sb", new ConfiguredSurfaceBuilder(PFSurfaceBuilders.KAYENTA_BUTTES, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(PFBlocks.SILT.func_176223_P(), PFBlocks.SILT.func_176223_P(), PFBlocks.HARDENED_SILT.func_176223_P())));
    static final Biome.RainType PRECIPATATION = Biome.RainType.NONE;
    static final Biome.Category CATEGORY = Biome.Category.NONE;
    static final float TEMPERATURE = 1.2f;
    static final float DOWNFALL = 0.0f;
    static final int WATER_COLOR = 2187172;
    static final int WATER_FOG_COLOR = 3630722;
    static final int SKY_COLOR = 9743839;
    static final int FOLIAGE_COLOR = 5468447;
    static final int GRASS_COLOR = 5468447;
    static final int FOG_COLOR = 14587735;
    static final float DEPTH = 0.05f;
    static final float SCALE = 0.0f;
    static final Biome.Climate WEATHER = new Biome.Climate(PRECIPATATION, 1.2f, Biome.TemperatureModifier.NONE, 0.0f);
    static final MobSpawnInfo.Builder SPAWN_SETTINGS = new MobSpawnInfo.Builder().func_242571_a();
    static final BiomeGenerationSettings.Builder GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().func_242517_a(SURFACE_BUILDER);

    public KayentaButtesBiome() {
        super(WEATHER, CATEGORY, 0.05f, 0.0f, new BiomeAmbience.Builder().func_235246_b_(2187172).func_235248_c_(3630722).func_242539_d(9743839).func_235239_a_(14587735).func_242540_e(5468447).func_242541_f(5468447).func_235238_a_(), GENERATION_SETTINGS.func_242508_a(), SPAWN_SETTINGS.func_242577_b());
    }

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeDictionary() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DRY};
    }

    @Override
    public BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.WARM;
    }

    static {
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        GENERATION_SETTINGS.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, PFConfiguredFeatures.JURASSIC_FOSSILIZED_SANDSTONE);
        PFConfiguredFeatures.addKayentaCanyonVegetation(GENERATION_SETTINGS);
        if (PrehistoricFaunaConfig.calsoyasuchusKayentaButtesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.CALSOYASUCHUS_ENTITY, PrehistoricFaunaConfig.calsoyasuchusKayentaButtesSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.dilophosaurusKayentaButtesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.DILOPHOSAURUS_ENTITY, PrehistoricFaunaConfig.dilophosaurusKayentaButtesSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.sarahsaurusKayentaButtesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.SARAHSAURUS_ENTITY, PrehistoricFaunaConfig.sarahsaurusKayentaButtesSpawnWeight, 1, 3));
        }
        if (PrehistoricFaunaConfig.scelidosaurusKayentaButtesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.SCELIDOSAURUS_ENTITY, PrehistoricFaunaConfig.scelidosaurusKayentaButtesSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.ceratodusKayentaButtesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(PFEntities.CERATODUS, PrehistoricFaunaConfig.ceratodusKayentaButtesSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.potamoceratodusKayentaButtesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(PFEntities.POTAMOCERATODUS, PrehistoricFaunaConfig.potamoceratodusKayentaButtesSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.caveSentinelKayentaButtesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.TRILOBITE_SENTINEL_ENTITY, PrehistoricFaunaConfig.caveSentinelKayentaButtesSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.landSentinelKayentaButtesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.LAND_SENTINEL_ENTITY, PrehistoricFaunaConfig.landSentinelKayentaButtesSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.scutellosaurusKayentaButtesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.SCUTELLOSAURUS_ENTITY, PrehistoricFaunaConfig.scutellosaurusKayentaButtesSpawnWeight, 2, 3));
        }
        if (PrehistoricFaunaConfig.megapnosaurusKayentaButtesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.MEGAPNOSAURUS_ENTITY, PrehistoricFaunaConfig.megapnosaurusKayentaButtesSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.kayentatheriumKayentaButtesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.KAYENTATHERIUM_ENTITY, PrehistoricFaunaConfig.kayentatheriumKayentaButtesSpawnWeight, 1, 2));
        }
    }
}

