/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.biome.cretaceous;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import superlord.prehistoricfauna.common.world.PFConfiguredFeatures;
import superlord.prehistoricfauna.common.world.PFSurfaceBuilders;
import superlord.prehistoricfauna.common.world.WorldGenRegistrationHelper;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.world.biome.PFBiome;
import superlord.prehistoricfauna.world.biome.cretaceous.HellCreekRiverBiome;

public class HellCreekClearingBiome
extends PFBiome {
    static final ConfiguredSurfaceBuilder<?> SURFACE_BUILDER = WorldGenRegistrationHelper.createConfiguredSurfaceBuilder("hell_creek_clearing_sb", new ConfiguredSurfaceBuilder(PFSurfaceBuilders.HELL_CREEK, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(PFBlocks.MOSSY_DIRT.func_176223_P(), Blocks.field_196660_k.func_176223_P(), Blocks.field_196660_k.func_176223_P())));
    static final Biome.RainType PRECIPATATION = Biome.RainType.RAIN;
    static final Biome.Category CATEGORY = Biome.Category.NONE;
    static final float TEMPERATURE = 0.7f;
    static final float DOWNFALL = 0.8f;
    static final int WATER_COLOR = 8150344;
    static final int WATER_FOG_COLOR = 7032379;
    static final int SKY_COLOR = 8306591;
    static final int FOLIAGE_COLOR = 5468447;
    static final int GRASS_COLOR = 5468447;
    static final int FOG_COLOR = 12638463;
    static final float DEPTH = 0.1f;
    static final float SCALE = 0.1f;
    static final Biome.Climate WEATHER = new Biome.Climate(PRECIPATATION, 0.7f, Biome.TemperatureModifier.NONE, 0.8f);
    static final MobSpawnInfo.Builder SPAWN_SETTINGS = new MobSpawnInfo.Builder().func_242571_a();
    static final BiomeGenerationSettings.Builder GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().func_242517_a(SURFACE_BUILDER);

    public HellCreekClearingBiome() {
        super(WEATHER, CATEGORY, 0.1f, 0.1f, new BiomeAmbience.Builder().func_235246_b_(8150344).func_235248_c_(7032379).func_242539_d(8306591).func_235239_a_(12638463).func_242540_e(5468447).func_242541_f(5468447).func_235238_a_(), GENERATION_SETTINGS.func_242508_a(), SPAWN_SETTINGS.func_242577_b());
    }

    @Override
    public Biome getRiver() {
        return new HellCreekRiverBiome().getBiome();
    }

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeDictionary() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.LUSH};
    }

    @Override
    public BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.COOL;
    }

    static {
        PFConfiguredFeatures.withHellCreekVegetation(GENERATION_SETTINGS);
        if (PrehistoricFaunaConfig.didelphodonHellCreekClearingSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.DIDELPHODON_ENTITY, PrehistoricFaunaConfig.didelphodonHellCreekClearingSpawnWeight, 1, 3));
        }
        if (PrehistoricFaunaConfig.dakotaraptorHellCreekClearingSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.DAKOTARAPTOR_ENTITY, PrehistoricFaunaConfig.dakotaraptorHellCreekClearingSpawnWeight, 1, 3));
        }
        if (PrehistoricFaunaConfig.tyrannosaurusHellCreekClearingSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.TYRANNOSAURUS_ENTITY, PrehistoricFaunaConfig.tyrannosaurusHellCreekClearingSpawnWeight, 1, 1));
        }
        PFConfiguredFeatures.addSparseHellCreekVegetation(GENERATION_SETTINGS);
        GENERATION_SETTINGS.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, PFConfiguredFeatures.CRETACEOUS_FOSSILIZED_SANDSTONE);
        GENERATION_SETTINGS.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, PFConfiguredFeatures.CRETACEOUS_FOSSILIZED_SILTSTONE);
        if (PrehistoricFaunaConfig.thescelosaurusHellCreekClearingSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.THESCELOSAURUS_ENTITY, PrehistoricFaunaConfig.thescelosaurusHellCreekClearingSpawnWeight, 2, 4));
        }
        if (PrehistoricFaunaConfig.triceratopsHellCreekClearingSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.TRICERATOPS_ENTITY, PrehistoricFaunaConfig.triceratopsHellCreekClearingSpawnWeight, 2, 3));
        }
        if (PrehistoricFaunaConfig.ankylosaurusHellCreekClearingSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.ANKYLOSAURUS_ENTITY, PrehistoricFaunaConfig.ankylosaurusHellCreekClearingSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.baseStoneWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.BASILEMYS_ENTITY, PrehistoricFaunaConfig.basilemysHellCreekClearingSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.caveSentinelHellCreekClearingSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.TRILOBITE_SENTINEL_ENTITY, PrehistoricFaunaConfig.caveSentinelHellCreekClearingSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.landSentinelHellCreekClearingSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.LAND_SENTINEL_ENTITY, PrehistoricFaunaConfig.landSentinelHellCreekClearingSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.garHellCreekClearingSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(PFEntities.GAR, PrehistoricFaunaConfig.garHellCreekClearingSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.cyclurusHellCreekClearingSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(PFEntities.CYCLURUS, PrehistoricFaunaConfig.cyclurusHellCreekClearingSpawnWeight, 1, 3));
        }
        if (PrehistoricFaunaConfig.myledaphusHellCreekClearingSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(PFEntities.MYLEDAPHUS, PrehistoricFaunaConfig.myledaphusHellCreekClearingSpawnWeight, 1, 7));
        }
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
    }
}

