/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.biome.cretaceous;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import superlord.prehistoricfauna.common.world.PFConfiguredFeatures;
import superlord.prehistoricfauna.common.world.PFSurfaceBuilders;
import superlord.prehistoricfauna.common.world.WorldGenRegistrationHelper;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.world.biome.PFBiome;
import superlord.prehistoricfauna.world.biome.cretaceous.DjadochtaArroyoBiome;

public class DjadochtaDunesBiome
extends PFBiome {
    static final ConfiguredSurfaceBuilder<?> SURFACE_BUILDER = WorldGenRegistrationHelper.createConfiguredSurfaceBuilder("djadochta_dunes_sb", new ConfiguredSurfaceBuilder(PFSurfaceBuilders.DJADOCHTA_DUNES, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(Blocks.field_150354_m.func_176223_P(), Blocks.field_150354_m.func_176223_P(), Blocks.field_150322_A.func_176223_P())));
    static final Biome.RainType PRECIPATATION = Biome.RainType.NONE;
    static final Biome.Category CATEGORY = Biome.Category.NONE;
    static final float TEMPERATURE = 1.0f;
    static final float DOWNFALL = 0.2f;
    static final int WATER_COLOR = 0x66866B;
    static final int WATER_FOG_COLOR = 10259559;
    static final int FOG_COLOR = 12638463;
    static final Biome.Climate WEATHER = new Biome.Climate(PRECIPATATION, 1.0f, Biome.TemperatureModifier.NONE, 0.2f);
    static final MobSpawnInfo.Builder SPAWN_SETTINGS = new MobSpawnInfo.Builder().func_242571_a();
    static final BiomeGenerationSettings.Builder GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().func_242517_a(SURFACE_BUILDER);

    public DjadochtaDunesBiome(float scale, float depth) {
        super(WEATHER, CATEGORY, depth, scale, new BiomeAmbience.Builder().func_235246_b_(0x66866B).func_235248_c_(10259559).func_242539_d(8372479).func_235239_a_(12638463).func_235238_a_(), GENERATION_SETTINGS.func_242508_a(), SPAWN_SETTINGS.func_242577_b());
    }

    @Override
    public Biome getClearing() {
        return new DjadochtaArroyoBiome(0.05f, 0.2f).getBiome();
    }

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeDictionary() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HOT};
    }

    @Override
    public BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.WARM;
    }

    static {
        GENERATION_SETTINGS.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, PFConfiguredFeatures.CRETACEOUS_FOSSILIZED_SANDSTONE);
        GENERATION_SETTINGS.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, PFConfiguredFeatures.CRETACEOUS_FOSSILIZED_SILTSTONE);
        PFConfiguredFeatures.withRareDeadCycadeoid(GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        if (PrehistoricFaunaConfig.caveSentinelDjadochtaDunesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.TRILOBITE_SENTINEL_ENTITY, PrehistoricFaunaConfig.caveSentinelDjadochtaDunesSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.landSentinelDjadochtaDunesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.LAND_SENTINEL_ENTITY, PrehistoricFaunaConfig.landSentinelDjadochtaDunesSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.protoceratopsDjadochtaDunesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.PROTOCERATOPS_ENTITY, PrehistoricFaunaConfig.protoceratopsDjadochtaDunesSpawnWeight, 2, 5));
        }
        if (PrehistoricFaunaConfig.velociraptorDjadochtaDunesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.VELOCIRAPTOR_ENTITY, PrehistoricFaunaConfig.velociraptorDjadochtaDunesSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.citipatiDjadochtaDunesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.CITIPATI_ENTITY, PrehistoricFaunaConfig.citipatiDjadochtaDunesSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.aepyornithomimusDjadochtaDunesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.AEPYORNITHOMIMUS_ENTITY, PrehistoricFaunaConfig.aepyornithomimusDjadochtaDunesSpawnWeight, 2, 3));
        }
        if (PrehistoricFaunaConfig.telmasaurusDjadochtaDunesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.TELMASAURUS_ENTITY, PrehistoricFaunaConfig.telmasaurusDjadochtaDunesSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.pinacosaurusDjadochtaDunesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.PINACOSAURUS_ENTITY, PrehistoricFaunaConfig.pinacosaurusDjadochtaDunesSpawnWeight, 3, 4));
        }
        if (PrehistoricFaunaConfig.plesiohadrosDjadochtaDunesSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.PLESIOHADROS_ENTITY, PrehistoricFaunaConfig.plesiohadrosDjadochtaDunesSpawnWeight, 3, 5));
        }
    }
}

