/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.biome.cretaceous;

import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import superlord.prehistoricfauna.common.world.PFConfiguredFeatures;
import superlord.prehistoricfauna.common.world.PFSurfaceBuilders;
import superlord.prehistoricfauna.common.world.WorldGenRegistrationHelper;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.world.biome.PFBiome;

public class DjadochtaArroyoBiome
extends PFBiome {
    static final ConfiguredSurfaceBuilder<?> SURFACE_BUILDER = WorldGenRegistrationHelper.createConfiguredSurfaceBuilder("djadochta_arroyo_sb", new ConfiguredSurfaceBuilder(PFSurfaceBuilders.DJADOCHTA_ARROYO, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(PFBlocks.SILT.func_176223_P(), PFBlocks.HARDENED_SILT.func_176223_P(), PFBlocks.HARDENED_SILT.func_176223_P())));
    static final Biome.RainType PRECIPATATION = Biome.RainType.NONE;
    static final Biome.Category CATEGORY = Biome.Category.NONE;
    static final float TEMPERATURE = 1.0f;
    static final float DOWNFALL = 0.2f;
    static final int WATER_COLOR = 0x66866B;
    static final int WATER_FOG_COLOR = 10259559;
    static final int FOG_COLOR = 12638463;
    static final Biome.Climate WEATHER = new Biome.Climate(PRECIPATATION, 1.0f, Biome.TemperatureModifier.NONE, 0.2f);
    static final MobSpawnInfo.Builder SPAWN_SETTINGS = new MobSpawnInfo.Builder().func_242571_a();
    static final BiomeGenerationSettings.Builder GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().func_242517_a(SURFACE_BUILDER);

    public DjadochtaArroyoBiome(float scale, float depth) {
        super(WEATHER, CATEGORY, depth, scale, new BiomeAmbience.Builder().func_235246_b_(0x66866B).func_235248_c_(10259559).func_242539_d(8372479).func_235239_a_(12638463).func_235238_a_(), GENERATION_SETTINGS.func_242508_a(), SPAWN_SETTINGS.func_242577_b());
    }

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeDictionary() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HOT};
    }

    @Override
    public BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.WARM;
    }

    static {
        GENERATION_SETTINGS.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, PFConfiguredFeatures.CRETACEOUS_FOSSILIZED_SANDSTONE);
        GENERATION_SETTINGS.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, PFConfiguredFeatures.CRETACEOUS_FOSSILIZED_SILTSTONE);
        PFConfiguredFeatures.withRareDeadCycadeoid(GENERATION_SETTINGS);
        PFConfiguredFeatures.withDjadochtaPlants(GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        PFConfiguredFeatures.withDjadochtaRocks(GENERATION_SETTINGS);
        PFConfiguredFeatures.withArroyoPlants(GENERATION_SETTINGS);
        GENERATION_SETTINGS.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PFConfiguredFeatures.DJADOCHTA_ARROYO_VEGETATION);
        if (PrehistoricFaunaConfig.caveSentinelDjadochtaArroyoSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.TRILOBITE_SENTINEL_ENTITY, PrehistoricFaunaConfig.caveSentinelDjadochtaArroyoSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.landSentinelDjadochtaArroyoSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(PFEntities.LAND_SENTINEL_ENTITY, PrehistoricFaunaConfig.landSentinelDjadochtaArroyoSpawnWeight, 1, 1));
        }
        if (PrehistoricFaunaConfig.protoceratopsDjadochtaArroyoSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.PROTOCERATOPS_ENTITY, PrehistoricFaunaConfig.protoceratopsDjadochtaArroyoSpawnWeight, 2, 5));
        }
        if (PrehistoricFaunaConfig.velociraptorDjadochtaArroyoSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.VELOCIRAPTOR_ENTITY, PrehistoricFaunaConfig.velociraptorDjadochtaArroyoSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.citipatiDjadochtaArroyoSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.CITIPATI_ENTITY, PrehistoricFaunaConfig.citipatiDjadochtaArroyoSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.aepyornithomimusDjadochtaArroyoSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.AEPYORNITHOMIMUS_ENTITY, PrehistoricFaunaConfig.aepyornithomimusDjadochtaArroyoSpawnWeight, 3, 5));
        }
        if (PrehistoricFaunaConfig.telmasaurusDjadochtaArroyoSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.TELMASAURUS_ENTITY, PrehistoricFaunaConfig.telmasaurusDjadochtaArroyoSpawnWeight, 1, 2));
        }
        if (PrehistoricFaunaConfig.pinacosaurusDjadochtaArroyoSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.PINACOSAURUS_ENTITY, PrehistoricFaunaConfig.pinacosaurusDjadochtaArroyoSpawnWeight, 4, 5));
        }
        if (PrehistoricFaunaConfig.plesiohadrosDjadochtaArroyoSpawnWeight != 0) {
            SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(PFEntities.PLESIOHADROS_ENTITY, PrehistoricFaunaConfig.plesiohadrosDjadochtaArroyoSpawnWeight, 3, 5));
        }
    }
}

