/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.biome;

import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import superlord.prehistoricfauna.common.world.PFConfiguredFeatures;
import superlord.prehistoricfauna.common.world.PFSurfaceBuilders;
import superlord.prehistoricfauna.common.world.WorldGenRegistrationHelper;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.world.biome.PFBiome;

public class PetrifiedForestBiome
extends PFBiome {
    static final ConfiguredSurfaceBuilder SURFACE_BUILDER = WorldGenRegistrationHelper.createConfiguredSurfaceBuilder("petrified_forest_sb", new ConfiguredSurfaceBuilder(PFSurfaceBuilders.PETRIFIED_FOREST, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(PFBlocks.SILT.func_176223_P(), PFBlocks.HARDENED_SILT.func_176223_P(), PFBlocks.HARDENED_SILT.func_176223_P())));
    static final Biome.RainType PRECIPATATION = Biome.RainType.NONE;
    static final Biome.Category CATEGORY = Biome.Category.DESERT;
    static final float DEPTH = 0.1f;
    static final float SCALE = 0.07f;
    static final float TEMPERATURE = 0.9f;
    static final float DOWNFALL = 0.0f;
    static final int WATER_COLOR = 4159204;
    static final int WATER_FOG_COLOR = 329011;
    static final Biome.Climate WEATHER = new Biome.Climate(PRECIPATATION, 0.9f, Biome.TemperatureModifier.NONE, 0.0f);
    static final MobSpawnInfo.Builder SPAWN_SETTINGS = new MobSpawnInfo.Builder().func_242571_a();
    static final BiomeGenerationSettings.Builder GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().func_242517_a(SURFACE_BUILDER);

    public PetrifiedForestBiome() {
        super(WEATHER, CATEGORY, 0.1f, 0.07f, new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(PetrifiedForestBiome.getSkyColorWithTemperatureModifier(0.9f)).func_235238_a_(), GENERATION_SETTINGS.func_242508_a(), SPAWN_SETTINGS.func_242577_b());
    }

    @Override
    public Biome getRiver() {
        return this.getBiome();
    }

    @Override
    public BiomeDictionary.Type[] getBiomeDictionary() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.PLATEAU};
    }

    @Override
    public BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.WARM;
    }

    @Override
    public int getWeight() {
        return 5;
    }

    static {
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243699_M((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        PFConfiguredFeatures.addSparseTrees(GENERATION_SETTINGS);
        SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200737_ac, 12, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200784_X, 10, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200795_i, 10, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200796_j, 8, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200724_aC, 5, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_200791_e, 10, 8, 8));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200748_an, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200725_aD, 95, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200727_aF, 5, 1, 1));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200741_ag, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200797_k, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200743_ai, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200803_q, 10, 1, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 5, 1, 1));
    }
}

