/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.world.structure.ChinleHutStructure;
import superlord.prehistoricfauna.world.structure.DjadochtaHutStructure;
import superlord.prehistoricfauna.world.structure.GeologistCampStructure;
import superlord.prehistoricfauna.world.structure.HellCreekHutStructure;
import superlord.prehistoricfauna.world.structure.IschigualastoHutStructure;
import superlord.prehistoricfauna.world.structure.KayentaHutStructure;
import superlord.prehistoricfauna.world.structure.MorrisonHutStructure;
import superlord.prehistoricfauna.world.structure.PortalChamberStructure;
import superlord.prehistoricfauna.world.structure.TimeTempleStructure;

public class PFStructures {
    public static List<Structure<?>> structureFeatureList = new ArrayList();
    public static IStructurePieceType TIME_TEMPLE_PIECE_TYPE = TimeTempleStructure.Piece::new;
    public static IStructurePieceType GEOLOGIST_CAMP_PIECE_TYPE = GeologistCampStructure.Piece::new;
    public static IStructurePieceType PORTAL_CHAMBER_PIECE_TYPE = PortalChamberStructure.Piece::new;
    public static IStructurePieceType HELL_CREEK_HUT_PIECE_TYPE = HellCreekHutStructure.Piece::new;
    public static IStructurePieceType MORRISON_HUT_PIECE_TYPE = MorrisonHutStructure.Piece::new;
    public static IStructurePieceType ISCHIGUALASTO_HUT_PIECE_TYPE = IschigualastoHutStructure.Piece::new;
    public static IStructurePieceType DJADOCHTA_HUT_PIECE_TYPE = DjadochtaHutStructure.Piece::new;
    public static IStructurePieceType KAYENTA_HUT_PIECE_TYPE = KayentaHutStructure.Piece::new;
    public static IStructurePieceType CHINLE_HUT_PIECE_TYPE = ChinleHutStructure.Piece::new;
    public static Structure<NoFeatureConfig> TIME_TEMPLE;
    public static Structure<NoFeatureConfig> GEOLOGIST_CAMP;
    public static Structure<NoFeatureConfig> PORTAL_CHAMBER;
    public static Structure<NoFeatureConfig> HELL_CREEK_HUT;
    public static Structure<NoFeatureConfig> MORRISON_HUT;
    public static Structure<NoFeatureConfig> ISCHIGUALASTO_HUT;
    public static Structure<NoFeatureConfig> DJADOCHTA_HUT;
    public static Structure<NoFeatureConfig> KAYENTA_HUT;
    public static Structure<NoFeatureConfig> CHINLE_HUT;

    public static void setupStructures() {
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("prehistoricfauna", "time_temple"), (Object)TIME_TEMPLE_PIECE_TYPE);
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("prehistoricfauna", "geologist_camp"), (Object)GEOLOGIST_CAMP_PIECE_TYPE);
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("prehistoricfauna", "portal_chamber"), (Object)PORTAL_CHAMBER_PIECE_TYPE);
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("prehistoricfauna", "hell_creek_hut"), (Object)HELL_CREEK_HUT_PIECE_TYPE);
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("prehistoricfauna", "morrison_hut"), (Object)MORRISON_HUT_PIECE_TYPE);
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("prehistoricfauna", "ischigualasto_hut"), (Object)ISCHIGUALASTO_HUT_PIECE_TYPE);
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("prehistoricfauna", "djadochta_hut"), (Object)DJADOCHTA_HUT_PIECE_TYPE);
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("prehistoricfauna", "kayenta_hut"), (Object)KAYENTA_HUT_PIECE_TYPE);
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("prehistoricfauna", "chinle_hut"), (Object)CHINLE_HUT_PIECE_TYPE);
        TIME_TEMPLE = PFStructures.registerStructureFeature("prehistoricfauna:time_temple", new TimeTempleStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        GEOLOGIST_CAMP = PFStructures.registerStructureFeature("prehistoricfauna:geologist_camp", new GeologistCampStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        PORTAL_CHAMBER = PFStructures.registerStructureFeature("prehistoricfauna:portal_chamber", new PortalChamberStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        HELL_CREEK_HUT = PFStructures.registerStructureFeature("prehistoricfauna:hell_creek_hut", new HellCreekHutStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        MORRISON_HUT = PFStructures.registerStructureFeature("prehistoricfauna:morrison_hut", new MorrisonHutStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        ISCHIGUALASTO_HUT = PFStructures.registerStructureFeature("prehistoricfauna:ischigualasto_hut", new IschigualastoHutStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        DJADOCHTA_HUT = PFStructures.registerStructureFeature("prehistoricfauna:djadochta_hut", new DjadochtaHutStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        KAYENTA_HUT = PFStructures.registerStructureFeature("prehistoricfauna:kayenta_hut", new KayentaHutStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        CHINLE_HUT = PFStructures.registerStructureFeature("prehistoricfauna:chinle_hut", new ChinleHutStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        PFStructures.setupMapSpacingAndLand(TIME_TEMPLE, new StructureSeparationSettings(PrehistoricFaunaConfig.timeTempleMaxDistance, PrehistoricFaunaConfig.timeTempleMinDistance, 8237163), true);
        PFStructures.setupMapSpacingAndLand(GEOLOGIST_CAMP, new StructureSeparationSettings(PrehistoricFaunaConfig.geologistCampMaxDistance, PrehistoricFaunaConfig.geologistCampMinDistance, 37126163), true);
        PFStructures.setupMapSpacingAndLand(PORTAL_CHAMBER, new StructureSeparationSettings(PrehistoricFaunaConfig.portalHubMaxDistance, PrehistoricFaunaConfig.portalHubMinDistance, 2837462), true);
        PFStructures.setupMapSpacingAndLand(HELL_CREEK_HUT, new StructureSeparationSettings(PrehistoricFaunaConfig.hellCreekHutMaxDistance, PrehistoricFaunaConfig.hellCreekHutMinDistance, 42773854), true);
        PFStructures.setupMapSpacingAndLand(MORRISON_HUT, new StructureSeparationSettings(PrehistoricFaunaConfig.morrisonHutMaxDistance, PrehistoricFaunaConfig.morrisonHutMinDistance, 476256184), true);
        PFStructures.setupMapSpacingAndLand(ISCHIGUALASTO_HUT, new StructureSeparationSettings(PrehistoricFaunaConfig.ischigualastoHutMaxDistance, PrehistoricFaunaConfig.ischigualastoHutMinDistance, 29578373), true);
        PFStructures.setupMapSpacingAndLand(DJADOCHTA_HUT, new StructureSeparationSettings(PrehistoricFaunaConfig.djadochtaHutMaxDistance, PrehistoricFaunaConfig.djadochtaHutMinDistance, 294837281), true);
        PFStructures.setupMapSpacingAndLand(KAYENTA_HUT, new StructureSeparationSettings(PrehistoricFaunaConfig.kayentaHutMaxDistance, PrehistoricFaunaConfig.kayentaHutMinDistance, 2847238), true);
        PFStructures.setupMapSpacingAndLand(CHINLE_HUT, new StructureSeparationSettings(PrehistoricFaunaConfig.chinleHutMaxDistance, PrehistoricFaunaConfig.chinleHutMinDistance, 485726216), true);
    }

    private static Structure<NoFeatureConfig> registerStructureFeature(String registryName, Structure<NoFeatureConfig> feature) {
        structureFeatureList.add(feature);
        return feature;
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        WorldGenRegistries.field_243658_j.forEach(dimensionSettings -> dimensionSettings.func_236108_a_().func_236195_a_().put(structure, structureSeparationSettings));
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
    }
}

