/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.init;

import java.lang.reflect.Field;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import superlord.prehistoricfauna.common.entities.tile.PaleontologyTableContainer;
import superlord.prehistoricfauna.common.entities.tile.PaleoscribeContainer;

@Mod.EventBusSubscriber(modid="prehistoricfauna", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PFContainers {
    public static final DeferredRegister<ContainerType<?>> CONTAINER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"prehistoricfauna");
    public static final RegistryObject<ContainerType<PaleontologyTableContainer>> PALEONTOLOGY_TABLE = CONTAINER_TYPES.register("paleontology_table_container", () -> IForgeContainerType.create(PaleontologyTableContainer::new));
    public static final ContainerType PALEOSCRIBE_CONTAINER = PFContainers.register(new ContainerType(PaleoscribeContainer::new), "paleoscribe_container");

    public static ContainerType register(ContainerType type, String name) {
        type.setRegistryName(name);
        return type;
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        try {
            for (Field f : PFContainers.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (obj instanceof ContainerType) {
                    event.getRegistry().register((IForgeRegistryEntry)((ContainerType)obj));
                    continue;
                }
                if (!(obj instanceof ContainerType[])) continue;
                for (ContainerType container : (ContainerType[])obj) {
                    event.getRegistry().register((IForgeRegistryEntry)container);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

