/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import superlord.prehistoricfauna.common.world.WorldGenRegistrationHelper;
import superlord.prehistoricfauna.world.biome.BiomeData;
import superlord.prehistoricfauna.world.biome.Dummy;
import superlord.prehistoricfauna.world.biome.PFBiome;
import superlord.prehistoricfauna.world.biome.cretaceous.DjadochtaArroyoBiome;
import superlord.prehistoricfauna.world.biome.cretaceous.DjadochtaDunesBiome;
import superlord.prehistoricfauna.world.biome.cretaceous.HellCreekBiome;
import superlord.prehistoricfauna.world.biome.cretaceous.HellCreekClearingBiome;
import superlord.prehistoricfauna.world.biome.cretaceous.HellCreekHillsBiome;
import superlord.prehistoricfauna.world.biome.cretaceous.HellCreekRiverBiome;
import superlord.prehistoricfauna.world.biome.jurassic.KayentaButtesBiome;
import superlord.prehistoricfauna.world.biome.jurassic.KayentaDesertBiome;
import superlord.prehistoricfauna.world.biome.jurassic.KayentaDryForestBiome;
import superlord.prehistoricfauna.world.biome.jurassic.KayentaRiverBiome;
import superlord.prehistoricfauna.world.biome.jurassic.MorrisonSavannahBiome;
import superlord.prehistoricfauna.world.biome.jurassic.MorrisonSavannahHillsBiome;
import superlord.prehistoricfauna.world.biome.triassic.ChinleFlatsBiome;
import superlord.prehistoricfauna.world.biome.triassic.ChinleRiverBiome;
import superlord.prehistoricfauna.world.biome.triassic.ChinleSwampBiome;
import superlord.prehistoricfauna.world.biome.triassic.ChinleWoodedMountainsBiome;
import superlord.prehistoricfauna.world.biome.triassic.IschigualastoBiome;
import superlord.prehistoricfauna.world.biome.triassic.IschigualastoClearingBiome;
import superlord.prehistoricfauna.world.biome.triassic.IschigualastoHillsBiome;
import superlord.prehistoricfauna.world.biome.triassic.IschigualastoRiverBiome;
import superlord.prehistoricfauna.world.worldtype.PrehistoricWorldTypeBiomeProvider;

public class PFBiomes {
    public static List<PreserveBiomeOrder> biomeList = new ArrayList<PreserveBiomeOrder>();
    public static Biome DUMMY = WorldGenRegistrationHelper.createBiome("dummy", new Dummy().getBiome(), 2000);
    public static final PFBiome HELL_CREEK_BIOME = new HellCreekBiome(0.2f, 0.1f);
    public static final PFBiome HELL_CREEK_CLEARING_BIOME = new HellCreekClearingBiome();
    public static final PFBiome HELL_CREEK_HILLS_BIOME = new HellCreekHillsBiome();
    public static final PFBiome HELL_CREEK_RIVER_BIOME = new HellCreekRiverBiome();
    public static final PFBiome MORRISON_SAVANNAH_BIOME = new MorrisonSavannahBiome(0.05f, 0.125f);
    public static final PFBiome MORRISON_HILLS_BIOME = new MorrisonSavannahHillsBiome();
    public static final PFBiome ISCHIGUALASTO_FOREST_BIOME = new IschigualastoBiome(0.1f, 0.1f);
    public static final PFBiome ISCHIGUALASTO_CLEARING_BIOME = new IschigualastoClearingBiome();
    public static final PFBiome ISCHIGUALASTO_HILLS_BIOME = new IschigualastoHillsBiome();
    public static final PFBiome ISCHIGUALASTO_RIVER_BIOME = new IschigualastoRiverBiome();
    public static final PFBiome DJADOCHTA_DUNES_BIOME = new DjadochtaDunesBiome(0.4f, 0.2f);
    public static final PFBiome DJADOCHTA_ARROYO_BIOME = new DjadochtaArroyoBiome(0.05f, 0.05f);
    public static final PFBiome KAYENTA_DRY_FOREST_BIOME = new KayentaDryForestBiome();
    public static final PFBiome KAYENTA_BUTTES_BIOME = new KayentaButtesBiome();
    public static final PFBiome KAYENTA_DESERT_BIOME = new KayentaDesertBiome();
    public static final PFBiome KAYENTA_RIVER_BIOME = new KayentaRiverBiome();
    public static final PFBiome CHINLE_SWAMP_BIOME = new ChinleSwampBiome();
    public static final PFBiome CHINLE_FLATS_BIOME = new ChinleFlatsBiome();
    public static final PFBiome CHINLE_WOODED_MOUNTAINS_BIOME = new ChinleWoodedMountainsBiome();
    public static final PFBiome CHINLE_RIVER_BIOME = new ChinleRiverBiome();
    public static final Biome HELL_CREEK = WorldGenRegistrationHelper.createBiome("hell_creek", HELL_CREEK_BIOME.getBiome(), 1);
    public static final Biome HELL_CREEK_CLEARING = WorldGenRegistrationHelper.createBiome("hell_creek_clearing", HELL_CREEK_CLEARING_BIOME.getBiome(), 6);
    public static final Biome HELL_CREEK_HILLS = WorldGenRegistrationHelper.createBiome("hell_creek_hills", HELL_CREEK_HILLS_BIOME.getBiome(), 5);
    public static final Biome HELL_CREEK_RIVER = WorldGenRegistrationHelper.createBiome("hell_creek_river", HELL_CREEK_RIVER_BIOME.getBiome(), 7);
    public static final Biome DJADOCHTA_DUNES = WorldGenRegistrationHelper.createBiome("djadochta_dunes", DJADOCHTA_DUNES_BIOME.getBiome(), 12);
    public static final Biome DJADOCHTA_ARROYO = WorldGenRegistrationHelper.createBiome("djadochta_arroyo", DJADOCHTA_ARROYO_BIOME.getBiome(), 13);
    public static final Biome MORRISON_SAVANNAH = WorldGenRegistrationHelper.createBiome("morrison_savannah", MORRISON_SAVANNAH_BIOME.getBiome(), 2);
    public static final Biome MORRISON_HILLS = WorldGenRegistrationHelper.createBiome("morrison_hills", MORRISON_HILLS_BIOME.getBiome(), 11);
    public static final Biome KAYENTA_DRY_FOREST = WorldGenRegistrationHelper.createBiome("kayenta_dry_forest", KAYENTA_DRY_FOREST_BIOME.getBiome(), 14);
    public static final Biome KAYENTA_BUTTES = WorldGenRegistrationHelper.createBiome("kayenta_canyon", KAYENTA_BUTTES_BIOME.getBiome(), 15);
    public static final Biome KAYENTA_DESERT = WorldGenRegistrationHelper.createBiome("kayenta_desert", KAYENTA_DESERT_BIOME.getBiome(), 16);
    public static final Biome KAYENTA_RIVER = WorldGenRegistrationHelper.createBiome("kayenta_river", KAYENTA_RIVER_BIOME.getBiome(), 21);
    public static final Biome ISCHIGUALASTO_FOREST = WorldGenRegistrationHelper.createBiome("ischigualasto_forest", ISCHIGUALASTO_FOREST_BIOME.getBiome(), 3);
    public static final Biome ISCHIGUALASTO_CLEARING = WorldGenRegistrationHelper.createBiome("ischigualasto_clearing", ISCHIGUALASTO_CLEARING_BIOME.getBiome(), 8);
    public static final Biome ISCHIGUALASTO_HILLS = WorldGenRegistrationHelper.createBiome("ischigualasto_hills", ISCHIGUALASTO_HILLS_BIOME.getBiome(), 9);
    public static final Biome ISCHIGUALASTO_RIVER = WorldGenRegistrationHelper.createBiome("ischigualasto_river", ISCHIGUALASTO_RIVER_BIOME.getBiome(), 10);
    public static final Biome CHINLE_SWAMP = WorldGenRegistrationHelper.createBiome("chinle_swamp", CHINLE_SWAMP_BIOME.getBiome(), 17);
    public static final Biome CHINLE_FLATS = WorldGenRegistrationHelper.createBiome("chinle_flats", CHINLE_FLATS_BIOME.getBiome(), 18);
    public static final Biome CHINLE_WOODED_MOUNTAINS = WorldGenRegistrationHelper.createBiome("chinle_wooded_mountains", CHINLE_WOODED_MOUNTAINS_BIOME.getBiome(), 19);
    public static final Biome CHINLE_RIVER = WorldGenRegistrationHelper.createBiome("chinle_river", CHINLE_RIVER_BIOME.getBiome(), 20);

    public static void init() {
        Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)new ResourceLocation("prehistoricfauna", "prehistoric_world"), PrehistoricWorldTypeBiomeProvider.CODEC);
    }

    public static void addBiomeEntries() {
        for (BiomeData biomeData : PFBiome.biomeData) {
            List dictionaryList = Arrays.stream(biomeData.getDictionaryTypes()).collect(Collectors.toList());
            ResourceLocation key = WorldGenRegistries.field_243657_i.func_177774_c((Object)biomeData.getBiome());
            if (biomeData.getBiomeWeight() <= 0) continue;
            BiomeManager.addBiome((BiomeManager.BiomeType)biomeData.getBiomeType(), (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)key), biomeData.getBiomeWeight()));
        }
    }

    public static void fillBiomeDictionary() {
        for (BiomeData pfBiomes : PFBiome.biomeData) {
            BiomeDictionary.addTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)WorldGenRegistries.field_243657_i.func_177774_c((Object)pfBiomes.getBiome())), (BiomeDictionary.Type[])pfBiomes.getDictionaryTypes());
        }
    }

    public static class PreserveBiomeOrder {
        private final Biome biome;
        private final int orderPosition;

        public PreserveBiomeOrder(Biome biome, int orderPosition) {
            this.biome = biome;
            this.orderPosition = orderPosition;
        }

        public Biome getBiome() {
            return this.biome;
        }

        public int getOrderPosition() {
            return this.orderPosition;
        }
    }
}

