/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.util;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import superlord.prehistoricfauna.compat.ChestItemRenderer;
import superlord.prehistoricfauna.compat.FuelBlockItem;
import superlord.prehistoricfauna.compat.PFChestBlock;
import superlord.prehistoricfauna.compat.PFChestTileEntity;
import superlord.prehistoricfauna.compat.PFTrappedChestBlock;
import superlord.prehistoricfauna.compat.PFTrappedChestTileEntity;

public class RegistryHelper {
    private final String modId;
    private final DeferredRegister<Item> itemRegister;
    private final DeferredRegister<Block> blockRegister;
    private final DeferredRegister<TileEntityType<?>> tileEntityRegister;

    public RegistryHelper(String modId) {
        this.modId = modId;
        this.itemRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modId);
        this.blockRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)modId);
        this.tileEntityRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)modId);
    }

    public String getModId() {
        return this.modId;
    }

    public DeferredRegister<Item> getDeferredItemRegister() {
        return this.itemRegister;
    }

    public DeferredRegister<Block> getDeferredBlockRegister() {
        return this.blockRegister;
    }

    public DeferredRegister<TileEntityType<?>> getDeferredTileEntityRegister() {
        return this.tileEntityRegister;
    }

    public <B extends Block> RegistryObject<B> createCompatFuelBlock(String modId, String name, Supplier<? extends B> supplier, int burnTime, @Nullable ItemGroup group) {
        ItemGroup determinedGroup = ModList.get().isLoaded(modId) || modId == "indev" ? group : null;
        RegistryObject block = this.blockRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new FuelBlockItem((Block)block.get(), burnTime, new Item.Properties().func_200916_a(determinedGroup)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createCompatBlock(String modId, String name, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        ItemGroup determinedGroup = ModList.get().isLoaded(modId) || modId == "indev" ? group : null;
        RegistryObject block = this.blockRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(determinedGroup)));
        return block;
    }

    public <T extends TileEntity> RegistryObject<TileEntityType<T>> createTileEntity(String name, Supplier<? extends T> tileEntity, Supplier<Block[]> validBlocks) {
        return this.tileEntityRegister.register(name, () -> new TileEntityType(tileEntity, (Set)Sets.newHashSet((Object[])((Block[])validBlocks.get())), null));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> chestISTER() {
        return () -> new ChestItemRenderer(PFChestTileEntity::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> trappedChestISTER() {
        return () -> new ChestItemRenderer(PFTrappedChestTileEntity::new);
    }

    public Pair<RegistryObject<PFChestBlock>, RegistryObject<PFTrappedChestBlock>> createCompatChestBlocks(String name, MaterialColor color) {
        ItemGroup chestGroup = ModList.get().isLoaded("quark") || this.modId == "indev" ? ItemGroup.field_78031_c : null;
        ItemGroup trappedChestGroup = ModList.get().isLoaded("quark") || this.modId == "indev" ? ItemGroup.field_78028_d : null;
        RegistryObject chest = this.blockRegister.register(name + "_chest", () -> new PFChestBlock(this.getModId(), name, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        RegistryObject trappedChest = this.blockRegister.register(name + "_trapped_chest", () -> new PFTrappedChestBlock(this.getModId(), name, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        this.itemRegister.register(name + "_chest", () -> new FuelBlockItem((Block)chest.get(), 300, new Item.Properties().func_200916_a(chestGroup).setISTER(() -> RegistryHelper.chestISTER())));
        this.itemRegister.register(name + "_trapped_chest", () -> new FuelBlockItem((Block)trappedChest.get(), 300, new Item.Properties().func_200916_a(trappedChestGroup).setISTER(() -> RegistryHelper.trappedChestISTER())));
        return Pair.of((Object)chest, (Object)trappedChest);
    }
}

