/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.util;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class PaleontologyTableResult {
    private static final Random random = new Random();
    private final NavigableMap<Float, ItemStack> results;
    private final float total;

    private PaleontologyTableResult(NavigableMap<Float, ItemStack> results, float total) {
        this.results = results;
        this.total = total;
    }

    public ItemStack next(Random rand) {
        return this.results.higherEntry(Float.valueOf(rand.nextFloat() * this.total)).getValue();
    }

    public ItemStack next() {
        return this.next(random);
    }

    public static PaleontologyTableResult read(PacketBuffer buffer) {
        Builder builder = new Builder();
        int resultListSize = buffer.readInt();
        for (int i = 0; i < resultListSize; ++i) {
            ItemStack result = buffer.func_150791_c();
            float weight = buffer.readFloat();
            builder.add(weight, result);
        }
        return builder.build();
    }

    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.results.size());
        for (Map.Entry entry : this.results.entrySet()) {
            buffer.func_150788_a((ItemStack)entry.getValue());
            buffer.writeFloat(((Float)entry.getKey()).floatValue());
        }
    }

    public static class Builder {
        private NavigableMap<Float, ItemStack> results = new TreeMap<Float, ItemStack>();
        private float total = 0.0f;

        public Builder add(float weight, ItemStack result) {
            if (weight <= 0.0f) {
                return this;
            }
            this.total += weight;
            this.results.put(Float.valueOf(this.total), result);
            return this;
        }

        public Builder add(ItemStack result) {
            return this.add(1.0f, result);
        }

        public PaleontologyTableResult build() {
            return new PaleontologyTableResult(this.results, this.total);
        }
    }
}

