/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.items;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpawnSkeletonItem
extends Item {
    private static final Map<EntityType<?>, SpawnSkeletonItem> EGGS = Maps.newIdentityHashMap();
    private final EntityType<?> typeIn;

    public SpawnSkeletonItem(EntityType<?> typeIn, Item.Properties builder) {
        super(builder);
        this.typeIn = typeIn;
        EGGS.put(typeIn, this);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity tileentity;
        World world = context.func_195991_k();
        if (!(world instanceof ServerWorld)) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemstack = context.func_195996_i();
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (blockstate.func_203425_a(Blocks.field_150474_ac) && (tileentity = world.func_175625_s(blockpos)) instanceof MobSpawnerTileEntity) {
            AbstractSpawner abstractspawner = ((MobSpawnerTileEntity)tileentity).func_145881_a();
            EntityType<?> entitytype1 = this.getType(itemstack.func_77978_p());
            abstractspawner.func_200876_a(entitytype1);
            tileentity.func_70296_d();
            world.func_184138_a(blockpos, blockstate, blockstate, 3);
            itemstack.func_190918_g(1);
            return ActionResultType.CONSUME;
        }
        BlockPos blockpos1 = blockstate.func_196952_d((IBlockReader)world, blockpos).func_197766_b() ? blockpos : blockpos.func_177972_a(direction);
        EntityType<?> entitytype = this.getType(itemstack.func_77978_p());
        if (entitytype.func_220331_a((ServerWorld)world, itemstack, context.func_195999_j(), blockpos1, SpawnReason.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP) != null) {
            itemstack.func_190918_g(1);
        }
        return ActionResultType.CONSUME;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        BlockRayTraceResult raytraceresult = SpawnSkeletonItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (!(worldIn instanceof ServerWorld)) {
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        BlockRayTraceResult blockraytraceresult = raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, blockraytraceresult.func_216354_b(), itemstack)) {
            EntityType<?> entitytype = this.getType(itemstack.func_77978_p());
            if (entitytype.func_220331_a((ServerWorld)worldIn, itemstack, playerIn, blockpos, SpawnReason.SPAWN_EGG, false, false) == null) {
                return ActionResult.func_226250_c_((Object)itemstack);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public boolean hasType(@Nullable CompoundNBT nbt, EntityType<?> type) {
        return Objects.equals(this.getType(nbt), type);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static SpawnSkeletonItem getEgg(@Nullable EntityType<?> type) {
        return EGGS.get(type);
    }

    public static Iterable<SpawnSkeletonItem> getEggs() {
        return Iterables.unmodifiableIterable(EGGS.values());
    }

    public EntityType<?> getType(@Nullable CompoundNBT nbt) {
        CompoundNBT compoundnbt;
        if (nbt != null && nbt.func_150297_b("EntityTag", 10) && (compoundnbt = nbt.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return EntityType.func_220327_a((String)compoundnbt.func_74779_i("id")).orElse(this.typeIn);
        }
        return this.typeIn;
    }

    public Optional<MobEntity> getChildToSpawn(PlayerEntity player, MobEntity mob, EntityType<? extends MobEntity> entityType, ServerWorld world, Vector3d pos, ItemStack stack) {
        if (!this.hasType(stack.func_77978_p(), entityType)) {
            return Optional.empty();
        }
        Object mobentity = mob instanceof AgeableEntity ? ((AgeableEntity)mob).func_241840_a(world, (AgeableEntity)mob) : (MobEntity)entityType.func_200721_a((World)world);
        if (mobentity == null) {
            return Optional.empty();
        }
        mobentity.func_82227_f(true);
        if (!mobentity.func_70631_g_()) {
            return Optional.empty();
        }
        mobentity.func_70012_b(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), 0.0f, 0.0f);
        world.func_242417_l((Entity)mobentity);
        if (stack.func_82837_s()) {
            mobentity.func_200203_b(stack.func_200301_q());
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return Optional.of(mobentity);
    }
}

