/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities.jurassic.morrison;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entities.DinosaurEntity;
import superlord.prehistoricfauna.common.entities.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entities.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entities.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFCustomDamageSource;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.SoundInit;

public class CamarasaurusEntity
extends DinosaurEntity {
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(CamarasaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(CamarasaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_JUVENILE = EntityDataManager.func_187226_a(CamarasaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ALBINO = EntityDataManager.func_187226_a(CamarasaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MELANISTIC = EntityDataManager.func_187226_a(CamarasaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EATING = EntityDataManager.func_187226_a(CamarasaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> NATURAL_LOVE = EntityDataManager.func_187226_a(CamarasaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int maxHunger = 500;
    private int currentHunger = 500;
    private int lastInLove = 0;
    int hungerTick = 0;
    private int warningSoundTicks;
    private int isDigging;
    int loveTick = 0;

    public CamarasaurusEntity(EntityType<? extends CamarasaurusEntity> type, World world) {
        super(type, world);
        this.field_70138_W = 1.0f;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        if (this.func_70631_g_() && !this.isJuvenile()) {
            return 2.75f;
        }
        if (this.isJuvenile() && this.func_70631_g_()) {
            return 5.5f;
        }
        return 8.5f;
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean isJuvenile() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_JUVENILE);
    }

    private void setJuvenile(boolean isJuvenile) {
        this.field_70180_af.func_187227_b(IS_JUVENILE, (Object)isJuvenile);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isAlbino() {
        return (Boolean)this.field_70180_af.func_187225_a(ALBINO);
    }

    private void setAlbino(boolean isAlbino) {
        this.field_70180_af.func_187227_b(ALBINO, (Object)isAlbino);
    }

    public boolean isMelanistic() {
        return (Boolean)this.field_70180_af.func_187225_a(MELANISTIC);
    }

    private void setMelanistic(boolean isMelanistic) {
        this.field_70180_af.func_187227_b(MELANISTIC, (Object)isMelanistic);
    }

    public boolean isInLoveNaturally() {
        return (Boolean)this.field_70180_af.func_187225_a(NATURAL_LOVE);
    }

    private void setInLoveNaturally(boolean isInLoveNaturally) {
        this.field_70180_af.func_187227_b(NATURAL_LOVE, (Object)isInLoveNaturally);
    }

    public int getCurrentHunger() {
        return this.currentHunger;
    }

    private void setHunger(int currentHunger) {
        this.currentHunger = currentHunger;
    }

    public int getHalfHunger() {
        return this.maxHunger / 2;
    }

    public int getThreeQuartersHunger() {
        return this.maxHunger / 4 * 3;
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(EATING);
    }

    private void setEating(boolean isEating) {
        this.field_70180_af.func_187227_b(EATING, (Object)isEating);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == PFItems.PTILOPHYLLUM_FRONDS.get();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new CamarasaurusFollowParentGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new DinosaurLookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new DinosaurRandomLookGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new DiurnalSleepingGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new HerbivoreEatGoal(1.2f, 12, 2));
    }

    public void func_70873_a(int age) {
        super.func_70873_a(age);
        if (this.func_70874_b() >= -12000 && this.func_70874_b() < 0) {
            this.setJuvenile(true);
        } else if (this.func_70874_b() >= 0) {
            this.setJuvenile(false);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.22).func_233815_a_(Attributes.field_233823_f_, 12.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    protected SoundEvent func_184639_G() {
        return this.isAsleep() ? SoundInit.CAMARASAURUS_SNORES : SoundInit.CAMARASAURUS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.CAMARASAURUS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.CAMARASAURUS_DEATH;
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundInit.CAMARASAURUS_WARN, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(ALBINO, (Object)false);
        this.field_70180_af.func_187214_a(MELANISTIC, (Object)false);
        this.field_70180_af.func_187214_a(IS_JUVENILE, (Object)false);
        this.field_70180_af.func_187214_a(EATING, (Object)false);
        this.field_70180_af.func_187214_a(NATURAL_LOVE, (Object)false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HasEgg", this.hasEgg());
        compound.func_74757_a("IsAlbino", this.isAlbino());
        compound.func_74757_a("IsMelanistic", this.isMelanistic());
        compound.func_74768_a("MaxHunger", this.currentHunger);
        compound.func_74757_a("IsEating", this.isEating());
        compound.func_74757_a("InNaturalLove", this.isInLoveNaturally());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
        this.setAlbino(compound.func_74767_n("IsAlbino"));
        this.setMelanistic(compound.func_74767_n("IsMelanistic"));
        this.setEating(compound.func_74767_n("IsEating"));
        this.setHunger(compound.func_74762_e("MaxHunger"));
        this.setInLoveNaturally(compound.func_74767_n("InNaturalLove"));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public void func_70636_d() {
        if (this.func_70631_g_() && !this.isJuvenile()) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(50.0);
        } else if (this.isJuvenile()) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(100.0);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(200.0);
        }
        super.func_70636_d();
        if (!(this.func_213322_ci().field_72450_a == 0.0 && this.func_213322_ci().field_72448_b == 0.0 && this.func_213322_ci().field_72449_c == 0.0 || this.func_70631_g_())) {
            for (LivingEntity entity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0))) {
                if (entity instanceof CamarasaurusEntity || !(entity.func_110138_aP() < 60.0f)) continue;
                entity.func_70097_a(PFCustomDamageSource.SAUROPOD_TRAMPLING, 5.0f);
            }
        }
        if (this.isAsleep()) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.22);
        }
        if (!this.func_175446_cd()) {
            List list = this.field_70170_p.func_217357_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0));
            if (PrehistoricFaunaConfig.advancedHunger) {
                ++this.hungerTick;
                if (this.hungerTick == 600 && !this.func_70631_g_() || this.hungerTick == 300 && this.func_70631_g_()) {
                    if (!this.isAsleep()) {
                        if (this.currentHunger != 0) {
                            this.setHunger(this.currentHunger - 1);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.field_70170_p.func_175659_aa() == Difficulty.HARD && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                    }
                    this.hungerTick = 0;
                }
                if (this.getCurrentHunger() >= this.getThreeQuartersHunger() && this.hungerTick % 150 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() != 0.0f && this.func_70638_az() == null && this.func_70643_av() == null) {
                    float currentHealth = this.func_110143_aJ();
                    this.func_70606_j(currentHealth + 1.0f);
                }
                if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                    if (!(this.lastInLove != 0 || this.currentHunger < this.getThreeQuartersHunger() || this.field_70173_aa % 900 != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep() || list.size() >= 10)) {
                        this.loveTick = 600;
                        this.setInLoveNaturally(true);
                        this.func_204700_e(600);
                        this.lastInLove = 28800;
                    }
                    if (this.loveTick != 0) {
                        --this.loveTick;
                    } else {
                        this.setInLoveNaturally(false);
                    }
                }
            } else if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                int naturalBreedingChance = this.field_70146_Z.nextInt(1000);
                if (!(this.lastInLove != 0 || naturalBreedingChance != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep() || list.size() >= 10)) {
                    this.loveTick = 600;
                    this.setInLoveNaturally(true);
                    this.func_204700_e(600);
                    this.lastInLove = 28800;
                }
                if (this.loveTick != 0) {
                    --this.loveTick;
                } else {
                    this.setInLoveNaturally(false);
                }
            }
            if (this.lastInLove != 0) {
                --this.lastInLove;
            }
        }
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Random rand = new Random();
        int birthNumber = rand.nextInt(799);
        if (birthNumber >= 0 && birthNumber < 4) {
            this.setAlbino(true);
        } else if (birthNumber >= 4 && birthNumber < 7) {
            this.setMelanistic(true);
        }
        this.setHunger(this.maxHunger);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected boolean shouldMoveTo(IWorldReader worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos.func_177984_a())) {
            return false;
        }
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150391_bh || block == Blocks.field_150354_m || block == Blocks.field_196611_F || block == PFBlocks.MOSSY_DIRT || block == PFBlocks.MOSS_BLOCK || block == PFBlocks.LOAM || block == PFBlocks.PACKED_LOAM || block == PFBlocks.SILT || block == PFBlocks.PACKED_LOAM || block == BlockTags.field_206952_E;
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        CamarasaurusEntity entity = new CamarasaurusEntity((EntityType<? extends CamarasaurusEntity>)PFEntities.CAMARASAURUS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos(entity.func_213303_ch())), SpawnReason.BREEDING, null, null);
        return entity;
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)CamarasaurusEntity.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    CamarasaurusEntity.this.playWarningSound();
                }
            } else {
                this.func_234039_g_();
            }
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 15.0f + attackTarget.func_213311_cf();
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)CamarasaurusEntity.this, 2.0);
        }

        public boolean func_75250_a() {
            return !CamarasaurusEntity.this.func_70631_g_() && !CamarasaurusEntity.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class CamarasaurusFollowParentGoal
    extends Goal {
        private final CamarasaurusEntity babyCamarasaurusEntity;
        private CamarasaurusEntity parentCamarasaurusEntity;
        private final double moveSpeed;
        private int delayCounter;

        public CamarasaurusFollowParentGoal(CamarasaurusEntity camarasaurus, double speed) {
            this.babyCamarasaurusEntity = camarasaurus;
            this.moveSpeed = speed;
        }

        public boolean func_75250_a() {
            if (this.babyCamarasaurusEntity.func_70631_g_() && !this.babyCamarasaurusEntity.isJuvenile()) {
                List list = this.babyCamarasaurusEntity.field_70170_p.func_217357_a(((Object)((Object)this.babyCamarasaurusEntity)).getClass(), this.babyCamarasaurusEntity.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
                CamarasaurusEntity camarasaurusEntity = null;
                double d0 = Double.MAX_VALUE;
                for (CamarasaurusEntity tyrannosaurusEntity1 : list) {
                    double d1;
                    if (tyrannosaurusEntity1.func_70631_g_() || (d1 = this.babyCamarasaurusEntity.func_70068_e((Entity)tyrannosaurusEntity1)) > d0) continue;
                    d0 = d1;
                    camarasaurusEntity = tyrannosaurusEntity1;
                }
                if (camarasaurusEntity == null) {
                    return false;
                }
                if (d0 < 9.0) {
                    return false;
                }
                this.parentCamarasaurusEntity = camarasaurusEntity;
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            if (!this.babyCamarasaurusEntity.isJuvenile() || !this.babyCamarasaurusEntity.func_70631_g_()) {
                return false;
            }
            if (!this.parentCamarasaurusEntity.func_70089_S()) {
                return false;
            }
            if (this.babyCamarasaurusEntity.func_70631_g_() && !this.babyCamarasaurusEntity.isJuvenile()) {
                double d0 = this.babyCamarasaurusEntity.func_70068_e((Entity)this.parentCamarasaurusEntity);
                return !(d0 < 9.0) && !(d0 > 256.0);
            }
            return false;
        }

        public void func_75249_e() {
            this.delayCounter = 0;
        }

        public void func_75251_c() {
            this.parentCamarasaurusEntity = null;
        }

        public void func_75246_d() {
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                this.babyCamarasaurusEntity.func_70661_as().func_75497_a((Entity)this.parentCamarasaurusEntity, this.moveSpeed);
            }
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)CamarasaurusEntity.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (CamarasaurusEntity.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof CamarasaurusEntity && !mobIn.func_70631_g_()) {
                super.func_220793_a(mobIn, targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)CamarasaurusEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (CamarasaurusEntity.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (CamarasaurusEntity camarasaurus : CamarasaurusEntity.this.field_70170_p.func_217357_a(CamarasaurusEntity.class, CamarasaurusEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!camarasaurus.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final CamarasaurusEntity camarasaurus;

        LayEggGoal(CamarasaurusEntity camarasaurus, double speedIn) {
            super((CreatureEntity)camarasaurus, speedIn, 16);
            this.camarasaurus = camarasaurus;
        }

        public boolean func_75250_a() {
            return this.camarasaurus.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.camarasaurus.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos(this.camarasaurus.func_213303_ch());
            if (!this.camarasaurus.func_70090_H() && this.func_179487_f()) {
                if (this.camarasaurus.isDigging < 1) {
                    this.camarasaurus.setDigging(true);
                } else if (this.camarasaurus.isDigging > 200) {
                    World world = this.camarasaurus.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)PFBlocks.CAMARASAURUS_EGG.func_176223_P().func_206870_a((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.camarasaurus.field_70146_Z.nextInt(4) + 1)), 3);
                    this.camarasaurus.setHasEgg(false);
                    this.camarasaurus.setDigging(false);
                    this.camarasaurus.func_204700_e(600);
                }
                if (this.camarasaurus.isDigging()) {
                    this.camarasaurus.isDigging++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150391_bh || block == Blocks.field_150354_m || block == Blocks.field_196611_F || block == PFBlocks.MOSSY_DIRT || block == PFBlocks.MOSS_BLOCK || block == PFBlocks.LOAM || block == PFBlocks.PACKED_LOAM || block == PFBlocks.SILT || block == PFBlocks.PACKED_LOAM || block == BlockTags.field_206952_E;
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final CamarasaurusEntity camarasaurus;
        private static final EntityPredicate field_220689_d = new EntityPredicate().func_221013_a(8.0).func_221008_a().func_221011_b().func_221014_c();
        private int spawnBabyDelay;
        private final double moveSpeed;

        MateGoal(CamarasaurusEntity camarasaurus, double speed) {
            super((AnimalEntity)camarasaurus, speed);
            this.camarasaurus = camarasaurus;
            this.moveSpeed = speed;
        }

        @Nullable
        private AnimalEntity getNearbyMate() {
            List list = this.field_75394_a.func_217374_a(CamarasaurusEntity.class, field_220689_d, (LivingEntity)this.field_75390_d, this.field_75390_d.func_174813_aQ().func_186662_g(24.0));
            double d0 = Double.MAX_VALUE;
            AnimalEntity animalentity = null;
            for (AnimalEntity animalentity1 : list) {
                if (!this.field_75390_d.func_70878_b(animalentity1) || !(this.field_75390_d.func_70068_e((Entity)animalentity1) < d0)) continue;
                animalentity = animalentity1;
                d0 = this.field_75390_d.func_70068_e((Entity)animalentity1);
            }
            return animalentity;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.camarasaurus.hasEgg() && !this.camarasaurus.isInLoveNaturally();
        }

        public void func_75251_c() {
            this.field_75391_e = null;
            this.spawnBabyDelay = 0;
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.field_75390_d.func_70671_ap().func_75651_a((Entity)this.field_75391_e, 10.0f, (float)this.field_75390_d.func_70646_bf());
            this.field_75390_d.func_70661_as().func_75497_a((Entity)this.field_75391_e, this.moveSpeed);
            ++this.spawnBabyDelay;
            if (this.spawnBabyDelay >= 60 && this.field_75390_d.func_70068_e((Entity)this.field_75391_e) < 20.0) {
                this.func_75388_i();
            }
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverPlayerEntity = this.field_75390_d.func_191993_do();
            if (serverPlayerEntity == null && this.field_75391_e.func_191993_do() != null) {
                serverPlayerEntity = this.field_75391_e.func_191993_do();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverPlayerEntity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.camarasaurus.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class NaturalMateGoal
    extends BreedGoal {
        private final CamarasaurusEntity camarasaurus;

        NaturalMateGoal(CamarasaurusEntity camarasaurus, double speed) {
            super((AnimalEntity)camarasaurus, speed);
            this.camarasaurus = camarasaurus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.camarasaurus.hasEgg() && this.camarasaurus.getCurrentHunger() >= this.camarasaurus.getThreeQuartersHunger() && this.camarasaurus.field_70173_aa % 60 == 0 && (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && this.camarasaurus.isInLoveNaturally();
        }

        protected void func_75388_i() {
            if (PrehistoricFaunaConfig.naturalEggItemLaying) {
                this.camarasaurus.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.camarasaurus.field_70146_Z.nextFloat() - this.camarasaurus.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                int eggAmount = this.camarasaurus.field_70146_Z.nextInt(4);
                if (eggAmount == 0) {
                    this.camarasaurus.func_199703_a((IItemProvider)PFBlocks.CAMARASAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 1) {
                    this.camarasaurus.func_199703_a((IItemProvider)PFBlocks.CAMARASAURUS_EGG.func_199767_j());
                    this.camarasaurus.func_199703_a((IItemProvider)PFBlocks.CAMARASAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 2) {
                    this.camarasaurus.func_199703_a((IItemProvider)PFBlocks.CAMARASAURUS_EGG.func_199767_j());
                    this.camarasaurus.func_199703_a((IItemProvider)PFBlocks.CAMARASAURUS_EGG.func_199767_j());
                    this.camarasaurus.func_199703_a((IItemProvider)PFBlocks.CAMARASAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 3) {
                    this.camarasaurus.func_199703_a((IItemProvider)PFBlocks.CAMARASAURUS_EGG.func_199767_j());
                    this.camarasaurus.func_199703_a((IItemProvider)PFBlocks.CAMARASAURUS_EGG.func_199767_j());
                    this.camarasaurus.func_199703_a((IItemProvider)PFBlocks.CAMARASAURUS_EGG.func_199767_j());
                    this.camarasaurus.func_199703_a((IItemProvider)PFBlocks.CAMARASAURUS_EGG.func_199767_j());
                }
            } else {
                this.camarasaurus.setHasEgg(true);
            }
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
        }
    }

    public class HerbivoreEatGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public HerbivoreEatGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((CreatureEntity)CamarasaurusEntity.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public double func_203110_f() {
            return 2.0;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 100 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            return blockstate.func_203425_a(PFBlocks.HORSETAIL) || blockstate.func_203425_a(PFBlocks.TALL_HORSETAIL) || blockstate.func_203425_a(PFBlocks.OSMUNDA) || blockstate.func_203425_a(PFBlocks.TALL_OSMUNDA) || blockstate.func_203425_a(PFBlocks.CLUBMOSS) || blockstate.func_203425_a(PFBlocks.MARCHANTIA) || blockstate.func_203425_a(PFBlocks.CONIOPTERIS) || blockstate.func_203425_a(PFBlocks.OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.TALL_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.DICROIDIUM) || blockstate.func_203425_a(PFBlocks.JOHNSTONIA) || blockstate.func_203425_a(PFBlocks.CLADOPHLEBIS) || blockstate.func_203425_a(PFBlocks.SCYTOPHYLLUM) || blockstate.func_203425_a(PFBlocks.MICHELILLOA) || blockstate.func_203425_a(PFBlocks.DEAD_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.COBBANIA) || blockstate.func_203425_a(PFBlocks.OTOZAMITES) || blockstate.func_203425_a(PFBlocks.TALL_OTOZAMITES) || blockstate.func_203425_a(PFBlocks.LAUROZAMITES) || blockstate.func_203425_a(Blocks.field_150349_c) || blockstate.func_203425_a(Blocks.field_150395_bd) || blockstate.func_235714_a_((ITag)BlockTags.field_226149_I_) || blockstate.func_203425_a(Blocks.field_196804_gh) || blockstate.func_203425_a(Blocks.field_196554_aH) || blockstate.func_203425_a(Blocks.field_196805_gi);
        }

        public void func_75246_d() {
            if (this.func_179487_f()) {
                if (this.field_220731_g >= 20) {
                    this.eatBerry();
                } else {
                    ++this.field_220731_g;
                    CamarasaurusEntity.this.setEating(true);
                }
                if (this.field_220731_g % 5 == 1) {
                    CamarasaurusEntity.this.field_70170_p.func_184133_a((PlayerEntity)null, this.field_179494_b, SoundEvents.field_187575_bT, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
            }
            super.func_75246_d();
        }

        protected void eatBerry() {
            int hunger;
            BlockState blockstate = CamarasaurusEntity.this.field_70170_p.func_180495_p(this.field_179494_b);
            if (blockstate.func_203425_a(PFBlocks.DEAD_OSMUNDACAULIS)) {
                hunger = CamarasaurusEntity.this.getCurrentHunger();
                if (hunger + 2 >= CamarasaurusEntity.this.maxHunger) {
                    CamarasaurusEntity.this.setHunger(CamarasaurusEntity.this.maxHunger);
                    CamarasaurusEntity.this.setEating(false);
                } else {
                    CamarasaurusEntity.this.setHunger(hunger + 2);
                    CamarasaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(Blocks.field_150349_c) || blockstate.func_203425_a(Blocks.field_196804_gh) || blockstate.func_235714_a_((ITag)BlockTags.field_226149_I_)) {
                hunger = CamarasaurusEntity.this.getCurrentHunger();
                if (hunger + 4 >= CamarasaurusEntity.this.maxHunger) {
                    CamarasaurusEntity.this.setHunger(CamarasaurusEntity.this.maxHunger);
                    CamarasaurusEntity.this.setEating(false);
                } else {
                    CamarasaurusEntity.this.setHunger(hunger + 4);
                    CamarasaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(Blocks.field_150395_bd)) {
                hunger = CamarasaurusEntity.this.getCurrentHunger();
                if (hunger + 6 >= CamarasaurusEntity.this.maxHunger) {
                    CamarasaurusEntity.this.setHunger(CamarasaurusEntity.this.maxHunger);
                    CamarasaurusEntity.this.setEating(false);
                } else {
                    CamarasaurusEntity.this.setHunger(hunger + 6);
                    CamarasaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.MARCHANTIA) || blockstate.func_203425_a(PFBlocks.OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.OTOZAMITES)) {
                hunger = CamarasaurusEntity.this.getCurrentHunger();
                if (hunger + 8 >= CamarasaurusEntity.this.maxHunger) {
                    CamarasaurusEntity.this.setHunger(CamarasaurusEntity.this.maxHunger);
                    CamarasaurusEntity.this.setEating(false);
                } else {
                    CamarasaurusEntity.this.setHunger(hunger + 8);
                    CamarasaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.HORSETAIL) || blockstate.func_203425_a(PFBlocks.CLUBMOSS) || blockstate.func_203425_a(PFBlocks.MICHELILLOA) || blockstate.func_203425_a(PFBlocks.COBBANIA) || blockstate.func_203425_a(PFBlocks.LAUROZAMITES) || blockstate.func_203425_a(PFBlocks.CLATHOPTERIS)) {
                hunger = CamarasaurusEntity.this.getCurrentHunger();
                if (hunger + 10 >= CamarasaurusEntity.this.maxHunger) {
                    CamarasaurusEntity.this.setHunger(CamarasaurusEntity.this.maxHunger);
                    CamarasaurusEntity.this.setEating(false);
                } else {
                    CamarasaurusEntity.this.setHunger(hunger + 10);
                    CamarasaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.TALL_OTOZAMITES)) {
                hunger = CamarasaurusEntity.this.getCurrentHunger();
                if (hunger + 12 >= CamarasaurusEntity.this.maxHunger) {
                    CamarasaurusEntity.this.setHunger(CamarasaurusEntity.this.maxHunger);
                    CamarasaurusEntity.this.setEating(false);
                } else {
                    CamarasaurusEntity.this.setHunger(hunger + 12);
                    CamarasaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.OSMUNDA) || blockstate.func_203425_a(Blocks.field_196554_aH) || blockstate.func_203425_a(PFBlocks.CONIOPTERIS) || blockstate.func_203425_a(PFBlocks.CLADOPHLEBIS)) {
                hunger = CamarasaurusEntity.this.getCurrentHunger();
                if (hunger + 15 >= CamarasaurusEntity.this.maxHunger) {
                    CamarasaurusEntity.this.setHunger(CamarasaurusEntity.this.maxHunger);
                    CamarasaurusEntity.this.setEating(false);
                } else {
                    CamarasaurusEntity.this.setHunger(hunger + 15);
                    CamarasaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_HORSETAIL) || blockstate.func_203425_a(PFBlocks.SCYTOPHYLLUM)) {
                hunger = CamarasaurusEntity.this.getCurrentHunger();
                if (hunger + 20 >= CamarasaurusEntity.this.maxHunger) {
                    CamarasaurusEntity.this.setHunger(CamarasaurusEntity.this.maxHunger);
                    CamarasaurusEntity.this.setEating(false);
                } else {
                    CamarasaurusEntity.this.setHunger(hunger + 20);
                    CamarasaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_OSMUNDA) || blockstate.func_203425_a(Blocks.field_196805_gi) || blockstate.func_203425_a(PFBlocks.JOHNSTONIA)) {
                hunger = CamarasaurusEntity.this.getCurrentHunger();
                if (hunger + 25 >= CamarasaurusEntity.this.maxHunger) {
                    CamarasaurusEntity.this.setHunger(CamarasaurusEntity.this.maxHunger);
                    CamarasaurusEntity.this.setEating(false);
                } else {
                    CamarasaurusEntity.this.setHunger(hunger + 25);
                    CamarasaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.DICROIDIUM)) {
                hunger = CamarasaurusEntity.this.getCurrentHunger();
                if (hunger + 30 >= CamarasaurusEntity.this.maxHunger) {
                    CamarasaurusEntity.this.setHunger(CamarasaurusEntity.this.maxHunger);
                    CamarasaurusEntity.this.setEating(false);
                } else {
                    CamarasaurusEntity.this.setHunger(hunger + 30);
                    CamarasaurusEntity.this.setEating(false);
                }
            }
        }

        public boolean func_75250_a() {
            return !CamarasaurusEntity.this.isAsleep() && super.func_75250_a() && CamarasaurusEntity.this.getCurrentHunger() < CamarasaurusEntity.this.getHalfHunger();
        }

        public boolean func_75253_b() {
            if (CamarasaurusEntity.this.getCurrentHunger() >= CamarasaurusEntity.this.maxHunger || CamarasaurusEntity.this.isAsleep()) {
                return false;
            }
            return super.func_75253_b();
        }

        public void func_75249_e() {
            this.field_220731_g = 0;
            super.func_75249_e();
        }
    }
}

