/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities.jurassic.morrison;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entities.DinosaurEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.djadochta.AepyornithomimusEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.djadochta.CitipatiEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.djadochta.PinacosaurusEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.djadochta.PlesiohadrosEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.djadochta.ProtoceratopsEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.djadochta.TelmasaurusEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.AnkylosaurusEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.DakotaraptorEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.DidelphodonEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.ThescelosaurusEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.TriceratopsEntity;
import superlord.prehistoricfauna.common.entities.goal.CathemeralSleepGoal;
import superlord.prehistoricfauna.common.entities.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entities.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entities.goal.HuntGoal;
import superlord.prehistoricfauna.common.entities.jurassic.kayenta.SarahsaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.kayenta.ScelidosaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.kayenta.ScutellosaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.CamarasaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.DryosaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.EilenodonEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.HesperornithoidesEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.StegosaurusEntity;
import superlord.prehistoricfauna.common.entities.triassic.chinle.CoelophysisEntity;
import superlord.prehistoricfauna.common.entities.triassic.chinle.DesmatosuchusEntity;
import superlord.prehistoricfauna.common.entities.triassic.chinle.PlaceriasEntity;
import superlord.prehistoricfauna.common.entities.triassic.chinle.PoposaurusEntity;
import superlord.prehistoricfauna.common.entities.triassic.chinle.PostosuchusEntity;
import superlord.prehistoricfauna.common.entities.triassic.chinle.TrilophosaurusEntity;
import superlord.prehistoricfauna.common.entities.triassic.chinle.TypothoraxEntity;
import superlord.prehistoricfauna.common.entities.triassic.ischigualasto.HerrerasaurusEntity;
import superlord.prehistoricfauna.common.entities.triassic.ischigualasto.HyperodapedonEntity;
import superlord.prehistoricfauna.common.entities.triassic.ischigualasto.IschigualastiaEntity;
import superlord.prehistoricfauna.common.entities.triassic.ischigualasto.SaurosuchusEntity;
import superlord.prehistoricfauna.common.entities.triassic.ischigualasto.SillosuchusEntity;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEffects;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.SoundInit;

public class AllosaurusEntity
extends DinosaurEntity {
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(AllosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(AllosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ALBINO = EntityDataManager.func_187226_a(AllosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MELANISTIC = EntityDataManager.func_187226_a(AllosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> NATURAL_LOVE = EntityDataManager.func_187226_a(AllosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int currentHunger = 150;
    private int maxHunger = 150;
    int hungerTick = 0;
    private int warningSoundTicks;
    private int isDigging;
    private int lastInLove = 0;
    int loveTick = 0;
    private Goal attackAnimals;

    public AllosaurusEntity(EntityType<? extends AllosaurusEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        if (this.func_70631_g_()) {
            return 1.5f;
        }
        return 3.0f;
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    public boolean isInLoveNaturally() {
        return (Boolean)this.field_70180_af.func_187225_a(NATURAL_LOVE);
    }

    private void setInLoveNaturally(boolean isInLoveNaturally) {
        this.field_70180_af.func_187227_b(NATURAL_LOVE, (Object)isInLoveNaturally);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isAlbino() {
        return (Boolean)this.field_70180_af.func_187225_a(ALBINO);
    }

    private void setAlbino(boolean isAlbino) {
        this.field_70180_af.func_187227_b(ALBINO, (Object)isAlbino);
    }

    public boolean isMelanistic() {
        return (Boolean)this.field_70180_af.func_187225_a(MELANISTIC);
    }

    private void setMelanistic(boolean isMelanistic) {
        this.field_70180_af.func_187227_b(MELANISTIC, (Object)isMelanistic);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == PFItems.RAW_LARGE_THYREOPHORAN_MEAT.get();
    }

    public int getCurrentHunger() {
        return this.currentHunger;
    }

    private void setHunger(int currentHunger) {
        this.currentHunger = currentHunger;
    }

    public int getHalfHunger() {
        return this.maxHunger / 2;
    }

    public int getThreeQuartersHunger() {
        return this.maxHunger / 4 * 3;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.attackAnimals = new HuntGoal((MobEntity)this, AnimalEntity.class, 10, false, false, p_213487_0_ -> p_213487_0_ instanceof AepyornithomimusEntity || p_213487_0_ instanceof AnkylosaurusEntity || p_213487_0_ instanceof CitipatiEntity || p_213487_0_ instanceof DakotaraptorEntity || p_213487_0_ instanceof DryosaurusEntity || p_213487_0_ instanceof HerrerasaurusEntity || p_213487_0_ instanceof IschigualastiaEntity || p_213487_0_ instanceof PinacosaurusEntity || p_213487_0_ instanceof PlesiohadrosEntity || p_213487_0_ instanceof ProtoceratopsEntity || p_213487_0_ instanceof SaurosuchusEntity || p_213487_0_ instanceof SillosuchusEntity || p_213487_0_ instanceof StegosaurusEntity || p_213487_0_ instanceof ThescelosaurusEntity || p_213487_0_ instanceof TriceratopsEntity || p_213487_0_ instanceof CatEntity || p_213487_0_ instanceof OcelotEntity || p_213487_0_ instanceof CowEntity || p_213487_0_ instanceof AbstractHorseEntity || p_213487_0_ instanceof FoxEntity || p_213487_0_ instanceof MooshroomEntity || p_213487_0_ instanceof PigEntity || p_213487_0_ instanceof AbstractVillagerEntity || p_213487_0_ instanceof WanderingTraderEntity || p_213487_0_ instanceof AbstractIllagerEntity || p_213487_0_ instanceof LlamaEntity || p_213487_0_ instanceof PandaEntity || p_213487_0_ instanceof PolarBearEntity || p_213487_0_ instanceof TurtleEntity || p_213487_0_ instanceof PlayerEntity || p_213487_0_ instanceof SarahsaurusEntity || p_213487_0_ instanceof ScelidosaurusEntity || p_213487_0_ instanceof CoelophysisEntity || p_213487_0_ instanceof DesmatosuchusEntity || p_213487_0_ instanceof PlaceriasEntity || p_213487_0_ instanceof PoposaurusEntity || p_213487_0_ instanceof PostosuchusEntity || p_213487_0_ instanceof TypothoraxEntity || p_213487_0_ instanceof TrilophosaurusEntity);
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new TerritoryAttackGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new DinosaurLookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new DinosaurRandomLookGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new NaturalMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new AvoidEntityGoal((CreatureEntity)this, CamarasaurusEntity.class, 7.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(1, (Goal)new CathemeralSleepGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new CarnivoreHuntGoal((MobEntity)this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_ instanceof AepyornithomimusEntity || p_213487_0_ instanceof AnkylosaurusEntity || p_213487_0_ instanceof CitipatiEntity || p_213487_0_ instanceof DakotaraptorEntity || p_213487_0_ instanceof DryosaurusEntity || p_213487_0_ instanceof HerrerasaurusEntity || p_213487_0_ instanceof IschigualastiaEntity || p_213487_0_ instanceof PinacosaurusEntity || p_213487_0_ instanceof PlesiohadrosEntity || p_213487_0_ instanceof ProtoceratopsEntity || p_213487_0_ instanceof SaurosuchusEntity || p_213487_0_ instanceof SillosuchusEntity || p_213487_0_ instanceof StegosaurusEntity || p_213487_0_ instanceof ThescelosaurusEntity || p_213487_0_ instanceof TriceratopsEntity || p_213487_0_ instanceof CatEntity || p_213487_0_ instanceof OcelotEntity || p_213487_0_ instanceof CowEntity || p_213487_0_ instanceof AbstractHorseEntity || p_213487_0_ instanceof FoxEntity || p_213487_0_ instanceof MooshroomEntity || p_213487_0_ instanceof PigEntity || p_213487_0_ instanceof AbstractVillagerEntity || p_213487_0_ instanceof WanderingTraderEntity || p_213487_0_ instanceof AbstractIllagerEntity || p_213487_0_ instanceof LlamaEntity || p_213487_0_ instanceof PandaEntity || p_213487_0_ instanceof PolarBearEntity || p_213487_0_ instanceof TurtleEntity || p_213487_0_ instanceof PlayerEntity || p_213487_0_ instanceof SarahsaurusEntity || p_213487_0_ instanceof ScelidosaurusEntity || p_213487_0_ instanceof CoelophysisEntity || p_213487_0_ instanceof DesmatosuchusEntity || p_213487_0_ instanceof PlaceriasEntity || p_213487_0_ instanceof PoposaurusEntity || p_213487_0_ instanceof PostosuchusEntity || p_213487_0_ instanceof TypothoraxEntity || p_213487_0_ instanceof TrilophosaurusEntity));
        this.field_70715_bh.func_75776_a(0, (Goal)new BabyCarnivoreHuntGoal((MobEntity)this, LivingEntity.class, 10, 1.75, true, false, p_213487_1_ -> p_213487_1_ instanceof DidelphodonEntity || p_213487_1_ instanceof EilenodonEntity || p_213487_1_ instanceof HyperodapedonEntity || p_213487_1_ instanceof TelmasaurusEntity || p_213487_1_ instanceof RabbitEntity || p_213487_1_ instanceof ChickenEntity || p_213487_1_ instanceof HesperornithoidesEntity || p_213487_1_ instanceof ScutellosaurusEntity));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 12.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233820_c_, 0.6);
    }

    private void setAttackGoals() {
        this.field_70715_bh.func_75776_a(4, this.attackAnimals);
    }

    protected SoundEvent func_184639_G() {
        return this.isAsleep() ? SoundInit.ALLOSAURUS_SNORES : SoundInit.ALLOSAURUS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.ALLOSAURUS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.ALLOSAURUS_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundInit.ALLOSAURUS_WARN, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(ALBINO, (Object)false);
        this.field_70180_af.func_187214_a(MELANISTIC, (Object)false);
        this.field_70180_af.func_187214_a(NATURAL_LOVE, (Object)false);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isAsleep()) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.25);
        }
        if (!this.func_175446_cd()) {
            List list = this.field_70170_p.func_217357_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0));
            if (PrehistoricFaunaConfig.advancedHunger) {
                ++this.hungerTick;
                if (this.hungerTick == 600 && !this.func_70631_g_() || this.hungerTick == 300 && this.func_70631_g_()) {
                    if (!this.isAsleep()) {
                        if (this.currentHunger != 0) {
                            this.setHunger(this.currentHunger - 1);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.field_70170_p.func_175659_aa() == Difficulty.HARD && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                    }
                    this.hungerTick = 0;
                }
                if (this.getCurrentHunger() >= this.getThreeQuartersHunger() && this.hungerTick % 150 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() != 0.0f && this.func_70638_az() == null && this.func_70643_av() == null) {
                    float currentHealth = this.func_110143_aJ();
                    this.func_70606_j(currentHealth + 1.0f);
                }
                if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                    if (!(this.lastInLove != 0 || this.currentHunger < this.getThreeQuartersHunger() || this.field_70173_aa % 900 != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep() || list.size() >= 5)) {
                        this.loveTick = 600;
                        this.setInLoveNaturally(true);
                        this.func_204700_e(600);
                        this.lastInLove = 28800;
                    }
                    if (this.loveTick != 0) {
                        --this.loveTick;
                    } else {
                        this.setInLoveNaturally(false);
                    }
                }
            } else if ((PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && !PrehistoricFaunaConfig.advancedHunger && list.size() < 5) {
                int naturalBreedingChance = this.field_70146_Z.nextInt(1000);
                if (!(this.lastInLove != 0 || naturalBreedingChance != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep())) {
                    this.loveTick = 600;
                    this.setInLoveNaturally(true);
                    this.func_204700_e(600);
                    this.lastInLove = 28800;
                }
                if (this.loveTick != 0) {
                    --this.loveTick;
                } else {
                    this.setInLoveNaturally(false);
                }
            }
            if (this.lastInLove != 0) {
                --this.lastInLove;
            }
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HasEgg", this.hasEgg());
        compound.func_74757_a("IsAlbino", this.isAlbino());
        compound.func_74757_a("IsMelanistic", this.isMelanistic());
        compound.func_74768_a("MaxHunger", this.currentHunger);
        compound.func_74757_a("InNaturalLove", this.isInLoveNaturally());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
        this.setAlbino(compound.func_74767_n("IsAlbino"));
        this.setMelanistic(compound.func_74767_n("IsMelanistic"));
        this.setAttackGoals();
        this.setHunger(compound.func_74762_e("MaxHunger"));
        this.setInLoveNaturally(compound.func_74767_n("InNaturalLove"));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Random rand = new Random();
        int birthNumber = rand.nextInt(799);
        if (birthNumber >= 0 && birthNumber < 4) {
            this.setAlbino(true);
        } else if (birthNumber >= 4 && birthNumber < 7) {
            this.setMelanistic(true);
        }
        this.setHunger(this.maxHunger);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance((Effect)PFEffects.BLEEDING.get(), 300, 0, true, false));
        }
        return flag;
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        AllosaurusEntity entity = new AllosaurusEntity((EntityType<? extends AllosaurusEntity>)PFEntities.ALLOSAURUS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IServerWorld)p_241840_1_, this.field_70170_p.func_175649_E(new BlockPos(entity.func_213303_ch())), SpawnReason.BREEDING, null, null);
        return entity;
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)AllosaurusEntity.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                AllosaurusEntity.this.func_184185_a(SoundInit.ALLOSAURUS_BITE, 1.0f, AllosaurusEntity.this.func_70647_i());
                this.field_75441_b.func_70652_k((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    AllosaurusEntity.this.playWarningSound();
                }
            } else {
                this.func_234039_g_();
            }
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 8.0f + attackTarget.func_213311_cf();
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)AllosaurusEntity.this, 2.0);
        }

        public boolean func_75250_a() {
            return !AllosaurusEntity.this.func_70631_g_() && !AllosaurusEntity.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class TerritoryAttackGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public TerritoryAttackGoal() {
            super((MobEntity)AllosaurusEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            Iterator iterator;
            if (AllosaurusEntity.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a() && (iterator = AllosaurusEntity.this.field_70170_p.func_217357_a(AllosaurusEntity.class, AllosaurusEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0)).iterator()).hasNext()) {
                AllosaurusEntity allosaurus = (AllosaurusEntity)((Object)iterator.next());
                return true;
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)AllosaurusEntity.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (AllosaurusEntity.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof AllosaurusEntity && !mobIn.func_70631_g_()) {
                super.func_220793_a(mobIn, targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)AllosaurusEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (AllosaurusEntity.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (AllosaurusEntity allosaurus : AllosaurusEntity.this.field_70170_p.func_217357_a(AllosaurusEntity.class, AllosaurusEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!allosaurus.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final AllosaurusEntity allosaurus;

        LayEggGoal(AllosaurusEntity allosaurus, double speedIn) {
            super((CreatureEntity)allosaurus, speedIn, 16);
            this.allosaurus = allosaurus;
        }

        public boolean func_75250_a() {
            return this.allosaurus.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.allosaurus.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos(this.allosaurus.func_213303_ch());
            if (!this.allosaurus.func_70090_H() && this.func_179487_f()) {
                if (this.allosaurus.isDigging < 1) {
                    this.allosaurus.setDigging(true);
                } else if (this.allosaurus.isDigging > 200) {
                    World world = this.allosaurus.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)PFBlocks.ALLOSAURUS_EGG.func_176223_P().func_206870_a((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.allosaurus.field_70146_Z.nextInt(4) + 1)), 3);
                    this.allosaurus.setHasEgg(false);
                    this.allosaurus.setDigging(false);
                    this.allosaurus.func_204700_e(600);
                }
                if (this.allosaurus.isDigging()) {
                    this.allosaurus.isDigging++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150391_bh || block == Blocks.field_150354_m || block == Blocks.field_196611_F || block == PFBlocks.MOSSY_DIRT || block == PFBlocks.MOSS_BLOCK || block == PFBlocks.LOAM || block == PFBlocks.PACKED_LOAM || block == PFBlocks.SILT || block == PFBlocks.PACKED_LOAM || block == BlockTags.field_206952_E;
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final AllosaurusEntity allosaurus;

        MateGoal(AllosaurusEntity allosaurus, double speedIn) {
            super((AnimalEntity)allosaurus, speedIn);
            this.allosaurus = allosaurus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.allosaurus.hasEgg() && !this.allosaurus.isInLoveNaturally();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverplayerentity = this.field_75390_d.func_191993_do();
            if (serverplayerentity == null && this.field_75391_e.func_191993_do() != null) {
                serverplayerentity = this.field_75391_e.func_191993_do();
            }
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.allosaurus.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class NaturalMateGoal
    extends BreedGoal {
        private final AllosaurusEntity allosaurus;

        NaturalMateGoal(AllosaurusEntity allosaurus, double speed) {
            super((AnimalEntity)allosaurus, speed);
            this.allosaurus = allosaurus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.allosaurus.hasEgg() && this.allosaurus.getCurrentHunger() >= this.allosaurus.getThreeQuartersHunger() && this.allosaurus.field_70173_aa % 60 == 0 && (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && this.allosaurus.isInLoveNaturally();
        }

        protected void func_75388_i() {
            if (PrehistoricFaunaConfig.naturalEggItemLaying) {
                this.allosaurus.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.allosaurus.field_70146_Z.nextFloat() - this.allosaurus.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                int eggAmount = this.allosaurus.field_70146_Z.nextInt(4);
                if (eggAmount == 0) {
                    this.allosaurus.func_199703_a((IItemProvider)PFBlocks.ALLOSAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 1) {
                    this.allosaurus.func_199703_a((IItemProvider)PFBlocks.ALLOSAURUS_EGG.func_199767_j());
                    this.allosaurus.func_199703_a((IItemProvider)PFBlocks.ALLOSAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 2) {
                    this.allosaurus.func_199703_a((IItemProvider)PFBlocks.ALLOSAURUS_EGG.func_199767_j());
                    this.allosaurus.func_199703_a((IItemProvider)PFBlocks.ALLOSAURUS_EGG.func_199767_j());
                    this.allosaurus.func_199703_a((IItemProvider)PFBlocks.ALLOSAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 3) {
                    this.allosaurus.func_199703_a((IItemProvider)PFBlocks.ALLOSAURUS_EGG.func_199767_j());
                    this.allosaurus.func_199703_a((IItemProvider)PFBlocks.ALLOSAURUS_EGG.func_199767_j());
                    this.allosaurus.func_199703_a((IItemProvider)PFBlocks.ALLOSAURUS_EGG.func_199767_j());
                    this.allosaurus.func_199703_a((IItemProvider)PFBlocks.ALLOSAURUS_EGG.func_199767_j());
                }
            } else {
                this.allosaurus.setHasEgg(true);
            }
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
        }
    }

    public class CarnivoreHuntGoal
    extends NearestAttackableTargetGoal {
        double huntSpeed;

        public CarnivoreHuntGoal(MobEntity goalOwnerIn, Class targetClassIn, int targetChanceIn, double huntSpeed, boolean checkSight, @Nullable boolean nearbyOnly, Predicate<LivingEntity> targetPredicate) {
            super(goalOwnerIn, targetClassIn, targetChanceIn, checkSight, nearbyOnly, targetPredicate);
            this.huntSpeed = huntSpeed;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && AllosaurusEntity.this.getCurrentHunger() <= AllosaurusEntity.this.getHalfHunger() && !AllosaurusEntity.this.func_70631_g_() && PrehistoricFaunaConfig.advancedHunger;
        }

        public boolean func_75253_b() {
            return AllosaurusEntity.this.getCurrentHunger() > AllosaurusEntity.this.maxHunger && PrehistoricFaunaConfig.advancedHunger;
        }

        public void func_75246_d() {
            AllosaurusEntity.this.func_70661_as().func_75489_a(this.huntSpeed);
            LivingEntity target = AllosaurusEntity.this.func_70638_az();
            if ((target instanceof CatEntity || target instanceof FoxEntity || target instanceof CowEntity || target instanceof MooshroomEntity || target instanceof PigEntity || target instanceof OcelotEntity || target instanceof AepyornithomimusEntity || target instanceof ProtoceratopsEntity || target instanceof CoelophysisEntity || target instanceof TypothoraxEntity || target instanceof TrilophosaurusEntity) && target.func_110143_aJ() == 0.0f) {
                if (AllosaurusEntity.this.getCurrentHunger() + 10 >= AllosaurusEntity.this.maxHunger) {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.maxHunger);
                } else {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.currentHunger + 10);
                }
            }
            if ((target instanceof CitipatiEntity || target instanceof DryosaurusEntity || target instanceof ThescelosaurusEntity || target instanceof ScelidosaurusEntity || target instanceof SarahsaurusEntity) && target.func_110143_aJ() == 0.0f) {
                if (AllosaurusEntity.this.getCurrentHunger() + 15 >= AllosaurusEntity.this.maxHunger) {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.maxHunger);
                } else {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.currentHunger + 15);
                }
            }
            if ((target instanceof HerrerasaurusEntity || target instanceof PlaceriasEntity || target instanceof PostosuchusEntity || target instanceof AbstractHorseEntity || target instanceof WanderingTraderEntity || target instanceof PlayerEntity || target instanceof AbstractVillagerEntity || target instanceof AbstractIllagerEntity || target instanceof LlamaEntity || target instanceof PandaEntity || target instanceof PoposaurusEntity || target instanceof DesmatosuchusEntity) && target.func_110143_aJ() == 0.0f) {
                if (AllosaurusEntity.this.getCurrentHunger() + 20 >= AllosaurusEntity.this.maxHunger) {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.maxHunger);
                } else {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.currentHunger + 20);
                }
            }
            if ((target instanceof DakotaraptorEntity || target instanceof PolarBearEntity || target instanceof TurtleEntity || target instanceof SaurosuchusEntity) && target.func_110143_aJ() == 0.0f) {
                if (AllosaurusEntity.this.getCurrentHunger() + 30 >= AllosaurusEntity.this.maxHunger) {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.maxHunger);
                } else {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.currentHunger + 30);
                }
            }
            if ((target instanceof IschigualastiaEntity || target instanceof PinacosaurusEntity || target instanceof PlesiohadrosEntity) && target.func_110143_aJ() == 0.0f) {
                if (AllosaurusEntity.this.getCurrentHunger() + 40 >= AllosaurusEntity.this.maxHunger) {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.maxHunger);
                } else {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.currentHunger + 40);
                }
            }
            if ((target instanceof AnkylosaurusEntity || target instanceof SillosuchusEntity || target instanceof StegosaurusEntity || target instanceof TriceratopsEntity) && target.func_110143_aJ() == 0.0f) {
                if (AllosaurusEntity.this.getCurrentHunger() + 60 >= AllosaurusEntity.this.maxHunger) {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.maxHunger);
                } else {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.currentHunger + 60);
                }
            }
            super.func_75246_d();
        }
    }

    public class BabyCarnivoreHuntGoal
    extends NearestAttackableTargetGoal {
        double huntSpeed;

        public BabyCarnivoreHuntGoal(MobEntity goalOwnerIn, Class targetClassIn, int targetChanceIn, double huntSpeed, boolean checkSight, @Nullable boolean nearbyOnly, Predicate<LivingEntity> targetPredicate) {
            super(goalOwnerIn, targetClassIn, targetChanceIn, checkSight, nearbyOnly, targetPredicate);
            this.huntSpeed = huntSpeed;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && AllosaurusEntity.this.getCurrentHunger() <= AllosaurusEntity.this.getHalfHunger() && AllosaurusEntity.this.func_70631_g_() && PrehistoricFaunaConfig.advancedHunger;
        }

        public boolean func_75253_b() {
            return AllosaurusEntity.this.getCurrentHunger() > AllosaurusEntity.this.maxHunger && PrehistoricFaunaConfig.advancedHunger || !AllosaurusEntity.this.func_70631_g_() && PrehistoricFaunaConfig.advancedHunger;
        }

        public void func_75246_d() {
            AllosaurusEntity.this.func_70661_as().func_75489_a(this.huntSpeed);
            LivingEntity target = AllosaurusEntity.this.func_70638_az();
            if (target instanceof RabbitEntity && target.func_110143_aJ() == 0.0f) {
                if (AllosaurusEntity.this.getCurrentHunger() + 3 >= AllosaurusEntity.this.maxHunger) {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.maxHunger);
                } else {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.currentHunger + 3);
                }
            }
            if ((target instanceof DidelphodonEntity || target instanceof EilenodonEntity || target instanceof HyperodapedonEntity || target instanceof ChickenEntity || target instanceof HesperornithoidesEntity || target instanceof ScutellosaurusEntity) && target.func_110143_aJ() == 0.0f) {
                if (AllosaurusEntity.this.getCurrentHunger() + 4 >= AllosaurusEntity.this.maxHunger) {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.maxHunger);
                } else {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.currentHunger + 4);
                }
            }
            if (target instanceof TelmasaurusEntity && target.func_110143_aJ() == 0.0f) {
                if (AllosaurusEntity.this.getCurrentHunger() + 6 >= AllosaurusEntity.this.maxHunger) {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.maxHunger);
                } else {
                    AllosaurusEntity.this.setHunger(AllosaurusEntity.this.currentHunger + 6);
                }
            }
            super.func_75246_d();
        }
    }
}

