/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities.jurassic.kayenta;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entities.DinosaurEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.djadochta.PinacosaurusEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.djadochta.PlesiohadrosEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.AnkylosaurusEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.DakotaraptorEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.TriceratopsEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.TyrannosaurusEntity;
import superlord.prehistoricfauna.common.entities.goal.CathemeralSleepGoal;
import superlord.prehistoricfauna.common.entities.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entities.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entities.jurassic.kayenta.DilophosaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.AllosaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.CamarasaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.CeratosaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.StegosaurusEntity;
import superlord.prehistoricfauna.common.entities.triassic.ischigualasto.HerrerasaurusEntity;
import superlord.prehistoricfauna.common.entities.triassic.ischigualasto.IschigualastiaEntity;
import superlord.prehistoricfauna.common.entities.triassic.ischigualasto.SaurosuchusEntity;
import superlord.prehistoricfauna.common.entities.triassic.ischigualasto.SillosuchusEntity;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.SoundInit;

public class SarahsaurusEntity
extends DinosaurEntity {
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(SarahsaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(SarahsaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ALBINO = EntityDataManager.func_187226_a(SarahsaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MELANISTIC = EntityDataManager.func_187226_a(SarahsaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EATING = EntityDataManager.func_187226_a(SarahsaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> NATURAL_LOVE = EntityDataManager.func_187226_a(SarahsaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int maxHunger = 38;
    private int currentHunger = 38;
    private int lastInLove = 0;
    int hungerTick = 0;
    int loveTick = 0;
    private int warningSoundTicks;
    private int isDigging;

    public SarahsaurusEntity(EntityType<? extends SarahsaurusEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        if (this.func_70631_g_()) {
            return 0.725f;
        }
        return 1.45f;
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == PFBlocks.OTOZAMITES.func_199767_j();
    }

    public boolean isAlbino() {
        return (Boolean)this.field_70180_af.func_187225_a(ALBINO);
    }

    private void setAlbino(boolean isAlbino) {
        this.field_70180_af.func_187227_b(ALBINO, (Object)isAlbino);
    }

    public boolean isMelanistic() {
        return (Boolean)this.field_70180_af.func_187225_a(MELANISTIC);
    }

    private void setMelanistic(boolean isMelanistic) {
        this.field_70180_af.func_187227_b(MELANISTIC, (Object)isMelanistic);
    }

    public boolean isInLoveNaturally() {
        return (Boolean)this.field_70180_af.func_187225_a(NATURAL_LOVE);
    }

    private void setInLoveNaturally(boolean isInLoveNaturally) {
        this.field_70180_af.func_187227_b(NATURAL_LOVE, (Object)isInLoveNaturally);
    }

    public int getCurrentHunger() {
        return this.currentHunger;
    }

    private void setHunger(int currentHunger) {
        this.currentHunger = currentHunger;
    }

    public int getHalfHunger() {
        return this.maxHunger / 2;
    }

    public int getThreeQuartersHunger() {
        return this.maxHunger / 4 * 3;
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(EATING);
    }

    private void setEating(boolean isEating) {
        this.field_70180_af.func_187227_b(EATING, (Object)isEating);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Random rand = new Random();
        int birthNumber = rand.nextInt(799);
        if (birthNumber >= 0 && birthNumber < 4) {
            this.setAlbino(true);
        } else if (birthNumber >= 4 && birthNumber < 7) {
            this.setMelanistic(true);
        }
        this.setHunger(this.maxHunger);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(ALBINO, (Object)false);
        this.field_70180_af.func_187214_a(MELANISTIC, (Object)false);
        this.field_70180_af.func_187214_a(EATING, (Object)false);
        this.field_70180_af.func_187214_a(NATURAL_LOVE, (Object)false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HasEgg", this.hasEgg());
        compound.func_74757_a("IsAlbino", this.isAlbino());
        compound.func_74757_a("IsMelanistic", this.isMelanistic());
        compound.func_74768_a("MaxHunger", this.currentHunger);
        compound.func_74757_a("IsEating", this.isEating());
        compound.func_74757_a("InNaturalLove", this.isInLoveNaturally());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
        this.setAlbino(compound.func_74767_n("IsAlbino"));
        this.setMelanistic(compound.func_74767_n("IsMelanistic"));
        this.setEating(compound.func_74767_n("IsEating"));
        this.setHunger(compound.func_74762_e("MaxHunger"));
        this.setInLoveNaturally(compound.func_74767_n("InNaturalLove"));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new DinosaurLookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new DinosaurRandomLookGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, DilophosaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, PinacosaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlesiohadrosEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, AnkylosaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, DakotaraptorEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, TriceratopsEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, TyrannosaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, AllosaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, CamarasaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, CeratosaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, StegosaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, HerrerasaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, IschigualastiaEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, SaurosuchusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, SillosuchusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(0, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new CathemeralSleepGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new HerbivoreEatGoal(1.2f, 12, 2));
    }

    protected SoundEvent func_184639_G() {
        return this.isAsleep() ? null : SoundInit.SARAHSAURUS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.SARAHSAURUS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.SARAHSAURUS_DEATH;
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundInit.SARAHSAURUS_WARN, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 15.0).func_233815_a_(Attributes.field_233821_d_, 0.22).func_233815_a_(Attributes.field_233819_b_, 15.0).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isAsleep()) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.22);
        }
        if (!this.func_175446_cd()) {
            List list = this.field_70170_p.func_217357_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0));
            if (PrehistoricFaunaConfig.advancedHunger) {
                ++this.hungerTick;
                if (this.hungerTick == 600 && !this.func_70631_g_() || this.hungerTick == 300 && this.func_70631_g_()) {
                    if (!this.isAsleep()) {
                        if (this.currentHunger != 0) {
                            this.setHunger(this.currentHunger - 1);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.field_70170_p.func_175659_aa() == Difficulty.HARD && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                    }
                    this.hungerTick = 0;
                }
                if (this.getCurrentHunger() >= this.getThreeQuartersHunger() && this.hungerTick % 150 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() != 0.0f && this.func_70638_az() == null && this.func_70643_av() == null) {
                    float currentHealth = this.func_110143_aJ();
                    this.func_70606_j(currentHealth + 1.0f);
                }
                if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                    if (!(this.lastInLove != 0 || this.currentHunger < this.getThreeQuartersHunger() || this.field_70173_aa % 900 != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep() || list.size() >= 5)) {
                        this.loveTick = 600;
                        this.setInLoveNaturally(true);
                        this.func_204700_e(600);
                        this.lastInLove = 28800;
                    }
                    if (this.loveTick != 0) {
                        --this.loveTick;
                    } else {
                        this.setInLoveNaturally(false);
                    }
                }
            } else if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                int naturalBreedingChance = this.field_70146_Z.nextInt(1000);
                if (!(this.lastInLove != 0 || naturalBreedingChance != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep() || list.size() >= 5)) {
                    this.loveTick = 600;
                    this.setInLoveNaturally(true);
                    this.func_204700_e(600);
                    this.lastInLove = 28800;
                }
                if (this.loveTick != 0) {
                    --this.loveTick;
                } else {
                    this.setInLoveNaturally(false);
                }
            }
            if (this.lastInLove != 0) {
                --this.lastInLove;
            }
        }
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        SarahsaurusEntity entity = new SarahsaurusEntity((EntityType<? extends SarahsaurusEntity>)PFEntities.SARAHSAURUS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos(entity.func_213303_ch())), SpawnReason.BREEDING, null, null);
        return entity;
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)SarahsaurusEntity.this, 2.0);
        }

        public boolean func_75250_a() {
            return !SarahsaurusEntity.this.func_70631_g_() && !SarahsaurusEntity.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)SarahsaurusEntity.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    SarahsaurusEntity.this.playWarningSound();
                }
            } else {
                this.func_234039_g_();
            }
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final SarahsaurusEntity sarahsaurus;

        MateGoal(SarahsaurusEntity sarahsaurus, double speed) {
            super((AnimalEntity)sarahsaurus, speed);
            this.sarahsaurus = sarahsaurus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.sarahsaurus.hasEgg() && !this.sarahsaurus.isInLoveNaturally();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverPlayerEntity = this.field_75390_d.func_191993_do();
            if (serverPlayerEntity == null && this.field_75391_e.func_191993_do() != null) {
                serverPlayerEntity = this.field_75391_e.func_191993_do();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverPlayerEntity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.sarahsaurus.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class NaturalMateGoal
    extends BreedGoal {
        private final SarahsaurusEntity sarahsaurus;

        NaturalMateGoal(SarahsaurusEntity sarahsaurus, double speed) {
            super((AnimalEntity)sarahsaurus, speed);
            this.sarahsaurus = sarahsaurus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.sarahsaurus.hasEgg() && this.sarahsaurus.getCurrentHunger() >= this.sarahsaurus.getThreeQuartersHunger() && this.sarahsaurus.field_70173_aa % 60 == 0 && (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && this.sarahsaurus.isInLoveNaturally();
        }

        protected void func_75388_i() {
            if (PrehistoricFaunaConfig.naturalEggItemLaying) {
                this.sarahsaurus.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.sarahsaurus.field_70146_Z.nextFloat() - this.sarahsaurus.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                int eggAmount = this.sarahsaurus.field_70146_Z.nextInt(4);
                if (eggAmount == 0) {
                    this.sarahsaurus.func_199703_a((IItemProvider)PFBlocks.SARAHSAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 1) {
                    this.sarahsaurus.func_199703_a((IItemProvider)PFBlocks.SARAHSAURUS_EGG.func_199767_j());
                    this.sarahsaurus.func_199703_a((IItemProvider)PFBlocks.SARAHSAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 2) {
                    this.sarahsaurus.func_199703_a((IItemProvider)PFBlocks.SARAHSAURUS_EGG.func_199767_j());
                    this.sarahsaurus.func_199703_a((IItemProvider)PFBlocks.SARAHSAURUS_EGG.func_199767_j());
                    this.sarahsaurus.func_199703_a((IItemProvider)PFBlocks.SARAHSAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 3) {
                    this.sarahsaurus.func_199703_a((IItemProvider)PFBlocks.SARAHSAURUS_EGG.func_199767_j());
                    this.sarahsaurus.func_199703_a((IItemProvider)PFBlocks.SARAHSAURUS_EGG.func_199767_j());
                    this.sarahsaurus.func_199703_a((IItemProvider)PFBlocks.SARAHSAURUS_EGG.func_199767_j());
                    this.sarahsaurus.func_199703_a((IItemProvider)PFBlocks.SARAHSAURUS_EGG.func_199767_j());
                }
            } else {
                this.sarahsaurus.setHasEgg(true);
            }
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)SarahsaurusEntity.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (SarahsaurusEntity.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof SarahsaurusEntity && !mobIn.func_70631_g_()) {
                super.func_220793_a(mobIn, targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)SarahsaurusEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (SarahsaurusEntity.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (SarahsaurusEntity sarahsaurus : SarahsaurusEntity.this.field_70170_p.func_217357_a(SarahsaurusEntity.class, SarahsaurusEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!sarahsaurus.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final SarahsaurusEntity sarahsaurus;

        LayEggGoal(SarahsaurusEntity sarahsaurus, double speedIn) {
            super((CreatureEntity)sarahsaurus, speedIn, 16);
            this.sarahsaurus = sarahsaurus;
        }

        public boolean func_75250_a() {
            return this.sarahsaurus.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.sarahsaurus.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos(this.sarahsaurus.func_213303_ch());
            if (!this.sarahsaurus.func_70090_H() && this.func_179487_f()) {
                if (this.sarahsaurus.isDigging < 1) {
                    this.sarahsaurus.setDigging(true);
                } else if (this.sarahsaurus.isDigging > 200) {
                    World world = this.sarahsaurus.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)PFBlocks.SARAHSAURUS_EGG.func_176223_P().func_206870_a((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.sarahsaurus.field_70146_Z.nextInt(4) + 1)), 3);
                    this.sarahsaurus.setHasEgg(false);
                    this.sarahsaurus.setDigging(false);
                    this.sarahsaurus.func_204700_e(600);
                }
                if (this.sarahsaurus.isDigging()) {
                    this.sarahsaurus.isDigging++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150391_bh || block == Blocks.field_150354_m || block == Blocks.field_196611_F || block == PFBlocks.MOSSY_DIRT || block == PFBlocks.MOSS_BLOCK || block == PFBlocks.LOAM || block == PFBlocks.PACKED_LOAM || block == PFBlocks.SILT || block == PFBlocks.PACKED_LOAM || block == BlockTags.field_206952_E;
        }
    }

    public class HerbivoreEatGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public HerbivoreEatGoal(double p_i50725_2_, int p_i50725_4_, int p_i50725_5_) {
            super((CreatureEntity)SarahsaurusEntity.this, p_i50725_2_, p_i50725_4_, p_i50725_5_);
        }

        public double func_203110_f() {
            return 2.0;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 100 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            return blockstate.func_203425_a(PFBlocks.HORSETAIL) || blockstate.func_203425_a(PFBlocks.TALL_HORSETAIL) || blockstate.func_203425_a(PFBlocks.OSMUNDA) || blockstate.func_203425_a(PFBlocks.TALL_OSMUNDA) || blockstate.func_203425_a(PFBlocks.CLUBMOSS) || blockstate.func_203425_a(PFBlocks.MARCHANTIA) || blockstate.func_203425_a(PFBlocks.CONIOPTERIS) || blockstate.func_203425_a(PFBlocks.OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.TALL_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.DICROIDIUM) || blockstate.func_203425_a(PFBlocks.JOHNSTONIA) || blockstate.func_203425_a(PFBlocks.CLADOPHLEBIS) || blockstate.func_203425_a(PFBlocks.SCYTOPHYLLUM) || blockstate.func_203425_a(PFBlocks.MICHELILLOA) || blockstate.func_203425_a(PFBlocks.DEAD_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.COBBANIA) || blockstate.func_203425_a(PFBlocks.OTOZAMITES) || blockstate.func_203425_a(PFBlocks.TALL_OTOZAMITES) || blockstate.func_203425_a(PFBlocks.LAUROZAMITES) || blockstate.func_203425_a(Blocks.field_150349_c) || blockstate.func_203425_a(Blocks.field_150395_bd) || blockstate.func_235714_a_((ITag)BlockTags.field_226149_I_) || blockstate.func_203425_a(Blocks.field_196804_gh) || blockstate.func_203425_a(Blocks.field_196554_aH) || blockstate.func_203425_a(Blocks.field_196805_gi);
        }

        public void func_75246_d() {
            if (this.func_179487_f()) {
                if (this.field_220731_g >= 20) {
                    this.eatBerry();
                } else {
                    ++this.field_220731_g;
                    SarahsaurusEntity.this.setEating(true);
                }
                if (this.field_220731_g % 5 == 1) {
                    SarahsaurusEntity.this.field_70170_p.func_184133_a((PlayerEntity)null, this.field_179494_b, SoundEvents.field_187575_bT, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
            }
            if (SarahsaurusEntity.this.getCurrentHunger() >= 13) {
                SarahsaurusEntity.this.setEating(false);
            }
            super.func_75246_d();
        }

        protected void eatBerry() {
            BlockState blockstate = SarahsaurusEntity.this.field_70170_p.func_180495_p(this.field_179494_b);
            int hunger = SarahsaurusEntity.this.getCurrentHunger();
            if (blockstate.func_203425_a(PFBlocks.DEAD_OSMUNDACAULIS)) {
                if (hunger + 2 >= SarahsaurusEntity.this.maxHunger) {
                    SarahsaurusEntity.this.setHunger(SarahsaurusEntity.this.maxHunger);
                } else {
                    SarahsaurusEntity.this.setHunger(hunger + 2);
                }
            }
            if (blockstate.func_203425_a(Blocks.field_150349_c) || blockstate.func_203425_a(Blocks.field_196804_gh) || blockstate.func_235714_a_((ITag)BlockTags.field_226149_I_)) {
                if (hunger + 4 >= SarahsaurusEntity.this.maxHunger) {
                    SarahsaurusEntity.this.setHunger(SarahsaurusEntity.this.maxHunger);
                } else {
                    SarahsaurusEntity.this.setHunger(hunger + 4);
                }
            }
            if (blockstate.func_203425_a(Blocks.field_150395_bd)) {
                if (hunger + 6 >= SarahsaurusEntity.this.maxHunger) {
                    SarahsaurusEntity.this.setHunger(SarahsaurusEntity.this.maxHunger);
                } else {
                    SarahsaurusEntity.this.setHunger(hunger + 6);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.MARCHANTIA) || blockstate.func_203425_a(PFBlocks.OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.OTOZAMITES)) {
                if (hunger + 8 >= SarahsaurusEntity.this.maxHunger) {
                    SarahsaurusEntity.this.setHunger(SarahsaurusEntity.this.maxHunger);
                } else {
                    SarahsaurusEntity.this.setHunger(hunger + 8);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.HORSETAIL) || blockstate.func_203425_a(PFBlocks.CLUBMOSS) || blockstate.func_203425_a(PFBlocks.MICHELILLOA) || blockstate.func_203425_a(PFBlocks.COBBANIA) || blockstate.func_203425_a(PFBlocks.LAUROZAMITES) || blockstate.func_203425_a(PFBlocks.CLATHOPTERIS)) {
                if (hunger + 10 >= SarahsaurusEntity.this.maxHunger) {
                    SarahsaurusEntity.this.setHunger(SarahsaurusEntity.this.maxHunger);
                } else {
                    SarahsaurusEntity.this.setHunger(hunger + 10);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.TALL_OTOZAMITES)) {
                if (hunger + 12 >= SarahsaurusEntity.this.maxHunger) {
                    SarahsaurusEntity.this.setHunger(SarahsaurusEntity.this.maxHunger);
                } else {
                    SarahsaurusEntity.this.setHunger(hunger + 12);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.OSMUNDA) || blockstate.func_203425_a(Blocks.field_196554_aH) || blockstate.func_203425_a(PFBlocks.CONIOPTERIS) || blockstate.func_203425_a(PFBlocks.CLADOPHLEBIS)) {
                if (hunger + 15 >= SarahsaurusEntity.this.maxHunger) {
                    SarahsaurusEntity.this.setHunger(SarahsaurusEntity.this.maxHunger);
                } else {
                    SarahsaurusEntity.this.setHunger(hunger + 15);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_HORSETAIL) || blockstate.func_203425_a(PFBlocks.SCYTOPHYLLUM)) {
                if (hunger + 20 >= SarahsaurusEntity.this.maxHunger) {
                    SarahsaurusEntity.this.setHunger(SarahsaurusEntity.this.maxHunger);
                } else {
                    SarahsaurusEntity.this.setHunger(hunger + 20);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_OSMUNDA) || blockstate.func_203425_a(Blocks.field_196805_gi) || blockstate.func_203425_a(PFBlocks.JOHNSTONIA)) {
                if (hunger + 25 >= SarahsaurusEntity.this.maxHunger) {
                    SarahsaurusEntity.this.setHunger(SarahsaurusEntity.this.maxHunger);
                } else {
                    SarahsaurusEntity.this.setHunger(hunger + 25);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.DICROIDIUM)) {
                if (hunger + 30 >= SarahsaurusEntity.this.maxHunger) {
                    SarahsaurusEntity.this.setHunger(SarahsaurusEntity.this.maxHunger);
                } else {
                    SarahsaurusEntity.this.setHunger(hunger + 30);
                }
            }
            SarahsaurusEntity.this.setEating(false);
        }

        public boolean func_75250_a() {
            return !SarahsaurusEntity.this.isAsleep() && super.func_75250_a() && SarahsaurusEntity.this.getCurrentHunger() < SarahsaurusEntity.this.getHalfHunger();
        }

        public boolean func_75253_b() {
            if (SarahsaurusEntity.this.getCurrentHunger() >= SarahsaurusEntity.this.maxHunger || SarahsaurusEntity.this.isAsleep()) {
                return false;
            }
            return super.func_75253_b();
        }

        public void func_75249_e() {
            this.field_220731_g = 0;
            super.func_75249_e();
        }
    }
}

