/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities.jurassic.kayenta;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.CodEntity;
import net.minecraft.entity.passive.fish.SalmonEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.pathfinding.WalkAndSwimNodeProcessor;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entities.DinosaurEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.djadochta.AepyornithomimusEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.djadochta.ProtoceratopsEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.djadochta.TelmasaurusEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.djadochta.VelociraptorEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.BasilemysEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.DidelphodonEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.ThescelosaurusEntity;
import superlord.prehistoricfauna.common.entities.fish.ArganodusEntity;
import superlord.prehistoricfauna.common.entities.fish.CeratodusEntity;
import superlord.prehistoricfauna.common.entities.fish.ChinleaEntity;
import superlord.prehistoricfauna.common.entities.fish.CyclurusEntity;
import superlord.prehistoricfauna.common.entities.fish.GarEntity;
import superlord.prehistoricfauna.common.entities.fish.MooreodontusEntity;
import superlord.prehistoricfauna.common.entities.fish.MyledaphusEntity;
import superlord.prehistoricfauna.common.entities.fish.PotamoceratodusEntity;
import superlord.prehistoricfauna.common.entities.fish.SaurichthysEntity;
import superlord.prehistoricfauna.common.entities.goal.CathemeralSleepGoal;
import superlord.prehistoricfauna.common.entities.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entities.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entities.goal.HuntGoal;
import superlord.prehistoricfauna.common.entities.jurassic.kayenta.KayentatheriumEntity;
import superlord.prehistoricfauna.common.entities.jurassic.kayenta.MegapnosaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.kayenta.SarahsaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.kayenta.ScutellosaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.DryosaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.EilenodonEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.HesperornithoidesEntity;
import superlord.prehistoricfauna.common.entities.triassic.ischigualasto.ChromogisaurusEntity;
import superlord.prehistoricfauna.common.entities.triassic.ischigualasto.ExaeretodonEntity;
import superlord.prehistoricfauna.common.entities.triassic.ischigualasto.HyperodapedonEntity;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.SoundInit;

public class CalsoyasuchusEntity
extends DinosaurEntity {
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(CalsoyasuchusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(CalsoyasuchusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ALBINO = EntityDataManager.func_187226_a(CalsoyasuchusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MELANISTIC = EntityDataManager.func_187226_a(CalsoyasuchusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> NATURAL_LOVE = EntityDataManager.func_187226_a(CalsoyasuchusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int maxHunger = 15;
    private int currentHunger = 15;
    int hungerTick = 0;
    private int lastInLove = 0;
    private int warningSoundTicks;
    private int isDigging;
    int loveTick = 0;

    public CalsoyasuchusEntity(EntityType<? extends TameableEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70138_W = 1.0f;
    }

    public boolean isDigging() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_DIGGING);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        if (this.func_70631_g_()) {
            return 0.15f;
        }
        return 0.3f;
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean hasEgg() {
        return (Boolean)this.func_184212_Q().func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isAlbino() {
        return (Boolean)this.field_70180_af.func_187225_a(ALBINO);
    }

    private void setAlbino(boolean isAlbino) {
        this.field_70180_af.func_187227_b(ALBINO, (Object)isAlbino);
    }

    public boolean isMelanistic() {
        return (Boolean)this.field_70180_af.func_187225_a(MELANISTIC);
    }

    private void setMelanistic(boolean isMelanistic) {
        this.field_70180_af.func_187227_b(MELANISTIC, (Object)isMelanistic);
    }

    public boolean isInLoveNaturally() {
        return (Boolean)this.field_70180_af.func_187225_a(NATURAL_LOVE);
    }

    private void setInLoveNaturally(boolean isInLoveNaturally) {
        this.field_70180_af.func_187227_b(NATURAL_LOVE, (Object)isInLoveNaturally);
    }

    public int getCurrentHunger() {
        return this.currentHunger;
    }

    private void setHunger(int currentHunger) {
        this.currentHunger = currentHunger;
    }

    public int getHalfHunger() {
        return this.maxHunger / 2;
    }

    public int getThreeQuartersHunger() {
        return this.maxHunger / 4 * 3;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Random rand = new Random();
        int birthNumber = rand.nextInt(799);
        if (birthNumber >= 0 && birthNumber < 4) {
            this.setAlbino(true);
        } else if (birthNumber >= 4 && birthNumber < 7) {
            this.setMelanistic(true);
        }
        this.setHunger(50);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public int func_205010_bg() {
        return 4800;
    }

    protected int func_207300_l(int currentAir) {
        return this.func_205010_bg();
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == PFItems.CERATODUS.get();
    }

    protected PathNavigator func_175447_b(World world) {
        return new WalkAndSwimPathNavigator(this, world);
    }

    protected boolean func_212800_dy() {
        return true;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new CathemeralSleepGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal());
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new TerritoryAttackGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new DinosaurLookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new DinosaurRandomLookGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new SwimGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new CarnivoreHuntGoal((MobEntity)this, LivingEntity.class, 10, 1.75, true, false, p_213487_1_ -> p_213487_1_ instanceof RabbitEntity || p_213487_1_ instanceof HyperodapedonEntity || p_213487_1_ instanceof HesperornithoidesEntity || p_213487_1_ instanceof EilenodonEntity || p_213487_1_ instanceof ScutellosaurusEntity || p_213487_1_ instanceof ChickenEntity || p_213487_1_ instanceof BasilemysEntity || p_213487_1_ instanceof ChromogisaurusEntity || p_213487_1_ instanceof ExaeretodonEntity || p_213487_1_ instanceof TelmasaurusEntity || p_213487_1_ instanceof KayentatheriumEntity || p_213487_1_ instanceof MegapnosaurusEntity || p_213487_1_ instanceof VelociraptorEntity || p_213487_1_ instanceof WolfEntity || p_213487_1_ instanceof ArganodusEntity || p_213487_1_ instanceof CeratodusEntity || p_213487_1_ instanceof ChinleaEntity || p_213487_1_ instanceof CyclurusEntity || p_213487_1_ instanceof MooreodontusEntity || p_213487_1_ instanceof MyledaphusEntity || p_213487_1_ instanceof PotamoceratodusEntity || p_213487_1_ instanceof SaurichthysEntity || p_213487_1_ instanceof CatEntity || p_213487_1_ instanceof FoxEntity || p_213487_1_ instanceof CowEntity || p_213487_1_ instanceof MooshroomEntity || p_213487_1_ instanceof PigEntity || p_213487_1_ instanceof OcelotEntity || p_213487_1_ instanceof AepyornithomimusEntity || p_213487_1_ instanceof DryosaurusEntity || p_213487_1_ instanceof ProtoceratopsEntity || p_213487_1_ instanceof ThescelosaurusEntity || p_213487_1_ instanceof SarahsaurusEntity || p_213487_1_ instanceof CodEntity || p_213487_1_ instanceof SalmonEntity || p_213487_1_ instanceof TropicalFishEntity));
        this.field_70715_bh.func_75776_a(0, (Goal)new BabyCarnivoreHuntGoal((MobEntity)this, LivingEntity.class, 10, 1.75, true, false, p_213487_1_ -> p_213487_1_ instanceof DidelphodonEntity || p_213487_1_ instanceof EilenodonEntity || p_213487_1_ instanceof HyperodapedonEntity || p_213487_1_ instanceof TelmasaurusEntity || p_213487_1_ instanceof RabbitEntity || p_213487_1_ instanceof ChickenEntity || p_213487_1_ instanceof HesperornithoidesEntity || p_213487_1_ instanceof ScutellosaurusEntity || p_213487_1_ instanceof CodEntity || p_213487_1_ instanceof SalmonEntity || p_213487_1_ instanceof TropicalFishEntity || p_213487_1_ instanceof ArganodusEntity || p_213487_1_ instanceof CeratodusEntity || p_213487_1_ instanceof ChinleaEntity || p_213487_1_ instanceof CyclurusEntity || p_213487_1_ instanceof MooreodontusEntity || p_213487_1_ instanceof MyledaphusEntity || p_213487_1_ instanceof PotamoceratodusEntity || p_213487_1_ instanceof SaurichthysEntity));
        this.field_70715_bh.func_75776_a(1, (Goal)new HuntGoal((MobEntity)this, AnimalEntity.class, 10, true, false, p_213487_1_ -> p_213487_1_ instanceof RabbitEntity || p_213487_1_ instanceof HyperodapedonEntity || p_213487_1_ instanceof HesperornithoidesEntity || p_213487_1_ instanceof EilenodonEntity || p_213487_1_ instanceof ScutellosaurusEntity || p_213487_1_ instanceof ChickenEntity || p_213487_1_ instanceof BasilemysEntity || p_213487_1_ instanceof ChromogisaurusEntity || p_213487_1_ instanceof ExaeretodonEntity || p_213487_1_ instanceof TelmasaurusEntity || p_213487_1_ instanceof KayentatheriumEntity || p_213487_1_ instanceof MegapnosaurusEntity || p_213487_1_ instanceof VelociraptorEntity || p_213487_1_ instanceof WolfEntity || p_213487_1_ instanceof ArganodusEntity || p_213487_1_ instanceof CeratodusEntity || p_213487_1_ instanceof ChinleaEntity || p_213487_1_ instanceof CyclurusEntity || p_213487_1_ instanceof MooreodontusEntity || p_213487_1_ instanceof MyledaphusEntity || p_213487_1_ instanceof PotamoceratodusEntity || p_213487_1_ instanceof SaurichthysEntity || p_213487_1_ instanceof CatEntity || p_213487_1_ instanceof FoxEntity || p_213487_1_ instanceof CowEntity || p_213487_1_ instanceof MooshroomEntity || p_213487_1_ instanceof PigEntity || p_213487_1_ instanceof OcelotEntity || p_213487_1_ instanceof AepyornithomimusEntity || p_213487_1_ instanceof DryosaurusEntity || p_213487_1_ instanceof ProtoceratopsEntity || p_213487_1_ instanceof ThescelosaurusEntity || p_213487_1_ instanceof SarahsaurusEntity || p_213487_1_ instanceof CodEntity || p_213487_1_ instanceof SalmonEntity || p_213487_1_ instanceof TropicalFishEntity));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isAsleep()) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.25);
        }
        if (!this.func_175446_cd()) {
            List list = this.field_70170_p.func_217357_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0));
            if (PrehistoricFaunaConfig.advancedHunger) {
                ++this.hungerTick;
                if (this.hungerTick == 600 && !this.func_70631_g_() || this.hungerTick == 300 && this.func_70631_g_()) {
                    if (!this.isAsleep()) {
                        if (this.currentHunger != 0) {
                            this.setHunger(this.currentHunger - 1);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.field_70170_p.func_175659_aa() == Difficulty.HARD && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                    }
                    this.hungerTick = 0;
                }
                if (this.getCurrentHunger() >= this.getThreeQuartersHunger() && this.hungerTick % 150 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() != 0.0f && this.func_70638_az() == null && this.func_70643_av() == null) {
                    float currentHealth = this.func_110143_aJ();
                    this.func_70606_j(currentHealth + 1.0f);
                }
                if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                    if (!(this.lastInLove != 0 || this.currentHunger < this.getThreeQuartersHunger() || this.field_70173_aa % 900 != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep() || list.size() >= 3)) {
                        this.loveTick = 600;
                        this.setInLoveNaturally(true);
                        this.func_204700_e(600);
                        this.lastInLove = 28800;
                    }
                    if (this.loveTick != 0) {
                        --this.loveTick;
                    } else {
                        this.setInLoveNaturally(false);
                    }
                }
            } else if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                int naturalBreedingChance = this.field_70146_Z.nextInt(1000);
                if (!(this.lastInLove != 0 || naturalBreedingChance != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep() || list.size() >= 3)) {
                    this.loveTick = 600;
                    this.setInLoveNaturally(true);
                    this.func_204700_e(600);
                    this.lastInLove = 28800;
                }
                if (this.loveTick != 0) {
                    --this.loveTick;
                } else {
                    this.setInLoveNaturally(false);
                }
            }
            if (this.lastInLove != 0) {
                --this.lastInLove;
            }
        }
    }

    public static boolean canDinosaurSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return (worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)Tags.Blocks.DIRT) || worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150355_j) || worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)Tags.Blocks.SAND)) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    protected SoundEvent func_184639_G() {
        return this.isAsleep() ? null : SoundInit.CALSOYASUCHUS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.CALSOYASUCHUS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.CALSOYASUCHUS_DEATH;
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundInit.CALSOYASUCHUS_WARN, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(ALBINO, (Object)false);
        this.field_70180_af.func_187214_a(MELANISTIC, (Object)false);
        this.field_70180_af.func_187214_a(NATURAL_LOVE, (Object)false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HasEgg", this.hasEgg());
        compound.func_74757_a("IsAlbino", this.isAlbino());
        compound.func_74757_a("IsMelanistic", this.isMelanistic());
        compound.func_74768_a("MaxHunger", this.currentHunger);
        compound.func_74757_a("InNaturalLove", this.isInLoveNaturally());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
        this.setAlbino(compound.func_74767_n("IsAlbino"));
        this.setMelanistic(compound.func_74767_n("IsMelanistic"));
        this.setHunger(compound.func_74762_e("MaxHunger"));
        this.setInLoveNaturally(compound.func_74767_n("InNaturalLove"));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag) {
            this.func_174815_a((LivingEntity)this, entity);
        }
        return flag;
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        CalsoyasuchusEntity entity = new CalsoyasuchusEntity(PFEntities.CALSOYASUCHUS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos(entity.func_213303_ch())), SpawnReason.BREEDING, null, null);
        return entity;
    }

    static class MoveHelperController
    extends MovementController {
        private final CalsoyasuchusEntity calsoyasuchus;

        MoveHelperController(CalsoyasuchusEntity calsoyasuchus) {
            super((MobEntity)calsoyasuchus);
            this.calsoyasuchus = calsoyasuchus;
        }

        public void func_75641_c() {
            if (this.calsoyasuchus.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.calsoyasuchus.func_213317_d(this.calsoyasuchus.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.calsoyasuchus.func_70661_as().func_75500_f()) {
                float f = (float)(this.field_75645_e * this.calsoyasuchus.func_233637_b_(Attributes.field_233821_d_));
                this.calsoyasuchus.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.calsoyasuchus.func_70689_ay(), (float)f));
                double d0 = this.field_75646_b - this.calsoyasuchus.func_226277_ct_();
                double d1 = this.field_75647_c - this.calsoyasuchus.func_226278_cu_();
                double d2 = this.field_75644_d - this.calsoyasuchus.func_226281_cx_();
                if (d1 != 0.0) {
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    this.calsoyasuchus.func_213317_d(this.calsoyasuchus.func_213322_ci().func_72441_c(0.0, (double)this.calsoyasuchus.func_70689_ay() * (d1 / d3) * 0.1, 0.0));
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.calsoyasuchus.field_70761_aq = this.calsoyasuchus.field_70177_z = this.func_75639_a(this.calsoyasuchus.field_70177_z, f1, 90.0f);
                }
            } else {
                this.calsoyasuchus.func_70659_e(0.0f);
            }
        }
    }

    class WalkAndSwimPathNavigator
    extends SwimmerPathNavigator {
        WalkAndSwimPathNavigator(CalsoyasuchusEntity calsoyasuchus, World world) {
            super((MobEntity)calsoyasuchus, world);
        }

        protected boolean func_75485_k() {
            return true;
        }

        protected PathFinder func_179679_a(int uncategorizedNumber) {
            this.field_179695_a = new WalkAndSwimNodeProcessor();
            return new PathFinder(this.field_179695_a, uncategorizedNumber);
        }

        public boolean func_188555_b(BlockPos pos) {
            return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)CalsoyasuchusEntity.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    CalsoyasuchusEntity.this.playWarningSound();
                }
            } else {
                this.func_234039_g_();
            }
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)CalsoyasuchusEntity.this, 2.0);
        }

        public boolean func_75250_a() {
            return !CalsoyasuchusEntity.this.func_70631_g_() && !CalsoyasuchusEntity.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)CalsoyasuchusEntity.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (CalsoyasuchusEntity.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity entity, LivingEntity target) {
            if (entity instanceof CalsoyasuchusEntity && !entity.func_70631_g_()) {
                super.func_220793_a(entity, target);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)CalsoyasuchusEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (CalsoyasuchusEntity.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (CalsoyasuchusEntity calsoyasuchus : CalsoyasuchusEntity.this.field_70170_p.func_217357_a(CalsoyasuchusEntity.class, CalsoyasuchusEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!CalsoyasuchusEntity.this.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    class TerritoryAttackGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public TerritoryAttackGoal() {
            super((MobEntity)CalsoyasuchusEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            Iterator iterator;
            if (CalsoyasuchusEntity.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a() && (iterator = CalsoyasuchusEntity.this.field_70170_p.func_217357_a(CalsoyasuchusEntity.class, CalsoyasuchusEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0)).iterator()).hasNext()) {
                CalsoyasuchusEntity calsoyasuchus = (CalsoyasuchusEntity)((Object)iterator.next());
                return true;
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final CalsoyasuchusEntity calsoyasuchus;

        MateGoal(CalsoyasuchusEntity calsoyasuchus, double speed) {
            super((AnimalEntity)calsoyasuchus, speed);
            this.calsoyasuchus = calsoyasuchus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.calsoyasuchus.hasEgg() && !this.calsoyasuchus.isInLoveNaturally();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverPlayerEntity = this.field_75390_d.func_191993_do();
            if (serverPlayerEntity == null && this.field_75391_e.func_191993_do() == null) {
                serverPlayerEntity = this.field_75391_e.func_191993_do();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverPlayerEntity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.calsoyasuchus.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class NaturalMateGoal
    extends BreedGoal {
        private final CalsoyasuchusEntity calsoyasuchus;

        NaturalMateGoal(CalsoyasuchusEntity calsoyasuchus, double speed) {
            super((AnimalEntity)calsoyasuchus, speed);
            this.calsoyasuchus = calsoyasuchus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.calsoyasuchus.hasEgg() && this.calsoyasuchus.getCurrentHunger() >= this.calsoyasuchus.getThreeQuartersHunger() && this.calsoyasuchus.field_70173_aa % 60 == 0 && (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && this.calsoyasuchus.isInLoveNaturally();
        }

        protected void func_75388_i() {
            if (PrehistoricFaunaConfig.naturalEggItemLaying) {
                this.calsoyasuchus.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.calsoyasuchus.field_70146_Z.nextFloat() - this.calsoyasuchus.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                int eggAmount = this.calsoyasuchus.field_70146_Z.nextInt(4);
                if (eggAmount == 0) {
                    this.calsoyasuchus.func_199703_a((IItemProvider)PFBlocks.CALSOYASUCHUS_EGG.func_199767_j());
                }
                if (eggAmount == 1) {
                    this.calsoyasuchus.func_199703_a((IItemProvider)PFBlocks.CALSOYASUCHUS_EGG.func_199767_j());
                    this.calsoyasuchus.func_199703_a((IItemProvider)PFBlocks.CALSOYASUCHUS_EGG.func_199767_j());
                }
                if (eggAmount == 2) {
                    this.calsoyasuchus.func_199703_a((IItemProvider)PFBlocks.CALSOYASUCHUS_EGG.func_199767_j());
                    this.calsoyasuchus.func_199703_a((IItemProvider)PFBlocks.CALSOYASUCHUS_EGG.func_199767_j());
                    this.calsoyasuchus.func_199703_a((IItemProvider)PFBlocks.CALSOYASUCHUS_EGG.func_199767_j());
                }
                if (eggAmount == 3) {
                    this.calsoyasuchus.func_199703_a((IItemProvider)PFBlocks.CALSOYASUCHUS_EGG.func_199767_j());
                    this.calsoyasuchus.func_199703_a((IItemProvider)PFBlocks.CALSOYASUCHUS_EGG.func_199767_j());
                    this.calsoyasuchus.func_199703_a((IItemProvider)PFBlocks.CALSOYASUCHUS_EGG.func_199767_j());
                    this.calsoyasuchus.func_199703_a((IItemProvider)PFBlocks.CALSOYASUCHUS_EGG.func_199767_j());
                }
            } else {
                this.calsoyasuchus.setHasEgg(true);
            }
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final CalsoyasuchusEntity calsoyasuchus;

        LayEggGoal(CalsoyasuchusEntity calsoyasuchus, double speed) {
            super((CreatureEntity)calsoyasuchus, speed, 16);
            this.calsoyasuchus = calsoyasuchus;
        }

        public boolean func_75250_a() {
            return this.calsoyasuchus.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.calsoyasuchus.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos(this.calsoyasuchus.func_213303_ch());
            if (!this.calsoyasuchus.func_70090_H() && this.func_179487_f()) {
                if (this.calsoyasuchus.isDigging < 1) {
                    this.calsoyasuchus.setDigging(true);
                } else if (this.calsoyasuchus.isDigging > 200) {
                    World world = this.calsoyasuchus.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)PFBlocks.CALSOYASUCHUS_EGG.func_176223_P().func_206870_a((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.calsoyasuchus.field_70146_Z.nextInt(4) + 1)), 3);
                    this.calsoyasuchus.setHasEgg(false);
                    this.calsoyasuchus.setDigging(false);
                    this.calsoyasuchus.func_204700_e(600);
                }
                if (this.calsoyasuchus.isDigging()) {
                    this.calsoyasuchus.isDigging++;
                }
            }
        }

        public boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150391_bh || block == Blocks.field_150354_m || block == Blocks.field_196611_F || block == PFBlocks.MOSSY_DIRT || block == PFBlocks.MOSS_BLOCK || block == PFBlocks.LOAM || block == PFBlocks.PACKED_LOAM || block == PFBlocks.SILT || block == PFBlocks.PACKED_LOAM || block == BlockTags.field_206952_E;
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final CalsoyasuchusEntity calsoyasuchus;

        public SwimGoal(CalsoyasuchusEntity calsoyasuchus) {
            super((CreatureEntity)calsoyasuchus, 1.0, 40);
            this.calsoyasuchus = calsoyasuchus;
        }

        public boolean func_75250_a() {
            return this.calsoyasuchus.func_212800_dy() && super.func_75250_a();
        }
    }

    public class CarnivoreHuntGoal
    extends NearestAttackableTargetGoal {
        double huntSpeed;

        public CarnivoreHuntGoal(MobEntity goalOwnerIn, Class targetClassIn, int targetChanceIn, double huntSpeed, boolean checkSight, @Nullable boolean nearbyOnly, Predicate<LivingEntity> targetPredicate) {
            super(goalOwnerIn, targetClassIn, targetChanceIn, checkSight, nearbyOnly, targetPredicate);
            this.huntSpeed = huntSpeed;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && CalsoyasuchusEntity.this.getCurrentHunger() <= CalsoyasuchusEntity.this.getHalfHunger() && !CalsoyasuchusEntity.this.func_70631_g_() && PrehistoricFaunaConfig.advancedHunger;
        }

        public boolean func_75253_b() {
            return CalsoyasuchusEntity.this.getCurrentHunger() < CalsoyasuchusEntity.this.maxHunger && PrehistoricFaunaConfig.advancedHunger;
        }

        public void func_75246_d() {
            CalsoyasuchusEntity.this.func_70661_as().func_75489_a(this.huntSpeed);
            LivingEntity target = CalsoyasuchusEntity.this.func_70638_az();
            if ((target instanceof RabbitEntity || target instanceof ArganodusEntity || target instanceof CeratodusEntity || target instanceof ChinleaEntity || target instanceof CyclurusEntity || target instanceof MooreodontusEntity || target instanceof MyledaphusEntity || target instanceof PotamoceratodusEntity || target instanceof SaurichthysEntity || target instanceof CodEntity || target instanceof SalmonEntity || target instanceof TropicalFishEntity) && target.func_110143_aJ() == 0.0f) {
                if (CalsoyasuchusEntity.this.getCurrentHunger() + 3 >= CalsoyasuchusEntity.this.maxHunger) {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.maxHunger);
                } else {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.currentHunger + 3);
                }
            }
            if ((target instanceof HyperodapedonEntity || target instanceof HesperornithoidesEntity || target instanceof EilenodonEntity || target instanceof ScutellosaurusEntity || target instanceof ChickenEntity) && target.func_110143_aJ() == 0.0f) {
                if (CalsoyasuchusEntity.this.getCurrentHunger() + 4 >= CalsoyasuchusEntity.this.maxHunger) {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.maxHunger);
                } else {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.currentHunger + 6);
                }
            }
            if ((target instanceof BasilemysEntity || target instanceof ChromogisaurusEntity || target instanceof ExaeretodonEntity || target instanceof TelmasaurusEntity || target instanceof KayentatheriumEntity || target instanceof MegapnosaurusEntity) && target.func_110143_aJ() == 0.0f) {
                if (CalsoyasuchusEntity.this.getCurrentHunger() + 6 >= CalsoyasuchusEntity.this.maxHunger) {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.maxHunger);
                } else {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.currentHunger + 6);
                }
            }
            if ((target instanceof VelociraptorEntity || target instanceof WolfEntity) && target.func_110143_aJ() == 0.0f) {
                if (CalsoyasuchusEntity.this.getCurrentHunger() + 8 >= CalsoyasuchusEntity.this.maxHunger) {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.maxHunger);
                } else {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.currentHunger + 8);
                }
            }
            if ((target instanceof CatEntity || target instanceof FoxEntity || target instanceof CowEntity || target instanceof MooshroomEntity || target instanceof PigEntity || target instanceof OcelotEntity || target instanceof AepyornithomimusEntity || target instanceof DryosaurusEntity || target instanceof ProtoceratopsEntity || target instanceof ThescelosaurusEntity || target instanceof SarahsaurusEntity) && target.func_110143_aJ() == 0.0f) {
                if (CalsoyasuchusEntity.this.getCurrentHunger() + 10 >= CalsoyasuchusEntity.this.maxHunger) {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.maxHunger);
                } else {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.currentHunger + 10);
                }
            }
            super.func_75246_d();
        }
    }

    public class BabyCarnivoreHuntGoal
    extends NearestAttackableTargetGoal {
        double huntSpeed;

        public BabyCarnivoreHuntGoal(MobEntity goalOwnerIn, Class targetClassIn, int targetChanceIn, double huntSpeed, boolean checkSight, @Nullable boolean nearbyOnly, Predicate<LivingEntity> targetPredicate) {
            super(goalOwnerIn, targetClassIn, targetChanceIn, checkSight, nearbyOnly, targetPredicate);
            this.huntSpeed = huntSpeed;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && CalsoyasuchusEntity.this.getCurrentHunger() <= CalsoyasuchusEntity.this.getHalfHunger() && CalsoyasuchusEntity.this.func_70631_g_() && PrehistoricFaunaConfig.advancedHunger;
        }

        public boolean func_75253_b() {
            return CalsoyasuchusEntity.this.getCurrentHunger() < CalsoyasuchusEntity.this.maxHunger && PrehistoricFaunaConfig.advancedHunger || !CalsoyasuchusEntity.this.func_70631_g_() && PrehistoricFaunaConfig.advancedHunger;
        }

        public void func_75246_d() {
            CalsoyasuchusEntity.this.func_70661_as().func_75489_a(this.huntSpeed);
            LivingEntity target = CalsoyasuchusEntity.this.func_70638_az();
            if (target instanceof RabbitEntity && target.func_110143_aJ() == 0.0f) {
                if (CalsoyasuchusEntity.this.getCurrentHunger() + 3 >= CalsoyasuchusEntity.this.maxHunger) {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.maxHunger);
                } else {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.currentHunger + 3);
                }
            }
            if ((target instanceof DidelphodonEntity || target instanceof EilenodonEntity || target instanceof HyperodapedonEntity || target instanceof ChickenEntity || target instanceof HesperornithoidesEntity || target instanceof ScutellosaurusEntity || target instanceof ArganodusEntity || target instanceof CeratodusEntity || target instanceof ChinleaEntity || target instanceof CyclurusEntity || target instanceof GarEntity || target instanceof MooreodontusEntity || target instanceof MyledaphusEntity || target instanceof PotamoceratodusEntity || target instanceof SaurichthysEntity) && target.func_110143_aJ() == 0.0f) {
                if (CalsoyasuchusEntity.this.getCurrentHunger() + 4 >= CalsoyasuchusEntity.this.maxHunger) {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.maxHunger);
                } else {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.currentHunger + 4);
                }
            }
            if (target instanceof TelmasaurusEntity && target.func_110143_aJ() == 0.0f) {
                if (CalsoyasuchusEntity.this.getCurrentHunger() + 6 >= CalsoyasuchusEntity.this.maxHunger) {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.maxHunger);
                } else {
                    CalsoyasuchusEntity.this.setHunger(CalsoyasuchusEntity.this.currentHunger + 6);
                }
            }
            super.func_75246_d();
        }
    }
}

