/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities.henos;

import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import superlord.prehistoricfauna.init.PFParticles;
import superlord.prehistoricfauna.init.SoundInit;

public class TimeGuardianEntity
extends AnimalEntity {
    private static final DataParameter<Boolean> ACTIVE = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> USE_BEAM = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> USE_REGULAR_ATTACK = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CHARGING_BEAM = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> USING_BEAM = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> LASER_TARGET_ENTITY = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> LASER_X = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> LASER_Y = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> LASER_Z = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> IS_SUMMONED = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MELEE_TICK = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LASER_TICK = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SHIELD_LEVEL = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS);
    public boolean inWall;
    public float targetDistance;
    public float targetAngle;
    public float prevLaserX;
    public float prevLaserY;
    public float prevLaserZ;
    private float leftPunchProgress;
    private float prevLeftPunchProgress;
    private float rightPunchProgress;
    private float prevRightPunchProgress;
    private float laserProgress;
    private float prevLaserProgress;
    private boolean usingLeftHand;
    private int shieldCooldown = 0;

    public TimeGuardianEntity(EntityType<? extends TimeGuardianEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233819_b_, 25.0).func_233815_a_(Attributes.field_233820_c_, 50.0);
    }

    public boolean isSummoned() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SUMMONED);
    }

    public void setSummoned(boolean isSummoned) {
        this.field_70180_af.func_187227_b(IS_SUMMONED, (Object)isSummoned);
    }

    protected SoundEvent func_184639_G() {
        return SoundInit.HENOS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.HENOS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.HENOS_DEATH;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new BeamAttackAI(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal(this, 1.0, true));
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public boolean func_70648_aU() {
        return true;
    }

    private boolean checkWalls(AxisAlignedBB p_31140_) {
        int i = MathHelper.func_76128_c((double)p_31140_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_31140_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_31140_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_31140_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_31140_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_31140_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                    if (blockstate.func_196958_f() || blockstate.func_185904_a() == Material.field_151581_o) continue;
                    if (ForgeHooks.canEntityDestroy((World)this.field_70170_p, (BlockPos)blockpos, (LivingEntity)this) && !BlockTags.field_219754_W.func_230235_a_((Object)blockstate.func_177230_c())) {
                        flag1 = this.field_70170_p.func_217377_a(blockpos, false) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.field_70146_Z.nextInt(l - i + 1), j + this.field_70146_Z.nextInt(i1 - j + 1), k + this.field_70146_Z.nextInt(j1 - k + 1));
            this.field_70170_p.func_217379_c(2008, blockpos1, 0);
        }
        return flag;
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            this.inWall = this.checkWalls(this.func_174813_aQ());
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevRightPunchProgress = this.rightPunchProgress;
        this.prevLeftPunchProgress = this.leftPunchProgress;
        this.prevLaserX = this.getLaserX();
        this.prevLaserY = this.getLaserY();
        this.prevLaserZ = this.getLaserZ();
        this.prevLaserProgress = this.laserProgress;
        if (this.laserProgress < 1.0f && this.isUsingBeamAttack() && !this.isUsingRegularAttack()) {
            this.laserProgress += 0.1f;
        }
        if (this.laserProgress > 0.0f && (!this.isUsingBeamAttack() || this.isUsingRegularAttack())) {
            this.laserProgress -= 0.1f;
        }
        if (this.func_70638_az() != null) {
            this.targetDistance = this.func_70032_d((Entity)this.func_70638_az()) - this.func_70638_az().func_213311_cf() / 2.0f;
            this.targetAngle = (float)this.getAngleBetweenEntities((Entity)this, (Entity)this.func_70638_az());
        }
        if (this.func_70638_az() != null && (!this.func_70638_az().func_70089_S() || this.func_70638_az().func_110143_aJ() <= 0.0f)) {
            this.func_70624_b(null);
        }
        if (!this.field_70170_p.field_72995_K && !this.func_175446_cd()) {
            if (this.isActive()) {
                if (this.func_70638_az() == null) {
                    this.setActive(false);
                }
            } else if (this.func_70638_az() != null && this.targetDistance <= 30.0f || this.func_70643_av() != null && this.targetDistance <= 30.0f) {
                this.setActive(true);
            }
            if (this.getHealthRatio() < 0.5f && this.shieldCooldown == 0 && !this.hasHealingShield()) {
                this.shieldCooldown = 300 + this.field_70146_Z.nextInt(300);
                this.setHealingShield(3);
            }
        }
        if (!this.isActive()) {
            this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
            this.field_70177_z = this.field_70126_B;
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.setHealingShield(1);
            }
            if (this.func_110143_aJ() == this.func_110138_aP()) {
                this.setHealingShield(0);
            }
        }
        this.field_70761_aq = this.field_70177_z;
        if (!this.field_70170_p.field_72995_K && this.hasHealingShield()) {
            if (this.func_70638_az() == null) {
                this.func_70691_i(0.3f);
            } else {
                double dist = this.func_70032_d((Entity)this.func_70638_az());
                if (dist > 16.0) {
                    this.func_70691_i(3.0f);
                } else {
                    this.func_70691_i((float)MathHelper.func_151237_a((double)(dist * (double)0.085f), (double)0.2f, (double)3.0));
                }
            }
        }
        if ((Integer)this.field_70180_af.func_187225_a(MELEE_TICK) > 0 && this.isUsingRegularAttack()) {
            if (Math.max(this.rightPunchProgress, this.leftPunchProgress) == 5.0f && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < this.func_70638_az().func_213311_cf() + this.func_213311_cf() + 2.0f) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.0f);
                if (this.func_70638_az().func_184585_cz()) {
                    ((PlayerEntity)this.func_70638_az()).func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                    this.field_70170_p.func_72960_a((Entity)((PlayerEntity)this.func_70638_az()), (byte)30);
                }
            }
            this.field_70180_af.func_187227_b(MELEE_TICK, (Object)((Integer)this.field_70180_af.func_187225_a(MELEE_TICK) - 1));
            if ((Integer)this.field_70180_af.func_187225_a(MELEE_TICK) == 0) {
                boolean bl = this.usingLeftHand = !this.usingLeftHand;
            }
            if (!this.usingLeftHand && this.rightPunchProgress < 5.0f) {
                this.rightPunchProgress += 2.5f;
            }
            if (this.usingLeftHand && this.leftPunchProgress < 5.0f) {
                this.leftPunchProgress += 2.5f;
            }
        } else {
            if (this.leftPunchProgress > 0.0f) {
                this.leftPunchProgress -= Math.min(0.5f, this.leftPunchProgress);
            }
            if (this.rightPunchProgress > 0.0f) {
                this.rightPunchProgress -= Math.min(0.5f, this.rightPunchProgress);
            }
        }
        if (this.usingLeftHand) {
            if (this.rightPunchProgress > 0.0f) {
                this.rightPunchProgress -= 1.0f;
            }
        } else if (this.leftPunchProgress > 0.0f) {
            this.leftPunchProgress -= 1.0f;
        }
        if (this.isUsingBeamAttack()) {
            double d0 = (double)this.getLaserX() - this.func_226277_ct_();
            double d1 = (double)this.getLaserY() - this.func_226283_e_(1.0);
            double d2 = (double)this.getLaserZ() - this.func_226281_cx_();
            double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
            d0 /= d3;
            d1 /= d3;
            d2 /= d3;
            double d4 = this.field_70146_Z.nextDouble();
            while (d4 < d3) {
                this.field_70170_p.func_195594_a((IParticleData)PFParticles.BOSS_LASER, this.func_226277_ct_() + d0 * (d4 += 3.0 - this.field_70146_Z.nextDouble() * 2.5), this.func_226280_cw_() + d1 * d4, this.func_226281_cx_() + d2 * d4, (double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.1f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.1f));
            }
        }
        if (this.hasHealingShield() && this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2 + this.field_70146_Z.nextInt(2); ++i) {
                this.field_70170_p.func_195594_a((IParticleData)PFParticles.BOSS_HEAL, this.func_226282_d_(2.0), this.func_226278_cu_(), this.func_226287_g_(2.0), this.func_226277_ct_(), this.func_226283_e_(0.75), this.func_226281_cx_());
            }
        }
        if (this.getLaserTick() < 0) {
            this.setLaserTick(this.getLaserTick() + 1);
        }
        if (this.shieldCooldown > 0 && !this.hasHealingShield()) {
            --this.shieldCooldown;
        }
    }

    public boolean func_70104_M() {
        return this.isActive();
    }

    public boolean func_213392_I() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ACTIVE, (Object)false);
        this.func_184212_Q().func_187214_a(USE_BEAM, (Object)false);
        this.func_184212_Q().func_187214_a(USE_REGULAR_ATTACK, (Object)false);
        this.func_184212_Q().func_187214_a(CHARGING_BEAM, (Object)false);
        this.func_184212_Q().func_187214_a(USING_BEAM, (Object)false);
        this.func_184212_Q().func_187214_a(LASER_X, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(LASER_Y, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(LASER_Z, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(MELEE_TICK, (Object)0);
        this.func_184212_Q().func_187214_a(LASER_TICK, (Object)0);
        this.func_184212_Q().func_187214_a(LASER_TARGET_ENTITY, (Object)-1);
        this.func_184212_Q().func_187214_a(IS_SUMMONED, (Object)false);
        this.func_184212_Q().func_187214_a(SHIELD_LEVEL, (Object)0);
    }

    public boolean isUsingBeamAttack() {
        return (Boolean)this.func_184212_Q().func_187225_a(USE_BEAM);
    }

    public void useBeam(boolean isUsingBeam) {
        this.func_184212_Q().func_187227_b(USE_BEAM, (Object)isUsingBeam);
    }

    public boolean hasHealingShield() {
        return this.getShieldLevel() > 0;
    }

    public int getShieldLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(SHIELD_LEVEL);
    }

    public void setHealingShield(int shield) {
        this.func_184212_Q().func_187227_b(SHIELD_LEVEL, (Object)shield);
    }

    public boolean isUsingRegularAttack() {
        return (Boolean)this.func_184212_Q().func_187225_a(USE_REGULAR_ATTACK);
    }

    public void useRegularAttack(boolean isUsingRegularAttack) {
        this.func_184212_Q().func_187227_b(USE_REGULAR_ATTACK, (Object)isUsingRegularAttack);
    }

    public boolean isActive() {
        return (Boolean)this.func_184212_Q().func_187225_a(ACTIVE);
    }

    public void setActive(boolean isActive) {
        this.func_184212_Q().func_187227_b(ACTIVE, (Object)isActive);
    }

    public float getHealthRatio() {
        return this.func_110143_aJ() / this.func_110138_aP();
    }

    public float getLaserX() {
        return ((Float)this.field_70180_af.func_187225_a(LASER_X)).floatValue();
    }

    public void setLaserX(float laser) {
        this.field_70180_af.func_187227_b(LASER_X, (Object)Float.valueOf(laser));
    }

    public float getLaserY() {
        return ((Float)this.field_70180_af.func_187225_a(LASER_Y)).floatValue();
    }

    public void setLaserY(float laser) {
        this.field_70180_af.func_187227_b(LASER_Y, (Object)Float.valueOf(laser));
    }

    public float getLaserZ() {
        return ((Float)this.field_70180_af.func_187225_a(LASER_Z)).floatValue();
    }

    public void setLaserZ(float laser) {
        this.field_70180_af.func_187227_b(LASER_Z, (Object)Float.valueOf(laser));
    }

    public boolean isUsingBeam() {
        return (Boolean)this.field_70180_af.func_187225_a(USING_BEAM);
    }

    private void setUsingBeam(boolean isUsingBeam) {
        this.field_70180_af.func_187227_b(USING_BEAM, (Object)isUsingBeam);
    }

    public boolean isChargingBeam() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGING_BEAM);
    }

    private void setChargingBeam(boolean isChargingBeam) {
        this.field_70180_af.func_187227_b(CHARGING_BEAM, (Object)isChargingBeam);
    }

    public float getMeleeProgress(boolean left, float partialTick) {
        if (left) {
            return this.prevLeftPunchProgress + (this.leftPunchProgress - this.prevLeftPunchProgress) * partialTick;
        }
        return this.prevRightPunchProgress + (this.rightPunchProgress - this.prevRightPunchProgress) * partialTick;
    }

    public boolean hasLaserTarget() {
        return (Integer)this.field_70180_af.func_187225_a(LASER_TARGET_ENTITY) != -1;
    }

    private void setLaserEntity(@Nullable Entity entity) {
        this.field_70180_af.func_187227_b(LASER_TARGET_ENTITY, (Object)(entity == null ? -1 : entity.func_145782_y()));
    }

    @Nullable
    public Entity getLaserTarget() {
        if (!this.hasLaserTarget()) {
            return this.func_70638_az();
        }
        return this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(LASER_TARGET_ENTITY)).intValue());
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    public int getLaserTick() {
        return (Integer)this.func_184212_Q().func_187225_a(LASER_TICK);
    }

    public void setLaserTick(int tick) {
        this.func_184212_Q().func_187227_b(LASER_TICK, (Object)tick);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("active", this.isActive());
        compound.func_74757_a("summoned", this.isSummoned());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setActive(compound.func_74767_n("active"));
        this.setSummoned(compound.func_74767_n("summoned"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        this.func_184212_Q().func_187227_b(MELEE_TICK, (Object)10);
        return true;
    }

    protected float func_203009_ad() {
        return this.field_82151_R + 0.3f;
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.func_226281_cx_() - first.func_226281_cx_(), second.func_226277_ct_() - first.func_226277_ct_()) * 57.29577951308232 + 90.0;
    }

    public Vector3d getLaserTargetPos(float partialTicks) {
        float x = this.prevLaserX + (this.getLaserX() - this.prevLaserX) * partialTicks;
        float y = this.prevLaserY + (this.getLaserY() - this.prevLaserY) * partialTicks;
        float z = this.prevLaserZ + (this.getLaserZ() - this.prevLaserZ) * partialTicks;
        return new Vector3d((double)x, (double)y, (double)z);
    }

    public float getLaserTargetProgress(float partialTicks) {
        return this.prevLaserProgress + (this.laserProgress - this.prevLaserProgress) * partialTicks;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.hasHealingShield()) {
            float pitchMod = MathHelper.func_76125_a((int)(4 - this.getShieldLevel()), (int)1, (int)3);
            this.func_184185_a(SoundEvents.field_187658_bx, this.func_70599_aP(), this.func_70647_i() * pitchMod);
            this.setHealingShield(Math.max(0, this.getShieldLevel() - 1));
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public float getShieldThickness() {
        switch (this.getShieldLevel()) {
            case 1: {
                return 0.15f;
            }
            case 2: {
                return 0.5f;
            }
            case 3: {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public static class BeamAttackAI
    extends Goal {
        private static final int TIME = 40;
        private TimeGuardianEntity timeGuardian;
        private float laserYaw;
        private float laserPitch;
        private int laserSoundTick = 0;

        public BeamAttackAI(TimeGuardianEntity timeGuardian) {
            this.timeGuardian = timeGuardian;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public static boolean canSeeEntity(Vector3d observer, Entity subject) {
            if (observer == null || subject == null) {
                return false;
            }
            AxisAlignedBB axisalignedbb = subject.func_174813_aQ().func_186662_g((double)0.3f);
            Vector3d subjectLocation = new Vector3d(subject.func_226277_ct_(), subject.func_226278_cu_() + (double)subject.func_70047_e(), subject.func_226281_cx_());
            BlockRayTraceResult traceToBlocks = subject.field_70170_p.func_217299_a(new RayTraceContext(observer, subjectLocation, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, subject));
            if (traceToBlocks.func_216346_c() != RayTraceResult.Type.MISS) {
                subjectLocation = traceToBlocks.func_216347_e();
            }
            Optional traceToEntity = axisalignedbb.func_216365_b(observer, subjectLocation);
            return traceToEntity.isPresent();
        }

        public boolean func_75250_a() {
            return this.timeGuardian.func_110143_aJ() <= this.timeGuardian.func_110138_aP() / 2.0f && !this.timeGuardian.isUsingRegularAttack() && this.timeGuardian.getLaserTick() >= 0;
        }

        public boolean func_75253_b() {
            if (this.timeGuardian.field_70173_aa > 0 && this.timeGuardian.field_70173_aa % 20 == 0 && !BeamAttackAI.canSeeEntity(this.timeGuardian.func_213303_ch(), (Entity)this.timeGuardian.func_70638_az())) {
                this.timeGuardian.setChargingBeam(false);
                this.timeGuardian.setUsingBeam(false);
                this.timeGuardian.setLaserTick(-120);
                return false;
            }
            if (this.timeGuardian.getLaserTick() <= 0 || !super.func_75253_b()) {
                this.timeGuardian.setChargingBeam(false);
                this.timeGuardian.setUsingBeam(false);
                return false;
            }
            return super.func_75253_b();
        }

        public void func_75249_e() {
            this.laserSoundTick = 0;
            this.timeGuardian.setChargingBeam(true);
            this.timeGuardian.setLaserEntity((Entity)this.timeGuardian.func_70638_az());
            this.timeGuardian.func_70661_as().func_75499_g();
            this.laserYaw = MathHelper.func_76142_g((float)this.timeGuardian.field_70177_z);
            this.laserPitch = MathHelper.func_76142_g((float)(this.timeGuardian.field_70125_A + 90.0f));
            this.timeGuardian.field_70160_al = true;
            this.timeGuardian.setLaserTick(40);
            this.timeGuardian.setLaserX((float)this.timeGuardian.func_226277_ct_());
            this.timeGuardian.setLaserY((float)this.timeGuardian.func_226278_cu_());
            this.timeGuardian.setLaserZ((float)this.timeGuardian.func_226281_cx_());
            this.timeGuardian.useBeam(true);
        }

        private float updateRotation(float currentAngle, float targetAngle, float maxChange) {
            float change = MathHelper.func_76142_g((float)(targetAngle - currentAngle));
            return MathHelper.func_76142_g((float)(currentAngle + this.timeGuardian.field_70146_Z.nextFloat() * 1.5f - 0.75f + change / maxChange));
        }

        private void updateLaser() {
            if (this.timeGuardian.field_70170_p != null && this.timeGuardian.func_70638_az() != null) {
                double range;
                double targetX = this.timeGuardian.func_70638_az().func_226277_ct_();
                double targetY = this.timeGuardian.func_70638_az().func_226278_cu_() + (double)(this.timeGuardian.func_70638_az().func_70047_e() * 0.5f);
                double targetZ = this.timeGuardian.func_70638_az().func_226281_cx_();
                double rot = (double)this.timeGuardian.field_70761_aq * 0.01745329238474369 + 1.5707963267948966;
                double lureX = Math.cos(rot) * (double)(this.timeGuardian.func_213311_cf() + 1.0f) + this.timeGuardian.func_226277_ct_();
                double lureY = this.timeGuardian.func_226283_e_(0.65f);
                double lureZ = Math.sin(rot) * (double)(this.timeGuardian.func_213311_cf() + 1.0f) + this.timeGuardian.func_226281_cx_();
                Vector3d lureVec = new Vector3d(lureX, lureY, lureZ);
                double d0 = targetX - lureX;
                double d1 = targetY - lureY;
                double d2 = targetZ - lureZ;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float targetYaw = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                float targetPitch = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                float laserProg = 1.0f - (float)MathHelper.func_76125_a((int)this.timeGuardian.getLaserTick(), (int)0, (int)40) / 40.0f;
                float baseYaw = MathHelper.func_76142_g((float)this.timeGuardian.field_70177_z);
                float basePitch = MathHelper.func_76142_g((float)(this.timeGuardian.field_70125_A + 120.0f));
                this.laserYaw = baseYaw + MathHelper.func_76142_g((float)(targetYaw - baseYaw)) * laserProg;
                this.laserPitch = basePitch + (targetPitch - basePitch) * laserProg;
                Vector3d laserAngle = Vector3d.func_189986_a((float)this.laserPitch, (float)this.laserYaw);
                Vector3d hitVec = lureVec.func_178787_e(laserAngle.func_186678_a(range = 30.0));
                BlockRayTraceResult trace = this.timeGuardian.field_70170_p.func_217299_a(new RayTraceContext(lureVec, hitVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)this.timeGuardian));
                if (trace.func_216346_c() != RayTraceResult.Type.MISS) {
                    hitVec = trace.func_216347_e();
                }
                this.timeGuardian.setLaserX((float)hitVec.field_72450_a);
                this.timeGuardian.setLaserY((float)hitVec.field_72448_b);
                this.timeGuardian.setLaserZ((float)hitVec.field_72449_c);
                float f = 1.0f;
                if (this.timeGuardian.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    f += 2.0f;
                }
                LivingEntity base = null;
                for (LivingEntity entity : this.timeGuardian.field_70170_p.func_217357_a(LivingEntity.class, this.timeGuardian.func_174813_aQ().func_186662_g(30.0))) {
                    AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g((double)0.3f);
                    Optional traceToEntity = axisalignedbb.func_216365_b(lureVec, hitVec);
                    if (!traceToEntity.isPresent() || !BeamAttackAI.canSeeEntity(lureVec, (Entity)entity) || entity == this.timeGuardian || base != null && !(this.timeGuardian.func_70032_d((Entity)entity) < this.timeGuardian.func_70032_d((Entity)base))) continue;
                    base = entity;
                }
                if (base != null) {
                    base.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.timeGuardian), (float)this.timeGuardian.func_110148_a(Attributes.field_233823_f_).func_111126_e() / 2.0f);
                    if (!base.func_184585_cz()) {
                        base.func_195064_c(new EffectInstance(Effects.field_76421_d, 140 * (int)f, 2));
                        base.func_195064_c(new EffectInstance(Effects.field_76419_f, 140 * (int)f, 2));
                    }
                }
            }
        }

        public void func_75246_d() {
            this.timeGuardian.func_70661_as().func_75499_g();
            if (this.timeGuardian.getLaserTick() > 0) {
                this.timeGuardian.setLaserTick(this.timeGuardian.getLaserTick() - 1);
            }
            if (this.timeGuardian.getLaserTick() == 0) {
                this.timeGuardian.setChargingBeam(false);
                this.timeGuardian.setUsingBeam(true);
                this.timeGuardian.func_184185_a(SoundInit.HENOS_LASER, 1.0f, this.timeGuardian.func_70647_i());
            } else if (this.timeGuardian.getLaserTick() > 0) {
                this.updateLaser();
                if (this.laserSoundTick % 17 == 0) {
                    this.timeGuardian.func_184185_a(SoundInit.HENOS_LASER_LOOP, 1.0f, this.timeGuardian.func_70647_i());
                }
                ++this.laserSoundTick;
            }
            super.func_75246_d();
        }

        public void func_75251_c() {
            this.timeGuardian.setLaserEntity(null);
            this.timeGuardian.setLaserTick(-50);
            this.timeGuardian.setLaserX((float)this.timeGuardian.func_226277_ct_());
            this.timeGuardian.setLaserY((float)this.timeGuardian.func_226278_cu_());
            this.timeGuardian.setLaserZ((float)this.timeGuardian.func_226281_cx_());
            this.timeGuardian.useBeam(false);
        }
    }

    public class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        TimeGuardianEntity timeGuardian;

        public MeleeAttackGoal(TimeGuardianEntity timeGuardian, double speedIn, boolean useLongMemory) {
            super((CreatureEntity)timeGuardian, speedIn, useLongMemory);
            this.timeGuardian = timeGuardian;
        }

        public boolean func_75250_a() {
            if (this.timeGuardian.func_110143_aJ() >= this.timeGuardian.func_110138_aP() / 2.0f || this.timeGuardian.getLaserTick() < 0) {
                return super.func_75250_a();
            }
            if (this.timeGuardian.func_110143_aJ() <= this.timeGuardian.func_110138_aP() / 2.0f && !this.timeGuardian.isUsingBeamAttack()) {
                if (this.timeGuardian.func_70638_az() != null) {
                    if (this.timeGuardian.func_70068_e((Entity)this.timeGuardian.func_70638_az()) <= 14.0) {
                        return super.func_75250_a();
                    }
                    return false;
                }
                return false;
            }
            return false;
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return this.field_75441_b.func_213311_cf() * 3.0f * this.field_75441_b.func_213311_cf() * 3.0f + attackTarget.func_213311_cf();
        }

        public boolean func_75253_b() {
            if (this.timeGuardian.getLaserTick() < 0) {
                return super.func_75253_b();
            }
            if (this.timeGuardian.func_110143_aJ() <= this.timeGuardian.func_110138_aP() / 2.0f && !this.timeGuardian.isUsingBeamAttack()) {
                if (this.timeGuardian.func_70638_az() != null) {
                    if (this.timeGuardian.func_70068_e((Entity)this.timeGuardian.func_70638_az()) <= 10.0) {
                        return super.func_75253_b();
                    }
                    return false;
                }
                return false;
            }
            if (this.timeGuardian.func_110143_aJ() > this.timeGuardian.func_110138_aP() / 2.0f || this.timeGuardian.getLaserTick() < 0) {
                return super.func_75253_b();
            }
            return false;
        }

        public void func_75249_e() {
            super.func_75251_c();
            this.timeGuardian.useRegularAttack(true);
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.timeGuardian.useRegularAttack(false);
        }
    }
}

