/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities.fossil;

import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import superlord.prehistoricfauna.common.entities.PrehistoricEntity;
import superlord.prehistoricfauna.init.PFItems;

public class PostosuchusSkeletonEntity
extends PrehistoricEntity {
    private static final DataParameter<Boolean> ATTACK_RIGHT = EntityDataManager.func_187226_a(PostosuchusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ATTACK_LEFT = EntityDataManager.func_187226_a(PostosuchusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WALKING = EntityDataManager.func_187226_a(PostosuchusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CURIOUS = EntityDataManager.func_187226_a(PostosuchusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(PostosuchusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PUSHING = EntityDataManager.func_187226_a(PostosuchusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LOOKING = EntityDataManager.func_187226_a(PostosuchusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public boolean isAttackRight() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACK_RIGHT);
    }

    private void setAttackRight(boolean isAttackRight) {
        this.field_70180_af.func_187227_b(ATTACK_RIGHT, (Object)isAttackRight);
    }

    public boolean isAttackLeft() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACK_LEFT);
    }

    private void setAttackLeft(boolean isAttackLeft) {
        this.field_70180_af.func_187227_b(ATTACK_LEFT, (Object)isAttackLeft);
    }

    public boolean isWalking() {
        return (Boolean)this.field_70180_af.func_187225_a(WALKING);
    }

    private void setWalking(boolean isWalking) {
        this.field_70180_af.func_187227_b(WALKING, (Object)isWalking);
    }

    public boolean isCurious() {
        return (Boolean)this.field_70180_af.func_187225_a(CURIOUS);
    }

    private void setCurious(boolean isCurious) {
        this.field_70180_af.func_187227_b(CURIOUS, (Object)isCurious);
    }

    public boolean func_70608_bn() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    private void setSleeping(boolean isSleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)isSleeping);
    }

    public boolean isPushable() {
        return (Boolean)this.field_70180_af.func_187225_a(PUSHING);
    }

    private void setPushable(boolean isPushable) {
        this.field_70180_af.func_187227_b(PUSHING, (Object)isPushable);
    }

    public boolean isLooking() {
        return (Boolean)this.field_70180_af.func_187225_a(LOOKING);
    }

    private void setLooking(boolean isLooking) {
        this.field_70180_af.func_187227_b(LOOKING, (Object)isLooking);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_RIGHT, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_LEFT, (Object)false);
        this.field_70180_af.func_187214_a(WALKING, (Object)false);
        this.field_70180_af.func_187214_a(CURIOUS, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(PUSHING, (Object)false);
        this.field_70180_af.func_187214_a(LOOKING, (Object)false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsActionRight", this.isAttackRight());
        compound.func_74757_a("IsActionLeft", this.isAttackLeft());
        compound.func_74757_a("IsWalking", this.isWalking());
        compound.func_74757_a("IsCurious", this.isCurious());
        compound.func_74757_a("IsSleeping", this.func_70608_bn());
        compound.func_74757_a("IsPushable", this.isPushable());
        compound.func_74757_a("IsLooking", this.isLooking());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setAttackRight(compound.func_74767_n("IsActionRight"));
        this.setAttackLeft(compound.func_74767_n("IsActionLeft"));
        this.setWalking(compound.func_74767_n("IsWalking"));
        this.setCurious(compound.func_74767_n("IsCurious"));
        this.setSleeping(compound.func_74767_n("IsSleeping"));
        this.setPushable(compound.func_74767_n("IsPushable"));
        this.setLooking(compound.func_74767_n("IsLooking"));
    }

    public PostosuchusSkeletonEntity(EntityType<? extends PostosuchusSkeletonEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new LookAtPlayerGoal(this, PlayerEntity.class, 8.0f));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 1.0);
    }

    @Override
    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70104_M() {
        return this.isPushable();
    }

    protected void func_82167_n(Entity entityIn) {
    }

    private void playBrokenSound() {
        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187864_fh, this.func_184176_by(), 1.0f, 1.0f);
    }

    private void playParticles() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_189880_di.func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6666666666666666), this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == PFItems.GEOLOGY_HAMMER.get()) {
            if (!(this.func_70608_bn() || this.isCurious() || this.isWalking() || this.isAttackLeft() || this.isAttackRight() || player.func_225608_bj_())) {
                this.setAttackRight(true);
            } else if (this.isAttackRight() && !player.func_225608_bj_()) {
                this.setAttackRight(false);
                this.setAttackLeft(true);
            } else if (this.isAttackLeft() && !player.func_225608_bj_()) {
                this.setAttackLeft(false);
                this.setWalking(true);
            } else if (this.isWalking() && !player.func_225608_bj_()) {
                this.setWalking(false);
                this.setCurious(true);
            } else if (this.isCurious() && !player.func_225608_bj_()) {
                this.setCurious(false);
                this.setSleeping(true);
            } else if (this.func_70608_bn() && !player.func_225608_bj_()) {
                this.setSleeping(false);
            } else if (player.func_225608_bj_() && !this.isPushable() && !this.isLooking()) {
                this.setPushable(true);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.prehistoricfauna.skeleton.pushable"), true);
            } else if (player.func_225608_bj_() && this.isPushable()) {
                this.setPushable(false);
                this.setLooking(true);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.prehistoricfauna.skeleton.rotating"), true);
            } else if (player.func_225608_bj_() && this.isLooking()) {
                this.setLooking(false);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.prehistoricfauna.skeleton.neutral"), true);
            }
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof PlayerEntity) {
            if (source.func_94541_c()) {
                return super.func_70097_a(source, amount);
            }
            this.func_70106_y();
            this.playBrokenSound();
            this.playParticles();
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            if (!player.func_184812_l_()) {
                this.spawnFossil(source);
            }
        }
        return false;
    }

    private void spawnFossil(DamageSource p_213815_1_) {
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)new BlockPos(this.func_213303_ch()), (ItemStack)new ItemStack((IItemProvider)PFItems.POSTOSUCHUS_SKELETON.get()));
    }

    public boolean func_184603_cC() {
        return false;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)PFItems.POSTOSUCHUS_SKELETON.get());
    }

    static class LookAtPlayerGoal
    extends LookAtGoal {
        PostosuchusSkeletonEntity field_75332_b;

        public LookAtPlayerGoal(PostosuchusSkeletonEntity entityIn, Class<? extends LivingEntity> watchTargetClass, float maxDistance) {
            super((MobEntity)entityIn, watchTargetClass, maxDistance);
            this.field_75332_b = entityIn;
        }

        public boolean func_75250_a() {
            if (this.field_75332_b.isLooking()) {
                return super.func_75250_a();
            }
            return false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.field_75332_b.isLooking();
        }
    }
}

