/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities.fossil;

import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import superlord.prehistoricfauna.common.entities.PrehistoricEntity;
import superlord.prehistoricfauna.init.PFItems;

public class DilophosaurusSkeletonEntity
extends PrehistoricEntity {
    private static final DataParameter<Boolean> STRUT = EntityDataManager.func_187226_a(DilophosaurusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> GAZE = EntityDataManager.func_187226_a(DilophosaurusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ATTACK = EntityDataManager.func_187226_a(DilophosaurusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(DilophosaurusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PUSHING = EntityDataManager.func_187226_a(DilophosaurusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LOOKING = EntityDataManager.func_187226_a(DilophosaurusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public boolean isStrutting() {
        return (Boolean)this.field_70180_af.func_187225_a(STRUT);
    }

    private void setStrutting(boolean isStrutting) {
        this.field_70180_af.func_187227_b(STRUT, (Object)isStrutting);
    }

    public boolean isGazing() {
        return (Boolean)this.field_70180_af.func_187225_a(GAZE);
    }

    private void setGazing(boolean isGazing) {
        this.field_70180_af.func_187227_b(GAZE, (Object)isGazing);
    }

    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACK);
    }

    private void setAttacking(boolean isAttacking) {
        this.field_70180_af.func_187227_b(ATTACK, (Object)isAttacking);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    private void setSitting(boolean isSitting) {
        this.field_70180_af.func_187227_b(SITTING, (Object)isSitting);
    }

    public boolean isPushable() {
        return (Boolean)this.field_70180_af.func_187225_a(PUSHING);
    }

    private void setPushable(boolean isPushable) {
        this.field_70180_af.func_187227_b(PUSHING, (Object)isPushable);
    }

    public boolean isLooking() {
        return (Boolean)this.field_70180_af.func_187225_a(LOOKING);
    }

    private void setLooking(boolean isLooking) {
        this.field_70180_af.func_187227_b(LOOKING, (Object)isLooking);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STRUT, (Object)false);
        this.field_70180_af.func_187214_a(GAZE, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(PUSHING, (Object)false);
        this.field_70180_af.func_187214_a(LOOKING, (Object)false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsStrutting", this.isStrutting());
        compound.func_74757_a("IsGazing", this.isGazing());
        compound.func_74757_a("IsAttacking", this.isAttacking());
        compound.func_74757_a("IsSitting", this.isSitting());
        compound.func_74757_a("IsPushable", this.isPushable());
        compound.func_74757_a("IsLooking", this.isLooking());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setStrutting(compound.func_74767_n("IsStrutting"));
        this.setGazing(compound.func_74767_n("IsGazing"));
        this.setAttacking(compound.func_74767_n("IsAttacking"));
        this.setSitting(compound.func_74767_n("IsSitting"));
        this.setPushable(compound.func_74767_n("IsPushable"));
        this.setLooking(compound.func_74767_n("IsLooking"));
    }

    public DilophosaurusSkeletonEntity(EntityType<? extends DilophosaurusSkeletonEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new LookAtPlayerGoal(this, PlayerEntity.class, 8.0f));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 1.0);
    }

    @Override
    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70104_M() {
        return this.isPushable();
    }

    protected void func_82167_n(Entity entityIn) {
    }

    private void playBrokenSound() {
        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187864_fh, this.func_184176_by(), 1.0f, 1.0f);
    }

    private void playParticles() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_189880_di.func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6666666666666666), this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == PFItems.GEOLOGY_HAMMER.get()) {
            if (!(this.isStrutting() || this.isGazing() || this.isAttacking() || this.isSitting() || player.func_225608_bj_())) {
                this.setStrutting(true);
            } else if (this.isStrutting() && !player.func_225608_bj_()) {
                this.setStrutting(false);
                this.setGazing(true);
            } else if (this.isGazing() && !player.func_225608_bj_()) {
                this.setGazing(false);
                this.setAttacking(true);
            } else if (this.isAttacking() && !player.func_225608_bj_()) {
                this.setAttacking(false);
                this.setSitting(true);
            } else if (this.isSitting() && !player.func_225608_bj_()) {
                this.setSitting(false);
            } else if (player.func_225608_bj_() && !this.isPushable() && !this.isLooking()) {
                this.setPushable(true);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.prehistoricfauna.skeleton.pushable"), true);
            } else if (player.func_225608_bj_() && this.isPushable()) {
                this.setPushable(false);
                this.setLooking(true);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.prehistoricfauna.skeleton.rotating"), true);
            } else if (player.func_225608_bj_() && this.isLooking()) {
                this.setLooking(false);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.prehistoricfauna.skeleton.neutral"), true);
            }
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof PlayerEntity) {
            if (source.func_94541_c()) {
                return super.func_70097_a(source, amount);
            }
            this.func_70106_y();
            this.playBrokenSound();
            this.playParticles();
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            if (!player.func_184812_l_()) {
                this.spawnFossil(source);
            }
        }
        return false;
    }

    private void spawnFossil(DamageSource p_213815_1_) {
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)new BlockPos(this.func_213303_ch()), (ItemStack)new ItemStack((IItemProvider)PFItems.DILOPHOSAURUS_SKELETON.get()));
    }

    public boolean func_184603_cC() {
        return false;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)PFItems.DILOPHOSAURUS_SKELETON.get());
    }

    static class LookAtPlayerGoal
    extends LookAtGoal {
        DilophosaurusSkeletonEntity field_75332_b;

        public LookAtPlayerGoal(DilophosaurusSkeletonEntity entityIn, Class<? extends LivingEntity> watchTargetClass, float maxDistance) {
            super((MobEntity)entityIn, watchTargetClass, maxDistance);
            this.field_75332_b = entityIn;
        }

        public boolean func_75250_a() {
            if (this.field_75332_b.isLooking()) {
                return super.func_75250_a();
            }
            return false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.field_75332_b.isLooking();
        }
    }
}

