/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities.cretaceous.hellcreek;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.SoundInit;

public class TriceratopsEntity
extends AbstractChestedHorseEntity {
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(TriceratopsEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(TriceratopsEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_JUVENILE = EntityDataManager.func_187226_a(TriceratopsEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ALBINO = EntityDataManager.func_187226_a(TriceratopsEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MELANISTIC = EntityDataManager.func_187226_a(TriceratopsEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(TriceratopsEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EATING = EntityDataManager.func_187226_a(TriceratopsEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> NATURAL_LOVE = EntityDataManager.func_187226_a(TriceratopsEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ATTACK_TICK = EntityDataManager.func_187226_a(TriceratopsEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int maxHunger = 200;
    private int currentHunger = 200;
    int hungerTick = 0;
    private int lastInLove = 0;
    private int warningSoundTicks;
    private int isDigging;
    public float ridingXZ;
    public float ridingY = 1.0f;
    private boolean allowStandSliding;
    public int attackTick;
    int loveTick = 0;
    private float meleeProgress = 0.0f;
    private float prevMeleeProgress = 0.0f;

    public TriceratopsEntity(EntityType<? extends TriceratopsEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        if (this.func_70631_g_()) {
            return 0.75f;
        }
        return 2.2f;
    }

    public AgeableEntity createChild(AgeableEntity ageable) {
        TriceratopsEntity entity = new TriceratopsEntity(PFEntities.TRICERATOPS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos(entity.func_213303_ch())), SpawnReason.BREEDING, null, null);
        return entity;
    }

    public void func_70873_a(int age) {
        super.func_70873_a(age);
        if (this.func_70874_b() >= -12000 && this.func_70874_b() < 0) {
            this.setJuvenile(true);
        } else if (this.func_70874_b() >= 0) {
            this.setJuvenile(false);
        }
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean func_70608_bn() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    private void setSleeping(boolean isSleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)isSleeping);
    }

    public boolean isJuvenile() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_JUVENILE);
    }

    private void setJuvenile(boolean isJuvenile) {
        this.field_70180_af.func_187227_b(IS_JUVENILE, (Object)isJuvenile);
    }

    public boolean isAlbino() {
        return (Boolean)this.field_70180_af.func_187225_a(ALBINO);
    }

    private void setAlbino(boolean isAlbino) {
        this.field_70180_af.func_187227_b(ALBINO, (Object)isAlbino);
    }

    public boolean isMelanistic() {
        return (Boolean)this.field_70180_af.func_187225_a(MELANISTIC);
    }

    private void setMelanistic(boolean isMelanistic) {
        this.field_70180_af.func_187227_b(MELANISTIC, (Object)isMelanistic);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == PFBlocks.OSMUNDA.func_199767_j();
    }

    public boolean isInLoveNaturally() {
        return (Boolean)this.field_70180_af.func_187225_a(NATURAL_LOVE);
    }

    private void setInLoveNaturally(boolean isInLoveNaturally) {
        this.field_70180_af.func_187227_b(NATURAL_LOVE, (Object)isInLoveNaturally);
    }

    public int getCurrentHunger() {
        return this.currentHunger;
    }

    private void setHunger(int currentHunger) {
        this.currentHunger = currentHunger;
    }

    public int getHalfHunger() {
        return this.maxHunger / 2;
    }

    public int getThreeQuartersHunger() {
        return this.maxHunger / 4 * 3;
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(EATING);
    }

    private void setEating(boolean isEating) {
        this.field_70180_af.func_187227_b(EATING, (Object)isEating);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new TriceratopsLookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new TriceratopsRandomLookGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new CathemeralSleepGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new HerbivoreEatGoal(1.2f, 12, 2));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233820_c_, 0.5);
    }

    protected SoundEvent func_184639_G() {
        return this.func_70608_bn() ? SoundInit.TRICERATOPS_SNORES : SoundInit.TRICERATOPS_IDLE;
    }

    protected void func_190680_a(SoundType p_190680_1_) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.TRICERATOPS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.TRICERATOPS_DEATH;
    }

    protected SoundEvent func_184785_dv() {
        return SoundInit.TRICERATOPS_WARN;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        int i;
        if (distance > 1.0f) {
            this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
        }
        if ((i = this.func_225508_e_(distance, damageMultiplier)) <= 0) {
            return false;
        }
        this.func_70097_a(DamageSource.field_76379_h, i);
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184182_bu()) {
                entity.func_70097_a(DamageSource.field_76379_h, (float)i);
            }
        }
        this.func_226295_cZ_();
        return true;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundInit.TRICERATOPS_WARN, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(IS_JUVENILE, (Object)false);
        this.field_70180_af.func_187214_a(ALBINO, (Object)false);
        this.field_70180_af.func_187214_a(MELANISTIC, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(EATING, (Object)false);
        this.field_70180_af.func_187214_a(NATURAL_LOVE, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_TICK, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HasEgg", this.hasEgg());
        compound.func_74757_a("IsAlbino", this.isAlbino());
        compound.func_74757_a("IsMelanistic", this.isMelanistic());
        compound.func_74757_a("IsSleeping", this.func_70608_bn());
        compound.func_74768_a("AttackTick", this.attackTick);
        compound.func_74768_a("MaxHunger", this.currentHunger);
        compound.func_74757_a("IsEating", this.isEating());
        compound.func_74757_a("InNaturalLove", this.isInLoveNaturally());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
        this.setAlbino(compound.func_74767_n("IsAlbino"));
        this.setMelanistic(compound.func_74767_n("IsMelanistic"));
        this.setSleeping(compound.func_74767_n("IsSleeping"));
        this.attackTick = compound.func_74762_e("AttackTick");
        this.setEating(compound.func_74767_n("IsEating"));
        this.setHunger(compound.func_74762_e("MaxHunger"));
        this.setInLoveNaturally(compound.func_74767_n("InNaturalLove"));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Random rand = new Random();
        int birthNumber = rand.nextInt(799);
        if (birthNumber >= 0 && birthNumber < 4) {
            this.setAlbino(true);
        } else if (birthNumber >= 4 && birthNumber < 7) {
            this.setMelanistic(true);
        }
        this.setHunger(this.maxHunger);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected boolean func_110200_cJ() {
        return !this.func_184207_aI() && !this.func_184218_aH() && !this.func_70631_g_() && this.func_70880_s();
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return this.func_110200_cJ() && ((TriceratopsEntity)otherAnimal).func_110200_cJ();
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        World world = p_230254_1_.field_70170_p;
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (this.func_70877_b(itemstack)) {
            int i = this.func_70874_b();
            if (!this.field_70170_p.field_72995_K && i == 0 && this.func_204701_dC()) {
                this.func_175505_a(p_230254_1_, itemstack);
                this.func_146082_f(p_230254_1_);
                return ActionResultType.SUCCESS;
            }
        }
        if (!this.func_70631_g_()) {
            if (item == PFItems.TRICERATOPS_SPAWN_EGG.get()) {
                TriceratopsEntity triceratopsentity = (TriceratopsEntity)PFEntities.TRICERATOPS_ENTITY.func_200721_a(world);
                triceratopsentity.func_70873_a(-24000);
                triceratopsentity.func_70012_b(this.func_226277_ct_() + 0.06, this.func_226278_cu_(), this.func_226281_cx_() + 0.3, 0.0f, 0.0f);
                world.func_217376_c((Entity)triceratopsentity);
                return super.func_230254_b_(p_230254_1_, p_230254_2_);
            }
            if (this.func_110248_bS() && p_230254_1_.func_226563_dT_()) {
                this.func_110199_f(p_230254_1_);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (this.func_184207_aI()) {
                return super.func_230254_b_(p_230254_1_, p_230254_2_);
            }
        }
        if (!itemstack.func_190926_b()) {
            if (!this.func_110248_bS()) {
                this.func_190687_dF();
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (!this.func_190695_dh() && itemstack.func_77973_b() == Blocks.field_150486_ae.func_199767_j()) {
                this.func_110207_m(true);
                this.func_190697_dk();
                if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.func_110226_cD();
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (!this.func_70631_g_() && !this.func_110257_ck() && itemstack.func_77973_b() == Items.field_151141_av) {
                this.func_110199_f(p_230254_1_);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
        }
        if (this.func_70631_g_()) {
            if (item == PFItems.TRICERATOPS_SPAWN_EGG.get()) {
                TriceratopsEntity triceratopsentity = (TriceratopsEntity)PFEntities.TRICERATOPS_ENTITY.func_200721_a(world);
                triceratopsentity.func_70873_a(-24000);
                triceratopsentity.func_70012_b(this.func_226277_ct_() + 0.06, this.func_226278_cu_(), this.func_226281_cx_() + 0.3, 0.0f, 0.0f);
                world.func_217376_c((Entity)triceratopsentity);
                return super.func_230254_b_(p_230254_1_, p_230254_2_);
            }
            return super.func_230254_b_(p_230254_1_, p_230254_2_);
        }
        this.func_110237_h(p_230254_1_);
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevMeleeProgress = this.meleeProgress;
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
        if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) > 0) {
            LivingEntity target = this.func_70638_az();
            if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) == 1 && target != null && this.func_70685_l((Entity)target) && this.func_70032_d((Entity)target) < this.getMeleeRange() + this.func_213311_cf() + target.func_213311_cf()) {
                this.onAttackAnimationFinish((Entity)target);
            }
            this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) - 1));
            if (this.meleeProgress < 1.0f) {
                this.meleeProgress = Math.min(this.meleeProgress + 0.2f, 1.0f);
            }
        } else if (this.meleeProgress > 0.0f) {
            this.meleeProgress = Math.max(this.meleeProgress - 0.2f, 0.0f);
        }
    }

    public float getMeleeRange() {
        return 2.5f;
    }

    public boolean func_70652_k(Entity entityIn) {
        this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)7);
        return true;
    }

    public boolean onAttackAnimationFinish(Entity target) {
        return target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
    }

    public float getMeleeProgress(float partialTick) {
        return this.prevMeleeProgress + (this.meleeProgress - this.prevMeleeProgress) * partialTick;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70631_g_() && !this.isJuvenile()) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
        } else if (this.isJuvenile()) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(40.0);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(80.0);
        }
        if (this.func_70089_S() && this.attackTick > 0) {
            --this.attackTick;
        }
        if (this.func_70608_bn()) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.2f);
        }
        if (!this.func_175446_cd()) {
            List list = this.field_70170_p.func_217357_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0));
            if (PrehistoricFaunaConfig.advancedHunger) {
                ++this.hungerTick;
                if (this.hungerTick == 600 && !this.func_70631_g_() || this.hungerTick == 300 && this.func_70631_g_() && !this.isJuvenile() || this.hungerTick == 450 && this.isJuvenile()) {
                    if (!this.func_70608_bn()) {
                        if (this.currentHunger != 0) {
                            this.setHunger(this.currentHunger - 1);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.field_70170_p.func_175659_aa() == Difficulty.HARD && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                    }
                    this.hungerTick = 0;
                }
                if (this.getCurrentHunger() >= this.getThreeQuartersHunger() && this.hungerTick % 150 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() != 0.0f && this.func_70638_az() == null && this.func_70643_av() == null) {
                    float currentHealth = this.func_110143_aJ();
                    this.func_70606_j(currentHealth + 1.0f);
                }
                if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                    if (!(this.lastInLove != 0 || this.currentHunger < this.getThreeQuartersHunger() || this.field_70173_aa % 900 != 0 || this.func_70631_g_() || this.func_70880_s() || this.func_70608_bn() || list.size() >= 10)) {
                        this.loveTick = 600;
                        this.setInLoveNaturally(true);
                        this.func_204700_e(600);
                        this.lastInLove = 28800;
                    }
                    if (this.loveTick != 0) {
                        --this.loveTick;
                    } else {
                        this.setInLoveNaturally(false);
                    }
                }
            } else if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                int naturalBreedingChance = this.field_70146_Z.nextInt(1000);
                if (!(this.lastInLove != 0 || naturalBreedingChance != 0 || this.func_70631_g_() || this.func_70880_s() || this.func_70608_bn() || list.size() >= 10)) {
                    this.loveTick = 600;
                    this.setInLoveNaturally(true);
                    this.func_204700_e(600);
                    this.lastInLove = 28800;
                }
                if (this.loveTick != 0) {
                    --this.loveTick;
                } else {
                    this.setInLoveNaturally(false);
                }
            }
            if (this.lastInLove != 0) {
                --this.lastInLove;
            }
        }
    }

    public PlayerEntity getRidingPlayer() {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (PlayerEntity)this.func_184179_bs();
        }
        return null;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70177_z = passenger.field_70177_z;
        }
        if (this.getRidingPlayer() != null && this.getRidingPlayer() instanceof PlayerEntity && this.func_70638_az() != this.getRidingPlayer()) {
            this.field_70177_z = this.field_70761_aq;
            this.field_70177_z = this.getRidingPlayer().field_70177_z;
            this.field_70759_as = this.getRidingPlayer().field_70177_z;
            float radius = this.ridingXZ * 0.7f * -3.0f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = this.ridingY * 4.0f;
            this.getRidingPlayer().func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY - 1.75, this.func_226281_cx_() + extraZ);
        }
    }

    public void func_213352_e(Vector3d positionIn) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.func_110257_ck()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                    this.field_110285_bP = 0;
                }
                if (this.field_70122_E && this.field_110277_bt == 0.0f && this.func_110209_cd() && !this.allowStandSliding) {
                    f = 0.0f;
                    f1 = 0.0f;
                }
                if (this.field_110277_bt > 0.0f && !this.func_110246_bZ() && this.field_70122_E) {
                    double d0 = 0.0;
                    double d1 = this.func_70644_a(Effects.field_76430_j) ? d0 + (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f) : d0;
                    Vector3d vec3d = this.func_213322_ci();
                    this.func_213293_j(vec3d.field_72450_a, d1, vec3d.field_72449_c);
                    this.func_110255_k(true);
                    this.field_70160_al = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-0.4f * f2 * this.field_110277_bt), 0.0, (double)(0.4f * f3 * this.field_110277_bt)));
                    }
                    this.field_110277_bt = 0.0f;
                }
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                    super.func_213352_e(new Vector3d((double)f, positionIn.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                if (this.field_70122_E) {
                    this.field_110277_bt = 0.0f;
                    this.func_110255_k(false);
                }
            } else {
                this.field_70747_aH = 0.02f;
                super.func_213352_e(positionIn);
            }
        }
    }

    protected void func_190681_a(AgeableEntity p_190681_1_, AbstractHorseEntity p_190681_2_) {
        double d0 = this.func_233638_c_(Attributes.field_233818_a_);
        p_190681_2_.func_110148_a(Attributes.field_233818_a_).func_111128_a(d0);
        double d2 = this.func_233638_c_(Attributes.field_233821_d_);
        p_190681_2_.func_110148_a(Attributes.field_233821_d_).func_111128_a(d2);
    }

    protected float func_110267_cL() {
        return this.func_110138_aP();
    }

    protected boolean func_190678_b(PlayerEntity player, ItemStack stack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        Item item = stack.func_77973_b();
        if (item == PFBlocks.HORSETAIL.func_199767_j()) {
            f = 2.0f;
            i = 20;
        } else if (item == PFBlocks.TALL_HORSETAIL.func_199767_j()) {
            f = 1.0f;
            i = 30;
        } else if (item == PFBlocks.OSMUNDA.func_199767_j()) {
            f = 20.0f;
            i = 180;
            if (this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        } else if (item == PFBlocks.TALL_OSMUNDA.func_199767_j()) {
            f = 3.0f;
            i = 60;
        } else if (item == PFBlocks.CLUBMOSS.func_199767_j()) {
            f = 4.0f;
            i = 60;
        } else if (item == PFBlocks.MARCHANTIA.func_199767_j()) {
            f = 3.0f;
            i = 80;
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
            this.func_70691_i(f);
            flag = true;
        }
        if (this.func_70631_g_() && i > 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(i);
            }
            flag = true;
        }
        return flag;
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)TriceratopsEntity.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    TriceratopsEntity.this.playWarningSound();
                }
            } else {
                this.func_234039_g_();
            }
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 10.0f + attackTarget.func_213311_cf();
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)TriceratopsEntity.this, 2.0);
        }

        public boolean func_75250_a() {
            return !TriceratopsEntity.this.func_70631_g_() && !TriceratopsEntity.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    public class TriceratopsLookAtGoal
    extends LookAtGoal {
        TriceratopsEntity triceratops;

        public TriceratopsLookAtGoal(TriceratopsEntity entityIn, Class<? extends LivingEntity> watchTargetClass, float maxDistance) {
            super((MobEntity)entityIn, watchTargetClass, maxDistance);
            this.triceratops = entityIn;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.triceratops.func_70608_bn();
        }
    }

    public class TriceratopsRandomLookGoal
    extends LookRandomlyGoal {
        TriceratopsEntity dinosaur;

        public TriceratopsRandomLookGoal(TriceratopsEntity entitylivingIn) {
            super((MobEntity)entitylivingIn);
            this.dinosaur = entitylivingIn;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.dinosaur.func_70608_bn();
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)TriceratopsEntity.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (TriceratopsEntity.this.func_70631_g_() && !TriceratopsEntity.this.isJuvenile()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof TriceratopsEntity && !mobIn.func_70631_g_()) {
                super.func_220793_a(mobIn, targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)TriceratopsEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (TriceratopsEntity.this.func_70631_g_() && !TriceratopsEntity.this.isJuvenile() || TriceratopsEntity.this.func_110248_bS()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (TriceratopsEntity triceratops : TriceratopsEntity.this.field_70170_p.func_217357_a(TriceratopsEntity.class, TriceratopsEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!triceratops.func_70631_g_() || triceratops.isJuvenile()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final TriceratopsEntity triceratops;

        LayEggGoal(TriceratopsEntity triceratops, double speedIn) {
            super((CreatureEntity)triceratops, speedIn, 16);
            this.triceratops = triceratops;
        }

        public boolean func_75250_a() {
            return this.triceratops.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.triceratops.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos(this.triceratops.func_213303_ch());
            if (!this.triceratops.func_70090_H() && this.func_179487_f()) {
                if (this.triceratops.isDigging < 1) {
                    this.triceratops.setDigging(true);
                } else if (this.triceratops.isDigging > 200) {
                    World world = this.triceratops.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)PFBlocks.TRICERATOPS_EGG.func_176223_P().func_206870_a((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.triceratops.field_70146_Z.nextInt(4) + 1)), 3);
                    this.triceratops.setHasEgg(false);
                    this.triceratops.setDigging(false);
                    this.triceratops.func_204700_e(600);
                }
                if (this.triceratops.isDigging()) {
                    this.triceratops.isDigging++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150391_bh || block == Blocks.field_150354_m || block == Blocks.field_196611_F || block == PFBlocks.MOSSY_DIRT || block == PFBlocks.MOSS_BLOCK || block == PFBlocks.LOAM || block == PFBlocks.PACKED_LOAM || block == PFBlocks.SILT || block == PFBlocks.PACKED_LOAM || block == BlockTags.field_206952_E;
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final TriceratopsEntity triceratops;
        private static final EntityPredicate field_220689_d = new EntityPredicate().func_221013_a(8.0).func_221008_a().func_221011_b().func_221014_c();
        private int spawnBabyDelay;
        private final double moveSpeed;

        MateGoal(TriceratopsEntity triceratops, double speed) {
            super((AnimalEntity)triceratops, speed);
            this.triceratops = triceratops;
            this.moveSpeed = speed;
        }

        @Nullable
        private TriceratopsEntity getNearbyMate() {
            List list = this.field_75394_a.func_217374_a(TriceratopsEntity.class, field_220689_d, (LivingEntity)this.field_75390_d, this.field_75390_d.func_174813_aQ().func_186662_g(24.0));
            double d0 = Double.MAX_VALUE;
            TriceratopsEntity animalentity = null;
            for (TriceratopsEntity animalentity1 : list) {
                if (!this.field_75390_d.func_70878_b((AnimalEntity)animalentity1) || !(this.field_75390_d.func_70068_e((Entity)animalentity1) < d0)) continue;
                animalentity = animalentity1;
                d0 = this.field_75390_d.func_70068_e((Entity)animalentity1);
            }
            return animalentity;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.triceratops.hasEgg() && !this.triceratops.isInLoveNaturally();
        }

        public void func_75251_c() {
            this.field_75391_e = null;
            this.spawnBabyDelay = 0;
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.field_75390_d.func_70671_ap().func_75651_a((Entity)this.field_75391_e, 10.0f, (float)this.field_75390_d.func_70646_bf());
            this.field_75390_d.func_70661_as().func_75497_a((Entity)this.field_75391_e, this.moveSpeed);
            ++this.spawnBabyDelay;
            if (this.spawnBabyDelay >= 60 && this.field_75390_d.func_70068_e((Entity)this.field_75391_e) < 20.0) {
                this.func_75388_i();
            }
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverPlayerEntity = this.field_75390_d.func_191993_do();
            if (serverPlayerEntity == null && this.field_75391_e.func_191993_do() != null) {
                serverPlayerEntity = this.field_75391_e.func_191993_do();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverPlayerEntity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.triceratops.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class NaturalMateGoal
    extends BreedGoal {
        private final TriceratopsEntity triceratops;

        NaturalMateGoal(TriceratopsEntity triceratops, double speed) {
            super((AnimalEntity)triceratops, speed);
            this.triceratops = triceratops;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.triceratops.hasEgg() && this.triceratops.getCurrentHunger() >= this.triceratops.getThreeQuartersHunger() && this.triceratops.field_70173_aa % 60 == 0 && (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && this.triceratops.isInLoveNaturally();
        }

        protected void func_75388_i() {
            if (PrehistoricFaunaConfig.naturalEggItemLaying) {
                this.triceratops.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.triceratops.field_70146_Z.nextFloat() - this.triceratops.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                int eggAmount = this.triceratops.field_70146_Z.nextInt(4);
                if (eggAmount == 0) {
                    this.triceratops.func_199703_a((IItemProvider)PFBlocks.TRICERATOPS_EGG.func_199767_j());
                }
                if (eggAmount == 1) {
                    this.triceratops.func_199703_a((IItemProvider)PFBlocks.TRICERATOPS_EGG.func_199767_j());
                    this.triceratops.func_199703_a((IItemProvider)PFBlocks.TRICERATOPS_EGG.func_199767_j());
                }
                if (eggAmount == 2) {
                    this.triceratops.func_199703_a((IItemProvider)PFBlocks.TRICERATOPS_EGG.func_199767_j());
                    this.triceratops.func_199703_a((IItemProvider)PFBlocks.TRICERATOPS_EGG.func_199767_j());
                    this.triceratops.func_199703_a((IItemProvider)PFBlocks.TRICERATOPS_EGG.func_199767_j());
                }
                if (eggAmount == 3) {
                    this.triceratops.func_199703_a((IItemProvider)PFBlocks.TRICERATOPS_EGG.func_199767_j());
                    this.triceratops.func_199703_a((IItemProvider)PFBlocks.TRICERATOPS_EGG.func_199767_j());
                    this.triceratops.func_199703_a((IItemProvider)PFBlocks.TRICERATOPS_EGG.func_199767_j());
                    this.triceratops.func_199703_a((IItemProvider)PFBlocks.TRICERATOPS_EGG.func_199767_j());
                }
            } else {
                this.triceratops.setHasEgg(true);
            }
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
        }
    }

    public class CathemeralSleepGoal
    extends Goal {
        public TriceratopsEntity entity;
        private int sleepTimer = 0;

        public CathemeralSleepGoal(TriceratopsEntity sleeper) {
            this.entity = sleeper;
        }

        public boolean func_75250_a() {
            PrehistoricFaunaConfig.sleeping = this.entity.func_70681_au().nextInt(1000) == 0 && this.entity.func_70643_av() == null && !this.entity.func_110248_bS() && this.entity.func_184187_bx() == null && !this.entity.func_70090_H() && !this.entity.func_180799_ab();
            return PrehistoricFaunaConfig.sleeping;
        }

        public boolean func_75253_b() {
            if (this.sleepTimer >= 6000 || this.entity.func_70643_av() != null || this.entity.func_110248_bS() || this.entity.func_184187_bx() != null || super.func_75253_b() || this.entity.func_70090_H() || this.entity.func_180799_ab()) {
                this.func_75251_c();
                return false;
            }
            return true;
        }

        public void func_75246_d() {
            super.func_75246_d();
            ++this.sleepTimer;
            if (this.sleepTimer >= 6000 || this.entity.func_70643_av() != null) {
                this.func_75251_c();
            }
        }

        public void func_75249_e() {
            this.sleepTimer = 0;
            this.entity.setSleeping(true);
            this.entity.field_70702_br = 0.0f;
            this.entity.field_191988_bg = 0.0f;
            this.entity.field_70701_bs = 0.0f;
            this.entity.func_70661_as().func_75499_g();
            this.entity.func_213293_j(0.0, 0.0, 0.0);
        }

        public void func_75251_c() {
            this.sleepTimer = 0;
            this.entity.setSleeping(false);
        }
    }

    public class HerbivoreEatGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public HerbivoreEatGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((CreatureEntity)TriceratopsEntity.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public double func_203110_f() {
            return 2.0;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 100 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            return blockstate.func_203425_a(PFBlocks.HORSETAIL) || blockstate.func_203425_a(PFBlocks.TALL_HORSETAIL) || blockstate.func_203425_a(PFBlocks.OSMUNDA) || blockstate.func_203425_a(PFBlocks.TALL_OSMUNDA) || blockstate.func_203425_a(PFBlocks.CLUBMOSS) || blockstate.func_203425_a(PFBlocks.MARCHANTIA) || blockstate.func_203425_a(PFBlocks.CONIOPTERIS) || blockstate.func_203425_a(PFBlocks.OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.TALL_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.DICROIDIUM) || blockstate.func_203425_a(PFBlocks.JOHNSTONIA) || blockstate.func_203425_a(PFBlocks.CLADOPHLEBIS) || blockstate.func_203425_a(PFBlocks.SCYTOPHYLLUM) || blockstate.func_203425_a(PFBlocks.MICHELILLOA) || blockstate.func_203425_a(PFBlocks.DEAD_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.COBBANIA) || blockstate.func_203425_a(PFBlocks.OTOZAMITES) || blockstate.func_203425_a(PFBlocks.TALL_OTOZAMITES) || blockstate.func_203425_a(PFBlocks.LAUROZAMITES) || blockstate.func_203425_a(Blocks.field_150349_c) || blockstate.func_203425_a(Blocks.field_150395_bd) || blockstate.func_235714_a_((ITag)BlockTags.field_226149_I_) || blockstate.func_203425_a(Blocks.field_196804_gh) || blockstate.func_203425_a(Blocks.field_196554_aH) || blockstate.func_203425_a(Blocks.field_196805_gi);
        }

        public void func_75246_d() {
            if (this.func_179487_f()) {
                if (this.field_220731_g >= 20) {
                    this.eatBerry();
                } else {
                    ++this.field_220731_g;
                    TriceratopsEntity.this.setEating(true);
                }
                if (this.field_220731_g % 5 == 1) {
                    TriceratopsEntity.this.field_70170_p.func_184133_a((PlayerEntity)null, this.field_179494_b, SoundEvents.field_187575_bT, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
            }
            super.func_75246_d();
        }

        protected void eatBerry() {
            int hunger;
            BlockState blockstate = TriceratopsEntity.this.field_70170_p.func_180495_p(this.field_179494_b);
            if (blockstate.func_203425_a(PFBlocks.DEAD_OSMUNDACAULIS)) {
                hunger = TriceratopsEntity.this.getCurrentHunger();
                if (hunger + 2 >= TriceratopsEntity.this.maxHunger) {
                    TriceratopsEntity.this.setHunger(TriceratopsEntity.this.maxHunger);
                    TriceratopsEntity.this.setEating(false);
                } else {
                    TriceratopsEntity.this.setHunger(hunger + 2);
                    TriceratopsEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(Blocks.field_150349_c) || blockstate.func_203425_a(Blocks.field_196804_gh) || blockstate.func_235714_a_((ITag)BlockTags.field_226149_I_)) {
                hunger = TriceratopsEntity.this.getCurrentHunger();
                if (hunger + 4 >= TriceratopsEntity.this.maxHunger) {
                    TriceratopsEntity.this.setHunger(TriceratopsEntity.this.maxHunger);
                    TriceratopsEntity.this.setEating(false);
                } else {
                    TriceratopsEntity.this.setHunger(hunger + 4);
                    TriceratopsEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(Blocks.field_150395_bd)) {
                hunger = TriceratopsEntity.this.getCurrentHunger();
                if (hunger + 6 >= TriceratopsEntity.this.maxHunger) {
                    TriceratopsEntity.this.setHunger(TriceratopsEntity.this.maxHunger);
                    TriceratopsEntity.this.setEating(false);
                } else {
                    TriceratopsEntity.this.setHunger(hunger + 6);
                    TriceratopsEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.MARCHANTIA) || blockstate.func_203425_a(PFBlocks.OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.OTOZAMITES)) {
                hunger = TriceratopsEntity.this.getCurrentHunger();
                if (hunger + 8 >= TriceratopsEntity.this.maxHunger) {
                    TriceratopsEntity.this.setHunger(TriceratopsEntity.this.maxHunger);
                    TriceratopsEntity.this.setEating(false);
                } else {
                    TriceratopsEntity.this.setHunger(hunger + 8);
                    TriceratopsEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.HORSETAIL) || blockstate.func_203425_a(PFBlocks.CLUBMOSS) || blockstate.func_203425_a(PFBlocks.MICHELILLOA) || blockstate.func_203425_a(PFBlocks.COBBANIA) || blockstate.func_203425_a(PFBlocks.LAUROZAMITES) || blockstate.func_203425_a(PFBlocks.CLATHOPTERIS)) {
                hunger = TriceratopsEntity.this.getCurrentHunger();
                if (hunger + 10 >= TriceratopsEntity.this.maxHunger) {
                    TriceratopsEntity.this.setHunger(TriceratopsEntity.this.maxHunger);
                    TriceratopsEntity.this.setEating(false);
                } else {
                    TriceratopsEntity.this.setHunger(hunger + 10);
                    TriceratopsEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.TALL_OTOZAMITES)) {
                hunger = TriceratopsEntity.this.getCurrentHunger();
                if (hunger + 12 >= TriceratopsEntity.this.maxHunger) {
                    TriceratopsEntity.this.setHunger(TriceratopsEntity.this.maxHunger);
                    TriceratopsEntity.this.setEating(false);
                } else {
                    TriceratopsEntity.this.setHunger(hunger + 12);
                    TriceratopsEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.OSMUNDA) || blockstate.func_203425_a(Blocks.field_196554_aH) || blockstate.func_203425_a(PFBlocks.CONIOPTERIS) || blockstate.func_203425_a(PFBlocks.CLADOPHLEBIS)) {
                hunger = TriceratopsEntity.this.getCurrentHunger();
                if (hunger + 15 >= TriceratopsEntity.this.maxHunger) {
                    TriceratopsEntity.this.setHunger(TriceratopsEntity.this.maxHunger);
                    TriceratopsEntity.this.setEating(false);
                } else {
                    TriceratopsEntity.this.setHunger(hunger + 15);
                    TriceratopsEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_HORSETAIL) || blockstate.func_203425_a(PFBlocks.SCYTOPHYLLUM)) {
                hunger = TriceratopsEntity.this.getCurrentHunger();
                if (hunger + 20 >= TriceratopsEntity.this.maxHunger) {
                    TriceratopsEntity.this.setHunger(TriceratopsEntity.this.maxHunger);
                    TriceratopsEntity.this.setEating(false);
                } else {
                    TriceratopsEntity.this.setHunger(hunger + 20);
                    TriceratopsEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_OSMUNDA) || blockstate.func_203425_a(Blocks.field_196805_gi) || blockstate.func_203425_a(PFBlocks.JOHNSTONIA)) {
                hunger = TriceratopsEntity.this.getCurrentHunger();
                if (hunger + 25 >= TriceratopsEntity.this.maxHunger) {
                    TriceratopsEntity.this.setHunger(TriceratopsEntity.this.maxHunger);
                    TriceratopsEntity.this.setEating(false);
                } else {
                    TriceratopsEntity.this.setHunger(hunger + 25);
                    TriceratopsEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.DICROIDIUM)) {
                hunger = TriceratopsEntity.this.getCurrentHunger();
                if (hunger + 30 >= TriceratopsEntity.this.maxHunger) {
                    TriceratopsEntity.this.setHunger(TriceratopsEntity.this.maxHunger);
                    TriceratopsEntity.this.setEating(false);
                } else {
                    TriceratopsEntity.this.setHunger(hunger + 30);
                    TriceratopsEntity.this.setEating(false);
                }
            }
        }

        public boolean func_75250_a() {
            return !TriceratopsEntity.this.func_70608_bn() && super.func_75250_a() && TriceratopsEntity.this.getCurrentHunger() < TriceratopsEntity.this.getHalfHunger();
        }

        public boolean func_75253_b() {
            if (TriceratopsEntity.this.getCurrentHunger() >= TriceratopsEntity.this.maxHunger || TriceratopsEntity.this.func_70608_bn()) {
                return false;
            }
            return super.func_75253_b();
        }

        public void func_75249_e() {
            this.field_220731_g = 0;
            super.func_75249_e();
        }
    }

    class TriceratopsFollowParentGoal
    extends Goal {
        private final TriceratopsEntity babyTriceratopsEntity;
        private TriceratopsEntity parentTriceratopsEntity;
        private final double moveSpeed;
        private int delayCounter;

        public TriceratopsFollowParentGoal(TriceratopsEntity triceratops, double speed) {
            this.babyTriceratopsEntity = triceratops;
            this.moveSpeed = speed;
        }

        public boolean func_75250_a() {
            if (this.babyTriceratopsEntity.func_70631_g_() && !this.babyTriceratopsEntity.isJuvenile()) {
                List list = this.babyTriceratopsEntity.field_70170_p.func_217357_a(((Object)((Object)this.babyTriceratopsEntity)).getClass(), this.babyTriceratopsEntity.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
                TriceratopsEntity triceratopsEntity = null;
                double d0 = Double.MAX_VALUE;
                for (TriceratopsEntity triceratopsEntity1 : list) {
                    double d1;
                    if (triceratopsEntity1.func_70631_g_() || (d1 = this.babyTriceratopsEntity.func_70068_e((Entity)triceratopsEntity1)) > d0) continue;
                    d0 = d1;
                    triceratopsEntity = triceratopsEntity1;
                }
                if (triceratopsEntity == null) {
                    return false;
                }
                if (d0 < 9.0) {
                    return false;
                }
                this.parentTriceratopsEntity = triceratopsEntity;
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            if (!this.babyTriceratopsEntity.isJuvenile() || !this.babyTriceratopsEntity.func_70631_g_()) {
                return false;
            }
            if (!this.parentTriceratopsEntity.func_70089_S()) {
                return false;
            }
            if (this.babyTriceratopsEntity.func_70631_g_() && !this.babyTriceratopsEntity.isJuvenile()) {
                double d0 = this.babyTriceratopsEntity.func_70068_e((Entity)this.parentTriceratopsEntity);
                return !(d0 < 9.0) && !(d0 > 256.0);
            }
            return false;
        }

        public void func_75249_e() {
            this.delayCounter = 0;
        }

        public void func_75251_c() {
            this.parentTriceratopsEntity = null;
        }

        public void func_75246_d() {
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                this.babyTriceratopsEntity.func_70661_as().func_75497_a((Entity)this.parentTriceratopsEntity, this.moveSpeed);
            }
        }
    }
}

