/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities.cretaceous.hellcreek;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entities.DinosaurEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.DakotaraptorEntity;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.TyrannosaurusEntity;
import superlord.prehistoricfauna.common.entities.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entities.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entities.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.common.entities.jurassic.kayenta.DilophosaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.AllosaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.CamarasaurusEntity;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.CeratosaurusEntity;
import superlord.prehistoricfauna.common.entities.triassic.chinle.PoposaurusEntity;
import superlord.prehistoricfauna.common.entities.triassic.chinle.PostosuchusEntity;
import superlord.prehistoricfauna.common.entities.triassic.ischigualasto.SaurosuchusEntity;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.SoundInit;

public class ThescelosaurusEntity
extends DinosaurEntity {
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(ThescelosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(ThescelosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ALBINO = EntityDataManager.func_187226_a(ThescelosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MELANISTIC = EntityDataManager.func_187226_a(ThescelosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{PFBlocks.MARCHANTIA.func_199767_j()});
    private static final DataParameter<Boolean> EATING = EntityDataManager.func_187226_a(ThescelosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> NATURAL_LOVE = EntityDataManager.func_187226_a(ThescelosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int maxHunger = 38;
    private int currentHunger = 38;
    int hungerTick = 0;
    private int lastInLove = 0;
    private int isDigging;
    private int chewingTick;
    int loveTick = 0;

    public ThescelosaurusEntity(EntityType<? extends ThescelosaurusEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        if (this.func_70631_g_()) {
            return 0.625f;
        }
        return 1.25f;
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean isAlbino() {
        return (Boolean)this.field_70180_af.func_187225_a(ALBINO);
    }

    private void setAlbino(boolean isAlbino) {
        this.field_70180_af.func_187227_b(ALBINO, (Object)isAlbino);
    }

    public boolean isMelanistic() {
        return (Boolean)this.field_70180_af.func_187225_a(MELANISTIC);
    }

    private void setMelanistic(boolean isMelanistic) {
        this.field_70180_af.func_187227_b(MELANISTIC, (Object)isMelanistic);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == PFBlocks.MARCHANTIA.func_199767_j();
    }

    public boolean isInLoveNaturally() {
        return (Boolean)this.field_70180_af.func_187225_a(NATURAL_LOVE);
    }

    private void setInLoveNaturally(boolean isInLoveNaturally) {
        this.field_70180_af.func_187227_b(NATURAL_LOVE, (Object)isInLoveNaturally);
    }

    public int getCurrentHunger() {
        return this.currentHunger;
    }

    private void setHunger(int currentHunger) {
        this.currentHunger = currentHunger;
    }

    public int getHalfHunger() {
        return this.maxHunger / 2;
    }

    public int getThreeQuartersHunger() {
        return this.maxHunger / 4 * 3;
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(EATING);
    }

    private void setEating(boolean isEating) {
        this.field_70180_af.func_187227_b(EATING, (Object)isEating);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(ALBINO, (Object)false);
        this.field_70180_af.func_187214_a(MELANISTIC, (Object)false);
        this.field_70180_af.func_187214_a(EATING, (Object)false);
        this.field_70180_af.func_187214_a(NATURAL_LOVE, (Object)false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HasEgg", this.hasEgg());
        compound.func_74757_a("IsAlbino", this.isAlbino());
        compound.func_74757_a("IsMelanistic", this.isMelanistic());
        compound.func_74768_a("MaxHunger", this.currentHunger);
        compound.func_74757_a("IsEating", this.isEating());
        compound.func_74757_a("InNaturalLove", this.isInLoveNaturally());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
        this.setAlbino(compound.func_74767_n("IsAlbino"));
        this.setMelanistic(compound.func_74767_n("IsMelanistic"));
        this.setEating(compound.func_74767_n("IsEating"));
        this.setHunger(compound.func_74762_e("MaxHunger"));
        this.setInLoveNaturally(compound.func_74767_n("InNaturalLove"));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Random rand = new Random();
        int birthNumber = rand.nextInt(799);
        if (birthNumber >= 0 && birthNumber < 4) {
            this.setAlbino(true);
        } else if (birthNumber >= 4 && birthNumber < 7) {
            this.setMelanistic(true);
        }
        this.setHunger(this.maxHunger);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(5, (Goal)new DinosaurLookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new DinosaurRandomLookGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(0, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, TyrannosaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, DakotaraptorEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, AllosaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, CeratosaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, CamarasaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, SaurosuchusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(1, (Goal)new DiurnalSleepingGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new HerbivoreEatGoal(1.2f, 12, 2));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, DilophosaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, PoposaurusEntity.class, 10.0f, 1.5, 1.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, PostosuchusEntity.class, 10.0f, 1.5, 1.75));
    }

    protected SoundEvent func_184639_G() {
        return this.isAsleep() ? null : SoundInit.THESCELOSAURUS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.THESCELOSAURUS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.THESCELOSAURUS_DEATH;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    private void spawnItem(ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack);
        this.field_70170_p.func_217376_c((Entity)itemEntity);
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (this.chewingTick == 0 && (item == PFItems.PTILOPHYLLUM_FRONDS.get() || item == PFBlocks.DICROIDIUM.func_199767_j() || item == PFBlocks.JOHNSTONIA.func_199767_j() || item == PFBlocks.MICHELILLOA.func_199767_j() || item == PFBlocks.SCYTOPHYLLUM.func_199767_j() || item == PFBlocks.METASEQUOIA_SAPLING.func_199767_j() || item == PFBlocks.PROTOPICEOXYLON_SAPLING.func_199767_j() || item == PFBlocks.PROTOJUNIPEROXYLON_SAPLING.func_199767_j() || item == PFBlocks.HEIDIPHYLLUM_SAPLING.func_199767_j())) {
            this.chewingTick = 600;
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.chewingTick > 0) {
            --this.chewingTick;
        }
        if (this.chewingTick == 1) {
            this.spawnItem(((Item)PFItems.PLANT_FIBER.get()).func_190903_i());
            this.spawnItem(((Item)PFItems.PLANT_FIBER.get()).func_190903_i());
            this.spawnItem(((Item)PFItems.PLANT_FIBER.get()).func_190903_i());
        }
        if (this.isAsleep()) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.23);
        }
        if (!this.func_175446_cd()) {
            List list = this.field_70170_p.func_217357_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0));
            if (PrehistoricFaunaConfig.advancedHunger) {
                ++this.hungerTick;
                if (this.hungerTick == 600 && !this.func_70631_g_() || this.hungerTick == 300 && this.func_70631_g_()) {
                    if (!this.isAsleep()) {
                        if (this.currentHunger != 0) {
                            this.setHunger(this.currentHunger - 1);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.field_70170_p.func_175659_aa() == Difficulty.HARD && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                    }
                    this.hungerTick = 0;
                }
                if (this.getCurrentHunger() >= this.getThreeQuartersHunger() && this.hungerTick % 150 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() != 0.0f && this.func_70638_az() == null && this.func_70643_av() == null) {
                    float currentHealth = this.func_110143_aJ();
                    this.func_70606_j(currentHealth + 1.0f);
                }
                if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                    if (!(this.lastInLove != 0 || this.currentHunger < this.getThreeQuartersHunger() || this.field_70173_aa % 900 != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep() || list.size() >= 6)) {
                        this.loveTick = 600;
                        this.setInLoveNaturally(true);
                        this.func_204700_e(600);
                        this.lastInLove = 28800;
                    }
                    if (this.loveTick != 0) {
                        --this.loveTick;
                    } else {
                        this.setInLoveNaturally(false);
                    }
                }
            } else if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                int naturalBreedingChance = this.field_70146_Z.nextInt(1000);
                if (!(this.lastInLove != 0 || naturalBreedingChance != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep() || list.size() >= 6)) {
                    this.loveTick = 600;
                    this.setInLoveNaturally(true);
                    this.func_204700_e(600);
                    this.lastInLove = 28800;
                }
                if (this.loveTick != 0) {
                    --this.loveTick;
                } else {
                    this.setInLoveNaturally(false);
                }
            }
            if (this.lastInLove != 0) {
                --this.lastInLove;
            }
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 15.0).func_233815_a_(Attributes.field_233821_d_, 0.23);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        ThescelosaurusEntity entity = new ThescelosaurusEntity((EntityType<? extends ThescelosaurusEntity>)PFEntities.THESCELOSAURUS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IServerWorld)p_241840_1_, this.field_70170_p.func_175649_E(new BlockPos(entity.func_213303_ch())), SpawnReason.BREEDING, null, null);
        return entity;
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final ThescelosaurusEntity thescelosaurus;

        LayEggGoal(ThescelosaurusEntity thescelosaurus, double speedIn) {
            super((CreatureEntity)thescelosaurus, speedIn, 16);
            this.thescelosaurus = thescelosaurus;
        }

        public boolean func_75250_a() {
            return this.thescelosaurus.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.thescelosaurus.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos(this.thescelosaurus.func_213303_ch());
            if (!this.thescelosaurus.func_70090_H() && this.func_179487_f()) {
                if (this.thescelosaurus.isDigging < 1) {
                    this.thescelosaurus.setDigging(true);
                } else if (this.thescelosaurus.isDigging > 200) {
                    World world = this.thescelosaurus.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)PFBlocks.THESCELOSAURUS_EGG.func_176223_P().func_206870_a((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.thescelosaurus.field_70146_Z.nextInt(4) + 1)), 3);
                    this.thescelosaurus.setHasEgg(false);
                    this.thescelosaurus.setDigging(false);
                    this.thescelosaurus.func_204700_e(600);
                }
                if (this.thescelosaurus.isDigging()) {
                    this.thescelosaurus.isDigging++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150391_bh || block == Blocks.field_150354_m || block == Blocks.field_196611_F || block == PFBlocks.MOSSY_DIRT || block == PFBlocks.MOSS_BLOCK || block == PFBlocks.LOAM || block == PFBlocks.PACKED_LOAM || block == PFBlocks.SILT || block == PFBlocks.PACKED_LOAM || block == BlockTags.field_206952_E;
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final ThescelosaurusEntity thescelosaurus;

        MateGoal(ThescelosaurusEntity thescelosaurus, double speedIn) {
            super((AnimalEntity)thescelosaurus, speedIn);
            this.thescelosaurus = thescelosaurus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.thescelosaurus.hasEgg() && !this.thescelosaurus.isInLoveNaturally();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverplayerentity = this.field_75390_d.func_191993_do();
            if (serverplayerentity == null && this.field_75391_e.func_191993_do() != null) {
                serverplayerentity = this.field_75391_e.func_191993_do();
            }
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.thescelosaurus.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class NaturalMateGoal
    extends BreedGoal {
        private final ThescelosaurusEntity thescelosaurus;

        NaturalMateGoal(ThescelosaurusEntity thescelosaurus, double speed) {
            super((AnimalEntity)thescelosaurus, speed);
            this.thescelosaurus = thescelosaurus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.thescelosaurus.hasEgg() && this.thescelosaurus.getCurrentHunger() >= this.thescelosaurus.getThreeQuartersHunger() && this.thescelosaurus.field_70173_aa % 60 == 0 && (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && this.thescelosaurus.isInLoveNaturally();
        }

        protected void func_75388_i() {
            if (PrehistoricFaunaConfig.naturalEggItemLaying) {
                this.thescelosaurus.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.thescelosaurus.field_70146_Z.nextFloat() - this.thescelosaurus.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                int eggAmount = this.thescelosaurus.field_70146_Z.nextInt(4);
                if (eggAmount == 0) {
                    this.thescelosaurus.func_199703_a((IItemProvider)PFBlocks.THESCELOSAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 1) {
                    this.thescelosaurus.func_199703_a((IItemProvider)PFBlocks.THESCELOSAURUS_EGG.func_199767_j());
                    this.thescelosaurus.func_199703_a((IItemProvider)PFBlocks.THESCELOSAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 2) {
                    this.thescelosaurus.func_199703_a((IItemProvider)PFBlocks.THESCELOSAURUS_EGG.func_199767_j());
                    this.thescelosaurus.func_199703_a((IItemProvider)PFBlocks.THESCELOSAURUS_EGG.func_199767_j());
                    this.thescelosaurus.func_199703_a((IItemProvider)PFBlocks.THESCELOSAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 3) {
                    this.thescelosaurus.func_199703_a((IItemProvider)PFBlocks.THESCELOSAURUS_EGG.func_199767_j());
                    this.thescelosaurus.func_199703_a((IItemProvider)PFBlocks.THESCELOSAURUS_EGG.func_199767_j());
                    this.thescelosaurus.func_199703_a((IItemProvider)PFBlocks.THESCELOSAURUS_EGG.func_199767_j());
                    this.thescelosaurus.func_199703_a((IItemProvider)PFBlocks.THESCELOSAURUS_EGG.func_199767_j());
                }
            } else {
                this.thescelosaurus.setHasEgg(true);
            }
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
        }
    }

    public class HerbivoreEatGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public HerbivoreEatGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((CreatureEntity)ThescelosaurusEntity.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public double func_203110_f() {
            return 2.0;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 100 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            return blockstate.func_203425_a(PFBlocks.HORSETAIL) || blockstate.func_203425_a(PFBlocks.TALL_HORSETAIL) || blockstate.func_203425_a(PFBlocks.OSMUNDA) || blockstate.func_203425_a(PFBlocks.TALL_OSMUNDA) || blockstate.func_203425_a(PFBlocks.CLUBMOSS) || blockstate.func_203425_a(PFBlocks.MARCHANTIA) || blockstate.func_203425_a(PFBlocks.CONIOPTERIS) || blockstate.func_203425_a(PFBlocks.OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.TALL_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.DICROIDIUM) || blockstate.func_203425_a(PFBlocks.JOHNSTONIA) || blockstate.func_203425_a(PFBlocks.CLADOPHLEBIS) || blockstate.func_203425_a(PFBlocks.SCYTOPHYLLUM) || blockstate.func_203425_a(PFBlocks.MICHELILLOA) || blockstate.func_203425_a(PFBlocks.DEAD_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.COBBANIA) || blockstate.func_203425_a(PFBlocks.OTOZAMITES) || blockstate.func_203425_a(PFBlocks.TALL_OTOZAMITES) || blockstate.func_203425_a(PFBlocks.LAUROZAMITES) || blockstate.func_203425_a(Blocks.field_150349_c) || blockstate.func_203425_a(Blocks.field_150395_bd) || blockstate.func_235714_a_((ITag)BlockTags.field_226149_I_) || blockstate.func_203425_a(Blocks.field_196804_gh) || blockstate.func_203425_a(Blocks.field_196554_aH) || blockstate.func_203425_a(Blocks.field_196805_gi);
        }

        public void func_75246_d() {
            if (this.func_179487_f()) {
                if (this.field_220731_g >= 20) {
                    this.eatBerry();
                } else {
                    ++this.field_220731_g;
                    ThescelosaurusEntity.this.setEating(true);
                }
                if (this.field_220731_g % 5 == 1) {
                    ThescelosaurusEntity.this.field_70170_p.func_184133_a((PlayerEntity)null, this.field_179494_b, SoundEvents.field_187575_bT, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
            }
            super.func_75246_d();
        }

        protected void eatBerry() {
            int hunger;
            BlockState blockstate = ThescelosaurusEntity.this.field_70170_p.func_180495_p(this.field_179494_b);
            if (blockstate.func_203425_a(PFBlocks.DEAD_OSMUNDACAULIS)) {
                hunger = ThescelosaurusEntity.this.getCurrentHunger();
                if (hunger + 2 >= ThescelosaurusEntity.this.maxHunger) {
                    ThescelosaurusEntity.this.setHunger(ThescelosaurusEntity.this.maxHunger);
                    ThescelosaurusEntity.this.setEating(false);
                } else {
                    ThescelosaurusEntity.this.setHunger(hunger + 2);
                    ThescelosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(Blocks.field_150349_c) || blockstate.func_203425_a(Blocks.field_196804_gh) || blockstate.func_235714_a_((ITag)BlockTags.field_226149_I_)) {
                hunger = ThescelosaurusEntity.this.getCurrentHunger();
                if (hunger + 4 >= ThescelosaurusEntity.this.maxHunger) {
                    ThescelosaurusEntity.this.setHunger(ThescelosaurusEntity.this.maxHunger);
                    ThescelosaurusEntity.this.setEating(false);
                } else {
                    ThescelosaurusEntity.this.setHunger(hunger + 4);
                    ThescelosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(Blocks.field_150395_bd)) {
                hunger = ThescelosaurusEntity.this.getCurrentHunger();
                if (hunger + 6 >= ThescelosaurusEntity.this.maxHunger) {
                    ThescelosaurusEntity.this.setHunger(ThescelosaurusEntity.this.maxHunger);
                    ThescelosaurusEntity.this.setEating(false);
                } else {
                    ThescelosaurusEntity.this.setHunger(hunger + 6);
                    ThescelosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.MARCHANTIA) || blockstate.func_203425_a(PFBlocks.OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.OTOZAMITES)) {
                hunger = ThescelosaurusEntity.this.getCurrentHunger();
                if (hunger + 8 >= ThescelosaurusEntity.this.maxHunger) {
                    ThescelosaurusEntity.this.setHunger(ThescelosaurusEntity.this.maxHunger);
                    ThescelosaurusEntity.this.setEating(false);
                } else {
                    ThescelosaurusEntity.this.setHunger(hunger + 8);
                    ThescelosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.HORSETAIL) || blockstate.func_203425_a(PFBlocks.CLUBMOSS) || blockstate.func_203425_a(PFBlocks.MICHELILLOA) || blockstate.func_203425_a(PFBlocks.COBBANIA) || blockstate.func_203425_a(PFBlocks.LAUROZAMITES) || blockstate.func_203425_a(PFBlocks.CLATHOPTERIS)) {
                hunger = ThescelosaurusEntity.this.getCurrentHunger();
                if (hunger + 10 >= ThescelosaurusEntity.this.maxHunger) {
                    ThescelosaurusEntity.this.setHunger(ThescelosaurusEntity.this.maxHunger);
                    ThescelosaurusEntity.this.setEating(false);
                } else {
                    ThescelosaurusEntity.this.setHunger(hunger + 10);
                    ThescelosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.TALL_OTOZAMITES)) {
                hunger = ThescelosaurusEntity.this.getCurrentHunger();
                if (hunger + 12 >= ThescelosaurusEntity.this.maxHunger) {
                    ThescelosaurusEntity.this.setHunger(ThescelosaurusEntity.this.maxHunger);
                    ThescelosaurusEntity.this.setEating(false);
                } else {
                    ThescelosaurusEntity.this.setHunger(hunger + 12);
                    ThescelosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.OSMUNDA) || blockstate.func_203425_a(Blocks.field_196554_aH) || blockstate.func_203425_a(PFBlocks.CONIOPTERIS) || blockstate.func_203425_a(PFBlocks.CLADOPHLEBIS)) {
                hunger = ThescelosaurusEntity.this.getCurrentHunger();
                if (hunger + 15 >= ThescelosaurusEntity.this.maxHunger) {
                    ThescelosaurusEntity.this.setHunger(ThescelosaurusEntity.this.maxHunger);
                    ThescelosaurusEntity.this.setEating(false);
                } else {
                    ThescelosaurusEntity.this.setHunger(hunger + 15);
                    ThescelosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_HORSETAIL) || blockstate.func_203425_a(PFBlocks.SCYTOPHYLLUM)) {
                hunger = ThescelosaurusEntity.this.getCurrentHunger();
                if (hunger + 20 >= ThescelosaurusEntity.this.maxHunger) {
                    ThescelosaurusEntity.this.setHunger(ThescelosaurusEntity.this.maxHunger);
                    ThescelosaurusEntity.this.setEating(false);
                } else {
                    ThescelosaurusEntity.this.setHunger(hunger + 20);
                    ThescelosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_OSMUNDA) || blockstate.func_203425_a(Blocks.field_196805_gi) || blockstate.func_203425_a(PFBlocks.JOHNSTONIA)) {
                hunger = ThescelosaurusEntity.this.getCurrentHunger();
                if (hunger + 25 >= ThescelosaurusEntity.this.maxHunger) {
                    ThescelosaurusEntity.this.setHunger(ThescelosaurusEntity.this.maxHunger);
                    ThescelosaurusEntity.this.setEating(false);
                } else {
                    ThescelosaurusEntity.this.setHunger(hunger + 25);
                    ThescelosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.DICROIDIUM)) {
                hunger = ThescelosaurusEntity.this.getCurrentHunger();
                if (hunger + 30 >= ThescelosaurusEntity.this.maxHunger) {
                    ThescelosaurusEntity.this.setHunger(ThescelosaurusEntity.this.maxHunger);
                    ThescelosaurusEntity.this.setEating(false);
                } else {
                    ThescelosaurusEntity.this.setHunger(hunger + 30);
                    ThescelosaurusEntity.this.setEating(false);
                }
            }
        }

        public boolean func_75250_a() {
            return !ThescelosaurusEntity.this.isAsleep() && super.func_75250_a() && ThescelosaurusEntity.this.getCurrentHunger() < ThescelosaurusEntity.this.getHalfHunger();
        }

        public boolean func_75253_b() {
            if (ThescelosaurusEntity.this.getCurrentHunger() >= ThescelosaurusEntity.this.maxHunger || ThescelosaurusEntity.this.isAsleep()) {
                return false;
            }
            return super.func_75253_b();
        }

        public void func_75249_e() {
            this.field_220731_g = 0;
            super.func_75249_e();
        }
    }
}

