/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities.cretaceous.hellcreek;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entities.DinosaurEntity;
import superlord.prehistoricfauna.common.entities.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entities.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entities.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.SoundInit;

public class AnkylosaurusEntity
extends DinosaurEntity {
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(AnkylosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(AnkylosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ALBINO = EntityDataManager.func_187226_a(AnkylosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MELANISTIC = EntityDataManager.func_187226_a(AnkylosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EATING = EntityDataManager.func_187226_a(AnkylosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TUBER_DIGGING = EntityDataManager.func_187226_a(AnkylosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> NATURAL_LOVE = EntityDataManager.func_187226_a(AnkylosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int warningSoundTicks = 200;
    private int maxHunger = 200;
    private int currentHunger;
    private int lastInLove = 0;
    int hungerTick = 0;
    private int isDigging;
    int loveTick = 0;

    public AnkylosaurusEntity(EntityType<? extends AnkylosaurusEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    public AgeableEntity createChild(AgeableEntity ageable) {
        AnkylosaurusEntity entity = new AnkylosaurusEntity((EntityType<? extends AnkylosaurusEntity>)PFEntities.ANKYLOSAURUS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos(entity.func_213303_ch())), SpawnReason.BREEDING, null, null);
        return entity;
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    public int func_205010_bg() {
        return 0;
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isAlbino() {
        return (Boolean)this.field_70180_af.func_187225_a(ALBINO);
    }

    private void setAlbino(boolean isAlbino) {
        this.field_70180_af.func_187227_b(ALBINO, (Object)isAlbino);
    }

    public boolean isTuberDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(TUBER_DIGGING);
    }

    private void setTuberDigging(boolean isTuberDigging) {
        this.field_70180_af.func_187227_b(TUBER_DIGGING, (Object)isTuberDigging);
    }

    public boolean isMelanistic() {
        return (Boolean)this.field_70180_af.func_187225_a(MELANISTIC);
    }

    private void setMelanistic(boolean isMelanistic) {
        this.field_70180_af.func_187227_b(MELANISTIC, (Object)isMelanistic);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == PFBlocks.CLUBMOSS.func_199767_j();
    }

    public int getCurrentHunger() {
        return this.currentHunger;
    }

    public boolean isInLoveNaturally() {
        return (Boolean)this.field_70180_af.func_187225_a(NATURAL_LOVE);
    }

    private void setInLoveNaturally(boolean isInLoveNaturally) {
        this.field_70180_af.func_187227_b(NATURAL_LOVE, (Object)isInLoveNaturally);
    }

    private void setHunger(int currentHunger) {
        this.currentHunger = currentHunger;
    }

    public int getHalfHunger() {
        return this.maxHunger / 2;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        if (this.func_70631_g_()) {
            return 0.76f;
        }
        return 1.5f;
    }

    public int getThreeQuartersHunger() {
        return this.maxHunger / 4 * 3;
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(EATING);
    }

    private void setEating(boolean isEating) {
        this.field_70180_af.func_187227_b(EATING, (Object)isEating);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isAsleep()) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.2);
        }
        if (!this.func_175446_cd()) {
            List list = this.field_70170_p.func_217357_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0));
            if (PrehistoricFaunaConfig.advancedHunger) {
                ++this.hungerTick;
                if (this.hungerTick == 600 && !this.func_70631_g_() || this.hungerTick == 300 && this.func_70631_g_()) {
                    if (!this.isAsleep()) {
                        if (this.currentHunger != 0) {
                            this.setHunger(this.currentHunger - 1);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.field_70170_p.func_175659_aa() == Difficulty.HARD && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                    }
                    this.hungerTick = 0;
                }
                if (this.getCurrentHunger() >= this.getThreeQuartersHunger() && this.hungerTick % 150 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() != 0.0f && this.func_70638_az() == null && this.func_70643_av() == null) {
                    float currentHealth = this.func_110143_aJ();
                    this.func_70606_j(currentHealth + 1.0f);
                }
                if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                    if (!(this.lastInLove != 0 || this.currentHunger < this.getThreeQuartersHunger() || this.field_70173_aa % 900 != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep() || list.size() >= 6)) {
                        this.loveTick = 600;
                        this.setInLoveNaturally(true);
                        this.func_204700_e(600);
                        this.lastInLove = 28800;
                    }
                    if (this.loveTick != 0) {
                        --this.loveTick;
                    } else {
                        this.setInLoveNaturally(false);
                    }
                }
            } else if ((PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && !PrehistoricFaunaConfig.advancedHunger) {
                int naturalBreedingChance = this.field_70146_Z.nextInt(1000);
                if (!(this.lastInLove != 0 || naturalBreedingChance != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep() || list.size() >= 6)) {
                    this.loveTick = 600;
                    this.setInLoveNaturally(true);
                    this.func_204700_e(600);
                    this.lastInLove = 28800;
                }
                if (this.loveTick != 0) {
                    --this.loveTick;
                } else {
                    this.setInLoveNaturally(false);
                }
            }
            if (this.lastInLove != 0) {
                --this.lastInLove;
            }
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Random rand = new Random();
        int birthNumber = rand.nextInt(799);
        if (birthNumber >= 0 && birthNumber < 4) {
            this.setAlbino(true);
        } else if (birthNumber == 4) {
            this.setMelanistic(true);
        }
        this.setHunger(this.maxHunger);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new DinosaurLookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new DinosaurRandomLookGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new DiggingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
        this.field_70715_bh.func_75776_a(3, (Goal)new ProtectBabyGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new DiurnalSleepingGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new HerbivoreEatGoal(1.2f, 12, 2));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233823_f_, 14.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233820_c_, 0.5);
    }

    protected SoundEvent func_184639_G() {
        return this.isAsleep() ? SoundInit.ANKYLOSAURUS_SNORES : SoundInit.ANKYLOSAURUS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.ANKYLOSAURUS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.ANKYLOSAURUS_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundInit.ANKYLOSAURUS_WARN, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(ALBINO, (Object)false);
        this.field_70180_af.func_187214_a(MELANISTIC, (Object)false);
        this.field_70180_af.func_187214_a(EATING, (Object)false);
        this.field_70180_af.func_187214_a(NATURAL_LOVE, (Object)false);
        this.field_70180_af.func_187214_a(TUBER_DIGGING, (Object)false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HasEgg", this.hasEgg());
        compound.func_74757_a("IsAlbino", this.isAlbino());
        compound.func_74757_a("IsMelanistic", this.isMelanistic());
        compound.func_74768_a("MaxHunger", this.currentHunger);
        compound.func_74757_a("IsEating", this.isEating());
        compound.func_74757_a("InNaturalLove", this.isInLoveNaturally());
        compound.func_74757_a("TuberDigging", this.isTuberDigging());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
        this.setAlbino(compound.func_74767_n("IsAlbino"));
        this.setMelanistic(compound.func_74767_n("IsMelanistic"));
        this.setEating(compound.func_74767_n("IsEating"));
        this.setHunger(compound.func_74762_e("MaxHunger"));
        this.setInLoveNaturally(compound.func_74767_n("InNaturalLove"));
        this.setTuberDigging(compound.func_74767_n("TuberDigging"));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        AnkylosaurusEntity entity = new AnkylosaurusEntity((EntityType<? extends AnkylosaurusEntity>)PFEntities.ANKYLOSAURUS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IServerWorld)p_241840_1_, this.field_70170_p.func_175649_E(new BlockPos(entity.func_213303_ch())), SpawnReason.BREEDING, null, null);
        return entity;
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)AnkylosaurusEntity.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    AnkylosaurusEntity.this.playWarningSound();
                }
            } else {
                this.func_234039_g_();
            }
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 8.0f + attackTarget.func_213311_cf();
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)AnkylosaurusEntity.this, 2.0);
        }

        public boolean func_75250_a() {
            return !AnkylosaurusEntity.this.func_70631_g_() && !AnkylosaurusEntity.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    static class DiggingGoal
    extends Goal {
        private static final ResourceLocation DIGGING_LOOT = new ResourceLocation("prehistoricfauna", "entities/ankylosaurus_digging");
        private final AnkylosaurusEntity ankylosaurus;
        private int diggingTimer;
        private int digTimer2;

        public DiggingGoal(AnkylosaurusEntity entity) {
            this.ankylosaurus = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            if (this.digTimer2 > 0) {
                --this.digTimer2;
                return false;
            }
            if (this.ankylosaurus.func_70681_au().nextInt(this.ankylosaurus.func_70631_g_() ? 100 : 1000) != 0) {
                return false;
            }
            BlockPos blockpos = this.ankylosaurus.func_233580_cy_();
            BlockState state = this.ankylosaurus.field_70170_p.func_180495_p(blockpos);
            if (state.func_235714_a_((ITag)Tags.Blocks.DIRT)) {
                return true;
            }
            return this.ankylosaurus.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_235714_a_((ITag)Tags.Blocks.DIRT);
        }

        public void func_75249_e() {
            this.diggingTimer = 40;
            this.digTimer2 = 6000;
            this.ankylosaurus.field_70170_p.func_72960_a((Entity)this.ankylosaurus, (byte)10);
            this.ankylosaurus.setTuberDigging(true);
            this.ankylosaurus.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.diggingTimer = 0;
            this.ankylosaurus.setTuberDigging(false);
        }

        public boolean func_75253_b() {
            return this.diggingTimer > 0;
        }

        public void func_75246_d() {
            BlockPos blockpos;
            BlockPos blockpos1;
            if (this.digTimer2 > 0) {
                --this.digTimer2;
            }
            if (this.diggingTimer > 0) {
                --this.diggingTimer;
            }
            if (this.diggingTimer == 25 && this.ankylosaurus.field_70170_p.func_180495_p(blockpos1 = (blockpos = this.ankylosaurus.func_233580_cy_()).func_177977_b()).func_235714_a_((ITag)Tags.Blocks.DIRT)) {
                BlockState state = this.ankylosaurus.field_70170_p.func_180495_p(blockpos1);
                this.ankylosaurus.field_70170_p.func_217379_c(2001, blockpos1, Block.func_196246_j((BlockState)state));
                MinecraftServer server = this.ankylosaurus.field_70170_p.func_73046_m();
                if (server != null) {
                    List items = server.func_200249_aQ().func_186521_a(DIGGING_LOOT).func_216113_a(new LootContext.Builder((ServerWorld)this.ankylosaurus.field_70170_p).func_216023_a(this.ankylosaurus.func_70681_au()).func_216022_a(LootParameterSets.field_216260_a));
                    InventoryHelper.func_219961_a((World)this.ankylosaurus.field_70170_p, (BlockPos)blockpos, (NonNullList)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])items.toArray(new ItemStack[0])));
                }
            }
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)AnkylosaurusEntity.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (AnkylosaurusEntity.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof AnkylosaurusEntity && !mobIn.func_70631_g_()) {
                super.func_220793_a(mobIn, targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)AnkylosaurusEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            Iterator iterator;
            if (AnkylosaurusEntity.this.func_70631_g_() || AnkylosaurusEntity.this.isAsleep()) {
                return false;
            }
            if (super.func_75250_a() && (iterator = AnkylosaurusEntity.this.field_70170_p.func_217357_a(AnkylosaurusEntity.class, AnkylosaurusEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0)).iterator()).hasNext()) {
                AnkylosaurusEntity ankylosaurus = (AnkylosaurusEntity)((Object)iterator.next());
                return true;
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    class ProtectBabyGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public ProtectBabyGoal() {
            super((MobEntity)AnkylosaurusEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (AnkylosaurusEntity.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (AnkylosaurusEntity ankylosaurus : AnkylosaurusEntity.this.field_70170_p.func_217357_a(AnkylosaurusEntity.class, AnkylosaurusEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!ankylosaurus.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final AnkylosaurusEntity ankylosaurus;

        LayEggGoal(AnkylosaurusEntity ankylosaurus, double speedIn) {
            super((CreatureEntity)ankylosaurus, speedIn, 16);
            this.ankylosaurus = ankylosaurus;
        }

        public boolean func_75250_a() {
            return this.ankylosaurus.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.ankylosaurus.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos(this.ankylosaurus.func_213303_ch());
            if (!this.ankylosaurus.func_70090_H() && this.func_179487_f()) {
                if (this.ankylosaurus.isDigging < 1) {
                    this.ankylosaurus.setDigging(true);
                } else if (this.ankylosaurus.isDigging > 200) {
                    World world = this.ankylosaurus.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)PFBlocks.ANKYLOSAURUS_EGG.func_176223_P().func_206870_a((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.ankylosaurus.field_70146_Z.nextInt(4) + 1)), 3);
                    this.ankylosaurus.setHasEgg(false);
                    this.ankylosaurus.setDigging(false);
                    this.ankylosaurus.func_204700_e(600);
                }
                if (this.ankylosaurus.isDigging()) {
                    this.ankylosaurus.isDigging++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150391_bh || block == Blocks.field_150354_m || block == Blocks.field_196611_F || block == PFBlocks.MOSSY_DIRT || block == PFBlocks.MOSS_BLOCK || block == PFBlocks.LOAM || block == PFBlocks.PACKED_LOAM || block == PFBlocks.SILT || block == PFBlocks.PACKED_LOAM || block == BlockTags.field_206952_E;
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final AnkylosaurusEntity ankylosaurus;

        MateGoal(AnkylosaurusEntity ankylosaurus, double speedIn) {
            super((AnimalEntity)ankylosaurus, speedIn);
            this.ankylosaurus = ankylosaurus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.ankylosaurus.hasEgg() && !this.ankylosaurus.isInLoveNaturally();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverplayerentity = this.field_75390_d.func_191993_do();
            if (serverplayerentity == null && this.field_75391_e.func_191993_do() != null) {
                serverplayerentity = this.field_75391_e.func_191993_do();
            }
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.ankylosaurus.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class NaturalMateGoal
    extends BreedGoal {
        private final AnkylosaurusEntity ankylosaurus;

        NaturalMateGoal(AnkylosaurusEntity ankylosaurus, double speed) {
            super((AnimalEntity)ankylosaurus, speed);
            this.ankylosaurus = ankylosaurus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.ankylosaurus.hasEgg() && this.ankylosaurus.getCurrentHunger() >= this.ankylosaurus.getThreeQuartersHunger() && this.ankylosaurus.field_70173_aa % 60 == 0 && (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && this.ankylosaurus.isInLoveNaturally();
        }

        protected void func_75388_i() {
            if (PrehistoricFaunaConfig.naturalEggItemLaying) {
                this.ankylosaurus.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.ankylosaurus.field_70146_Z.nextFloat() - this.ankylosaurus.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                int eggAmount = this.ankylosaurus.field_70146_Z.nextInt(4);
                if (eggAmount == 0) {
                    this.ankylosaurus.func_199703_a((IItemProvider)PFBlocks.ANKYLOSAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 1) {
                    this.ankylosaurus.func_199703_a((IItemProvider)PFBlocks.ANKYLOSAURUS_EGG.func_199767_j());
                    this.ankylosaurus.func_199703_a((IItemProvider)PFBlocks.ANKYLOSAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 2) {
                    this.ankylosaurus.func_199703_a((IItemProvider)PFBlocks.ANKYLOSAURUS_EGG.func_199767_j());
                    this.ankylosaurus.func_199703_a((IItemProvider)PFBlocks.ANKYLOSAURUS_EGG.func_199767_j());
                    this.ankylosaurus.func_199703_a((IItemProvider)PFBlocks.ANKYLOSAURUS_EGG.func_199767_j());
                }
                if (eggAmount == 3) {
                    this.ankylosaurus.func_199703_a((IItemProvider)PFBlocks.ANKYLOSAURUS_EGG.func_199767_j());
                    this.ankylosaurus.func_199703_a((IItemProvider)PFBlocks.ANKYLOSAURUS_EGG.func_199767_j());
                    this.ankylosaurus.func_199703_a((IItemProvider)PFBlocks.ANKYLOSAURUS_EGG.func_199767_j());
                    this.ankylosaurus.func_199703_a((IItemProvider)PFBlocks.ANKYLOSAURUS_EGG.func_199767_j());
                }
            } else {
                this.ankylosaurus.setHasEgg(true);
            }
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
        }
    }

    public class HerbivoreEatGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public HerbivoreEatGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((CreatureEntity)AnkylosaurusEntity.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public double func_203110_f() {
            return 2.0;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 100 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            return blockstate.func_203425_a(PFBlocks.HORSETAIL) || blockstate.func_203425_a(PFBlocks.TALL_HORSETAIL) || blockstate.func_203425_a(PFBlocks.OSMUNDA) || blockstate.func_203425_a(PFBlocks.TALL_OSMUNDA) || blockstate.func_203425_a(PFBlocks.CLUBMOSS) || blockstate.func_203425_a(PFBlocks.MARCHANTIA) || blockstate.func_203425_a(PFBlocks.CONIOPTERIS) || blockstate.func_203425_a(PFBlocks.OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.TALL_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.DICROIDIUM) || blockstate.func_203425_a(PFBlocks.JOHNSTONIA) || blockstate.func_203425_a(PFBlocks.CLADOPHLEBIS) || blockstate.func_203425_a(PFBlocks.SCYTOPHYLLUM) || blockstate.func_203425_a(PFBlocks.MICHELILLOA) || blockstate.func_203425_a(PFBlocks.DEAD_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.COBBANIA) || blockstate.func_203425_a(PFBlocks.OTOZAMITES) || blockstate.func_203425_a(PFBlocks.TALL_OTOZAMITES) || blockstate.func_203425_a(PFBlocks.LAUROZAMITES) || blockstate.func_203425_a(Blocks.field_150349_c) || blockstate.func_203425_a(Blocks.field_150395_bd) || blockstate.func_235714_a_((ITag)BlockTags.field_226149_I_) || blockstate.func_203425_a(Blocks.field_196804_gh) || blockstate.func_203425_a(Blocks.field_196554_aH) || blockstate.func_203425_a(Blocks.field_196805_gi);
        }

        public void func_75246_d() {
            if (this.func_179487_f()) {
                if (this.field_220731_g >= 20) {
                    this.eatBerry();
                } else {
                    ++this.field_220731_g;
                    AnkylosaurusEntity.this.setEating(true);
                }
                if (this.field_220731_g % 5 == 1) {
                    AnkylosaurusEntity.this.field_70170_p.func_184133_a((PlayerEntity)null, this.field_179494_b, SoundEvents.field_187575_bT, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
            }
            super.func_75246_d();
        }

        protected void eatBerry() {
            int hunger;
            BlockState blockstate = AnkylosaurusEntity.this.field_70170_p.func_180495_p(this.field_179494_b);
            if (blockstate.func_203425_a(PFBlocks.DEAD_OSMUNDACAULIS)) {
                hunger = AnkylosaurusEntity.this.getCurrentHunger();
                if (hunger + 2 >= AnkylosaurusEntity.this.maxHunger) {
                    AnkylosaurusEntity.this.setHunger(AnkylosaurusEntity.this.maxHunger);
                    AnkylosaurusEntity.this.setEating(false);
                } else {
                    AnkylosaurusEntity.this.setHunger(hunger + 2);
                    AnkylosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(Blocks.field_150349_c) || blockstate.func_203425_a(Blocks.field_196804_gh) || blockstate.func_235714_a_((ITag)BlockTags.field_226149_I_)) {
                hunger = AnkylosaurusEntity.this.getCurrentHunger();
                if (hunger + 4 >= AnkylosaurusEntity.this.maxHunger) {
                    AnkylosaurusEntity.this.setHunger(AnkylosaurusEntity.this.maxHunger);
                    AnkylosaurusEntity.this.setEating(false);
                } else {
                    AnkylosaurusEntity.this.setHunger(hunger + 4);
                    AnkylosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(Blocks.field_150395_bd)) {
                hunger = AnkylosaurusEntity.this.getCurrentHunger();
                if (hunger + 6 >= AnkylosaurusEntity.this.maxHunger) {
                    AnkylosaurusEntity.this.setHunger(AnkylosaurusEntity.this.maxHunger);
                    AnkylosaurusEntity.this.setEating(false);
                } else {
                    AnkylosaurusEntity.this.setHunger(hunger + 6);
                    AnkylosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.MARCHANTIA) || blockstate.func_203425_a(PFBlocks.OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.OTOZAMITES)) {
                hunger = AnkylosaurusEntity.this.getCurrentHunger();
                if (hunger + 8 >= AnkylosaurusEntity.this.maxHunger) {
                    AnkylosaurusEntity.this.setHunger(AnkylosaurusEntity.this.maxHunger);
                    AnkylosaurusEntity.this.setEating(false);
                } else {
                    AnkylosaurusEntity.this.setHunger(hunger + 8);
                    AnkylosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.HORSETAIL) || blockstate.func_203425_a(PFBlocks.CLUBMOSS) || blockstate.func_203425_a(PFBlocks.MICHELILLOA) || blockstate.func_203425_a(PFBlocks.COBBANIA) || blockstate.func_203425_a(PFBlocks.LAUROZAMITES) || blockstate.func_203425_a(PFBlocks.CLATHOPTERIS)) {
                hunger = AnkylosaurusEntity.this.getCurrentHunger();
                if (hunger + 10 >= AnkylosaurusEntity.this.maxHunger) {
                    AnkylosaurusEntity.this.setHunger(AnkylosaurusEntity.this.maxHunger);
                    AnkylosaurusEntity.this.setEating(false);
                } else {
                    AnkylosaurusEntity.this.setHunger(hunger + 10);
                    AnkylosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.TALL_OTOZAMITES)) {
                hunger = AnkylosaurusEntity.this.getCurrentHunger();
                if (hunger + 12 >= AnkylosaurusEntity.this.maxHunger) {
                    AnkylosaurusEntity.this.setHunger(AnkylosaurusEntity.this.maxHunger);
                    AnkylosaurusEntity.this.setEating(false);
                } else {
                    AnkylosaurusEntity.this.setHunger(hunger + 12);
                    AnkylosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.OSMUNDA) || blockstate.func_203425_a(Blocks.field_196554_aH) || blockstate.func_203425_a(PFBlocks.CONIOPTERIS) || blockstate.func_203425_a(PFBlocks.CLADOPHLEBIS)) {
                hunger = AnkylosaurusEntity.this.getCurrentHunger();
                if (hunger + 15 >= AnkylosaurusEntity.this.maxHunger) {
                    AnkylosaurusEntity.this.setHunger(AnkylosaurusEntity.this.maxHunger);
                    AnkylosaurusEntity.this.setEating(false);
                } else {
                    AnkylosaurusEntity.this.setHunger(hunger + 15);
                    AnkylosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_HORSETAIL) || blockstate.func_203425_a(PFBlocks.SCYTOPHYLLUM)) {
                hunger = AnkylosaurusEntity.this.getCurrentHunger();
                if (hunger + 20 >= AnkylosaurusEntity.this.maxHunger) {
                    AnkylosaurusEntity.this.setHunger(AnkylosaurusEntity.this.maxHunger);
                    AnkylosaurusEntity.this.setEating(false);
                } else {
                    AnkylosaurusEntity.this.setHunger(hunger + 20);
                    AnkylosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_OSMUNDA) || blockstate.func_203425_a(Blocks.field_196805_gi) || blockstate.func_203425_a(PFBlocks.JOHNSTONIA)) {
                hunger = AnkylosaurusEntity.this.getCurrentHunger();
                if (hunger + 25 >= AnkylosaurusEntity.this.maxHunger) {
                    AnkylosaurusEntity.this.setHunger(AnkylosaurusEntity.this.maxHunger);
                    AnkylosaurusEntity.this.setEating(false);
                } else {
                    AnkylosaurusEntity.this.setHunger(hunger + 25);
                    AnkylosaurusEntity.this.setEating(false);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.DICROIDIUM)) {
                hunger = AnkylosaurusEntity.this.getCurrentHunger();
                if (hunger + 30 >= AnkylosaurusEntity.this.maxHunger) {
                    AnkylosaurusEntity.this.setHunger(AnkylosaurusEntity.this.maxHunger);
                    AnkylosaurusEntity.this.setEating(false);
                } else {
                    AnkylosaurusEntity.this.setHunger(hunger + 30);
                    AnkylosaurusEntity.this.setEating(false);
                }
            }
        }

        public boolean func_75250_a() {
            return !AnkylosaurusEntity.this.isAsleep() && super.func_75250_a() && AnkylosaurusEntity.this.getCurrentHunger() < AnkylosaurusEntity.this.getHalfHunger();
        }

        public boolean func_75253_b() {
            if (AnkylosaurusEntity.this.getCurrentHunger() >= AnkylosaurusEntity.this.getHalfHunger() || AnkylosaurusEntity.this.isAsleep()) {
                return false;
            }
            return super.func_75253_b();
        }

        public void func_75249_e() {
            this.field_220731_g = 0;
            super.func_75249_e();
        }
    }
}

