/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities.cretaceous.djadochta;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entities.HerdDinosaurEntity;
import superlord.prehistoricfauna.common.entities.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entities.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entities.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.SoundInit;

public class PlesiohadrosEntity
extends HerdDinosaurEntity {
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(PlesiohadrosEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(PlesiohadrosEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ALBINO = EntityDataManager.func_187226_a(PlesiohadrosEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MELANISTIC = EntityDataManager.func_187226_a(PlesiohadrosEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DEOXIDATED = EntityDataManager.func_187226_a(PlesiohadrosEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EATING = EntityDataManager.func_187226_a(PlesiohadrosEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> NATURAL_LOVE = EntityDataManager.func_187226_a(PlesiohadrosEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(PlesiohadrosEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(PlesiohadrosEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int maxHunger = 100;
    private int currentHunger = 100;
    private int lastInLove = 0;
    int hungerTick = 0;
    private int warningSoundTicks;
    private int isDigging;
    public float ridingXZ;
    public float ridingY = 1.0f;
    int loveTick = 0;

    public PlesiohadrosEntity(EntityType<? extends PlesiohadrosEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    public AgeableEntity createChild(AgeableEntity ageable) {
        PlesiohadrosEntity entity = new PlesiohadrosEntity((EntityType<? extends PlesiohadrosEntity>)PFEntities.PLESIOHADROS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos(entity.func_213303_ch())), SpawnReason.BREEDING, null, null);
        return entity;
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
        super.func_241841_a(p_241841_1_, p_241841_2_);
        this.setDeoxidated(true);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isAlbino() {
        return (Boolean)this.field_70180_af.func_187225_a(ALBINO);
    }

    private void setAlbino(boolean isAlbino) {
        this.field_70180_af.func_187227_b(ALBINO, (Object)isAlbino);
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    private void setSaddled(boolean isSaddled) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)isSaddled);
    }

    public boolean isDeoxidated() {
        return (Boolean)this.field_70180_af.func_187225_a(DEOXIDATED);
    }

    private void setDeoxidated(boolean isDeoxidated) {
        this.field_70180_af.func_187227_b(DEOXIDATED, (Object)isDeoxidated);
    }

    public boolean isMelanistic() {
        return (Boolean)this.field_70180_af.func_187225_a(MELANISTIC);
    }

    private void setMelanistic(boolean isMelanistic) {
        this.field_70180_af.func_187227_b(MELANISTIC, (Object)isMelanistic);
    }

    public int getCurrentHunger() {
        return this.currentHunger;
    }

    private void setHunger(int currentHunger) {
        this.currentHunger = currentHunger;
    }

    public int getHalfHunger() {
        return this.maxHunger / 2;
    }

    public int getThreeQuartersHunger() {
        return this.maxHunger / 4 * 3;
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(EATING);
    }

    private void setEating(boolean isEating) {
        this.field_70180_af.func_187227_b(EATING, (Object)isEating);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == PFBlocks.TROCHODENDROIDES_SAPLING.func_199767_j();
    }

    public boolean isInLoveNaturally() {
        return (Boolean)this.field_70180_af.func_187225_a(NATURAL_LOVE);
    }

    private void setInLoveNaturally(boolean isInLoveNaturally) {
        this.field_70180_af.func_187227_b(NATURAL_LOVE, (Object)isInLoveNaturally);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Random rand = new Random();
        int birthNumber = rand.nextInt(799);
        if (birthNumber >= 0 && birthNumber < 4) {
            this.setAlbino(true);
        } else if (birthNumber == 4) {
            this.setMelanistic(true);
        }
        this.setHunger(this.maxHunger);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new DinosaurLookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new DinosaurRandomLookGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
        this.field_70715_bh.func_75776_a(3, (Goal)new ProtectBabyGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new DiurnalSleepingGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new HerbivoreEatGoal(1.2f, 12, 2));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233820_c_, 0.5);
    }

    protected SoundEvent func_184639_G() {
        return this.isAsleep() ? null : SoundInit.PLESIOHADROS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundInit.PLESIOHADROS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.PLESIOHADROS_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundInit.PLESIOHADROS_WARNING, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(ALBINO, (Object)false);
        this.field_70180_af.func_187214_a(MELANISTIC, (Object)false);
        this.field_70180_af.func_187214_a(DEOXIDATED, (Object)false);
        this.field_70180_af.func_187214_a(EATING, (Object)false);
        this.field_70180_af.func_187214_a(NATURAL_LOVE, (Object)false);
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HasEgg", this.hasEgg());
        compound.func_74757_a("IsAlbino", this.isAlbino());
        compound.func_74757_a("IsMelanistic", this.isMelanistic());
        compound.func_74757_a("IsDeoxidated", this.isDeoxidated());
        compound.func_74768_a("MaxHunger", this.currentHunger);
        compound.func_74757_a("IsEating", this.isEating());
        compound.func_74757_a("InNaturalLove", this.isInLoveNaturally());
        compound.func_74757_a("IsSaddled", this.isSaddled());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
        this.setAlbino(compound.func_74767_n("IsAlbino"));
        this.setMelanistic(compound.func_74767_n("IsMelanistic"));
        this.setDeoxidated(compound.func_74767_n("IsDeoxidated"));
        this.setEating(compound.func_74767_n("IsEating"));
        this.setHunger(compound.func_74762_e("MaxHunger"));
        this.setInLoveNaturally(compound.func_74767_n("InNaturalLove"));
        this.setSaddled(compound.func_74767_n("IsSaddled"));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        int ticks = 0;
        if (this.isDeoxidated() && ++ticks == 12000) {
            ticks = 0;
            this.setDeoxidated(false);
        }
        if (this.isAsleep()) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.2);
        }
        if (!this.func_175446_cd()) {
            List list = this.field_70170_p.func_217357_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0));
            if (PrehistoricFaunaConfig.advancedHunger) {
                ++this.hungerTick;
                if (this.hungerTick == 600 && !this.func_70631_g_() || this.hungerTick == 300 && this.func_70631_g_()) {
                    if (!this.isAsleep()) {
                        if (this.currentHunger != 0) {
                            this.setHunger(this.currentHunger - 1);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.field_70170_p.func_175659_aa() == Difficulty.HARD && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        }
                    }
                    this.hungerTick = 0;
                }
                if (this.getCurrentHunger() >= this.getThreeQuartersHunger() && this.hungerTick % 150 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() != 0.0f && this.func_70638_az() == null && this.func_70643_av() == null) {
                    float currentHealth = this.func_110143_aJ();
                    this.func_70606_j(currentHealth + 1.0f);
                }
                if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                    if (!(this.lastInLove != 0 || this.currentHunger < this.getThreeQuartersHunger() || this.field_70173_aa % 900 != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep() || list.size() >= 6)) {
                        this.loveTick = 600;
                        this.setInLoveNaturally(true);
                        this.func_204700_e(600);
                        this.lastInLove = 28800;
                    }
                    if (this.loveTick != 0) {
                        --this.loveTick;
                    } else {
                        this.setInLoveNaturally(false);
                    }
                }
            } else if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                int naturalBreedingChance = this.field_70146_Z.nextInt(1000);
                if (!(this.lastInLove != 0 || naturalBreedingChance != 0 || this.func_70631_g_() || this.func_70880_s() || this.isAsleep() || list.size() >= 6)) {
                    this.loveTick = 600;
                    this.setInLoveNaturally(true);
                    this.func_204700_e(600);
                    this.lastInLove = 28800;
                }
                if (this.loveTick != 0) {
                    --this.loveTick;
                } else {
                    this.setInLoveNaturally(false);
                }
            }
            if (this.lastInLove != 0) {
                --this.lastInLove;
            }
        }
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (!this.func_70909_n() && item == PFBlocks.COBBANIA.func_199767_j()) {
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)p_230254_1_)) {
                this.func_193101_c(p_230254_1_);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        if (!this.isSaddled() && !this.func_70631_g_() && this.func_70909_n() && item == Items.field_151141_av) {
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.setSaddled(true);
            this.field_70170_p.func_184148_a(p_230254_1_, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        if (this.isSaddled() && !this.func_184207_aI() && !this.func_70631_g_()) {
            p_230254_1_.func_184220_m((Entity)this);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.isSaddled()) {
            this.func_199703_a((IItemProvider)Items.field_151141_av);
        }
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.isSaddled()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg;
                this.field_70138_W = 1.0f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_));
                    super.func_213352_e(new Vector3d((double)f, travelVector.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                if (this.field_70122_E) {
                    // empty if block
                }
                this.func_233629_a_((LivingEntity)this, false);
            } else {
                super.func_213352_e(travelVector);
            }
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float radius = this.ridingXZ * 0.7f * -3.0f + 0.5f;
        float angle = (float)Math.PI / 180 * this.field_70761_aq;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        double extraY = this.ridingY * 4.1f;
        this.getRidingPlayer().func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY - 2.75, this.func_226281_cx_() + extraZ);
    }

    protected void func_230273_eI_() {
    }

    public PlayerEntity getRidingPlayer() {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (PlayerEntity)this.func_184179_bs();
        }
        return null;
    }

    @Nullable
    private Vector3d func_234236_a_(Vector3d p_234236_1_, LivingEntity p_234236_2_) {
        double d0 = this.func_226277_ct_() + p_234236_1_.field_72450_a;
        double d1 = this.func_174813_aQ().field_72338_b;
        double d2 = this.func_226281_cx_() + p_234236_1_.field_72449_c;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        block0: for (Pose pose : p_234236_2_.func_230297_ef_()) {
            blockpos$mutable.func_189532_c(d0, d1, d2);
            double d3 = this.func_174813_aQ().field_72337_e + 0.75;
            do {
                Vector3d vector3d;
                AxisAlignedBB axisalignedbb;
                double d4 = this.field_70170_p.func_242403_h((BlockPos)blockpos$mutable);
                if ((double)blockpos$mutable.func_177956_o() + d4 > d3) continue block0;
                if (TransportationHelper.func_234630_a_((double)d4) && TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)p_234236_2_, (AxisAlignedBB)(axisalignedbb = p_234236_2_.func_233648_f_(pose)).func_191194_a(vector3d = new Vector3d(d0, (double)blockpos$mutable.func_177956_o() + d4, d2)))) {
                    p_234236_2_.func_213301_b(pose);
                    return vector3d;
                }
                blockpos$mutable.func_189536_c(Direction.UP);
            } while ((double)blockpos$mutable.func_177956_o() < d3);
        }
        return null;
    }

    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        Vector3d vector3d = PlesiohadrosEntity.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)(this.field_70177_z + (livingEntity.func_184591_cq() == HandSide.RIGHT ? 90.0f : -90.0f)));
        Vector3d vector3d1 = this.func_234236_a_(vector3d, livingEntity);
        if (vector3d1 != null) {
            return vector3d1;
        }
        Vector3d vector3d2 = PlesiohadrosEntity.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)(this.field_70177_z + (livingEntity.func_184591_cq() == HandSide.LEFT ? 90.0f : -90.0f)));
        Vector3d vector3d3 = this.func_234236_a_(vector3d2, livingEntity);
        return vector3d3 != null ? vector3d3 : this.func_213303_ch();
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        PlesiohadrosEntity entity = new PlesiohadrosEntity((EntityType<? extends PlesiohadrosEntity>)PFEntities.PLESIOHADROS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IServerWorld)p_241840_1_, this.field_70170_p.func_175649_E(new BlockPos(entity.func_213303_ch())), SpawnReason.BREEDING, null, null);
        return entity;
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)PlesiohadrosEntity.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    PlesiohadrosEntity.this.playWarningSound();
                }
            } else {
                this.func_234039_g_();
            }
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 8.0f + attackTarget.func_213311_cf();
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)PlesiohadrosEntity.this, 2.0);
        }

        public boolean func_75250_a() {
            return !PlesiohadrosEntity.this.func_70631_g_() && !PlesiohadrosEntity.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)PlesiohadrosEntity.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (PlesiohadrosEntity.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof PlesiohadrosEntity && !mobIn.func_70631_g_()) {
                super.func_220793_a(mobIn, targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)PlesiohadrosEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (PlesiohadrosEntity.this.func_70631_g_() || PlesiohadrosEntity.this.func_70909_n()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (PlesiohadrosEntity plesiohadros : PlesiohadrosEntity.this.field_70170_p.func_217357_a(PlesiohadrosEntity.class, PlesiohadrosEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!plesiohadros.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    class ProtectBabyGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public ProtectBabyGoal() {
            super((MobEntity)PlesiohadrosEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (PlesiohadrosEntity.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (PlesiohadrosEntity plesiohadros : PlesiohadrosEntity.this.field_70170_p.func_217357_a(PlesiohadrosEntity.class, PlesiohadrosEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!plesiohadros.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final PlesiohadrosEntity plesiohadros;

        LayEggGoal(PlesiohadrosEntity plesiohadros, double speedIn) {
            super((CreatureEntity)plesiohadros, speedIn, 16);
            this.plesiohadros = plesiohadros;
        }

        public boolean func_75250_a() {
            return this.plesiohadros.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.plesiohadros.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos(this.plesiohadros.func_213303_ch());
            if (!this.plesiohadros.func_70090_H() && this.func_179487_f()) {
                if (this.plesiohadros.isDigging < 1) {
                    this.plesiohadros.setDigging(true);
                } else if (this.plesiohadros.isDigging > 200) {
                    World world = this.plesiohadros.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)PFBlocks.PLESIOHADROS_EGG.func_176223_P().func_206870_a((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.plesiohadros.field_70146_Z.nextInt(4) + 1)), 3);
                    this.plesiohadros.setHasEgg(false);
                    this.plesiohadros.setDigging(false);
                    this.plesiohadros.func_204700_e(600);
                }
                if (this.plesiohadros.isDigging()) {
                    this.plesiohadros.isDigging++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150391_bh || block == Blocks.field_150354_m || block == Blocks.field_196611_F || block == PFBlocks.MOSSY_DIRT || block == PFBlocks.MOSS_BLOCK || block == PFBlocks.LOAM || block == PFBlocks.PACKED_LOAM || block == PFBlocks.SILT || block == PFBlocks.PACKED_LOAM || block == BlockTags.field_206952_E;
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final PlesiohadrosEntity plesiohadros;

        MateGoal(PlesiohadrosEntity plesiohadros, double speedIn) {
            super((AnimalEntity)plesiohadros, speedIn);
            this.plesiohadros = plesiohadros;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.plesiohadros.hasEgg() && !this.plesiohadros.isInLoveNaturally();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverplayerentity = this.field_75390_d.func_191993_do();
            if (serverplayerentity == null && this.field_75391_e.func_191993_do() != null) {
                serverplayerentity = this.field_75391_e.func_191993_do();
            }
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.plesiohadros.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class NaturalMateGoal
    extends BreedGoal {
        private final PlesiohadrosEntity plesiohadros;

        NaturalMateGoal(PlesiohadrosEntity plesiohadros, double speed) {
            super((AnimalEntity)plesiohadros, speed);
            this.plesiohadros = plesiohadros;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.plesiohadros.hasEgg() && this.plesiohadros.getCurrentHunger() >= this.plesiohadros.getThreeQuartersHunger() && this.plesiohadros.field_70173_aa % 60 == 0 && (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && this.plesiohadros.isInLoveNaturally();
        }

        protected void func_75388_i() {
            if (PrehistoricFaunaConfig.naturalEggItemLaying) {
                this.plesiohadros.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.plesiohadros.field_70146_Z.nextFloat() - this.plesiohadros.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                int eggAmount = this.plesiohadros.field_70146_Z.nextInt(4);
                if (eggAmount == 0) {
                    this.plesiohadros.func_199703_a((IItemProvider)PFBlocks.PLESIOHADROS_EGG.func_199767_j());
                }
                if (eggAmount == 1) {
                    this.plesiohadros.func_199703_a((IItemProvider)PFBlocks.PLESIOHADROS_EGG.func_199767_j());
                    this.plesiohadros.func_199703_a((IItemProvider)PFBlocks.PLESIOHADROS_EGG.func_199767_j());
                }
                if (eggAmount == 2) {
                    this.plesiohadros.func_199703_a((IItemProvider)PFBlocks.PLESIOHADROS_EGG.func_199767_j());
                    this.plesiohadros.func_199703_a((IItemProvider)PFBlocks.PLESIOHADROS_EGG.func_199767_j());
                    this.plesiohadros.func_199703_a((IItemProvider)PFBlocks.PLESIOHADROS_EGG.func_199767_j());
                }
                if (eggAmount == 3) {
                    this.plesiohadros.func_199703_a((IItemProvider)PFBlocks.PLESIOHADROS_EGG.func_199767_j());
                    this.plesiohadros.func_199703_a((IItemProvider)PFBlocks.PLESIOHADROS_EGG.func_199767_j());
                    this.plesiohadros.func_199703_a((IItemProvider)PFBlocks.PLESIOHADROS_EGG.func_199767_j());
                    this.plesiohadros.func_199703_a((IItemProvider)PFBlocks.PLESIOHADROS_EGG.func_199767_j());
                }
            } else {
                this.plesiohadros.setHasEgg(true);
            }
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
        }
    }

    public class HerbivoreEatGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public HerbivoreEatGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((CreatureEntity)PlesiohadrosEntity.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public double func_203110_f() {
            return 2.0;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 100 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            return blockstate.func_203425_a(PFBlocks.HORSETAIL) || blockstate.func_203425_a(PFBlocks.TALL_HORSETAIL) || blockstate.func_203425_a(PFBlocks.OSMUNDA) || blockstate.func_203425_a(PFBlocks.TALL_OSMUNDA) || blockstate.func_203425_a(PFBlocks.CLUBMOSS) || blockstate.func_203425_a(PFBlocks.MARCHANTIA) || blockstate.func_203425_a(PFBlocks.CONIOPTERIS) || blockstate.func_203425_a(PFBlocks.OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.TALL_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.DICROIDIUM) || blockstate.func_203425_a(PFBlocks.JOHNSTONIA) || blockstate.func_203425_a(PFBlocks.CLADOPHLEBIS) || blockstate.func_203425_a(PFBlocks.SCYTOPHYLLUM) || blockstate.func_203425_a(PFBlocks.MICHELILLOA) || blockstate.func_203425_a(PFBlocks.DEAD_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.COBBANIA) || blockstate.func_203425_a(PFBlocks.OTOZAMITES) || blockstate.func_203425_a(PFBlocks.TALL_OTOZAMITES) || blockstate.func_203425_a(PFBlocks.LAUROZAMITES) || blockstate.func_203425_a(Blocks.field_150349_c) || blockstate.func_203425_a(Blocks.field_150395_bd) || blockstate.func_235714_a_((ITag)BlockTags.field_226149_I_) || blockstate.func_203425_a(Blocks.field_196804_gh) || blockstate.func_203425_a(Blocks.field_196554_aH) || blockstate.func_203425_a(Blocks.field_196805_gi);
        }

        public void func_75246_d() {
            if (this.func_179487_f()) {
                if (this.field_220731_g >= 20) {
                    this.eatBerry();
                } else {
                    ++this.field_220731_g;
                    PlesiohadrosEntity.this.setEating(true);
                }
                if (this.field_220731_g % 5 == 1) {
                    PlesiohadrosEntity.this.field_70170_p.func_184133_a((PlayerEntity)null, this.field_179494_b, SoundEvents.field_187575_bT, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
            }
            super.func_75246_d();
        }

        protected void eatBerry() {
            BlockState blockstate = PlesiohadrosEntity.this.field_70170_p.func_180495_p(this.field_179494_b);
            int hunger = PlesiohadrosEntity.this.getCurrentHunger();
            if (blockstate.func_203425_a(PFBlocks.DEAD_OSMUNDACAULIS)) {
                if (hunger + 2 >= PlesiohadrosEntity.this.maxHunger) {
                    PlesiohadrosEntity.this.setHunger(25);
                } else {
                    PlesiohadrosEntity.this.setHunger(hunger + 2);
                }
            }
            if (blockstate.func_203425_a(Blocks.field_150349_c) || blockstate.func_203425_a(Blocks.field_196804_gh) || blockstate.func_235714_a_((ITag)BlockTags.field_226149_I_)) {
                if (hunger + 4 >= PlesiohadrosEntity.this.maxHunger) {
                    PlesiohadrosEntity.this.setHunger(PlesiohadrosEntity.this.maxHunger);
                } else {
                    PlesiohadrosEntity.this.setHunger(hunger + 4);
                }
            }
            if (blockstate.func_203425_a(Blocks.field_150395_bd)) {
                if (hunger + 6 >= PlesiohadrosEntity.this.maxHunger) {
                    PlesiohadrosEntity.this.setHunger(PlesiohadrosEntity.this.maxHunger);
                } else {
                    PlesiohadrosEntity.this.setHunger(hunger + 6);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.MARCHANTIA) || blockstate.func_203425_a(PFBlocks.OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.OTOZAMITES)) {
                if (hunger + 8 >= PlesiohadrosEntity.this.maxHunger) {
                    PlesiohadrosEntity.this.setHunger(PlesiohadrosEntity.this.maxHunger);
                } else {
                    PlesiohadrosEntity.this.setHunger(hunger + 8);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.HORSETAIL) || blockstate.func_203425_a(PFBlocks.CLUBMOSS) || blockstate.func_203425_a(PFBlocks.MICHELILLOA) || blockstate.func_203425_a(PFBlocks.COBBANIA) || blockstate.func_203425_a(PFBlocks.LAUROZAMITES) || blockstate.func_203425_a(PFBlocks.CLATHOPTERIS)) {
                if (hunger + 10 >= PlesiohadrosEntity.this.maxHunger) {
                    PlesiohadrosEntity.this.setHunger(PlesiohadrosEntity.this.maxHunger);
                } else {
                    PlesiohadrosEntity.this.setHunger(hunger + 10);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_OSMUNDACAULIS) || blockstate.func_203425_a(PFBlocks.TALL_OTOZAMITES)) {
                if (hunger + 12 >= PlesiohadrosEntity.this.maxHunger) {
                    PlesiohadrosEntity.this.setHunger(PlesiohadrosEntity.this.maxHunger);
                } else {
                    PlesiohadrosEntity.this.setHunger(hunger + 12);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.OSMUNDA) || blockstate.func_203425_a(Blocks.field_196554_aH) || blockstate.func_203425_a(PFBlocks.CONIOPTERIS) || blockstate.func_203425_a(PFBlocks.CLADOPHLEBIS)) {
                if (hunger + 15 >= PlesiohadrosEntity.this.maxHunger) {
                    PlesiohadrosEntity.this.setHunger(PlesiohadrosEntity.this.maxHunger);
                } else {
                    PlesiohadrosEntity.this.setHunger(hunger + 15);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_HORSETAIL) || blockstate.func_203425_a(PFBlocks.SCYTOPHYLLUM)) {
                if (hunger + 20 >= PlesiohadrosEntity.this.maxHunger) {
                    PlesiohadrosEntity.this.setHunger(PlesiohadrosEntity.this.maxHunger);
                } else {
                    PlesiohadrosEntity.this.setHunger(hunger + 20);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.TALL_OSMUNDA) || blockstate.func_203425_a(Blocks.field_196805_gi) || blockstate.func_203425_a(PFBlocks.JOHNSTONIA)) {
                if (hunger + 25 >= PlesiohadrosEntity.this.maxHunger) {
                    PlesiohadrosEntity.this.setHunger(PlesiohadrosEntity.this.maxHunger);
                } else {
                    PlesiohadrosEntity.this.setHunger(hunger + 25);
                }
            }
            if (blockstate.func_203425_a(PFBlocks.DICROIDIUM)) {
                if (hunger + 30 >= PlesiohadrosEntity.this.maxHunger) {
                    PlesiohadrosEntity.this.setHunger(PlesiohadrosEntity.this.maxHunger);
                } else {
                    PlesiohadrosEntity.this.setHunger(hunger + 30);
                }
            }
            PlesiohadrosEntity.this.setEating(false);
        }

        public boolean func_75250_a() {
            return !PlesiohadrosEntity.this.isAsleep() && super.func_75250_a() && PlesiohadrosEntity.this.getCurrentHunger() < PlesiohadrosEntity.this.getHalfHunger();
        }

        public boolean func_75253_b() {
            if (PlesiohadrosEntity.this.getCurrentHunger() >= PlesiohadrosEntity.this.maxHunger || PlesiohadrosEntity.this.isAsleep()) {
                return false;
            }
            return super.func_75253_b();
        }

        public void func_75249_e() {
            this.field_220731_g = 0;
            super.func_75249_e();
        }
    }
}

