/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class PrehistoricEntity
extends AnimalEntity {
    private int inLove;
    private UUID playerInLove;

    protected PrehistoricEntity(EntityType<? extends PrehistoricEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70619_bc() {
        if (this.func_70874_b() != 0) {
            this.inLove = 0;
        }
        super.func_70619_bc();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70874_b() != 0) {
            this.inLove = 0;
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.inLove = 0;
        return super.func_70097_a(source, amount);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196658_i ? 10.0f : worldIn.func_205052_D(pos) - 0.5f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("InLove", this.inLove);
        if (this.playerInLove != null) {
            compound.func_186854_a("LoveCause", this.playerInLove);
        }
    }

    public double func_70033_W() {
        return 0.14;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.inLove = compound.func_74762_e("InLove");
        this.playerInLove = compound.func_186855_b("LoveCause") ? compound.func_186857_a("LoveCause") : null;
    }

    public static boolean canAnimalSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196658_i && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public int func_70627_aG() {
        return 120;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    protected void func_175505_a(PlayerEntity player, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
    }

    public boolean func_213743_em() {
        return this.inLove <= 0;
    }

    public void func_146082_f(@Nullable PlayerEntity player) {
        this.inLove = 600;
        if (player != null) {
            this.playerInLove = player.func_110124_au();
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    public void func_204700_e(int ticks) {
        this.inLove = ticks;
    }

    @Nullable
    public ServerPlayerEntity func_191993_do() {
        if (this.playerInLove == null) {
            return null;
        }
        PlayerEntity playerentity = this.field_70170_p.func_217371_b(this.playerInLove);
        return playerentity instanceof ServerPlayerEntity ? (ServerPlayerEntity)playerentity : null;
    }

    public boolean func_70880_s() {
        return this.inLove > 0;
    }

    public void func_70875_t() {
        this.inLove = 0;
    }

    public boolean canMateWith(PrehistoricEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (((Object)((Object)otherAnimal)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.func_70880_s() && otherAnimal.func_70880_s();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
            }
        } else {
            super.func_70103_a(id);
        }
    }
}

