/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;

public class PrehistoricBoatEntity
extends BoatEntity {
    private static final DataParameter<Integer> PF_BOAT_TYPE = EntityDataManager.func_187226_a(PrehistoricBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private BoatEntity.Status status;
    private double lastYd;

    public PrehistoricBoatEntity(World worldIn, double x, double y, double z) {
        this(PFEntities.BOAT, worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public PrehistoricBoatEntity(EntityType<? extends BoatEntity> boatEntityType, World worldType) {
        super(boatEntityType, worldType);
    }

    public PrehistoricBoatEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        super(PFEntities.BOAT, world);
    }

    public Item func_184455_j() {
        switch (this.getPFBoatType()) {
            default: {
                return (Item)PFItems.ARAUCARIA_BOAT.get();
            }
            case METASEQUOIA: {
                return (Item)PFItems.METASEQUOIA_BOAT.get();
            }
            case PROTOPICEOXYLON: {
                return (Item)PFItems.PROTOPICEOXYLON_BOAT.get();
            }
            case ZAMITES: {
                return (Item)PFItems.ZAMITES_BOAT.get();
            }
            case PROTOJUNIPER: {
                return (Item)PFItems.PROTOJUNIPER_BOAT.get();
            }
            case HEIDIPHYLLUM: {
                return (Item)PFItems.HEIDIPHYLLUM_BOAT.get();
            }
            case LIRIODENDRITES: {
                return (Item)PFItems.LIRIODENDRITES_BOAT.get();
            }
            case GINKGO: {
                return (Item)PFItems.GINKGO_BOAT.get();
            }
            case TROCHODENDROIDES: {
                return (Item)PFItems.TROCHODENDROIDES_BOAT.get();
            }
            case BRACHYPHYLLUM: {
                return (Item)PFItems.BRACHYPHYLLUM_BOAT.get();
            }
            case AGATHOXYLON: {
                return (Item)PFItems.AGATHOXYLON_BOAT.get();
            }
            case WOODWORTHIA: {
                return (Item)PFItems.WOODWORTHIA_BOAT.get();
            }
            case SCHILDERIA: 
        }
        return (Item)PFItems.SCHILDERIA_BOAT.get();
    }

    public Block getPlanks() {
        switch (this.getPFBoatType()) {
            default: {
                return PFBlocks.ARAUCARIA_PLANKS;
            }
            case METASEQUOIA: {
                return PFBlocks.METASEQUOIA_PLANKS;
            }
            case PROTOPICEOXYLON: {
                return PFBlocks.PROTOPICEOXYLON_PLANKS;
            }
            case ZAMITES: {
                return PFBlocks.ZAMITES_PLANKS;
            }
            case PROTOJUNIPER: {
                return PFBlocks.PROTOJUNIPEROXYLON_PLANKS;
            }
            case HEIDIPHYLLUM: {
                return PFBlocks.HEIDIPHYLLUM_PLANKS;
            }
            case LIRIODENDRITES: {
                return PFBlocks.LIRIODENDRITES_PLANKS;
            }
            case GINKGO: {
                return PFBlocks.GINKGO_PLANKS;
            }
            case TROCHODENDROIDES: {
                return PFBlocks.TROCHODENDROIDES_PLANKS;
            }
            case BRACHYPHYLLUM: {
                return PFBlocks.BRACHYPHYLLUM_PLANKS;
            }
            case AGATHOXYLON: {
                return PFBlocks.AGATHOXYLON_PLANKS;
            }
            case WOODWORTHIA: {
                return PFBlocks.WOODWORTHIA_PLANKS;
            }
            case SCHILDERIA: 
        }
        return PFBlocks.SCHILDERIA_PLANKS;
    }

    public PFType getPFBoatType() {
        return PFType.byId((Integer)this.field_70180_af.func_187225_a(PF_BOAT_TYPE));
    }

    public void setPFBoatType(PFType boatPFType) {
        this.field_70180_af.func_187227_b(PF_BOAT_TYPE, (Object)boatPFType.ordinal());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PF_BOAT_TYPE, (Object)PFType.ARAUCARIA.ordinal());
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("PFType", this.getPFBoatType().getName());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("PFType", 8)) {
            this.setPFBoatType(PFType.getTypeFromString(compound.func_74779_i("PFType")));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.func_70269_c(-this.func_70267_i());
        this.func_70265_b(10);
        this.func_70266_a(this.func_70271_g() * 11.0f);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.lastYd = this.func_213322_ci().field_72448_b;
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.status != BoatEntity.Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_225503_b_(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            for (int i = 0; i < 3; ++i) {
                                this.func_199703_a((IItemProvider)this.getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.func_199703_a((IItemProvider)Items.field_151055_y);
                            }
                            this.func_199703_a((IItemProvider)Blocks.field_150350_a);
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (!this.field_70170_p.func_204610_c(new BlockPos(this.func_213303_ch()).func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a) && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source instanceof IndirectEntityDamageSource && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.func_70269_c(-this.func_70267_i());
            this.func_70265_b(10);
            this.func_70266_a(this.func_70271_g() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.func_70271_g() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199703_a((IItemProvider)this.func_184455_j());
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum PFType {
        ARAUCARIA("araucaria"),
        METASEQUOIA("metasequoia"),
        PROTOPICEOXYLON("protopiceoxylon"),
        ZAMITES("zamites"),
        PROTOJUNIPER("protojuniper"),
        HEIDIPHYLLUM("heidiphyllum"),
        LIRIODENDRITES("liriodendrites"),
        GINKGO("ginkgo"),
        TROCHODENDROIDES("trochodendroides"),
        BRACHYPHYLLUM("brachyphyllum"),
        AGATHOXYLON("agathoxylon"),
        WOODWORTHIA("woodworthia"),
        SCHILDERIA("schilderia");

        private final String name;

        private PFType(String string2) {
            this.name = string2;
        }

        public static PFType byId(int id) {
            PFType[] aPFBoatEntity$PFType = PFType.values();
            if (id < 0 || id >= aPFBoatEntity$PFType.length) {
                id = 0;
            }
            return aPFBoatEntity$PFType[id];
        }

        public static PFType getTypeFromString(String nameIn) {
            PFType[] aPFBoatEntity$PFType;
            for (PFType PFType2 : aPFBoatEntity$PFType = PFType.values()) {
                if (!PFType2.getName().equals(nameIn)) continue;
                return PFType2;
            }
            return aPFBoatEntity$PFType[0];
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

