/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entities;

import java.util.Random;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;

public class DinosaurEntity
extends TameableEntity {
    private static final DataParameter<Boolean> ASLEEP = EntityDataManager.func_187226_a(DinosaurEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ATTACK_TICK = EntityDataManager.func_187226_a(DinosaurEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ATTACK_DIR = EntityDataManager.func_187226_a(DinosaurEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private float sleepProgress = 0.0f;
    private float prevSleepProgress = 0.0f;
    private float meleeProgress = 0.0f;
    private float prevMeleeProgress = 0.0f;

    public DinosaurEntity(EntityType<? extends TameableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static boolean canDinosaurSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return (worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)Tags.Blocks.DIRT) || worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)Tags.Blocks.SAND)) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public boolean isAsleep() {
        return (Boolean)this.field_70180_af.func_187225_a(ASLEEP);
    }

    public void setAsleep(boolean isAsleep) {
        this.field_70180_af.func_187227_b(ASLEEP, (Object)isAsleep);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ASLEEP, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_TICK, (Object)0);
        this.field_70180_af.func_187214_a(ATTACK_DIR, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsAsleep", this.isAsleep());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setAsleep(compound.func_74767_n("IsAsleep"));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevSleepProgress = this.sleepProgress;
        this.prevMeleeProgress = this.meleeProgress;
        if (this.isAsleep() && this.sleepProgress < 1.0f) {
            this.sleepProgress = Math.min(this.sleepProgress + 0.2f, 1.0f);
        }
        if (!this.isAsleep() && this.sleepProgress > 0.0f) {
            this.sleepProgress = Math.max(this.sleepProgress - 0.2f, 0.0f);
        }
        if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) > 0) {
            LivingEntity target = this.func_70638_az();
            if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) == 1 && target != null && this.func_70685_l((Entity)target) && this.func_70032_d((Entity)target) < this.getMeleeRange() + this.func_213311_cf() + target.func_213311_cf()) {
                this.onAttackAnimationFinish((Entity)target);
            }
            this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) - 1));
            if (this.meleeProgress < 1.0f) {
                this.meleeProgress = Math.min(this.meleeProgress + 0.2f, 1.0f);
            }
        } else if (this.meleeProgress > 0.0f) {
            this.meleeProgress = Math.max(this.meleeProgress - 0.2f, 0.0f);
        }
    }

    public float getMeleeRange() {
        return 1.5f;
    }

    public boolean getMeleeDirection() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACK_DIR);
    }

    public boolean func_70652_k(Entity entityIn) {
        if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) == 0) {
            this.field_70180_af.func_187227_b(ATTACK_DIR, (Object)this.field_70146_Z.nextBoolean());
        }
        this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)7);
        return true;
    }

    public boolean onAttackAnimationFinish(Entity target) {
        return target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
    }

    public float getSleepProgress(float partialTick) {
        return this.prevSleepProgress + (this.sleepProgress - this.prevSleepProgress) * partialTick;
    }

    public float getMeleeProgress(float partialTick) {
        return this.prevMeleeProgress + (this.meleeProgress - this.prevMeleeProgress) * partialTick;
    }

    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }
}

