/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import superlord.prehistoricfauna.common.blocks.ZamitesFrondsBlock;
import superlord.prehistoricfauna.init.PFBlocks;

public class ZamitesSaplingBlock
extends Block
implements IPlantable,
IGrowable {
    public static final IntegerProperty STAGE = BlockStateProperties.field_208137_al;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);

    public ZamitesSaplingBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_201696_r(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
            this.grow(worldIn, pos, state, rand);
        }
    }

    public void grow(ServerWorld serverWorld, BlockPos pos, BlockState state, Random rand) {
        if ((Integer)state.func_177229_b((Property)STAGE) == 0) {
            serverWorld.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)STAGE), 4);
        } else {
            if (!ForgeEventFactory.saplingGrowTree((IWorld)serverWorld, (Random)rand, (BlockPos)pos)) {
                return;
            }
            this.grow((IWorld)serverWorld, pos);
        }
    }

    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150458_ak;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        if (state.func_177230_c() == this) {
            return worldIn.func_180495_p(blockpos).canSustainPlant((IBlockReader)worldIn, blockpos, Direction.UP, (IPlantable)this);
        }
        return this.isValidGround(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STAGE});
    }

    public void grow(IWorld world, BlockPos pos) {
        Random rand = new Random();
        int height = rand.nextInt(3) + 1;
        int frondsChance = rand.nextInt(2);
        int secondFrondsChance = rand.nextInt(2);
        int secondFrondsHeight = rand.nextInt(2) + 1;
        int secondFrondsDirection = rand.nextInt(4);
        int frondsHeight = rand.nextInt(2) + 1;
        int frondsDirection = rand.nextInt(4);
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 2 <= 256) {
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + height; ++j) {
                world.func_180501_a(new BlockPos(x, j, z), PFBlocks.ZAMITES_LOG.func_176223_P(), 2);
                if (frondsChance == 0) {
                    if (frondsDirection == 0 && ZamitesSaplingBlock.isAir(world, new BlockPos(x + 1, pos.func_177956_o() + frondsHeight, z))) {
                        world.func_180501_a(new BlockPos(x + 1, pos.func_177956_o() + frondsHeight, z), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.WEST), 2);
                    }
                    if (frondsDirection == 1 && ZamitesSaplingBlock.isAir(world, new BlockPos(x + 0, pos.func_177956_o() + frondsHeight, z + 1))) {
                        world.func_180501_a(new BlockPos(x + 0, pos.func_177956_o() + frondsHeight, z + 1), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.NORTH), 2);
                    }
                    if (frondsDirection == 2 && ZamitesSaplingBlock.isAir(world, new BlockPos(x + 0, pos.func_177956_o() + frondsHeight, z - 1))) {
                        world.func_180501_a(new BlockPos(x + 0, pos.func_177956_o() + frondsHeight, z - 1), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.SOUTH), 2);
                    }
                    if (frondsDirection == 3 && ZamitesSaplingBlock.isAir(world, new BlockPos(x - 1, pos.func_177956_o() + frondsHeight, z - 0))) {
                        world.func_180501_a(new BlockPos(x - 1, pos.func_177956_o() + frondsHeight, z - 0), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.EAST), 2);
                    }
                }
                if (secondFrondsChance != 2) continue;
                if (secondFrondsDirection == 0 && ZamitesSaplingBlock.isAir(world, new BlockPos(x + 1, pos.func_177956_o() + secondFrondsHeight, z))) {
                    world.func_180501_a(new BlockPos(x + 1, pos.func_177956_o() + secondFrondsHeight, z), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.WEST), 2);
                }
                if (secondFrondsDirection == 1 && ZamitesSaplingBlock.isAir(world, new BlockPos(x + 0, pos.func_177956_o() + secondFrondsHeight, z + 1))) {
                    world.func_180501_a(new BlockPos(x + 0, pos.func_177956_o() + secondFrondsHeight, z + 1), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.NORTH), 2);
                }
                if (secondFrondsDirection == 2 && ZamitesSaplingBlock.isAir(world, new BlockPos(x + 0, pos.func_177956_o() + secondFrondsHeight, z - 1))) {
                    world.func_180501_a(new BlockPos(x + 0, pos.func_177956_o() + secondFrondsHeight, z - 1), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.SOUTH), 2);
                }
                if (secondFrondsDirection != 3 || !ZamitesSaplingBlock.isAir(world, new BlockPos(x - 1, pos.func_177956_o() + secondFrondsHeight, z - 0))) continue;
                world.func_180501_a(new BlockPos(x - 1, pos.func_177956_o() + secondFrondsHeight, z - 0), (BlockState)PFBlocks.ZAMITES_FROND.func_176223_P().func_206870_a((Property)ZamitesFrondsBlock.field_185512_D, (Comparable)Direction.EAST), 2);
            }
            if (ZamitesSaplingBlock.isAir(world, new BlockPos(x, pos.func_177956_o() + height + 1, z))) {
                world.func_180501_a(new BlockPos(x, pos.func_177956_o() + height + 1, z), PFBlocks.ZAMITES_LEAVES.func_176223_P(), 2);
            }
        }
    }

    public static boolean isAir(IWorld worldIn, BlockPos pos) {
        if (worldIn instanceof IBlockReader) {
            return worldIn.func_217375_a(pos, state -> state.isAir((IBlockReader)worldIn, pos));
        }
        return worldIn.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f);
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        this.grow(worldIn, pos, state, rand);
    }
}

