/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFDimensions;
import superlord.prehistoricfauna.init.PFParticles;
import superlord.prehistoricfauna.init.SoundInit;
import superlord.prehistoricfauna.world.dimension.JurassicTeleporter;

public class JurassicPortalBlock
extends BreakableBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    protected static final VoxelShape X_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public JurassicPortalBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    protected void updateNeighbors(World worldIn, BlockPos pos) {
        worldIn.func_195593_d(pos, (Block)this);
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public boolean tryToCreatePortal(World world, BlockPos pos) {
        Size jurassicPortalSize = this.isPortal((IWorld)world, pos);
        if (jurassicPortalSize != null && this.canCreatePortalByWorld(world, pos)) {
            jurassicPortalSize.placePortalBlocks();
            return true;
        }
        return false;
    }

    private boolean canCreatePortalByWorld(World world, BlockPos pos) {
        if (world.func_234923_W_() == World.field_234918_g_) {
            return true;
        }
        return world.func_234923_W_() == PFDimensions.CRETACEOUS_WORLD || world.func_234923_W_() == PFDimensions.JURASSIC_WORLD || world.func_234923_W_() == PFDimensions.TRIASSIC_WORLD;
    }

    @Nullable
    public Size isPortal(IWorld world, BlockPos pos) {
        Size jurassicPortalSizeX = new Size(world, pos, Direction.Axis.X);
        if (jurassicPortalSizeX.isValid() && jurassicPortalSizeX.portalBlockCount == 0) {
            return jurassicPortalSizeX;
        }
        Size jurassicPortalSizeZ = new Size(world, pos, Direction.Axis.Z);
        return jurassicPortalSizeZ.isValid() && jurassicPortalSizeZ.portalBlockCount == 0 ? jurassicPortalSizeZ : null;
    }

    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis directionAxis = facing.func_176740_k();
        Direction.Axis directionAxis1 = (Direction.Axis)state.func_177229_b(AXIS);
        boolean flag = directionAxis1 != directionAxis && directionAxis.func_176722_c();
        return !flag && facingState.func_177230_c() != this && !new Size(world, currentPos, directionAxis1).canCreatePortal() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    @Deprecated
    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
            if (entity.func_242280_ah()) {
                entity.func_242279_ag();
            } else {
                RegistryKey<World> registryKey;
                ServerWorld serverWorld;
                MinecraftServer minecraftServer;
                ServerWorld serverWorld1;
                if (!entity.field_70170_p.func_201670_d() && !pos.equals((Object)entity.field_242271_ac)) {
                    entity.field_242271_ac = pos.func_185334_h();
                }
                if (entity.field_70170_p instanceof ServerWorld && (serverWorld1 = (minecraftServer = (serverWorld = (ServerWorld)entity.field_70170_p).func_73046_m()).func_71218_a(registryKey = entity.field_70170_p.func_234923_W_() == PFDimensions.JURASSIC_WORLD ? World.field_234918_g_ : PFDimensions.JURASSIC_WORLD)) != null && !entity.func_184218_aH()) {
                    entity.func_242279_ag();
                    entity.changeDimension(serverWorld1, (ITeleporter)new JurassicTeleporter(serverWorld1));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundInit.PORTAL, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 2; ++i) {
            double x = (float)pos.func_177958_n() + rand.nextFloat();
            double y = (float)pos.func_177956_o() + rand.nextFloat();
            double z = (float)pos.func_177952_p() + rand.nextFloat();
            double sX = ((double)rand.nextFloat() - 0.5) * 0.5;
            double sY = ((double)rand.nextFloat() - 0.5) * 0.5;
            double sZ = ((double)rand.nextFloat() - 0.5) * 0.5;
            int mul = rand.nextInt(2) * 2 - 1;
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                x = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)mul;
                sX = rand.nextFloat() * 2.0f * (float)mul;
            } else {
                z = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)mul;
                sZ = rand.nextFloat() * 2.0f * (float)mul;
            }
            world.func_195594_a((IParticleData)PFParticles.PORTAL_PARTICLE, x, y, z, sX, sY, sZ);
        }
    }

    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS});
    }

    public static class Size {
        private final IWorld world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private static final AbstractBlock.IPositionPredicate FRAME_TEST = (state, reader, pos) -> state.func_177230_c() == PFBlocks.PORTAL_FRAME;
        private final Block PORTAL = (Block)PFBlocks.JURASSIC_PORTAL.get();

        public Size(IWorld world, BlockPos pos, Direction.Axis facing) {
            this.world = world;
            this.axis = facing;
            this.rightDir = facing == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
            this.bottomLeft = this.calculateBottomLeft(pos);
            if (this.bottomLeft == null) {
                this.bottomLeft = pos;
                this.width = 1;
                this.height = 1;
            } else {
                this.width = this.calculatePortalWidth();
                if (this.width > 0) {
                    this.height = this.calculatePortalHeight();
                }
            }
        }

        @Nullable
        private BlockPos calculateBottomLeft(BlockPos pos) {
            int i = Math.max(0, pos.func_177956_o() - 21);
            while (pos.func_177956_o() > i && this.isEmptyBlock(this.world.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            Direction direction = this.rightDir.func_176734_d();
            int j = this.getDistanceUntilEdge(pos, direction) - 1;
            return j < 0 ? null : pos.func_177967_a(direction, j);
        }

        private int getDistanceUntilEdge(BlockPos pos, Direction facing) {
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (int i = 0; i < 22; ++i) {
                mutable.func_189533_g((Vector3i)pos).func_189534_c(facing, i);
                BlockState state = this.world.func_180495_p((BlockPos)mutable);
                if (!this.isEmptyBlock(state)) {
                    if (!FRAME_TEST.test(state, (IBlockReader)this.world, (BlockPos)mutable)) break;
                    return i;
                }
                BlockState state1 = this.world.func_180495_p((BlockPos)mutable.func_189536_c(Direction.DOWN));
                if (!FRAME_TEST.test(state1, (IBlockReader)this.world, (BlockPos)mutable)) break;
            }
            return 0;
        }

        private int calculatePortalWidth() {
            int dist = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
            return dist >= 3 && dist <= 21 ? dist : 0;
        }

        private int calculatePortalHeight() {
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            int dist = this.getDistanceUntilTop(mutable);
            return dist >= 3 && dist <= 21 && this.hasTopFrame(mutable, dist) ? dist : 0;
        }

        private int getDistanceUntilTop(BlockPos.Mutable mutable) {
            for (int i = 0; i < 21; ++i) {
                mutable.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, -1);
                if (!FRAME_TEST.test(this.world.func_180495_p((BlockPos)mutable), (IBlockReader)this.world, (BlockPos)mutable)) {
                    return i;
                }
                mutable.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, this.width);
                if (!FRAME_TEST.test(this.world.func_180495_p((BlockPos)mutable), (IBlockReader)this.world, (BlockPos)mutable)) {
                    return i;
                }
                for (int j = 0; j < this.width; ++j) {
                    mutable.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, j);
                    BlockState blockstate = this.world.func_180495_p((BlockPos)mutable);
                    if (!this.isEmptyBlock(blockstate)) {
                        return i;
                    }
                    if (blockstate.func_177230_c() != this.PORTAL) continue;
                    ++this.portalBlockCount;
                }
            }
            return 21;
        }

        private boolean hasTopFrame(BlockPos.Mutable mutable, int offset) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos.Mutable mutablePos = mutable.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, offset).func_189534_c(this.rightDir, i);
                if (FRAME_TEST.test(this.world.func_180495_p((BlockPos)mutablePos), (IBlockReader)this.world, (BlockPos)mutablePos)) continue;
                return false;
            }
            return true;
        }

        private boolean isEmptyBlock(BlockState state) {
            Block block = state.func_177230_c();
            return state.func_196958_f() || block == PFBlocks.JURASSIC_TIME_BLOCK || block == this.PORTAL;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 3 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            BlockState state = (BlockState)this.PORTAL.func_176223_P().func_206870_a(AXIS, (Comparable)this.axis);
            BlockPos.func_218278_a((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.func_177967_a(Direction.UP, this.height - 1).func_177967_a(this.rightDir, this.width - 1)).forEach(pos -> this.world.func_180501_a(pos, state, 18));
        }

        public boolean canCreatePortal() {
            return this.isValid() && this.isLargeEnough();
        }

        private boolean isLargeEnough() {
            return this.portalBlockCount == this.width * this.height;
        }
    }
}

