/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.blocks;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockMaterialMatcher;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.enchantment.IArmorVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import superlord.prehistoricfauna.init.PFBlocks;

public class CarvedTuberBlock
extends HorizontalBlock
implements IArmorVanishable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    @Nullable
    private BlockPattern snowmanBasePattern;
    @Nullable
    private BlockPattern snowmanPattern;
    @Nullable
    private BlockPattern golemBasePattern;
    @Nullable
    private BlockPattern golemPattern;
    private static final Predicate<BlockState> IS_TUBER = state -> state != null && (state.func_203425_a(PFBlocks.CARVED_TUBER) || state.func_203425_a(PFBlocks.CARVED_TUBER_LIT) || state.func_203425_a(PFBlocks.CARVED_TUBER_SOUL_LIT) || state.func_203425_a(PFBlocks.CARVED_TUBER_TIME_LIT));

    public CarvedTuberBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c())) {
            this.trySpawnGolem(worldIn, pos);
        }
    }

    public boolean canDispenserPlace(IWorldReader reader, BlockPos pos) {
        return this.getSnowmanBasePattern().func_177681_a(reader, pos) != null || this.getGolemBasePattern().func_177681_a(reader, pos) != null;
    }

    private void trySpawnGolem(World world, BlockPos pos) {
        block9: {
            BlockPattern.PatternHelper blockpattern$patternhelper;
            block8: {
                blockpattern$patternhelper = this.getSnowmanPattern().func_177681_a((IWorldReader)world, pos);
                if (blockpattern$patternhelper == null) break block8;
                for (int i = 0; i < this.getSnowmanPattern().func_177685_b(); ++i) {
                    CachedBlockInfo cachedblockinfo = blockpattern$patternhelper.func_177670_a(0, i, 0);
                    world.func_180501_a(cachedblockinfo.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                    world.func_217379_c(2001, cachedblockinfo.func_177508_d(), Block.func_196246_j((BlockState)cachedblockinfo.func_177509_a()));
                }
                SnowGolemEntity snowgolementity = (SnowGolemEntity)EntityType.field_200745_ak.func_200721_a(world);
                BlockPos blockpos1 = blockpattern$patternhelper.func_177670_a(0, 2, 0).func_177508_d();
                snowgolementity.func_70012_b((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.05, (double)blockpos1.func_177952_p() + 0.5, 0.0f, 0.0f);
                world.func_217376_c((Entity)snowgolementity);
                for (ServerPlayerEntity serverplayerentity : world.func_217357_a(ServerPlayerEntity.class, snowgolementity.func_174813_aQ().func_186662_g(5.0))) {
                    CriteriaTriggers.field_192133_m.func_192229_a(serverplayerentity, (Entity)snowgolementity);
                }
                for (int l = 0; l < this.getSnowmanPattern().func_177685_b(); ++l) {
                    CachedBlockInfo cachedblockinfo3 = blockpattern$patternhelper.func_177670_a(0, l, 0);
                    world.func_230547_a_(cachedblockinfo3.func_177508_d(), Blocks.field_150350_a);
                }
                break block9;
            }
            blockpattern$patternhelper = this.getGolemPattern().func_177681_a((IWorldReader)world, pos);
            if (blockpattern$patternhelper == null) break block9;
            for (int j = 0; j < this.getGolemPattern().func_177684_c(); ++j) {
                for (int k = 0; k < this.getGolemPattern().func_177685_b(); ++k) {
                    CachedBlockInfo cachedblockinfo2 = blockpattern$patternhelper.func_177670_a(j, k, 0);
                    world.func_180501_a(cachedblockinfo2.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                    world.func_217379_c(2001, cachedblockinfo2.func_177508_d(), Block.func_196246_j((BlockState)cachedblockinfo2.func_177509_a()));
                }
            }
            BlockPos blockpos = blockpattern$patternhelper.func_177670_a(1, 2, 0).func_177508_d();
            IronGolemEntity irongolementity = (IronGolemEntity)EntityType.field_200757_aw.func_200721_a(world);
            irongolementity.func_70849_f(true);
            irongolementity.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.05, (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
            world.func_217376_c((Entity)irongolementity);
            for (ServerPlayerEntity serverplayerentity1 : world.func_217357_a(ServerPlayerEntity.class, irongolementity.func_174813_aQ().func_186662_g(5.0))) {
                CriteriaTriggers.field_192133_m.func_192229_a(serverplayerentity1, (Entity)irongolementity);
            }
            for (int i1 = 0; i1 < this.getGolemPattern().func_177684_c(); ++i1) {
                for (int j1 = 0; j1 < this.getGolemPattern().func_177685_b(); ++j1) {
                    CachedBlockInfo cachedblockinfo1 = blockpattern$patternhelper.func_177670_a(i1, j1, 0);
                    world.func_230547_a_(cachedblockinfo1.func_177508_d(), Blocks.field_150350_a);
                }
            }
        }
    }

    private BlockPattern getSnowmanBasePattern() {
        if (this.snowmanBasePattern == null) {
            this.snowmanBasePattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{" ", "#", "#"}).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_196604_cC))).func_177661_b();
        }
        return this.snowmanBasePattern;
    }

    private BlockPattern getSnowmanPattern() {
        if (this.snowmanPattern == null) {
            this.snowmanPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"^", "#", "#"}).func_177662_a('^', CachedBlockInfo.func_177510_a(IS_TUBER)).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_196604_cC))).func_177661_b();
        }
        return this.snowmanPattern;
    }

    private BlockPattern getGolemBasePattern() {
        if (this.golemBasePattern == null) {
            this.golemBasePattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"~ ~", "###", "~#~"}).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150339_S))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.golemBasePattern;
    }

    private BlockPattern getGolemPattern() {
        if (this.golemPattern == null) {
            this.golemPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"~^~", "###", "~#~"}).func_177662_a('^', CachedBlockInfo.func_177510_a(IS_TUBER)).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150339_S))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.golemPattern;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }
}

