/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractTrapBlock
extends Block {
    protected static final VoxelShape COLLISION_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    protected static final VoxelShape OUTLINE_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final AxisAlignedBB PRESSURE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875);

    protected AbstractTrapBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return COLLISION_SHAPE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return OUTLINE_SHAPE;
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 20;
    }

    public boolean func_181623_g() {
        return true;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        int i = this.getRedstoneStrength(state);
        if (i > 0) {
            this.updateState((World)worldIn, pos, state, i);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        int i;
        if (!worldIn.field_72995_K && (i = this.getRedstoneStrength(state)) == 0) {
            this.updateState(worldIn, pos, state, i);
        }
    }

    protected void updateState(World worldIn, BlockPos pos, BlockState state, int oldRedstoneStrength) {
        boolean flag1;
        int i = this.computeRedstoneStrength(worldIn, pos);
        boolean flag = oldRedstoneStrength > 0;
        boolean bl = flag1 = i > 0;
        if (oldRedstoneStrength != i) {
            BlockState blockstate = this.setRedstoneStrength(state, i);
            worldIn.func_180501_a(pos, blockstate, 2);
            this.updateNeighbors(worldIn, pos);
            worldIn.func_225319_b(pos, state, blockstate);
        }
        if (!flag1 && flag) {
            this.playClickOffSound((IWorld)worldIn, pos);
        } else if (flag1 && !flag) {
            this.playClickOnSound((IWorld)worldIn, pos);
        }
        if (flag1) {
            worldIn.func_205220_G_().func_205360_a(new BlockPos((Vector3i)pos), (Object)this, this.func_149738_a((IWorldReader)worldIn));
        }
    }

    protected abstract void playClickOnSound(IWorld var1, BlockPos var2);

    protected abstract void playClickOffSound(IWorld var1, BlockPos var2);

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            if (this.getRedstoneStrength(state) > 0) {
                this.updateNeighbors(worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    protected void updateNeighbors(World worldIn, BlockPos pos) {
        worldIn.func_195593_d(pos, (Block)this);
        worldIn.func_195593_d(pos.func_177977_b(), (Block)this);
    }

    protected abstract int computeRedstoneStrength(World var1, BlockPos var2);

    protected abstract int getRedstoneStrength(BlockState var1);

    protected abstract BlockState setRedstoneStrength(BlockState var1, int var2);
}

