/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.util;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import superlord.prehistoricfauna.client.render.tileentity.PFEditSignScreen;
import superlord.prehistoricfauna.client.util.PFPacketHandler;
import superlord.prehistoricfauna.common.entities.tile.PFSignTileEntity;

public class PacketToClientSign {
    private boolean messageIsValid;
    private BlockPos pos;

    public PacketToClientSign(BlockPos pos) {
        this.pos = pos;
        this.messageIsValid = true;
    }

    public PacketToClientSign(PacketBuffer packetBuffer) {
        this.pos = packetBuffer.func_179259_c();
        this.messageIsValid = packetBuffer.readBoolean();
    }

    public PacketToClientSign() {
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.func_179255_a(this.pos);
        packetBuffer.writeBoolean(this.messageIsValid);
    }

    public static PacketToClientSign decoder(PacketBuffer packetBuffer) {
        PacketToClientSign packet = new PacketToClientSign();
        packet.pos = packetBuffer.func_179259_c();
        packet.messageIsValid = packetBuffer.readBoolean();
        return packet;
    }

    public static void handle(PacketToClientSign packet, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        if (context != null) {
            if (packet != null && packet.messageIsValid) {
                context.enqueueWork(() -> PacketToClientSign.handleOnClient(packet));
                context.setPacketHandled(true);
            } else {
                context.setPacketHandled(false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(PacketToClientSign packet) {
        TileEntity tileEntity;
        if (Minecraft.func_71410_x().field_71441_e != null && (tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(packet.pos)) instanceof PFSignTileEntity) {
            PFSignTileEntity signTileEntity = (PFSignTileEntity)tileEntity;
            Minecraft.func_71410_x().func_147108_a((Screen)new PFEditSignScreen(signTileEntity));
        }
    }

    public static void sendMessage(ServerPlayerEntity player, BlockPos pos) {
        PFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketToClientSign(pos));
    }
}

