/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.render.triassic.chinle;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.client.model.triassic.chinle.PoposaurusModel;
import superlord.prehistoricfauna.client.render.layer.PoposaurusEyeLayer;
import superlord.prehistoricfauna.common.entities.triassic.chinle.PoposaurusEntity;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;

@OnlyIn(value=Dist.CLIENT)
public class PoposaurusRenderer
extends MobRenderer<PoposaurusEntity, EntityModel<PoposaurusEntity>> {
    private static final PoposaurusModel POPOSAURUS_MODEL = new PoposaurusModel();
    private static final ResourceLocation POPOSAURUS_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/poposaurus/poposaurus.png");
    private static final ResourceLocation POPOSAURUS_TEXTURE_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/poposaurus/poposaurus_sleeping.png");
    private static final ResourceLocation ALBINO = new ResourceLocation("prehistoricfauna", "textures/entities/poposaurus/albino.png");
    private static final ResourceLocation ALBINO_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/poposaurus/albino_sleeping.png");
    private static final ResourceLocation MELANISTIC = new ResourceLocation("prehistoricfauna", "textures/entities/poposaurus/melanistic.png");
    private static final ResourceLocation MELANISTIC_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/poposaurus/melanistic_sleeping.png");

    public PoposaurusRenderer() {
        super(Minecraft.func_71410_x().func_175598_ae(), (EntityModel)POPOSAURUS_MODEL, 1.0f);
        if (PrehistoricFaunaConfig.eyeShine) {
            this.func_177094_a(new PoposaurusEyeLayer((IEntityRenderer<PoposaurusEntity, EntityModel<PoposaurusEntity>>)this));
        }
    }

    protected void preRenderCallback(PoposaurusEntity poposaurus, MatrixStack matrixStackIn, float partialTickTime) {
        if (poposaurus.func_70631_g_()) {
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        }
    }

    public ResourceLocation getEntityTexture(PoposaurusEntity entity) {
        if (entity.isAlbino()) {
            if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
                return ALBINO_SLEEPING;
            }
            return ALBINO;
        }
        if (entity.isMelanistic()) {
            if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
                return MELANISTIC_SLEEPING;
            }
            return MELANISTIC;
        }
        if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
            return POPOSAURUS_TEXTURE_SLEEPING;
        }
        return POPOSAURUS_TEXTURE;
    }
}

