/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.render.tileentity.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;
import superlord.prehistoricfauna.PrehistoricFauna;
import superlord.prehistoricfauna.client.render.tileentity.ChangePageButton;
import superlord.prehistoricfauna.client.render.tileentity.IndexPageButton;
import superlord.prehistoricfauna.client.util.StatCollector;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFItems;

@OnlyIn(value=Dist.CLIENT)
public class GuiPaleo
extends Screen {
    protected static final int X = 390;
    protected static final int Y = 245;
    private static final ResourceLocation TEXTURE = new ResourceLocation("prehistoricfauna:textures/gui/paleopedia/paleopedia.png");
    private static final ResourceLocation DRAWINGS_0 = new ResourceLocation("prehistoricfauna:textures/gui/paleopedia/drawings_0.png");
    private static final Map<String, ResourceLocation> PICTURE_LOCATION_CACHE = Maps.newHashMap();
    public List<EnumPaleoPages> allPageTypes = new ArrayList<EnumPaleoPages>();
    public EnumPaleoPages pageType;
    public List<IndexPageButton> indexButtons = new ArrayList<IndexPageButton>();
    public ChangePageButton previousPage;
    public ChangePageButton nextPage;
    public int bookPages;
    public int bookPagesTotal = 1;
    public int indexPages;
    public int indexPagesTotal = 1;
    protected ItemStack book;
    protected boolean index;
    protected FontRenderer field_230712_o_ = this.getFont();

    public GuiPaleo(ItemStack book) {
        super((ITextComponent)new TranslationTextComponent("paleopedia_gui"));
        this.book = book;
        boolean indexPageTotal = false;
        if (!book.func_190926_b() && book.func_77973_b() != null && book.func_77973_b() == PFItems.PALEOPEDIA.get() && book.func_77978_p() != null) {
            List<EnumPaleoPages> pages = EnumPaleoPages.containedPages(EnumPaleoPages.toList(book.func_77978_p().func_74759_k("Pages")));
            this.allPageTypes.addAll(pages);
            this.indexPagesTotal = (int)Math.ceil((double)pages.size() / 10.0);
        }
        this.index = true;
    }

    private FontRenderer getFont() {
        FontRenderer font = !Minecraft.func_71410_x().field_71474_y.field_74363_ab.equalsIgnoreCase("en_us") ? Minecraft.func_71410_x().field_71466_p : (FontRenderer)PrehistoricFauna.PROXY.getFontRenderer();
        return font;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int centerX = (this.field_230708_k_ - 390) / 2;
        int centerY = (this.field_230709_l_ - 245) / 2;
        this.previousPage = new ChangePageButton(centerX + 25, centerY + 215, false, this.bookPages, 0, p_214132_1_ -> {
            if (this.index ? this.indexPages > 0 : this.pageType != null) {
                if (this.index) {
                    --this.indexPages;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
                } else if (this.bookPages > 0) {
                    --this.bookPages;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
                } else {
                    this.index = true;
                }
            }
        });
        this.func_230480_a_((Widget)this.previousPage);
        this.nextPage = new ChangePageButton(centerX + 347, centerY + 215, true, this.bookPages, 0, p_214132_1_ -> {
            if (this.index ? this.indexPages < this.indexPagesTotal - 1 : this.pageType != null && this.bookPages < this.pageType.pages) {
                if (this.index) {
                    ++this.indexPages;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
                } else {
                    ++this.bookPages;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
                }
            }
        });
        this.func_230480_a_((Widget)this.nextPage);
        if (!this.allPageTypes.isEmpty()) {
            for (int i = 0; i < this.allPageTypes.size(); ++i) {
                int xIndex = i % -2;
                int yIndex = i % 10;
                int id = 2 + i;
                IndexPageButton button = new IndexPageButton(id, centerX + 15 + xIndex * 200, centerY + 10 + yIndex * 20 - (xIndex == 1 ? 20 : 0), (ITextComponent)new TranslationTextComponent("paleopedia." + EnumPaleoPages.values()[this.allPageTypes.get(i).ordinal()].toString().toLowerCase()), p_214132_1_ -> {
                    if (this.indexButtons.get(id - 2) != null && this.allPageTypes.get(id - 2) != null) {
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
                        this.index = false;
                        this.bookPages = 0;
                        this.pageType = this.allPageTypes.get(id - 2);
                    }
                });
                this.indexButtons.add(button);
                this.func_230480_a_((Widget)button);
            }
        }
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
        for (Widget button : this.field_230710_m_) {
            if (!(button instanceof IndexPageButton)) continue;
            button.field_230693_o_ = this.index;
            button.field_230694_p_ = this.index;
        }
        for (int i = 0; i < this.indexButtons.size(); ++i) {
            this.indexButtons.get((int)i).field_230693_o_ = i < 10 * (this.indexPages + 1) && i >= 10 * this.indexPages && this.index;
        }
        this.func_230446_a_(ms);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        int cornerX = (this.field_230708_k_ - 390) / 2;
        int cornerY = (this.field_230709_l_ - 245) / 2;
        GuiPaleo.func_238463_a_((MatrixStack)ms, (int)cornerX, (int)cornerY, (float)0.0f, (float)0.0f, (int)390, (int)245, (int)390, (int)390);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        RenderHelper.func_227780_a_();
        ms.func_227860_a_();
        ms.func_227861_a_((double)cornerX, (double)cornerY, 0.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        int centerX = (this.field_230708_k_ - 390) / 2;
        int centerY = (this.field_230709_l_ - 245) / 2;
        if (!this.index) {
            this.drawPerPage(ms, this.bookPages);
            int pageLeft = this.bookPages * 2 + 1;
            int pageRight = pageLeft + 1;
            this.field_230712_o_.func_238421_b_(ms, "" + pageLeft, (float)centerX, (float)(centerY - 31), 0x303030);
            this.field_230712_o_.func_238421_b_(ms, "" + pageRight, (float)centerX, (float)(centerY - 31), 0x303030);
        }
        GL11.glEnable((int)2896);
        ms.func_227865_b_();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_227780_a_();
    }

    public void drawPerPage(MatrixStack ms, int bookPages) {
        this.imageFromTxt(ms);
        this.writeFromTxt(ms);
    }

    public void imageFromTxt(MatrixStack ms) {
        String fileName = this.pageType.toString().toLowerCase(Locale.ROOT) + "_" + this.bookPages + ".txt";
        ResourceLocation fileLoc = new ResourceLocation("prehistoricfauna:lang/paleopedia/" + Minecraft.func_71410_x().field_71474_y.field_74363_ab + "_0/" + fileName);
        ResourceLocation backupLoc = new ResourceLocation("prehistoricfauna:lang/paleopedia/en_us_0/" + fileName);
        IResource resource = null;
        try {
            resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(fileLoc);
        }
        catch (IOException e) {
            try {
                resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(backupLoc);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            Iterator iterator = IOUtils.readLines((InputStream)resource.func_199027_b(), (String)"UTF-8").iterator();
            String line = null;
            boolean linenumber = false;
            int zLevelAdd = 0;
            while (iterator.hasNext()) {
                String[] split;
                line = ((String)iterator.next()).trim();
                if ((line.contains("<") || line.contains(">")) && line.contains("<image>")) {
                    line = line.substring(8, line.length() - 1);
                    split = line.split(" ");
                    String texture = "prehistoricfauna:textures/gui/paleopedia/" + split[0];
                    ResourceLocation resourcelocation = PICTURE_LOCATION_CACHE.get(texture);
                    if (resourcelocation == null) {
                        resourcelocation = new ResourceLocation(texture);
                        PICTURE_LOCATION_CACHE.put(texture, resourcelocation);
                    }
                    ms.func_227860_a_();
                    this.drawImage(ms, resourcelocation, Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]), Integer.parseInt(split[6]), Float.parseFloat(split[7]) * 512.0f);
                    ms.func_227865_b_();
                }
                if (line.contains("<item>")) {
                    line = line.substring(7, line.length() - 1);
                    split = line.split(" ");
                    RenderHelper.func_227780_a_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)this.getItemByRegistryName(split[0]), 1), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Float.parseFloat(split[4]) * 2.0f);
                }
                if (line.contains("<block>")) {
                    line = line.substring(8, line.length() - 1);
                    split = line.split(" ");
                    RenderHelper.func_227780_a_();
                    this.drawBlockStack(ms, new ItemStack((IItemProvider)this.getItemByRegistryName(split[0]), 1), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Float.parseFloat(split[4]) * 2.0f, ++zLevelAdd);
                }
                if (!line.contains("<recipe>")) continue;
                line = line.substring(9, line.length() - 1);
                split = line.split(" ");
                RenderHelper.func_227780_a_();
                float scale = Float.parseFloat(split[split.length - 1]);
                int x = Integer.parseInt(split[split.length - 3]);
                int y = Integer.parseInt(split[split.length - 2]);
                ItemStack result = new ItemStack((IItemProvider)this.getItemByRegistryName(split[0]), 1);
                ItemStack[] ingredients = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                int j = 8;
                for (int i = split.length - 5; i >= 2; i -= 2) {
                    ingredients[j] = new ItemStack((IItemProvider)this.getItemByRegistryName(split[i]), 1);
                    --j;
                }
                RenderHelper.func_227780_a_();
                ms.func_227860_a_();
                this.drawRecipe(ms, result, ingredients, x, y, scale);
                ms.func_227865_b_();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Item getItemByRegistryName(String registryName) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
    }

    private void drawRecipe(MatrixStack ms, ItemStack result, ItemStack[] ingredients, int x, int y, float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)0.0f);
        this.drawItemStack(ms, result, 62, 17, 2.0f);
        for (int i = 0; i < 9; ++i) {
            this.drawItemStack(ms, ingredients[i], i % 3 * 22 + 30, i / 3 * 22 + 10, 1.25f);
        }
        RenderSystem.popMatrix();
        ms.func_227860_a_();
        ms.func_227861_a_((double)x, (double)y, 0.0);
        ms.func_227862_a_(scale, scale, 0.0f);
        ms.func_227861_a_(37.0, 13.0, 1.0);
        ms.func_227862_a_(1.5f, 1.5f, 1.0f);
        this.drawImage(ms, DRAWINGS_0, 0, 0, 389, 1, 50, 50, 512.0f);
        ms.func_227865_b_();
    }

    public void writeFromTxt(MatrixStack ms) {
        String fileName = this.pageType.toString().toLowerCase(Locale.ROOT) + "_" + this.bookPages + ".txt";
        ResourceLocation fileLoc = new ResourceLocation("prehistoricfauna:lang/paleopedia/" + Minecraft.func_71410_x().field_71474_y.field_74363_ab + "_0/" + fileName);
        ResourceLocation backupLoc = new ResourceLocation("prehistoricfauna:lang/paleopedia/en_us_0/" + fileName);
        IResource resource = null;
        try {
            resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(fileLoc);
        }
        catch (IOException e) {
            try {
                resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(backupLoc);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            Iterator iterator = IOUtils.readLines((InputStream)resource.func_199027_b(), (String)"UTF-8").iterator();
            String line = null;
            int linenumber = 0;
            while (iterator.hasNext()) {
                line = ((String)iterator.next()).trim();
                if (line.contains("<") || line.contains(">")) continue;
                ms.func_227860_a_();
                if (this.usingVanillaFont()) {
                    ms.func_227862_a_(0.945f, 0.945f, 0.945f);
                    ms.func_227861_a_(0.0, 5.5, 0.0);
                }
                if (linenumber <= 19) {
                    this.field_230712_o_.func_238421_b_(ms, line, 23.0f, (float)(20 + linenumber * 10), 0x303030);
                } else {
                    this.field_230712_o_.func_238421_b_(ms, line, 220.0f, (float)((linenumber - 19) * 10), 0x303030);
                }
                ++linenumber;
                ms.func_227865_b_();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ms.func_227860_a_();
        String s = StatCollector.translateToLocal("paleopedia." + this.pageType.toString().toLowerCase(Locale.ROOT));
        float scale = this.field_230712_o_.func_78256_a(s) <= 100 ? 1.5f : (float)this.field_230712_o_.func_78256_a(s) * 0.0125f;
        ms.func_227862_a_(scale, scale, scale);
        this.field_230712_o_.func_238421_b_(ms, s, 25.0f, 7.0f, 8025450);
        ms.func_227865_b_();
    }

    private boolean usingVanillaFont() {
        return this.field_230712_o_ == Minecraft.func_71410_x().field_71466_p;
    }

    public void drawImage(MatrixStack ms, ResourceLocation texture, int x, int y, int u, int v, int width, int height, float scale) {
        ms.func_227860_a_();
        this.getMinecraft().func_110434_K().func_110577_a(texture);
        ms.func_227862_a_(scale / 512.0f, scale / 512.0f, scale / 512.0f);
        GuiPaleo.func_238463_a_((MatrixStack)ms, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)512, (int)512);
        ms.func_227865_b_();
    }

    private void drawItemStack(MatrixStack ms, ItemStack stack, int x, int y, float scale) {
        int cornerX = (this.field_230708_k_ - 390) / 2;
        int cornerY = (this.field_230709_l_ - 245) / 2;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)cornerX, (float)cornerY, (float)32.0f);
        float zLevel = 200.0f;
        this.field_230707_j_.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.getFont();
        }
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        this.field_230707_j_.field_77023_b = -100.0f;
        RenderSystem.depthMask((boolean)true);
        this.field_230707_j_.func_180450_b(stack, x, y);
        zLevel = 0.0f;
        this.field_230707_j_.field_77023_b = 0.0f;
        RenderSystem.popMatrix();
    }

    protected void renderItemModelIntoGUI(MatrixStack ms, ItemStack stack, int x, int y, IBakedModel bakedmodel, float scale) {
        boolean flag;
        int i = (this.field_230708_k_ - 390) / 2;
        int j = (this.field_230709_l_ - 245) / 2;
        RenderSystem.pushMatrix();
        this.getMinecraft().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        this.getMinecraft().func_110434_K().func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.scalef((float)(16.0f * scale), (float)(16.0f * scale), (float)(16.0f * scale));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)x, (float)y, (float)(100.0f + this.field_230707_j_.field_77023_b));
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        MatrixStack matrixstack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !bakedmodel.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        this.field_230707_j_.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    private void drawBlockStack(MatrixStack ms, ItemStack stack, int x, int y, float scale, int zScale) {
        int cornerX = (this.field_230708_k_ - 390) / 2;
        int cornerY = (this.field_230709_l_ - 245) / 2;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)cornerX, (float)cornerY, (float)32.0f);
        float zLevel = 200.0f;
        this.field_230707_j_.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.getFont();
        }
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.field_230707_j_.field_77023_b = -100 + zScale * 10;
        this.field_230707_j_.func_180450_b(stack, x, y);
        zLevel = 0.0f;
        this.field_230707_j_.field_77023_b = 0.0f;
        RenderSystem.popMatrix();
    }
}

