/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.render.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.LightType;
import superlord.prehistoricfauna.client.model.jurassic.kayenta.DilophosaurusModel;
import superlord.prehistoricfauna.common.entities.jurassic.kayenta.DilophosaurusEntity;

public class DilophosaurusEyeLayer
extends LayerRenderer<DilophosaurusEntity, EntityModel<DilophosaurusEntity>> {
    private static final RenderType TEXTURE = RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("prehistoricfauna", "textures/entities/dilophosaurus/dilophosaurus_eyeglow.png"));
    private final IEntityRenderer<DilophosaurusEntity, EntityModel<DilophosaurusEntity>> dilophosaurusRenderer;

    public DilophosaurusEyeLayer(IEntityRenderer<DilophosaurusEntity, EntityModel<DilophosaurusEntity>> dilophosaurusRenderer) {
        super(dilophosaurusRenderer);
        this.dilophosaurusRenderer = dilophosaurusRenderer;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, DilophosaurusEntity dilophosaurus, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(this.dilophosaurusRenderer.func_217764_d() instanceof DilophosaurusModel)) {
            return;
        }
        long roundTime = dilophosaurus.field_70170_p.func_72820_D() % 24000L;
        boolean night = roundTime >= 13000L && roundTime <= 22000L;
        BlockPos dilophosaurusPos = dilophosaurus.func_233580_cy_();
        int i = dilophosaurus.field_70170_p.func_226658_a_(LightType.SKY, dilophosaurusPos);
        int j = dilophosaurus.field_70170_p.func_226658_a_(LightType.BLOCK, dilophosaurusPos);
        int brightness = night ? j : Math.max(i, j);
        if (brightness < 7) {
            RenderType tex = null;
            tex = dilophosaurus.isAsleep() || dilophosaurus.field_70173_aa % 50 >= 0 && dilophosaurus.field_70173_aa % 50 <= 5 ? null : TEXTURE;
            if (tex != null) {
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(tex);
                this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

