/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.render.jurassic.morrison;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import superlord.prehistoricfauna.client.model.jurassic.morrison.StegosaurusModel;
import superlord.prehistoricfauna.client.render.layer.StegosaurusEyeLayer;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.StegosaurusEntity;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;

public class StegosaurusRenderer
extends MobRenderer<StegosaurusEntity, EntityModel<StegosaurusEntity>> {
    private static final ResourceLocation STEGOSAURUS = new ResourceLocation("prehistoricfauna", "textures/entities/stegosaurus/stegosaurus.png");
    private static final ResourceLocation ALBINO = new ResourceLocation("prehistoricfauna", "textures/entities/stegosaurus/albino.png");
    private static final ResourceLocation MELANISTIC = new ResourceLocation("prehistoricfauna", "textures/entities/stegosaurus/melanistic.png");
    private static final ResourceLocation STEGOSAURUS_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/stegosaurus/stegosaurus_sleeping.png");
    private static final ResourceLocation ALBINO_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/stegosaurus/albino_sleeping.png");
    private static final ResourceLocation MELANISTIC_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/stegosaurus/melanistic_sleeping.png");
    private static final StegosaurusModel STEGOSAURUS_MODEL = new StegosaurusModel();

    public StegosaurusRenderer(EntityRendererManager rm) {
        super(rm, (EntityModel)STEGOSAURUS_MODEL, 1.25f);
        if (PrehistoricFaunaConfig.eyeShine) {
            this.func_177094_a(new StegosaurusEyeLayer((IEntityRenderer<StegosaurusEntity, EntityModel<StegosaurusEntity>>)this));
        }
    }

    protected void preRenderCallback(StegosaurusEntity entity, MatrixStack matrixStackIn, float partialTickTime) {
        if (entity.func_70631_g_()) {
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        }
        float attackProgress = entity.getMeleeProgress(partialTickTime);
        float leftOrRight = entity.getMeleeDirection() ? 1.0f : -1.0f;
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(160.0f * leftOrRight * attackProgress));
    }

    public ResourceLocation getEntityTexture(StegosaurusEntity entity) {
        if (entity.isAlbino()) {
            if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
                return ALBINO_SLEEPING;
            }
            return ALBINO;
        }
        if (entity.isMelanistic()) {
            if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
                return MELANISTIC_SLEEPING;
            }
            return MELANISTIC;
        }
        if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
            return STEGOSAURUS_SLEEPING;
        }
        return STEGOSAURUS;
    }
}

