/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.render.jurassic.morrison;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import superlord.prehistoricfauna.client.model.jurassic.morrison.CamarasaurusBabyModel;
import superlord.prehistoricfauna.client.model.jurassic.morrison.CamarasaurusModel;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.CamarasaurusEntity;

public class CamarasaurusRenderer
extends MobRenderer<CamarasaurusEntity, EntityModel<CamarasaurusEntity>> {
    private static final ResourceLocation CAMARASAURUS = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/camarasaurus.png");
    private static final ResourceLocation CAMARASAURUS_BABY = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/camarasaurus_baby.png");
    private static final ResourceLocation ALBINO_BABY = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/albino_baby.png");
    private static final ResourceLocation MELANISTIC_BABY = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/melanistic_baby.png");
    private static final ResourceLocation CAMARASAURUS_BABY_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/camarasaurus_baby_sleeping.png");
    private static final ResourceLocation ALBINO_BABY_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/albino_baby_sleeping.png");
    private static final ResourceLocation MELANISTIC_BABY_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/melanistic_baby_sleeping.png");
    private static final ResourceLocation ALBINO = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/albino.png");
    private static final ResourceLocation MELANISTIC = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/melanistic.png");
    private static final ResourceLocation FROSTY = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/camarasaurus_snowy.png");
    private static final ResourceLocation CAMARASAURUS_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/camarasaurus_sleeping.png");
    private static final ResourceLocation ALBINO_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/albino_sleeping.png");
    private static final ResourceLocation MELANISTIC_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/melanistic_sleeping.png");
    private static final ResourceLocation FROSTY_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/camarasaurus/camarasaurus_snowy_sleeping.png");
    private static final CamarasaurusModel CAMARASAURUS_MODEL = new CamarasaurusModel();
    private static final CamarasaurusBabyModel CAMARASAURUS_BABY_MODEL = new CamarasaurusBabyModel();
    private boolean isChristmas;

    public CamarasaurusRenderer() {
        super(Minecraft.func_71410_x().func_175598_ae(), (EntityModel)CAMARASAURUS_MODEL, 3.125f);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
    }

    public void render(CamarasaurusEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.field_77045_g = entityIn.func_70631_g_() ? CAMARASAURUS_BABY_MODEL : CAMARASAURUS_MODEL;
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void preRenderCallback(CamarasaurusEntity camarasaurus, MatrixStack matrixStackIn, float partialTickTime) {
        if (camarasaurus.func_70631_g_() && !camarasaurus.isJuvenile()) {
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        }
    }

    public ResourceLocation getEntityTexture(CamarasaurusEntity entity) {
        String s = TextFormatting.func_110646_a((String)entity.func_200200_C_().getString());
        if (s != null && ("Frosty".equals(s) || "frosty".equals(s)) || this.isChristmas) {
            if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
                return FROSTY_SLEEPING;
            }
            return FROSTY;
        }
        if (entity.func_70631_g_() && !entity.isAsleep()) {
            if (entity.isAlbino()) {
                return ALBINO_BABY;
            }
            if (entity.isMelanistic()) {
                return MELANISTIC_BABY;
            }
            return CAMARASAURUS_BABY;
        }
        if (entity.func_70631_g_() && (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5)) {
            if (entity.isAlbino()) {
                return ALBINO_BABY_SLEEPING;
            }
            if (entity.isMelanistic()) {
                return MELANISTIC_BABY_SLEEPING;
            }
            return CAMARASAURUS_BABY_SLEEPING;
        }
        if (entity.isAlbino()) {
            if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
                return ALBINO_SLEEPING;
            }
            return ALBINO;
        }
        if (entity.isMelanistic()) {
            if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
                return MELANISTIC_SLEEPING;
            }
            return MELANISTIC;
        }
        if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
            return CAMARASAURUS_SLEEPING;
        }
        return CAMARASAURUS;
    }
}

