/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.render.jurassic.morrison;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.client.model.jurassic.morrison.AllosaurusModel;
import superlord.prehistoricfauna.client.render.layer.AllosaurusEyeLayer;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.AllosaurusEntity;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;

@OnlyIn(value=Dist.CLIENT)
public class AllosaurusRenderer
extends MobRenderer<AllosaurusEntity, EntityModel<AllosaurusEntity>> {
    private static final AllosaurusModel ALLOSAURUS_MODEL = new AllosaurusModel();
    private static final ResourceLocation ALLOSAURUS_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/allosaurus.png");
    private static final ResourceLocation ALBINO = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/albino.png");
    private static final ResourceLocation MELANISTIC = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/melanistic.png");
    private static final ResourceLocation ALLOSAURUS_SLEEPING_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/allosaurus_sleeping.png");
    private static final ResourceLocation ALBINO_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/albino_sleeping.png");
    private static final ResourceLocation MELANISTIC_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/melanistic_sleeping.png");

    public AllosaurusRenderer() {
        super(Minecraft.func_71410_x().func_175598_ae(), (EntityModel)ALLOSAURUS_MODEL, 1.25f);
        if (PrehistoricFaunaConfig.eyeShine) {
            this.func_177094_a(new AllosaurusEyeLayer((IEntityRenderer<AllosaurusEntity, EntityModel<AllosaurusEntity>>)this));
        }
    }

    protected void preRenderCallback(AllosaurusEntity allosaurus, MatrixStack matrixStackIn, float partialTickTime) {
        if (allosaurus.func_70631_g_()) {
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        }
    }

    public ResourceLocation getEntityTexture(AllosaurusEntity entity) {
        if (entity.isAlbino()) {
            if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
                return ALBINO_SLEEPING;
            }
            return ALBINO;
        }
        if (entity.isMelanistic()) {
            if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
                return MELANISTIC_SLEEPING;
            }
            return MELANISTIC;
        }
        if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
            return ALLOSAURUS_SLEEPING_TEXTURE;
        }
        return ALLOSAURUS_TEXTURE;
    }
}

