/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.render.jurassic.kayenta;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.client.model.jurassic.kayenta.SarahsaurusModel;
import superlord.prehistoricfauna.client.render.layer.SarahsaurusEyeLayer;
import superlord.prehistoricfauna.common.entities.jurassic.kayenta.SarahsaurusEntity;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;

@OnlyIn(value=Dist.CLIENT)
public class SarahsaurusRenderer
extends MobRenderer<SarahsaurusEntity, EntityModel<SarahsaurusEntity>> {
    private static final SarahsaurusModel SARAHSAURUS_MODEL = new SarahsaurusModel();
    private static final ResourceLocation SARAHSAURUS_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/sarahsaurus/sarahsaurus.png");
    private static final ResourceLocation FLINSTONES_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/sarahsaurus/sarahsaurus_flintstones.png");
    private static final ResourceLocation FLINSTONES_SLEEPING_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/sarahsaurus/sarahsaurus_flintstones_sleeping.png");
    private static final ResourceLocation ALBINO = new ResourceLocation("prehistoricfauna", "textures/entities/sarahsaurus/albino.png");
    private static final ResourceLocation MELANISTIC = new ResourceLocation("prehistoricfauna", "textures/entities/sarahsaurus/melanistic.png");
    private static final ResourceLocation SARAHSAURUS_SLEEPING_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/sarahsaurus/sarahsaurus_sleeping.png");
    private static final ResourceLocation ALBINO_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/sarahsaurus/albino_sleeping.png");
    private static final ResourceLocation MELANISTIC_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/sarahsaurus/melanistic_sleeping.png");

    public SarahsaurusRenderer() {
        super(Minecraft.func_71410_x().func_175598_ae(), (EntityModel)SARAHSAURUS_MODEL, 1.0f);
        if (PrehistoricFaunaConfig.eyeShine) {
            this.func_177094_a(new SarahsaurusEyeLayer((IEntityRenderer<SarahsaurusEntity, EntityModel<SarahsaurusEntity>>)this));
        }
    }

    protected void preRenderCallback(SarahsaurusEntity sarahsaurus, MatrixStack matrixStackIn, float partialTickTime) {
        if (sarahsaurus.func_70631_g_()) {
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        }
    }

    public ResourceLocation getEntityTexture(SarahsaurusEntity entity) {
        String s = TextFormatting.func_110646_a((String)entity.func_200200_C_().getString());
        if (s != null && ("Dino".equals(s) || "Flintstones".equals(s))) {
            if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
                return FLINSTONES_SLEEPING_TEXTURE;
            }
            return FLINSTONES_TEXTURE;
        }
        if (entity.isAlbino()) {
            if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
                return ALBINO_SLEEPING;
            }
            return ALBINO;
        }
        if (entity.isMelanistic()) {
            if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
                return MELANISTIC_SLEEPING;
            }
            return MELANISTIC;
        }
        if (entity.isAsleep() || entity.field_70173_aa % 50 >= 0 && entity.field_70173_aa % 50 <= 5) {
            return SARAHSAURUS_SLEEPING_TEXTURE;
        }
        return SARAHSAURUS_TEXTURE;
    }
}

