/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.render.henos;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.client.model.henos.HenosModel;
import superlord.prehistoricfauna.client.model.henos.HenosSummonedModel;
import superlord.prehistoricfauna.client.render.PFRenderTypes;
import superlord.prehistoricfauna.client.render.layer.HenosGemGlowLayer;
import superlord.prehistoricfauna.common.entities.henos.TimeGuardianEntity;

@OnlyIn(value=Dist.CLIENT)
public class BossRenderer
extends MobRenderer<TimeGuardianEntity, EntityModel<TimeGuardianEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/henos/henos.png");
    private static final ResourceLocation SUMMONED_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/henos/henos_summoned.png");
    private static final ResourceLocation FUNKY_MONKEY = new ResourceLocation("prehistoricfauna", "textures/entities/henos/brass_monkey.png");
    private static final ResourceLocation TEXTURE_LIT = new ResourceLocation("prehistoricfauna", "textures/entities/henos/henos_lit.png");
    private static final ResourceLocation SUMMONED_TEXTURE_LIT = new ResourceLocation("prehistoricfauna", "textures/entities/henos/henos_summoned_lit.png");
    private static final ResourceLocation FUNKY_MONKEY_LIT = new ResourceLocation("prehistoricfauna", "textures/entities/henos/brass_monkey_lit.png");
    private static final HenosModel HENOS = new HenosModel(0.0f);
    private static final HenosSummonedModel SUMMONED = new HenosSummonedModel(0.0f);
    private static final HenosModel HENOS_HEALING = new HenosModel(0.5f);
    private static final HenosSummonedModel SUMMONED_HEALING = new HenosSummonedModel(0.5f);
    private static final ResourceLocation BEAM_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/henos/beam.png");
    private static final RenderType BEAM_RENDER_TYPE = PFRenderTypes.getBossBeam(BEAM_TEXTURE);

    public BossRenderer(EntityRendererManager rm) {
        super(Minecraft.func_71410_x().func_175598_ae(), (EntityModel)HENOS, 1.25f);
        this.func_177094_a(new HenosGemGlowLayer((IEntityRenderer<TimeGuardianEntity, EntityModel<TimeGuardianEntity>>)this));
        this.func_177094_a(new HealingLayer((IEntityRenderer<TimeGuardianEntity, EntityModel<TimeGuardianEntity>>)this));
    }

    private static void func_229108_a_(IVertexBuilder p_229108_0_, Matrix4f p_229108_1_, Matrix3f p_229108_2_, float p_229108_3_, float p_229108_4_, float p_229108_5_, int p_229108_6_, int p_229108_7_, int p_229108_8_, float p_229108_9_, float p_229108_10_) {
        p_229108_0_.func_227888_a_(p_229108_1_, p_229108_3_, p_229108_4_, p_229108_5_).func_225586_a_(p_229108_6_, p_229108_7_, p_229108_8_, 255).func_225583_a_(p_229108_9_, p_229108_10_).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(240).func_227887_a_(p_229108_2_, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public boolean shouldRender(TimeGuardianEntity livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        Entity livingentity;
        if (super.func_225626_a_((MobEntity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.hasLaserTarget() && (livingentity = livingEntityIn.getLaserTarget()) != null) {
            Vector3d vec3d = livingEntityIn.getLaserTargetPos(1.0f);
            Vector3d vec3d1 = this.getPosition((Entity)livingEntityIn, livingEntityIn.func_70047_e(), 1.0f);
            return camera.func_228957_a_(new AxisAlignedBB(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c));
        }
        return false;
    }

    private Vector3d getPosition(Entity entityLivingBaseIn, double p_177110_2_, float p_177110_4_) {
        double d0 = MathHelper.func_219803_d((double)p_177110_4_, (double)entityLivingBaseIn.field_70142_S, (double)entityLivingBaseIn.func_226277_ct_());
        double d1 = MathHelper.func_219803_d((double)p_177110_4_, (double)entityLivingBaseIn.field_70137_T, (double)entityLivingBaseIn.func_226278_cu_()) + p_177110_2_;
        double d2 = MathHelper.func_219803_d((double)p_177110_4_, (double)entityLivingBaseIn.field_70136_U, (double)entityLivingBaseIn.func_226281_cx_());
        return new Vector3d(d0, d1, d2);
    }

    protected void applyRotations(TimeGuardianEntity entityIn, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_((LivingEntity)entityIn, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        Vector3d vec = entityIn.getLaserTargetPos(partialTicks);
        double d0 = vec.field_72450_a - entityIn.func_226277_ct_();
        double d2 = vec.field_72449_c - entityIn.func_226281_cx_();
        float f1 = MathHelper.func_76142_g((float)(180.0f - rotationYaw));
        float f2 = MathHelper.func_76142_g((float)((float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) + 90.0f));
        float f3 = entityIn.getLaserTargetProgress(partialTicks);
        matrixStackIn.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(f1 * f3));
        matrixStackIn.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(f2 * f3));
    }

    public void render(TimeGuardianEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.field_77045_g = entityIn.isSummoned() ? SUMMONED : HENOS;
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        Entity livingentity = entityIn.getLaserTarget();
        if (livingentity != null) {
            float f1 = (float)entityIn.field_70170_p.func_82737_E() + partialTicks;
            float f2 = f1 * -0.2f % 1.0f;
            float f3 = entityIn.func_213302_cg() * 0.625f;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)f3, 0.0);
            Vector3d vector3d = entityIn.getLaserTargetPos(partialTicks);
            Vector3d vector3d1 = this.getPosition((Entity)entityIn, f3, partialTicks);
            Vector3d vector3d2 = vector3d.func_178788_d(vector3d1);
            float f4 = (float)vector3d2.func_72433_c();
            vector3d2 = vector3d2.func_72432_b();
            float f5 = (float)Math.acos(vector3d2.field_72448_b);
            float f6 = (float)Math.atan2(vector3d2.field_72449_c, vector3d2.field_72450_a);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((1.5707964f - f6) * 57.295776f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f5 * 57.295776f));
            float f8 = 1.0f;
            int j = (int)(f8 * 255.0f);
            int k = (int)(f8 * 255.0f);
            int l = (int)(f8 * 255.0f);
            float width = (float)(100 - (100 - MathHelper.func_76125_a((int)entityIn.getLaserTick(), (int)5, (int)100))) * 0.01f;
            float f11 = MathHelper.func_76134_b((float)2.3561945f) * 0.8f;
            float f12 = MathHelper.func_76126_a((float)2.3561945f) * 0.8f;
            float f13 = MathHelper.func_76134_b((float)0.7853982f) * 0.8f;
            float f14 = MathHelper.func_76126_a((float)0.7853982f) * 0.8f;
            float f15 = MathHelper.func_76134_b((float)3.926991f) * 0.8f;
            float f16 = MathHelper.func_76126_a((float)3.926991f) * 0.8f;
            float f17 = MathHelper.func_76134_b((float)5.4977875f) * 0.8f;
            float f18 = MathHelper.func_76126_a((float)5.4977875f) * 0.8f;
            float f19 = MathHelper.func_76134_b((float)((float)Math.PI)) * width;
            float f20 = MathHelper.func_76126_a((float)((float)Math.PI)) * width;
            float f21 = MathHelper.func_76134_b((float)0.0f) * width;
            float f22 = MathHelper.func_76126_a((float)0.0f) * width;
            float f23 = MathHelper.func_76134_b((float)1.5707964f) * width;
            float f24 = MathHelper.func_76126_a((float)1.5707964f) * width;
            float f25 = MathHelper.func_76134_b((float)4.712389f) * width;
            float f26 = MathHelper.func_76126_a((float)4.712389f) * width;
            float f29 = -1.0f + f2;
            float f30 = f4 * 0.5f + f29;
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(BEAM_RENDER_TYPE);
            MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
            Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
            Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
            BossRenderer.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30);
            BossRenderer.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29);
            BossRenderer.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29);
            BossRenderer.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30);
            BossRenderer.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f30);
            BossRenderer.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f29);
            BossRenderer.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f29);
            BossRenderer.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f30);
            float f31 = 0.0f;
            if (entityIn.field_70173_aa % 2 == 0) {
                f31 = 0.5f;
            }
            BossRenderer.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f11, f4, f12, j, k, l, 0.5f, f31 + 0.5f);
            BossRenderer.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f13, f4, f14, j, k, l, 1.0f, f31 + 0.5f);
            BossRenderer.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f17, f4, f18, j, k, l, 1.0f, f31);
            BossRenderer.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f15, f4, f16, j, k, l, 0.5f, f31);
            matrixStackIn.func_227865_b_();
        }
    }

    public ResourceLocation getEntityTexture(TimeGuardianEntity entity) {
        String s = TextFormatting.func_110646_a((String)entity.func_200200_C_().getString());
        if (!entity.isSummoned() && s != null && "Brass Monkey".equals(s)) {
            if (entity.getLaserTick() > 0) {
                return FUNKY_MONKEY_LIT;
            }
            return FUNKY_MONKEY;
        }
        if (entity.isSummoned()) {
            if (entity.getLaserTick() > 0) {
                return SUMMONED_TEXTURE_LIT;
            }
            return SUMMONED_TEXTURE;
        }
        if (entity.getLaserTick() > 0) {
            return TEXTURE_LIT;
        }
        return TEXTURE;
    }

    class HealingLayer
    extends LayerRenderer<TimeGuardianEntity, EntityModel<TimeGuardianEntity>> {
        public HealingLayer(IEntityRenderer<TimeGuardianEntity, EntityModel<TimeGuardianEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, TimeGuardianEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.hasHealingShield()) {
                EntityModel model = entitylivingbaseIn.isSummoned() ? SUMMONED_HEALING : HENOS_HEALING;
                IVertexBuilder vertexBuilder = bufferIn.getBuffer(PFRenderTypes.getBossGlint());
                model.func_225597_a_((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                model.func_225598_a_(matrixStackIn, vertexBuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, entitylivingbaseIn.getShieldThickness());
            }
        }
    }
}

