/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import superlord.prehistoricfauna.common.entities.PaleopaintingEntity;

public class PaleopaintingRenderer
extends EntityRenderer<PaleopaintingEntity> {
    private static final ResourceLocation BACK = new ResourceLocation("prehistoricfauna", "textures/painting/back.png");
    private static final Map<PaleopaintingEntity.Paleopainting, ResourceLocation> PALEOPAINTINGS = new HashMap<PaleopaintingEntity.Paleopainting, ResourceLocation>();

    public PaleopaintingRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(PaleopaintingEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLightIn) {
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        PaleopaintingEntity.Paleopainting painting = entityIn.paleopainting;
        float f = 0.0625f;
        matrixStack.func_227862_a_(f, f, f);
        this.addVertices(matrixStack, buffer, entityIn, painting.getWidth(), painting.getHeight());
        matrixStack.func_227865_b_();
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStack, buffer, packedLightIn);
    }

    public ResourceLocation getEntityTexture(PaleopaintingEntity entity) {
        return PALEOPAINTINGS.computeIfAbsent(entity.paleopainting, k -> new ResourceLocation("prehistoricfauna", "textures/painting/" + k.name().toLowerCase() + ".png"));
    }

    private void addVertices(MatrixStack p_229122_1_, IRenderTypeBuffer vertexProvider, PaleopaintingEntity painting, int width, int height) {
        MatrixStack.Entry matrixstack$entry = p_229122_1_.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        float f = (float)(-width) / 2.0f;
        float f1 = (float)(-height) / 2.0f;
        float backMinU = 0.0f;
        float backMaxU = 1.0f;
        float backMinV = 0.0f;
        float backMaxV = 1.0f;
        float backInterpolatedU = 0.0625f;
        float backInterpolatedV = 0.0625f;
        int i = width / 16;
        int j = height / 16;
        float d0 = 16.0f / (float)i;
        float d1 = 16.0f / (float)j;
        for (int k = 0; k < i; ++k) {
            for (int l = 0; l < j; ++l) {
                float uStart = f + (float)(k * 16);
                float uEnd = f + (float)((k + 1) * 16);
                float vStart = f1 + (float)(l * 16);
                float vEnd = f1 + (float)((l + 1) * 16);
                int x = MathHelper.func_76128_c((double)painting.func_226277_ct_());
                int y = MathHelper.func_76128_c((double)(painting.func_226278_cu_() + (double)((vEnd + vStart) / 2.0f / 16.0f)));
                int z = MathHelper.func_76128_c((double)painting.func_226281_cx_());
                Direction direction = painting.func_174811_aO();
                switch (direction) {
                    case NORTH: {
                        x = MathHelper.func_76128_c((double)(painting.func_226277_ct_() + (double)((uEnd + uStart) / 2.0f / 16.0f)));
                        break;
                    }
                    case WEST: {
                        z = MathHelper.func_76128_c((double)(painting.func_226281_cx_() - (double)((uEnd + uStart) / 2.0f / 16.0f)));
                        break;
                    }
                    case SOUTH: {
                        x = MathHelper.func_76128_c((double)(painting.func_226277_ct_() - (double)((uEnd + uStart) / 2.0f / 16.0f)));
                        break;
                    }
                    case EAST: {
                        z = MathHelper.func_76128_c((double)(painting.func_226281_cx_() + (double)((uEnd + uStart) / 2.0f / 16.0f)));
                        break;
                    }
                    default: {
                        x = MathHelper.func_76128_c((double)(painting.func_226277_ct_() + (double)((uEnd + uStart) / 2.0f / 16.0f)));
                    }
                }
                int light = WorldRenderer.func_228421_a_((IBlockDisplayReader)painting.field_70170_p, (BlockPos)new BlockPos(x, y, z));
                float spriteMinU = d0 * (float)(i - k) / 16.0f;
                float spriteMaxU = d0 * (float)(i - (k + 1)) / 16.0f;
                float spriteMinV = d1 * (float)(j - l) / 16.0f;
                float spriteMaxV = d1 * (float)(j - (l + 1)) / 16.0f;
                IVertexBuilder paintingBuffer = vertexProvider.getBuffer(RenderType.func_228634_a_((ResourceLocation)this.getEntityTexture(painting)));
                this.vertex(matrix4f, matrix3f, paintingBuffer, uEnd, vStart, spriteMaxU, spriteMinV, -0.5f, 0, 0, -1, light);
                this.vertex(matrix4f, matrix3f, paintingBuffer, uStart, vStart, spriteMinU, spriteMinV, -0.5f, 0, 0, -1, light);
                this.vertex(matrix4f, matrix3f, paintingBuffer, uStart, vEnd, spriteMinU, spriteMaxV, -0.5f, 0, 0, -1, light);
                this.vertex(matrix4f, matrix3f, paintingBuffer, uEnd, vEnd, spriteMaxU, spriteMaxV, -0.5f, 0, 0, -1, light);
                IVertexBuilder backBuffer = vertexProvider.getBuffer(RenderType.func_228634_a_((ResourceLocation)BACK));
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vEnd, backMinU, backMinV, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vEnd, backMaxU, backMinV, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vStart, backMaxU, backMaxV, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vStart, backMinU, backMaxV, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vEnd, backMinU, backMinV, -0.5f, 0, 1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vEnd, backMaxU, backMinV, -0.5f, 0, 1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vEnd, backMaxU, backInterpolatedV, 0.5f, 0, 1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vEnd, backMinU, backInterpolatedV, 0.5f, 0, 1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vStart, backMinU, backMinV, 0.5f, 0, -1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vStart, backMaxU, backMinV, 0.5f, 0, -1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vStart, backMaxU, backInterpolatedV, -0.5f, 0, -1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vStart, backMinU, backInterpolatedV, -0.5f, 0, -1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vEnd, backInterpolatedU, backMinV, 0.5f, -1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vStart, backInterpolatedU, backMaxV, 0.5f, -1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vStart, backMinU, backMaxV, -0.5f, -1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vEnd, backMinU, backMinV, -0.5f, -1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vEnd, backInterpolatedU, backMinV, -0.5f, 1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vStart, backInterpolatedU, backMaxV, -0.5f, 1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vStart, backMinU, backMaxV, 0.5f, 1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vEnd, backMinU, backMinV, 0.5f, 1, 0, 0, light);
            }
        }
    }

    private void vertex(Matrix4f matrix, Matrix3f normal, IVertexBuilder buffer, float x, float y, float u, float v, float z, int normalX, int normalY, int normalZ, int light) {
        buffer.func_227888_a_(matrix, x, y, z).func_225586_a_(255, 255, 255, 255).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, (float)normalX, (float)normalY, (float)normalZ).func_181675_d();
    }
}

