/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.triassic.chinle;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.common.entities.triassic.chinle.TrilophosaurusEntity;

@OnlyIn(value=Dist.CLIENT)
public class TrilophosaurusModel
extends EntityModel<TrilophosaurusEntity> {
    public ModelRenderer Body;
    public ModelRenderer LeftArm;
    public ModelRenderer RightArm;
    public ModelRenderer LeftLeg;
    public ModelRenderer RightLeg;
    public ModelRenderer Neck;
    public ModelRenderer TailBase;
    public ModelRenderer Head;
    public ModelRenderer Snoot;
    public ModelRenderer TailEnd;
    public ModelRenderer LeftHand;
    public ModelRenderer RightHand;
    public ModelRenderer LeftFoot;
    public ModelRenderer RightFoot;

    public TrilophosaurusModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.RightArm = new ModelRenderer((Model)this, 0, 10);
        this.RightArm.field_78809_i = true;
        this.RightArm.func_78793_a(-3.0f, 20.99f, -4.0f);
        this.RightArm.func_228302_a_(-1.0f, -2.0f, -1.5f, 2.0f, 5.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.LeftHand = new ModelRenderer((Model)this, 53, 27);
        this.LeftHand.func_78793_a(1.0f, 3.01f, -1.0f);
        this.LeftHand.func_228302_a_(-1.5f, 0.0f, -2.0f, 3.0f, 0.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.Head = new ModelRenderer((Model)this, 0, 5);
        this.Head.func_78793_a(0.0f, -2.9f, -3.0f);
        this.Head.func_228302_a_(-1.5f, -2.0f, -2.0f, 3.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.LeftFoot = new ModelRenderer((Model)this, 52, 16);
        this.LeftFoot.func_78793_a(1.0f, 4.01f, -2.0f);
        this.LeftFoot.func_228302_a_(-1.5f, 0.0f, -2.5f, 3.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.LeftArm = new ModelRenderer((Model)this, 0, 10);
        this.LeftArm.func_78793_a(3.0f, 20.89f, -4.0f);
        this.LeftArm.func_228302_a_(-1.0f, -2.0f, -1.5f, 2.0f, 5.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.RightFoot = new ModelRenderer((Model)this, 52, 16);
        this.RightFoot.field_78809_i = true;
        this.RightFoot.func_78793_a(-1.0f, 4.01f, -2.0f);
        this.RightFoot.func_228302_a_(-1.5f, 0.0f, -2.5f, 3.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.Snoot = new ModelRenderer((Model)this, 0, 0);
        this.Snoot.func_78793_a(0.0f, 0.0f, -2.0f);
        this.Snoot.func_228302_a_(-1.0f, -2.0f, -2.0f, 2.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.Neck = new ModelRenderer((Model)this, 10, 0);
        this.Neck.func_78793_a(0.0f, 0.0f, 0.0f);
        this.Neck.func_228302_a_(-1.0f, -5.0f, -4.0f, 2.0f, 7.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.TailEnd = new ModelRenderer((Model)this, 12, 19);
        this.TailEnd.func_78793_a(0.0f, -0.01f, 9.3f);
        this.TailEnd.func_228302_a_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 24.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.TailEnd, 0.11728612f, 0.0f, 0.0f);
        this.RightHand = new ModelRenderer((Model)this, 53, 27);
        this.RightHand.field_78809_i = true;
        this.RightHand.func_78793_a(-1.0f, 3.01f, -1.0f);
        this.RightHand.func_228302_a_(-1.5f, 0.0f, -2.0f, 3.0f, 0.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.RightLeg = new ModelRenderer((Model)this, 0, 18);
        this.RightLeg.field_78809_i = true;
        this.RightLeg.func_78793_a(-3.0f, 19.99f, 6.5f);
        this.RightLeg.func_228302_a_(-1.0f, -2.0f, -1.5f, 2.0f, 6.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.Body = new ModelRenderer((Model)this, 14, 0);
        this.Body.func_78793_a(0.0f, 18.0f, -4.0f);
        this.Body.func_228302_a_(-2.0f, -2.0f, -2.0f, 4.0f, 5.0f, 14.0f, 0.0f, 0.0f, 0.0f);
        this.TailBase = new ModelRenderer((Model)this, 38, 0);
        this.TailBase.func_78793_a(0.0f, 0.2f, 11.0f);
        this.TailBase.func_228302_a_(-1.5f, -2.0f, 0.0f, 3.0f, 4.0f, 10.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.TailBase, -0.27366763f, 0.0f, 0.0f);
        this.LeftLeg = new ModelRenderer((Model)this, 0, 18);
        this.LeftLeg.func_78793_a(3.0f, 19.99f, 6.5f);
        this.LeftLeg.func_228302_a_(-1.0f, -2.0f, -1.5f, 2.0f, 6.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.LeftArm.func_78792_a(this.LeftHand);
        this.Neck.func_78792_a(this.Head);
        this.LeftLeg.func_78792_a(this.LeftFoot);
        this.RightLeg.func_78792_a(this.RightFoot);
        this.Head.func_78792_a(this.Snoot);
        this.Body.func_78792_a(this.Neck);
        this.TailBase.func_78792_a(this.TailEnd);
        this.RightArm.func_78792_a(this.RightHand);
        this.Body.func_78792_a(this.TailBase);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.RightArm, (Object)this.LeftArm, (Object)this.RightLeg, (Object)this.Body, (Object)this.LeftLeg).forEach(modelRenderer -> modelRenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public void setRotationAngles(TrilophosaurusEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetModel();
        if (entityIn.isAsleep()) {
            this.Neck.field_78795_f = 0.70371675f;
            this.Neck.field_78796_g = -0.4691445f;
            this.LeftFoot.field_78795_f = -0.11728612f;
            this.LeftFoot.field_78796_g = 0.039095376f;
            this.LeftFoot.field_78808_h = 1.251052f;
            this.LeftHand.field_78808_h = 1.3688618f;
            this.RightHand.field_78808_h = -1.3683381f;
            this.Body.field_78797_d = 21.0f;
            this.LeftArm.field_78797_d = 23.89f;
            this.LeftArm.field_78795_f = -0.4691445f;
            this.LeftArm.field_78796_g = 0.1563815f;
            this.LeftArm.field_78808_h = -1.3683381f;
            this.TailBase.field_78795_f = -0.11728612f;
            this.TailBase.field_78796_g = 0.4691445f;
            this.LeftLeg.field_78797_d = 22.99f;
            this.LeftLeg.field_78795_f = 0.35185838f;
            this.LeftLeg.field_78808_h = -1.1728612f;
            this.TailEnd.field_78795_f = 0.07819075f;
            this.TailEnd.field_78796_g = 0.39095375f;
            this.RightLeg.field_78797_d = 22.99f;
            this.RightLeg.field_78795_f = 0.35185838f;
            this.RightLeg.field_78808_h = 1.1728612f;
            this.RightArm.field_78797_d = 22.99f;
            this.RightArm.field_78795_f = -0.4691445f;
            this.RightArm.field_78796_g = -0.1563815f;
            this.RightArm.field_78808_h = 1.3683381f;
            this.RightFoot.field_78795_f = -0.11728612f;
            this.RightFoot.field_78796_g = 0.039095376f;
            this.RightFoot.field_78808_h = -1.251052f;
        } else {
            this.RightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LeftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.TailBase.field_78796_g = -0.12f * MathHelper.func_76126_a((float)(0.2f * ageInTicks / 5.0f));
            this.TailEnd.field_78796_g = -0.12f * MathHelper.func_76126_a((float)(0.2f * ageInTicks / 5.0f));
            this.TailBase.field_78795_f = -Math.abs(-0.05f * MathHelper.func_76126_a((float)(0.1f * ageInTicks / 5.0f)));
            this.TailEnd.field_78795_f = -Math.abs(-0.05f * MathHelper.func_76126_a((float)(0.1f * ageInTicks / 5.0f)));
            this.Neck.field_78795_f = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * MathHelper.func_76126_a((float)(0.1f * ageInTicks / 3.0f)));
            this.LeftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Neck.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
            if (entityIn.isEating()) {
                this.Neck.field_78795_f = Math.abs(MathHelper.func_76126_a((float)(0.05f * ageInTicks)) * 0.75f) + 0.5f;
            }
            if (entityIn.func_70090_H()) {
                this.LeftArm.field_78795_f = 1.25f;
                this.LeftArm.field_78796_g = 0.25f;
                this.RightArm.field_78795_f = 1.25f;
                this.RightArm.field_78796_g = -0.25f;
                this.RightLeg.field_78795_f = 1.25f;
                this.RightLeg.field_78796_g = -0.25f + 0.25f * MathHelper.func_76126_a((float)(0.25f * ageInTicks / 1.0f));
                this.LeftLeg.field_78795_f = 1.25f;
                this.LeftLeg.field_78796_g = 0.25f + 0.25f * MathHelper.func_76126_a((float)(0.25f * ageInTicks / 1.0f));
                this.TailBase.field_78796_g = 0.25f * MathHelper.func_76126_a((float)(0.25f * ageInTicks / 1.0f));
                this.TailEnd.field_78796_g = 0.25f * MathHelper.func_76126_a((float)(0.25f * ageInTicks / 1.0f));
                this.LeftHand.field_78808_h = 1.3688618f;
                this.RightHand.field_78808_h = -1.3683381f;
                this.LeftFoot.field_78795_f = -0.11728612f;
                this.LeftFoot.field_78796_g = 0.039095376f;
                this.LeftFoot.field_78808_h = 1.251052f;
                this.RightFoot.field_78795_f = -0.11728612f;
                this.RightFoot.field_78796_g = 0.039095376f;
                this.RightFoot.field_78808_h = -1.251052f;
            }
        }
    }

    public void resetModel() {
        this.Neck.field_78795_f = 0.0f;
        this.Neck.field_78796_g = 0.0f;
        this.LeftFoot.field_78795_f = 0.0f;
        this.LeftFoot.field_78796_g = 0.0f;
        this.LeftFoot.field_78808_h = 0.0f;
        this.LeftHand.field_78808_h = 0.0f;
        this.RightHand.field_78808_h = 0.0f;
        this.Body.field_78797_d = 18.0f;
        this.LeftArm.field_78797_d = 20.89f;
        this.LeftArm.field_78795_f = 0.0f;
        this.LeftArm.field_78796_g = 0.0f;
        this.LeftArm.field_78808_h = 0.0f;
        this.TailBase.field_78795_f = -0.27366763f;
        this.TailBase.field_78796_g = 0.0f;
        this.LeftLeg.field_78797_d = 19.99f;
        this.LeftLeg.field_78795_f = 0.0f;
        this.LeftLeg.field_78808_h = 0.0f;
        this.TailEnd.field_78795_f = 0.11728612f;
        this.TailEnd.field_78796_g = 0.0f;
        this.RightLeg.field_78797_d = 19.99f;
        this.RightLeg.field_78795_f = 0.0f;
        this.RightLeg.field_78808_h = 0.0f;
        this.RightArm.field_78797_d = 20.99f;
        this.RightArm.field_78795_f = 0.0f;
        this.RightArm.field_78796_g = 0.0f;
        this.RightArm.field_78808_h = 0.0f;
        this.RightFoot.field_78795_f = 0.0f;
        this.RightFoot.field_78796_g = 0.0f;
        this.RightFoot.field_78808_h = 0.0f;
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

